/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection.views;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.LabelProvider;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.guifilters.DVTEPackageGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.DVTGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.DVTNamedElementGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.ViewSet;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IDVTJob;
import ro.amiq.dvt.ui.views.UpdateJob;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.checks.ChecksViewInput;
import ro.amiq.dvt.ui.views.checks.ChecksViewInputConfigurator;
import ro.amiq.dvt.ui.views.checks.IChecksViewContributor;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.reflection.RfAssert;
import ro.amiq.edt.base.model.reflection.RfCheckThat;
import ro.amiq.edt.base.model.reflection.RfCoverItem;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfEvent;
import ro.amiq.edt.base.model.reflection.RfExpect;
import ro.amiq.edt.base.model.reflection.RfExpectLayer;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructMember;
import ro.amiq.edt.base.model.reflection.RfType;
import ro.amiq.edt.base.model.reflection.util.RfUtils;
import ro.amiq.edt.base.model.reflection.views.AbstractRfTreeElementWrapper;
import ro.amiq.edt.base.model.reflection.views.ChecksViewLabelProvider;
import ro.amiq.edt.base.model.reflection.views.ELanguageElement;
import ro.amiq.edt.base.model.reflection.views.EQuickViewersUtil;
import ro.amiq.edt.base.ui.editor.hyperlink.RfNamedElementActionHyperlink;

public abstract class AbstractEChecksViewContributor
implements IChecksViewContributor {
    private static final Pattern WORD_PATTERN = Pattern.compile("\\w*");
    private ChecksViewLabelProvider fLabelProvider = new ChecksViewLabelProvider(this.getPluginConfig());
    private int fNrTotalChecks = 0;
    private int fNrNotFilteredChecks = 0;
    private int fNrOfEChecks = 0;
    private int fNrOfEExpects = 0;
    private int fNrOfEAsserts = 0;
    private int fNrOfEAssumption = 0;
    private boolean fHasGUIFilteredElements;
    private Map<RfStruct, AbstractRfTreeElementWrapper> fPkgTreeMap = new HashMap<RfStruct, AbstractRfTreeElementWrapper>();
    private Map<RfStruct, AbstractRfTreeElementWrapper> fStructTreeMap = new HashMap<RfStruct, AbstractRfTreeElementWrapper>();

    public abstract IEPluginConfig getPluginConfig();

    public String getComment(Object wrapper) {
        RfNamedElement namedElement = this.getNamedElement(wrapper);
        return namedElement == null ? "" : DVTStringUtil.replaceAll((Pattern)DVTStringUtil.NEW_LINE, (CharSequence)namedElement.getComment(), (String)" ");
    }

    private RfNamedElement getNamedElement(Object wrapper) {
        if (!(wrapper instanceof AbstractRfTreeElementWrapper)) {
            return null;
        }
        if (!(((AbstractRfTreeElementWrapper)((Object)wrapper)).getRfElement() instanceof RfNamedElement)) {
            return null;
        }
        return (RfNamedElement)((AbstractRfTreeElementWrapper)((Object)wrapper)).getRfElement();
    }

    public void gotoElement(IProject project, Object wrapper) {
        if (!(wrapper instanceof AbstractRfTreeElementWrapper)) {
            return;
        }
        Object element = ((AbstractRfTreeElementWrapper)((Object)wrapper)).getRfElement();
        if (element == null) {
            return;
        }
        RfNamedElementActionHyperlink actionHyperlink = null;
        if (element instanceof RfExpectLayer) {
            actionHyperlink = RfUtils.createOpenAction(this.getPluginConfig(), (RfExpectLayer)element, project, null, false);
        } else if (element instanceof RfCheckThat) {
            actionHyperlink = RfUtils.createOpenAction(this.getPluginConfig(), (RfCheckThat)element, project, null);
        } else if (element instanceof RfAssert) {
            actionHyperlink = RfUtils.createOpenAction(this.getPluginConfig(), (RfAssert)element, project, null);
        } else if (element instanceof RfNamedElement) {
            actionHyperlink = RfUtils.createOpenAction(this.getPluginConfig(), (RfNamedElement)element, project, null);
        }
        if (actionHyperlink == null) {
            return;
        }
        actionHyperlink.open();
    }

    public ChecksViewInput getInput(ChecksViewInputConfigurator inputConfig) {
        this.fNrTotalChecks = 0;
        this.fNrNotFilteredChecks = 0;
        this.fNrOfEChecks = 0;
        this.fNrOfEExpects = 0;
        this.fNrOfEAsserts = 0;
        this.fNrOfEAssumption = 0;
        this.fHasGUIFilteredElements = false;
        ArrayList<IDVTElementWrapper> elements = new ArrayList<IDVTElementWrapper>();
        try {
            if (!(inputConfig.getSource() instanceof IProject)) {
                return new ChecksViewInput(this.fNrTotalChecks, this.fNrNotFilteredChecks, elements, this.fHasGUIFilteredElements);
            }
            IProject project = (IProject)inputConfig.getSource();
            if (!project.isAccessible() || !project.hasNature(this.getPluginConfig().getNature())) {
                return new ChecksViewInput(this.fNrTotalChecks, this.fNrNotFilteredChecks, elements, this.fHasGUIFilteredElements);
            }
            if (!DVTPlugin.getDefault().collect().c(project, this.getPluginConfig().feature())) {
                return new ChecksViewInput(this.fNrTotalChecks, this.fNrNotFilteredChecks, elements, this.fHasGUIFilteredElements);
            }
            RfProject rfProject = this.getPluginConfig().getRfManager().getRfProject(project);
            if (rfProject == null) {
                return new ChecksViewInput(this.fNrTotalChecks, this.fNrNotFilteredChecks, elements, this.fHasGUIFilteredElements);
            }
            boolean collectExpects = !PrefConst.getChecksViewEdtHideExpects();
            boolean collectAsserts = !PrefConst.getChecksViewEdtHideAssertions();
            boolean collectAssuptions = !PrefConst.getChecksViewEdtHideAssumptions();
            boolean collectChecks = !PrefConst.getChecksViewEdtHideChecks();
            List<IDVTElementWrapper> wrappers = this.toWrappers(rfProject, inputConfig.getSearchSegments(), inputConfig.getSearchStrictness(), collectExpects, collectAssuptions, collectChecks, collectAsserts, inputConfig.getUpdateJob());
            if (wrappers != null && !wrappers.isEmpty()) {
                this.internalSort(wrappers, inputConfig.isSortByType());
                if (inputConfig.isShowLanguageNameAsRootElement()) {
                    StringBuilder infoText = new StringBuilder("[");
                    if (this.fNrTotalChecks == this.fNrNotFilteredChecks) {
                        infoText.append(this.fNrTotalChecks);
                    } else {
                        infoText.append(this.fNrNotFilteredChecks).append("/").append(this.fNrTotalChecks);
                    }
                    infoText.append(ViewsUtils.getUnitName((String)"check", (int)this.fNrTotalChecks, (String)" ", (String)"")).append("]");
                    AbstractRfTreeElementWrapper languageWrapper = this.getPluginConfig().createElementTreeWrapper(new ELanguageElement<String>(String.valueOf(this.getLanguageKind().VIEW_NAME) + " " + infoText.toString()));
                    elements.add(languageWrapper);
                    languageWrapper.addChildren(wrappers);
                } else {
                    elements.addAll(wrappers);
                }
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        ChecksViewInput checksViewInput = new ChecksViewInput(this.fNrTotalChecks, this.fNrNotFilteredChecks, elements, this.fHasGUIFilteredElements);
        checksViewInput.setNrOfEAsserts(this.fNrOfEAsserts);
        checksViewInput.setNrOfEAssumption(this.fNrOfEAssumption);
        checksViewInput.setNrOfEChecks(this.fNrOfEChecks);
        checksViewInput.setNrOfEExpects(this.fNrOfEExpects);
        return checksViewInput;
    }

    private List<IDVTElementWrapper> toWrappers(RfProject rfProject, StringMatcher[] searchSegments, boolean[] searchStrictness, boolean collectExpect, boolean collectAssumptions, boolean collectChecks, boolean collectAssertions, UpdateJob updateJob) {
        this.fStructTreeMap.clear();
        this.fPkgTreeMap.clear();
        ArrayList<IDVTElementWrapper> result = new ArrayList<IDVTElementWrapper>();
        try {
            RfStruct struct;
            RfType tmpType;
            RfStruct pkg;
            HashSet<RfStruct> filteredPackages = new HashSet<RfStruct>();
            Collection<RfStruct> packages = rfProject.getAllPackages();
            for (RfStruct rfStruct : packages) {
                if (DVTEPackageGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.CHECKS, (IProject)rfProject.getProject(), (String)rfStruct.getPackageName()) == DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) continue;
                filteredPackages.add(rfStruct);
            }
            HashSet<RfStruct> hashSet = new HashSet<RfStruct>();
            List<RfStruct> structs = rfProject.getAllStructs();
            for (RfStruct struct2 : structs) {
                if (DVTNamedElementGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.CHECKS, (IRfNamedElement)struct2, () -> this.fLabelProvider.getText((Object)this.getPluginConfig().createElementTreeWrapper(struct2))) == DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) continue;
                hashSet.add(struct2);
            }
            List<RfStruct> allStructs = rfProject.getAllStructs();
            for (RfStruct struct3 : allStructs) {
                if (ViewsUtils.isCanceled((IDVTJob)updateJob)) {
                    return result;
                }
                List<RfStructMember> candidates = struct3.getExpects();
                String pkgname = struct3.getPackageName();
                pkg = rfProject.getPackage(pkgname);
                for (RfStructMember candidate : candidates) {
                    if (ViewsUtils.isCanceled((IDVTJob)updateJob)) {
                        return result;
                    }
                    if (filteredPackages.contains(pkg)) {
                        this.fHasGUIFilteredElements = true;
                        continue;
                    }
                    if (hashSet.contains(struct3)) {
                        this.fHasGUIFilteredElements = true;
                        continue;
                    }
                    if (DVTNamedElementGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.CHECKS, (IRfNamedElement)candidate, () -> this.fLabelProvider.getText((Object)this.getPluginConfig().createElementTreeWrapper(candidate))) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
                        this.fHasGUIFilteredElements = true;
                        continue;
                    }
                    if (((RfExpect)candidate).isExpect()) {
                        ++this.fNrOfEExpects;
                        ++this.fNrTotalChecks;
                        if (!collectExpect) continue;
                        this.addToFullTree(pkg, struct3, candidate, updateJob);
                        continue;
                    }
                    ++this.fNrOfEAssumption;
                    ++this.fNrTotalChecks;
                    if (!collectAssumptions) continue;
                    this.addToFullTree(pkg, struct3, candidate, updateJob);
                }
            }
            Collection<RfModule> allModules = rfProject.getAllModules();
            for (RfModule module : allModules) {
                if (ViewsUtils.isCanceled((IDVTJob)updateJob)) {
                    return result;
                }
                List<RfCheckThat> checks = module.getCheckThatActions();
                if (checks == null || checks.isEmpty() || (pkg = rfProject.getPackage(module.getPackageName())) == null) continue;
                for (RfCheckThat check : checks) {
                    if (ViewsUtils.isCanceled((IDVTJob)updateJob)) {
                        return result;
                    }
                    if (filteredPackages.contains(pkg)) {
                        this.fHasGUIFilteredElements = true;
                        continue;
                    }
                    tmpType = pkg.getType(check.getStructName());
                    struct = null;
                    if (tmpType instanceof RfStruct) {
                        struct = (RfStruct)tmpType;
                    }
                    if (struct == null) continue;
                    if (hashSet.contains(struct)) {
                        this.fHasGUIFilteredElements = true;
                        continue;
                    }
                    if (DVTNamedElementGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.CHECKS, (IRfNamedElement)check, () -> this.fLabelProvider.getText((Object)this.wrapNamedElement(check))) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
                        this.fHasGUIFilteredElements = true;
                        continue;
                    }
                    ++this.fNrOfEChecks;
                    ++this.fNrTotalChecks;
                    if (!collectChecks) continue;
                    this.addToFullTree(pkg, struct, check, updateJob);
                }
            }
            for (RfModule module : allModules) {
                if (ViewsUtils.isCanceled((IDVTJob)updateJob)) {
                    return result;
                }
                List<RfAssert> asserts = module.getAssertActions();
                if (asserts == null || asserts.isEmpty() || (pkg = rfProject.getPackage(module.getPackageName())) == null) continue;
                for (RfAssert azzert : asserts) {
                    if (ViewsUtils.isCanceled((IDVTJob)updateJob)) {
                        return result;
                    }
                    if (filteredPackages.contains(pkg)) {
                        this.fHasGUIFilteredElements = true;
                        continue;
                    }
                    tmpType = pkg.getType(azzert.getStructName());
                    struct = null;
                    if (tmpType instanceof RfStruct) {
                        struct = (RfStruct)tmpType;
                    }
                    if (struct == null) continue;
                    if (hashSet.contains(struct)) {
                        this.fHasGUIFilteredElements = true;
                        continue;
                    }
                    if (DVTNamedElementGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.CHECKS, (IRfNamedElement)azzert, () -> this.fLabelProvider.getText((Object)this.wrapNamedElement(azzert))) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
                        this.fHasGUIFilteredElements = true;
                        continue;
                    }
                    ++this.fNrOfEAsserts;
                    ++this.fNrTotalChecks;
                    if (!collectAssertions) continue;
                    this.addToFullTree(pkg, struct, azzert, updateJob);
                }
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        Collection<AbstractRfTreeElementWrapper> allWrappedPackages = this.fPkgTreeMap.values();
        ArrayList<IDVTElementWrapper> newPackages = new ArrayList<IDVTElementWrapper>();
        for (IDVTElementWrapper iDVTElementWrapper : allWrappedPackages) {
            ViewsUtils.hierarchicalSearch((IDVTElementWrapper)iDVTElementWrapper, (DVTBaseLabelProvider)this.fLabelProvider, (UpdateJob)updateJob, (StringMatcher[])searchSegments, (boolean[])searchStrictness);
            if (!iDVTElementWrapper.hasChildren()) continue;
            this.fNrNotFilteredChecks += this.countAssertions(iDVTElementWrapper);
            newPackages.add(iDVTElementWrapper);
        }
        this.fStructTreeMap.clear();
        this.fPkgTreeMap.clear();
        return newPackages;
    }

    private void addToFullTree(RfStruct pkg, RfStruct struct, RfNamedElement e, UpdateJob updateJob) {
        AbstractRfTreeElementWrapper wrappedElement;
        AbstractRfTreeElementWrapper structWrapper;
        if (e == null) {
            return;
        }
        AbstractRfTreeElementWrapper pkgWrapper = this.fPkgTreeMap.get(pkg);
        if (pkgWrapper == null) {
            pkgWrapper = this.getPluginConfig().createElementTreeWrapper(pkg);
            this.fPkgTreeMap.put(pkg, pkgWrapper);
        }
        if ((structWrapper = this.fStructTreeMap.get(struct)) == null) {
            structWrapper = this.getPluginConfig().createElementTreeWrapper(struct);
            pkgWrapper.addChild(structWrapper);
            this.fStructTreeMap.put(struct, structWrapper);
        }
        if ((wrappedElement = this.wrapNamedElement(e)) == null) {
            return;
        }
        structWrapper.addChild(wrappedElement);
    }

    private AbstractRfTreeElementWrapper wrapNamedElement(RfNamedElement element) {
        AbstractRfTreeElementWrapper wrapper = null;
        IAdaptable treeElement = null;
        String treeName = null;
        String literal = null;
        String exp = null;
        String name = null;
        Matcher wordMatcher = null;
        if (element instanceof RfAssert) {
            treeElement = element;
            literal = ((RfAssert)element).getLiteral();
            exp = ((RfAssert)element).getExpression();
        } else if (element instanceof RfCheckThat) {
            treeElement = element;
            name = ((RfCheckThat)element).getName();
            if (name.equals("[anonymous]")) {
                name = null;
            }
            literal = ((RfCheckThat)element).getLiteral();
            exp = ((RfCheckThat)element).getExpression();
        } else if (element instanceof RfExpect) {
            treeElement = this.getRelevantLayer((RfStructMember)element);
            if (treeElement == null) {
                return null;
            }
            name = ((RfExpectLayer)treeElement).getName();
            if (((RfExpect)element).isAnonymous()) {
                name = null;
            }
            literal = ((RfExpectLayer)treeElement).getLiteral();
            exp = ((RfExpectLayer)treeElement).getExpression();
        }
        if (treeElement != null) {
            if (name != null && name.length() > 0) {
                treeName = name;
            } else if (literal != null && literal.length() > 0 && !literal.trim().equals("...")) {
                wordMatcher = WORD_PATTERN.matcher(literal);
                wordMatcher.find();
                treeName = wordMatcher.group();
            }
            if (treeName != null && treeName.length() > 0) {
                treeName = String.valueOf(treeName) + " : ";
            }
            if (exp != null && exp.length() > 0) {
                treeName = String.valueOf(treeName == null ? "" : treeName) + exp;
            }
            if (treeName == null) {
                treeName = "[anonymous]";
            }
            wrapper = this.getPluginConfig().createElementTreeWrapper(treeElement);
            wrapper.setTreeName(treeName);
        }
        return wrapper;
    }

    private RfDefElement getRelevantLayer(RfStructMember expect) {
        List<RfDefElement> layers = expect.getLayers();
        if (layers == null) {
            return null;
        }
        RfDefElement result = null;
        for (RfDefElement layer : layers) {
            if (layer.getLayerKind() == 378) {
                result = layer;
                continue;
            }
            if (layer.getLayerKind() != 377) continue;
            return layer;
        }
        return result;
    }

    private int countAssertions(IDVTElementWrapper root) {
        if (root == null) {
            return 0;
        }
        Object rfElement = root.getRfElement();
        if (!RfStruct.isPackageElement(rfElement, false)) {
            return root.getChildren().size();
        }
        int result = 0;
        if (!root.hasChildren()) {
            return result;
        }
        List children = root.getChildren();
        for (IDVTElementWrapper child : children) {
            result += this.countAssertions(child);
        }
        return result;
    }

    private void internalSort(List<IDVTElementWrapper> wrappers, boolean sortByType) {
        if (wrappers == null || wrappers.isEmpty()) {
            return;
        }
        if (sortByType) {
            Collections.sort(wrappers, EQuickViewersUtil.getInstance().getSortByTypeComparator((LabelProvider)this.fLabelProvider));
        } else {
            Collections.sort(wrappers, EQuickViewersUtil.getInstance().getSortByNameComparator((LabelProvider)this.fLabelProvider));
        }
        for (IDVTElementWrapper wrapper : wrappers) {
            this.internalSort(wrapper.getChildren(), sortByType);
        }
    }

    public boolean isSelectable(Object element, Object referenceData, StringMatcher matcher) {
        if (!(element instanceof AbstractRfTreeElementWrapper)) {
            return false;
        }
        Object rfElement = ((IDVTElementWrapper)element).getRfElement();
        if (rfElement == null) {
            return false;
        }
        if (rfElement instanceof RfEvent || rfElement instanceof RfCoverItem) {
            return matcher == null || ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)this.fLabelProvider.getText(element)) || ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)this.fLabelProvider.getColumnText(element, 1));
        }
        return false;
    }

    public DVTBaseLabelProvider getLabelProvider(Object wrapper) {
        return this.fLabelProvider;
    }
}

