/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection.views;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.views.IRfFilterableTreeAccessor;
import ro.amiq.dvt.resources.properties.PropertiesManager;
import ro.amiq.dvt.resources.properties.PropertyTypes;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.symbolcollector.ISymbolCollectorPrerequisite;
import ro.amiq.dvt.ui.guifilters.DVTCompileOrderGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.DVTGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.ViewSet;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.UpdateJob;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.compileorder.BaseCompileOrderViewContributor;
import ro.amiq.dvt.ui.views.compileorder.CompileOrderViewInput;
import ro.amiq.dvt.ui.views.compileorder.CompileOrderViewInputConfigurator;
import ro.amiq.dvt.ui.views.inspect.DVTInspectViewUtils;
import ro.amiq.dvt.ui.views.inspect.InspectViewInput;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.reflection.RfDummyElement;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.util.RfUtils;
import ro.amiq.edt.base.model.reflection.views.AbstractRfTreeElementWrapper;
import ro.amiq.edt.base.model.reflection.views.CompileOrderViewLabelProvider;
import ro.amiq.edt.base.model.reflection.views.ELanguageElement;
import ro.amiq.edt.base.ui.editor.hyperlink.RfNamedElementActionHyperlink;

public abstract class AbstractECompileOrderViewContributorCommon
extends BaseCompileOrderViewContributor {
    private CompileOrderViewLabelProvider fLabelProvider = new CompileOrderViewLabelProvider(this.getPluginConfig());

    public abstract IEPluginConfig getPluginConfig();

    private void toWrappers(AbstractRfTreeElementWrapper root, Collection<RfModule> files, CompileOrderViewInputConfigurator configurator, CompileOrderViewInput input) {
        try {
            if (root == null || files == null || input == null || configurator == null || configurator.isCanceled()) {
                return;
            }
            boolean ignoreContentFilters = configurator.ignoreContentFilters();
            for (RfModule instance : files) {
                if (configurator.isCanceled() || configurator.shouldStopCollecting()) {
                    return;
                }
                AbstractRfTreeElementWrapper child = this.getPluginConfig().createElementTreeWrapper(instance);
                String text = this.getLabelProvider((Object)child).getText((Object)child);
                DVTGUIFilterMatcher.ITextProvider textProvider = () -> text;
                if (!ignoreContentFilters && DVTCompileOrderGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.COMPILE_ORDER, (IProject)configurator.getProject(), (IRfFileDef)instance, (DVTGUIFilterMatcher.ITextProvider)textProvider) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
                    if (!input.hasSearchedElementFiltered() && ViewsUtils.matchesPath((Object)((Object)child), (IRfFilterableTreeAccessor)configurator.getView())) {
                        input.setHasSearchedElementFiltered(true);
                    }
                    input.setHasGUIFilteredElements(true);
                    continue;
                }
                if (!this.shouldAddFile((ISymbolCollectorPrerequisite)child, configurator)) continue;
                input.incrementElementCount();
                root.addChild(child);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void countElements(IDVTElementWrapper root, CompileOrderViewInputConfigurator configurator, CompileOrderViewInput input) {
        if (root == null) {
            return;
        }
        if (root.getRfElement() instanceof RfModule && root.getAdditionalInfo((Object)IDVTElementWrapper.Attribute.MATCH) != null) {
            input.incrementNotFilteredElementCount();
        }
        if (!root.hasChildren()) {
            return;
        }
        List children = root.getChildren();
        for (IDVTElementWrapper child : children) {
            if (configurator.isCanceled()) {
                return;
            }
            this.countElements(child, configurator, input);
        }
    }

    private void filterOutElementsWithoutErrors(AbstractRfTreeElementWrapper root, AbstractRfTreeElementWrapper newRoot, CompileOrderViewInputConfigurator configurator) {
        List<AbstractRfTreeElementWrapper> children = root.getChildren();
        RfModule rfElement = (RfModule)root.getRfElement();
        boolean hasErrors = false;
        if (rfElement != null) {
            hasErrors = Utils.hasErrors((IProject)configurator.getProject(), (String)DVTFileUtils.getInstance().parser2resource(configurator.getProject(), rfElement.getParserPath()), (LanguageKind)this.getLanguageKind());
        }
        if (children == null || children.isEmpty()) {
            if (hasErrors) {
                newRoot.addChild(root);
            }
            return;
        }
        Iterator<AbstractRfTreeElementWrapper> iterator = children.iterator();
        while (iterator.hasNext()) {
            if (configurator.isCanceled()) {
                return;
            }
            AbstractRfTreeElementWrapper child = iterator.next();
            this.filterOutElementsWithoutErrors(child, newRoot, configurator);
            iterator.remove();
        }
        if (hasErrors) {
            newRoot.addChild(root);
        }
    }

    public String getComment(Object wrapper) {
        RfNamedElement namedElement = this.getNamedElement(wrapper);
        return namedElement == null ? "" : namedElement.getComment();
    }

    private RfNamedElement getNamedElement(Object wrapper) {
        if (!(wrapper instanceof AbstractRfTreeElementWrapper)) {
            return null;
        }
        if (!(((AbstractRfTreeElementWrapper)((Object)wrapper)).getRfElement() instanceof RfNamedElement)) {
            return null;
        }
        return (RfNamedElement)((AbstractRfTreeElementWrapper)((Object)wrapper)).getRfElement();
    }

    public void gotoElement(IProject project, Object wrapper) {
        try {
            if (!(wrapper instanceof AbstractRfTreeElementWrapper)) {
                return;
            }
            Object element = ((AbstractRfTreeElementWrapper)((Object)wrapper)).getRfElement();
            if (element == null || !(element instanceof RfNamedElement)) {
                return;
            }
            RfNamedElementActionHyperlink actionHyperlink = RfUtils.createOpenAction(this.getPluginConfig(), (RfNamedElement)element, project, (IRegion)new Region(0, 1));
            if (actionHyperlink == null) {
                return;
            }
            actionHyperlink.open();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public CompileOrderViewInput getInput(CompileOrderViewInputConfigurator configurator) {
        try {
            CompileOrderViewInput input = CompileOrderViewInput.emptyInput();
            IProject project = configurator.getProject();
            if (project == null || !project.isAccessible() || !project.hasNature(this.getPluginConfig().getNature())) {
                return input;
            }
            if (!DVTPlugin.getDefault().collect().c(project, this.getPluginConfig().feature())) {
                return input;
            }
            RfProject rfProject = this.getPluginConfig().getRfManager().getRfProject(project);
            if (rfProject == null) {
                return input;
            }
            List<RfModule> files = Arrays.asList(rfProject.getImportedModules());
            AbstractRfTreeElementWrapper root = this.getPluginConfig().createElementTreeWrapper();
            if (files == null || files.isEmpty()) {
                return input;
            }
            this.toWrappers(root, files, configurator, input);
            if (configurator.isCanceled()) {
                return CompileOrderViewInput.emptyInput();
            }
            ViewsUtils.hierarchicalSearch((IDVTElementWrapper)root, (DVTBaseLabelProvider)this.fLabelProvider, (UpdateJob)configurator.getUpdateJob(), (StringMatcher[])configurator.getSearchSegments(), (boolean[])configurator.getSearchStrictness());
            if (configurator.hasShowFilesWithErrors()) {
                AbstractRfTreeElementWrapper newRoot = this.getPluginConfig().createElementTreeWrapper();
                this.filterOutElementsWithoutErrors(root, newRoot, configurator);
                List<AbstractRfTreeElementWrapper> children = newRoot.getChildren();
                if (children != null) {
                    children.stream().forEach(e -> e.setAdditionalInfo(IDVTElementWrapper.Attribute.MATCH, true));
                    Collections.sort(children, (o1, o2) -> ((RfModule)o1.getRfElement()).getModuleIndex() - ((RfModule)o2.getRfElement()).getModuleIndex());
                } else {
                    newRoot.addChild(this.getPluginConfig().createElementTreeWrapper(new RfDummyElement(null, project.getName())));
                    newRoot.addChild(this.getPluginConfig().createElementTreeWrapper(new RfDummyElement(null, "does not contain")));
                    newRoot.addChild(this.getPluginConfig().createElementTreeWrapper(new RfDummyElement(null, "any e Language files with errors!")));
                }
                root = newRoot;
            }
            if (configurator.hasShowFilesWithErrors() || configurator.getSearchSegments() != null && configurator.getSearchSegments().length != 0) {
                this.countElements(root, configurator, input);
            } else {
                input.setNotFilteredElementCount(input.getElementCount());
            }
            int snEncrypedFilesCount = 0;
            int dvtEncryptedFilesCount = 0;
            for (RfModule module : files) {
                IResource r = (IResource)module.getAdapter(IResource.class);
                String prop = PropertiesManager.getSessionProperty((IResource)r, (String)PropertyTypes.QN_ENCRYPTED_FILE);
                if (prop == null) continue;
                if (prop.equals("SN")) {
                    ++snEncrypedFilesCount;
                    continue;
                }
                if (!prop.equals("DVT")) continue;
                ++dvtEncryptedFilesCount;
            }
            int elementCount = input.getElementCount();
            int notFilteredElementCount = input.getNotFilteredElementCount();
            String tableInfo = "[" + (elementCount != notFilteredElementCount ? String.valueOf(notFilteredElementCount) + "/" + elementCount : Integer.valueOf(elementCount)) + ViewsUtils.getUnitName((String)"file", (int)elementCount, (String)" ", (String)"") + "]";
            boolean isSN = snEncrypedFilesCount > 0;
            boolean isDVT = dvtEncryptedFilesCount > 0;
            String combined = String.format("%s%s%s", isSN ? String.valueOf(snEncrypedFilesCount) + " SN" : "", isSN && isDVT ? " and " : "", isDVT ? String.valueOf(dvtEncryptedFilesCount) + " DVT" : "");
            if (isSN || isDVT) {
                tableInfo = String.valueOf(tableInfo) + " [" + combined + " encrypted]";
            }
            input.setTableInfo(tableInfo);
            List elements = input.getElements();
            if (configurator.isShowLanguageNameAsRootElement()) {
                AbstractRfTreeElementWrapper languageWrapper = this.getPluginConfig().createElementTreeWrapper(new ELanguageElement<String>(String.valueOf(this.getLanguageKind().VIEW_NAME) + " " + tableInfo));
                elements.add(languageWrapper);
                if (root.getChildren() != null) {
                    languageWrapper.addChildren(root.getChildren());
                }
            } else if (root.getChildren() != null) {
                elements.addAll(root.getChildren());
            }
            return input;
        }
        catch (Exception e2) {
            DVTLogger.INSTANCE.logError((Throwable)e2);
            return CompileOrderViewInput.emptyInput();
        }
    }

    public void gotoInclude(IProject project, IDVTElementWrapper wrapper) {
    }

    public boolean isSelectable(Object element, Object referenceData, StringMatcher matcher) {
        if (!(element instanceof AbstractRfTreeElementWrapper)) {
            return false;
        }
        Object rfElement = ((IDVTElementWrapper)element).getRfElement();
        if (rfElement == null) {
            return false;
        }
        if (rfElement instanceof ELanguageElement) {
            return false;
        }
        return matcher == null || ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)this.fLabelProvider.getText(element));
    }

    public String getShortFileName(IDVTElementWrapper element) {
        RfNamedElement namedElement = this.getNamedElement(element);
        if (namedElement != null) {
            return namedElement.getName();
        }
        return "";
    }

    public boolean canShowGotoIncludeMenu(IDVTElementWrapper element) {
        return false;
    }

    public boolean canShowGotoImportMenu(IDVTElementWrapper element) {
        return !(element.getRfElement() instanceof ELanguageElement);
    }

    public DVTBaseLabelProvider getLabelProvider(Object wrapper) {
        return this.fLabelProvider;
    }

    public InspectViewInput getInspectInput(IDVTElementWrapper wrapper) {
        Object element;
        block7: {
            block6: {
                if (wrapper instanceof AbstractRfTreeElementWrapper) break block6;
                return null;
            }
            element = wrapper.getRfElement();
            if (element != null && element instanceof IRfNamedElement) break block7;
            return null;
        }
        try {
            RfNamedElement namedElement = (RfNamedElement)element;
            Object adapter = namedElement.getInternalAdapter(IResource.class);
            if (adapter instanceof IFile) {
                return DVTInspectViewUtils.getInstance().processFile((IFile)adapter);
            }
            if (adapter instanceof IProject) {
                return DVTInspectViewUtils.getInstance().processProject((IProject)adapter);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return null;
    }
}

