/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection.views;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.LabelProvider;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.guifilters.DVTEPackageGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.DVTGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.DVTNamedElementGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.ViewSet;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.UpdateJob;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.coverage.CoverageViewInput;
import ro.amiq.dvt.ui.views.coverage.CoverageViewInputConfigurator;
import ro.amiq.dvt.ui.views.coverage.ICoverageViewContributor;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.reflection.RfCoverLayer;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfEvent;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructMember;
import ro.amiq.edt.base.model.reflection.RfType;
import ro.amiq.edt.base.model.reflection.RfVar;
import ro.amiq.edt.base.model.reflection.util.RfUtils;
import ro.amiq.edt.base.model.reflection.views.AbstractRfTreeElementWrapper;
import ro.amiq.edt.base.model.reflection.views.CoverageViewLabelProvider;
import ro.amiq.edt.base.model.reflection.views.ELanguageElement;
import ro.amiq.edt.base.model.reflection.views.EQuickViewersUtil;
import ro.amiq.edt.base.ui.editor.hyperlink.RfNamedElementActionHyperlink;

public abstract class AbstractECoverageViewContributor
implements ICoverageViewContributor {
    private CoverageViewLabelProvider fLabelProvider = new CoverageViewLabelProvider(this.getPluginConfig());
    private int fNrTotalCoverGroups = 0;
    private int fNrNotFilteredCoverGroups = 0;
    private int fNrTotalCoverItems = 0;
    private int fNrNotFilteredCoverItems = 0;
    private boolean fHasGUIFilteredElements;

    public abstract IEPluginConfig getPluginConfig();

    public String getComment(Object wrapper) {
        RfNamedElement namedElement = this.getNamedElement(wrapper);
        return namedElement == null ? "" : DVTStringUtil.replaceAll((Pattern)DVTStringUtil.NEW_LINE, (CharSequence)namedElement.getComment(), (String)" ");
    }

    private RfNamedElement getNamedElement(Object wrapper) {
        if (!(wrapper instanceof AbstractRfTreeElementWrapper)) {
            return null;
        }
        if (!(((AbstractRfTreeElementWrapper)((Object)wrapper)).getRfElement() instanceof RfNamedElement)) {
            return null;
        }
        return (RfNamedElement)((AbstractRfTreeElementWrapper)((Object)wrapper)).getRfElement();
    }

    public void gotoElement(IProject project, Object wrapper) {
        if (!(wrapper instanceof AbstractRfTreeElementWrapper)) {
            return;
        }
        Object element = ((AbstractRfTreeElementWrapper)((Object)wrapper)).getRfElement();
        if (element == null || !(element instanceof RfNamedElement)) {
            return;
        }
        RfNamedElement namedElement = (RfNamedElement)element;
        RfNamedElementActionHyperlink actionHyperlink = null;
        if (namedElement instanceof RfEvent) {
            RfDefElement coverLayer = null;
            for (RfDefElement defElement : namedElement.getLayers()) {
                if (!(defElement instanceof RfCoverLayer)) continue;
                coverLayer = defElement;
                break;
            }
            actionHyperlink = coverLayer != null ? RfUtils.createOpenAction(this.getPluginConfig(), coverLayer, project, null, false) : RfUtils.createOpenAction(this.getPluginConfig(), namedElement, project, null);
        } else {
            actionHyperlink = RfUtils.createOpenAction(this.getPluginConfig(), namedElement, project, null);
        }
        if (actionHyperlink == null) {
            return;
        }
        actionHyperlink.open();
    }

    public CoverageViewInput getInput(CoverageViewInputConfigurator inputSourceConfigurator) {
        this.fNrTotalCoverGroups = 0;
        this.fNrNotFilteredCoverGroups = 0;
        this.fNrTotalCoverItems = 0;
        this.fNrNotFilteredCoverItems = 0;
        this.fHasGUIFilteredElements = false;
        ArrayList<IDVTElementWrapper> elements = new ArrayList<IDVTElementWrapper>();
        try {
            if (!(inputSourceConfigurator.getSource() instanceof IProject)) {
                return new CoverageViewInput(this.fNrTotalCoverGroups, this.fNrNotFilteredCoverGroups, this.fNrTotalCoverItems, this.fNrNotFilteredCoverItems, 0, 0, elements, this.fHasGUIFilteredElements);
            }
            IProject project = (IProject)inputSourceConfigurator.getSource();
            if (!project.isAccessible() || !project.hasNature(this.getPluginConfig().getNature())) {
                return new CoverageViewInput(this.fNrTotalCoverGroups, this.fNrNotFilteredCoverGroups, this.fNrTotalCoverItems, this.fNrNotFilteredCoverItems, 0, 0, elements, this.fHasGUIFilteredElements);
            }
            if (!DVTPlugin.getDefault().collect().c(project, this.getPluginConfig().feature())) {
                return new CoverageViewInput(this.fNrTotalCoverGroups, this.fNrNotFilteredCoverGroups, this.fNrTotalCoverItems, this.fNrNotFilteredCoverItems, 0, 0, elements, this.fHasGUIFilteredElements);
            }
            RfProject rfProject = this.getPluginConfig().getRfManager().getRfProject(project);
            if (rfProject == null) {
                return new CoverageViewInput(this.fNrTotalCoverGroups, this.fNrNotFilteredCoverGroups, this.fNrTotalCoverItems, this.fNrNotFilteredCoverItems, 0, 0, elements, this.fHasGUIFilteredElements);
            }
            List<IDVTElementWrapper> wrappers = this.toWrappers(rfProject, inputSourceConfigurator.getSearchSegments(), inputSourceConfigurator.getSearchStrictness(), inputSourceConfigurator.getUpdateJob());
            if (wrappers == null || wrappers.isEmpty()) {
                return new CoverageViewInput(this.fNrTotalCoverGroups, this.fNrNotFilteredCoverGroups, this.fNrTotalCoverItems, this.fNrNotFilteredCoverItems, 0, 0, elements, this.fHasGUIFilteredElements);
            }
            this.internalSort(wrappers, inputSourceConfigurator.isSortByType());
            if (inputSourceConfigurator.isShowLanguageNameAsRootElement()) {
                StringBuilder infoText = new StringBuilder("[");
                if (this.fNrTotalCoverGroups == this.fNrNotFilteredCoverGroups) {
                    infoText.append(this.fNrTotalCoverGroups);
                } else {
                    infoText.append(this.fNrNotFilteredCoverGroups).append("/").append(this.fNrTotalCoverGroups);
                }
                infoText.append(ViewsUtils.getUnitName((String)"cover group", (int)this.fNrTotalCoverGroups, (String)" ", (String)"")).append("][");
                if (this.fNrTotalCoverItems == this.fNrNotFilteredCoverItems) {
                    infoText.append(this.fNrTotalCoverItems);
                } else {
                    infoText.append(this.fNrNotFilteredCoverItems).append("/").append(this.fNrTotalCoverItems);
                }
                infoText.append(ViewsUtils.getUnitName((String)"cover item", (int)this.fNrTotalCoverItems, (String)" ", (String)"")).append("]");
                AbstractRfTreeElementWrapper languageWrapper = this.getPluginConfig().createElementTreeWrapper(new ELanguageElement<String>(String.valueOf(this.getLanguageKind().VIEW_NAME) + " " + infoText.toString()));
                elements.add(languageWrapper);
                languageWrapper.addChildren(wrappers);
            } else {
                elements.addAll(wrappers);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return new CoverageViewInput(this.fNrTotalCoverGroups, this.fNrNotFilteredCoverGroups, this.fNrTotalCoverItems, this.fNrNotFilteredCoverItems, 0, 0, elements, this.fHasGUIFilteredElements);
    }

    private List<IDVTElementWrapper> toWrappers(RfProject rfProject, StringMatcher[] searchSegments, boolean[] searchStrictness, UpdateJob updateJob) {
        HashSet<RfStruct> filteredPackages = new HashSet<RfStruct>();
        Collection<RfStruct> packages = rfProject.getAllPackages();
        for (RfStruct pkg : packages) {
            if (DVTEPackageGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.COVERAGE, (IProject)rfProject.getProject(), (String)pkg.getPackageName()) == DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) continue;
            filteredPackages.add(pkg);
        }
        HashSet<RfStruct> filteredStructs = new HashSet<RfStruct>();
        List<RfStruct> structs = rfProject.getAllStructs();
        for (RfStruct struct : structs) {
            if (DVTNamedElementGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.COVERAGE, (IRfNamedElement)struct, () -> this.fLabelProvider.getText((Object)this.getPluginConfig().createElementTreeWrapper(struct))) == DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) continue;
            filteredStructs.add(struct);
        }
        IDVTElementWrapper tmp = this.toWrappersRecursive(rfProject, rfProject, searchSegments, searchStrictness, updateJob, filteredPackages, filteredStructs, new HashSet<Object>(), new HashSet<Object>());
        if (tmp != null) {
            ViewsUtils.hierarchicalSearch((IDVTElementWrapper)tmp, (DVTBaseLabelProvider)this.fLabelProvider, (UpdateJob)updateJob, (StringMatcher[])searchSegments, (boolean[])searchStrictness);
            this.countCoverGorupsAndItems(tmp);
            return tmp.getChildren();
        }
        return null;
    }

    private IDVTElementWrapper toWrappersRecursive(RfProject rfProject, Object root, StringMatcher[] searchSegments, boolean[] searchStrictness, UpdateJob updateJob, HashSet<RfStruct> filteredPackages, HashSet<RfStruct> filteredStructs, HashSet<Object> filteredParents, HashSet<Object> elementParents) {
        List<Object> children = this.getChildCoverGroupsContainersAndCoverGroups(root);
        if (children.isEmpty()) {
            if (!(root instanceof RfEvent)) {
                return null;
            }
            RfEvent event = (RfEvent)root;
            boolean hasCovergroup = false;
            RfDefElement coverLayer = null;
            List<RfDefElement> allLayers = event.getLayers();
            for (RfDefElement layer : allLayers) {
                if (!(layer instanceof RfCoverLayer) || layer.getLayerModule() == null || layer.getLayerModule().isInternalModule()) continue;
                coverLayer = layer;
                hasCovergroup = true;
                break;
            }
            if (!hasCovergroup) {
                return null;
            }
            for (Object myParent : elementParents) {
                if (!filteredParents.contains(myParent)) continue;
                this.fHasGUIFilteredElements = true;
                return null;
            }
            AbstractRfTreeElementWrapper myWrapper = this.getPluginConfig().createElementTreeWrapper(root);
            if (DVTNamedElementGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.COVERAGE, (IRfDefElement)coverLayer, () -> this.fLabelProvider.getText((Object)myWrapper)) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
                this.fHasGUIFilteredElements = true;
                return null;
            }
            ++this.fNrTotalCoverGroups;
            for (RfVar coverItem : event.getCoverItems()) {
                RfDefElement declaration = coverItem.getDeclaration();
                if (declaration != null && declaration.isImplicit()) continue;
                if (DVTNamedElementGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.COVERAGE, (IRfNamedElement)coverItem, () -> this.fLabelProvider.getText((Object)this.getPluginConfig().createElementTreeWrapper(coverItem))) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
                    this.fHasGUIFilteredElements = true;
                    continue;
                }
                myWrapper.addChild(this.getPluginConfig().createElementTreeWrapper(coverItem));
                ++this.fNrTotalCoverItems;
            }
            return myWrapper;
        }
        RfStruct struct = null;
        if (root instanceof RfStruct) {
            struct = (RfStruct)root;
        }
        if (struct != null) {
            RfStruct pkg;
            if (filteredStructs.contains(struct)) {
                filteredParents.add(struct);
            }
            if ((pkg = rfProject.getPackage(struct.getPackageName())) != null && filteredPackages.contains(pkg)) {
                filteredParents.add(pkg);
            }
        }
        ArrayList<IDVTElementWrapper> myChildren = new ArrayList<IDVTElementWrapper>();
        if (!children.isEmpty()) {
            elementParents.add(root);
        }
        for (Object child : children) {
            IDVTElementWrapper childWrapper = this.toWrappersRecursive(rfProject, child, searchSegments, searchStrictness, updateJob, filteredPackages, filteredStructs, filteredParents, elementParents);
            if (childWrapper == null) continue;
            myChildren.add(childWrapper);
        }
        if (!children.isEmpty()) {
            elementParents.remove(root);
        }
        if (myChildren.isEmpty()) {
            return null;
        }
        AbstractRfTreeElementWrapper myWrapper = this.getPluginConfig().createElementTreeWrapper(root);
        myWrapper.addChildren(myChildren);
        return myWrapper;
    }

    private List<Object> getChildCoverGroupsContainersAndCoverGroups(Object root) {
        RfStruct struct;
        List<RfStructMember> allEvents;
        RfStruct pack;
        Collection<RfType> allTypes;
        RfProject proj;
        Collection<RfStruct> allPack;
        ArrayList<Object> result = new ArrayList<Object>();
        if (root instanceof RfProject && (allPack = (proj = (RfProject)root).getAllPackages()) != null) {
            result.addAll(new ArrayList<RfStruct>(allPack));
        }
        if (root instanceof RfStruct && RfStruct.isPackageElement(root, true) && (allTypes = (pack = (RfStruct)root).getTypes()) != null) {
            for (RfType rfType : allTypes) {
                if (!(rfType instanceof RfStruct)) continue;
                result.add(rfType);
            }
        }
        if (root instanceof RfStruct && !RfStruct.isPackageElement(root, true) && (allEvents = (struct = (RfStruct)root).getEvents()) != null && !allEvents.isEmpty()) {
            result.addAll(allEvents);
        }
        return result;
    }

    private void countCoverGorupsAndItems(IDVTElementWrapper root) {
        if (root == null) {
            return;
        }
        if (root.getRfElement() instanceof RfEvent) {
            ++this.fNrNotFilteredCoverGroups;
            if (root.hasChildren()) {
                this.fNrNotFilteredCoverItems += root.getChildren().size();
            }
            return;
        }
        if (!root.hasChildren()) {
            return;
        }
        List children = root.getChildren();
        for (IDVTElementWrapper child : children) {
            this.countCoverGorupsAndItems(child);
        }
    }

    private void internalSort(List<IDVTElementWrapper> wrappers, boolean sortByType) {
        if (wrappers == null || wrappers.isEmpty()) {
            return;
        }
        if (sortByType) {
            Collections.sort(wrappers, EQuickViewersUtil.getInstance().getSortByTypeComparator((LabelProvider)this.fLabelProvider));
        } else {
            Collections.sort(wrappers, EQuickViewersUtil.getInstance().getSortByNameComparator((LabelProvider)this.fLabelProvider));
        }
        for (IDVTElementWrapper wrapper : wrappers) {
            this.internalSort(wrapper.getChildren(), sortByType);
        }
    }

    public boolean isSelectable(Object element, Object referenceData, StringMatcher matcher) {
        if (!(element instanceof AbstractRfTreeElementWrapper)) {
            return false;
        }
        Object rfElement = ((IDVTElementWrapper)element).getRfElement();
        if (rfElement == null) {
            return false;
        }
        if (rfElement instanceof RfEvent || rfElement instanceof RfVar) {
            return matcher == null || ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)this.fLabelProvider.getText(element)) || ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)this.fLabelProvider.getColumnText(element, 1));
        }
        return false;
    }

    public DVTBaseLabelProvider getLabelProvider(Object wrapper) {
        return this.fLabelProvider;
    }
}

