/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection.views;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.editor.DVTPosition;
import ro.amiq.dvt.ui.editor.IDVTEditor;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.InspectViewUpdateEvent;
import ro.amiq.dvt.ui.views.InspectViewUpdateEventCommon;
import ro.amiq.dvt.ui.views.inspect.BaseInspectViewContributor;
import ro.amiq.dvt.ui.views.inspect.DVTInspectViewUtils;
import ro.amiq.dvt.ui.views.inspect.FileCompileInfo;
import ro.amiq.dvt.ui.views.inspect.InspectViewInput;
import ro.amiq.dvt.ui.views.inspect.InspectViewPosition;
import ro.amiq.dvt.utils.DVTDocumentCommon;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.reflection.AbstractRfManager;
import ro.amiq.edt.base.model.reflection.RfEnum;
import ro.amiq.edt.base.model.reflection.RfMacro;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.ascomputed.base.AsComputedBase;
import ro.amiq.edt.base.model.reflection.ascomputed.base._Int;
import ro.amiq.edt.base.model.reflection.ascomputed.base.__etools_string;
import ro.amiq.edt.base.model.reflection.predefined.ecode.RfPredefinedCodeLoader;
import ro.amiq.edt.base.model.reflection.semantic.RfStructQualifier;
import ro.amiq.edt.base.model.reflection.semantic.RfSubtypeElement;
import ro.amiq.edt.base.model.reflection.util.RfUtils;
import ro.amiq.edt.base.model.reflection.util.RfUtilsCommon;
import ro.amiq.edt.base.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.edt.base.ui.editor.AbstractEEditor;
import ro.amiq.edt.base.ui.macroexpansion.MacroExpander;

public abstract class AbstractEInspectViewContributorCommon
extends BaseInspectViewContributor {
    private static final Pattern NUMBER_PATTERN = Pattern.compile("([\\d]*['0]?[bBdDoOhH] *)?[0-9A-Fa-fxXzZ_.?-]+[kKmM]?");
    private static final Pattern WS = Pattern.compile("\\s");
    private static final HashSet<Character> possibleCharacters = new HashSet<Character>(Arrays.asList(Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9'), Character.valueOf('0'), Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('e'), Character.valueOf('f'), Character.valueOf('\''), Character.valueOf('h'), Character.valueOf('o'), Character.valueOf('d'), Character.valueOf('x'), Character.valueOf('k'), Character.valueOf('m'), Character.valueOf('_'), Character.valueOf('A'), Character.valueOf('B'), Character.valueOf('C'), Character.valueOf('D'), Character.valueOf('E'), Character.valueOf('F'), Character.valueOf('H'), Character.valueOf('S'), Character.valueOf('O'), Character.valueOf('D'), Character.valueOf('X'), Character.valueOf('K'), Character.valueOf('M')));

    public abstract IEPluginConfig getPluginConfig();

    public InspectViewInput getInput(InspectViewUpdateEvent event) {
        InspectViewInput result;
        block9: {
            IProject iProject;
            block8: {
                block7: {
                    block6: {
                        result = null;
                        if (event.getLanguage().equals((Object)this.getLanguageKind())) break block6;
                        return null;
                    }
                    iProject = event.getProject();
                    if (iProject != null && iProject.isAccessible() && iProject.hasNature(this.getPluginConfig().getNature())) break block7;
                    return null;
                }
                if (DVTPlugin.getDefault().collect().c(iProject, this.getPluginConfig().feature())) break block8;
                return null;
            }
            RfProject rfProject = this.getPluginConfig().getRfManager().getRfProject(iProject);
            if (rfProject != null) break block9;
            return null;
        }
        try {
            result = this.getInspectContent(event);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return result;
    }

    private InspectViewInput getInspectContent(InspectViewUpdateEvent event) {
        if (event.hasInfos()) {
            return this.getInspectFromDiagram(event);
        }
        IProject project = event.getProject();
        Object selectedElement = event.getElement();
        if (event.getType() == InspectViewUpdateEventCommon.TYPE.WRAPPER && selectedElement instanceof IDVTElementWrapper) {
            selectedElement = ((IDVTElementWrapper)selectedElement).getRfElement();
        }
        if (selectedElement instanceof IRfNamedElement) {
            IRfNamedElement element = (IRfNamedElement)selectedElement;
            if (element instanceof RfSubtypeElement) {
                element = ((RfSubtypeElement)element).getNamedElement();
            }
            if (element instanceof RfStructQualifier) {
                element = ((RfStructQualifier)element).getEnum();
            }
            return AbstractEInspectViewContributorCommon.processNamedElement(this.getPluginConfig().getRfManager(), project, element, event.getCallOffset());
        }
        if (selectedElement instanceof IRfDefElement) {
            IRfDefElement def = (IRfDefElement)selectedElement;
            return DVTInspectViewUtils.getInstance().processDefElement(project, def, "//", null, 0, null);
        }
        return null;
    }

    public static InspectViewInput processNamedElement(AbstractRfManager rfManager, IProject project, IRfNamedElement element, int callOffset) {
        if (element instanceof RfMacro) {
            return AbstractEInspectViewContributorCommon.processMacro(rfManager, project, (RfMacro)element, callOffset);
        }
        IRfDefElement declaration = element.getDeclaration();
        if (element instanceof RfEnum) {
            return DVTInspectViewUtils.getInstance().createInspectViewInput(project, declaration, "//", null, 0, null, element.getLine(), element.getLine());
        }
        return DVTInspectViewUtils.getInstance().processDefElement(project, declaration, "//", null, 0, null);
    }

    public static InspectViewInput processMacro(AbstractRfManager rfManager, IProject project, RfMacro macroInfo, int macroCallOffset) {
        IFile iFile;
        boolean isTableMacro;
        int declarationLine;
        StringBuilder tmp;
        int macroCallLine;
        RfProject rfProject;
        IDocument document;
        IFile file;
        StringBuilder contentResult;
        String lineDelimiter;
        int currentOffset;
        InspectViewInput result;
        StringBuilder lineNumberContent;
        block26: {
            block25: {
                block24: {
                    block23: {
                        AbstractEEditor eEditor;
                        block22: {
                            IEditorPart editor;
                            block21: {
                                if (macroCallOffset < 0 || macroInfo.isPreprocessing()) {
                                    return AbstractEInspectViewContributorCommon.processMacroDefinition(project, macroInfo);
                                }
                                lineNumberContent = new StringBuilder();
                                result = new InspectViewInput("");
                                currentOffset = 0;
                                lineDelimiter = DVTDocumentCommon.getLineDelimiterByProject((IProject)project);
                                contentResult = new StringBuilder();
                                editor = DVTInspectViewUtils.getInstance().getActiveEditor();
                                if (editor instanceof AbstractEEditor) break block21;
                                return null;
                            }
                            eEditor = (AbstractEEditor)editor;
                            file = (IFile)eEditor.getAdapter(IResource.class);
                            if (file != null) break block22;
                            return null;
                        }
                        document = eEditor.getDocument();
                        if (document != null) break block23;
                        return null;
                    }
                    rfProject = rfManager.getRfProject(project);
                    if (rfProject != null) break block24;
                    return null;
                }
                macroCallLine = DVTFileUtils.getInstance().getLineFromOffset(file, macroCallOffset);
                tmp = new StringBuilder();
                declarationLine = macroInfo.getLine();
                if (macroInfo.getFileAdapter() != null) break block25;
                return null;
            }
            String declarationFileName = macroInfo.getFileAdapter().getName();
            isTableMacro = "__etools__table'__etools__expansion".equals(macroInfo.getName());
            if (!isTableMacro && declarationFileName.equals(file.getName()) && macroCallLine == declarationLine) {
                return AbstractEInspectViewContributorCommon.processMacroDefinition(project, macroInfo);
            }
            iFile = DVTFileUtils.getInstance().findProjectFileUsingAbsolutePath(project, macroInfo.getDeclaration().getParserPath().path);
            if (iFile != null) break block26;
            return null;
        }
        try {
            String expandedMacro;
            int currentLine;
            int commentStartLine;
            Position[] positions;
            String fileInfo = DVTInspectViewUtils.getInstance().getInfoLine(project, "Macro signature", iFile, "//", -1);
            if (!isTableMacro) {
                tmp.append(fileInfo);
                lineNumberContent.append("\n");
            }
            if ((positions = DVTInspectViewUtils.getInstance().getBackgroundAndHyperlinkPositions(currentOffset, fileInfo, iFile, declarationLine)) != null) {
                result.addFileNamePosition(positions[0]);
                result.addHyperlinkPosition((InspectViewPosition)positions[1]);
            }
            contentResult.append((CharSequence)tmp);
            currentOffset = contentResult.length();
            tmp = new StringBuilder();
            int aboveCommentStartLine = -1;
            if (macroInfo.getCommentBlock() != null && (commentStartLine = macroInfo.getCommentBlock().getAboveCommentStartLine()) >= 0 && commentStartLine <= macroCallLine) {
                aboveCommentStartLine = commentStartLine;
            }
            int startLine = aboveCommentStartLine > 0 ? aboveCommentStartLine : declarationLine;
            int endLine = declarationLine - 1;
            String data = DVTFileUtils.getInstance().getLinesFromFile(iFile, startLine, endLine, null);
            if (!isTableMacro) {
                String signature = AbstractEInspectViewContributorCommon.getSignature(macroInfo);
                lineNumberContent.append(DVTInspectViewUtils.getInstance().getLineNumberContent(startLine, declarationLine, false, fileInfo));
                lineNumberContent.append("\n");
                tmp.append(DVTInspectViewUtils.getInstance().formatContent(data, project, false));
                tmp.append(DVTInspectViewUtils.getInstance().formatContent(signature, project, false));
                result.addContentPosition((Position)new DVTPosition(currentOffset, tmp.length()));
                tmp.append(lineDelimiter);
                tmp.append(lineDelimiter);
            }
            contentResult.append((CharSequence)tmp);
            currentOffset = contentResult.length();
            RfUtilsCommon.MacroRegion region = RfUtils.getMacro(rfProject, file, document, macroCallOffset);
            String macroCall = null;
            if (region != null && region.getRegion() != null) {
                IRegion lineRegion = document.getLineInformationOfOffset(macroCallOffset);
                String lineText = document.get(lineRegion.getOffset(), lineRegion.getLength());
                int initialIndent = 0;
                int i = 0;
                while (i < lineText.length()) {
                    if (!Character.isWhitespace(lineText.charAt(i))) break;
                    ++initialIndent;
                    ++i;
                }
                TextSelection selection = new TextSelection(document, region.getRegion().getOffset(), region.getRegion().getLength());
                macroCall = selection.getText();
                tmp = new StringBuilder();
                fileInfo = DVTInspectViewUtils.getInstance().getInfoLine(project, "Macro call", file, "//", -1);
                tmp.append(fileInfo);
                positions = DVTInspectViewUtils.getInstance().getBackgroundAndHyperlinkPositions(currentOffset, fileInfo, file, macroCallLine);
                if (positions != null) {
                    result.addFileNamePosition(positions[0]);
                    result.addHyperlinkPosition((InspectViewPosition)positions[1]);
                }
                contentResult.append((CharSequence)tmp);
                currentOffset = contentResult.length();
                String macroCallContent = DVTInspectViewUtils.getInstance().formatContent(macroCall, project, false);
                int noLines = macroCallContent.split(lineDelimiter).length;
                currentLine = contentResult.toString().split(lineDelimiter).length;
                DVTInspectViewUtils.getInstance().skipToLine(lineNumberContent, currentLine - 1);
                lineNumberContent.append(DVTInspectViewUtils.getInstance().getLineNumberContent(macroCallLine, macroCallLine + noLines - 1, false, fileInfo));
                tmp = new StringBuilder();
                tmp.append(macroCallContent);
                result.addContentPosition((Position)new DVTPosition(currentOffset, tmp.length()));
                tmp.append(lineDelimiter);
                tmp.append(lineDelimiter);
                contentResult.append((CharSequence)tmp);
                currentOffset = contentResult.length();
                String contentType = ((IDocumentExtension3)document).getDocumentPartitioner("__e_partitioning").getContentType(selection.getOffset());
                if (macroCall == null) {
                    macroCall = macroInfo.getSignature();
                }
                expandedMacro = null;
                try {
                    expandedMacro = new MacroExpander().expand(initialIndent, macroCall, rfProject, contentType, 1, region.getUserDefineReplace());
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            } else {
                return AbstractEInspectViewContributorCommon.processMacroDefinition(project, macroInfo);
            }
            tmp = new StringBuilder();
            fileInfo = "// Macro expansion ";
            tmp.append(fileInfo);
            result.addFileNamePosition((Position)new DVTPosition(currentOffset, tmp.length()));
            tmp.append(lineDelimiter);
            contentResult.append((CharSequence)tmp);
            currentOffset = contentResult.length();
            tmp = new StringBuilder();
            tmp.append(DVTInspectViewUtils.getInstance().formatContent(expandedMacro, project, false));
            result.addContentPosition((Position)new DVTPosition(currentOffset, tmp.length()));
            tmp.append(lineDelimiter);
            contentResult.append((CharSequence)tmp);
            currentOffset = contentResult.length();
            currentLine = contentResult.toString().split(lineDelimiter).length;
            result.setMaxDigitsNumber(DVTInspectViewUtils.getInstance().getMaxDigitsNumberFromLineNumberContent(lineNumberContent.toString()));
            result.setLineNumberContent(lineNumberContent.toString());
            result.setContent(contentResult.toString());
            return result;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    private static InspectViewInput processMacroDefinition(IProject project, RfMacro macroInfo) {
        int aboveCommentStartLine;
        int contextLines;
        if (macroInfo.getDeclaration() == null) {
            return null;
        }
        int origStartLine = macroInfo.getDeclaration().getStartLine();
        int origEndLine = macroInfo.getDeclaration().getEndLine();
        if (origStartLine < 0 || origEndLine < 0 || origStartLine > origEndLine) {
            return null;
        }
        if (origEndLine - origStartLine + 1 > 1000) {
            origEndLine = origStartLine + 1000;
        }
        int n = contextLines = origStartLine == origEndLine ? DVTInspectViewUtils.getInstance().getInspectContextLines() : 0;
        if (macroInfo.getCommentBlock() != null && (aboveCommentStartLine = macroInfo.getCommentBlock().getAboveCommentStartLine()) >= 0 && aboveCommentStartLine <= origEndLine) {
            origStartLine = aboveCommentStartLine;
        }
        boolean addContextLines = origStartLine >= contextLines + 1 && contextLines > 0;
        int startLine = addContextLines ? origStartLine - contextLines : origStartLine;
        int endLine = origEndLine + contextLines;
        IFile iFile = DVTFileUtils.getInstance().findProjectFileUsingAbsolutePath(project, macroInfo.getDeclaration().getParserPath().path);
        if (iFile == null) {
            return null;
        }
        String fileData = DVTFileUtils.getInstance().getLinesFromFile(iFile, startLine, endLine, null);
        if (fileData == null || fileData.equals("")) {
            return null;
        }
        String fileInfo = DVTInspectViewUtils.getInstance().getInfoLine(project, "Macro Definition", iFile, "//", -1);
        String content = String.valueOf(fileInfo) + fileData;
        InspectViewInput result = new InspectViewInput(content);
        Position[] positions = DVTInspectViewUtils.getInstance().getBackgroundAndHyperlinkPositions(0, fileInfo, iFile, macroInfo.getLine());
        if (positions != null) {
            result.addFileNamePosition(positions[0]);
            result.addHyperlinkPosition((InspectViewPosition)positions[1]);
        }
        int contentStartLine = addContextLines ? origStartLine - startLine + 1 : 1;
        int contentEndLine = addContextLines ? origEndLine - startLine + 1 : origEndLine - origStartLine + 1;
        result.addContentPositions(DVTInspectViewUtils.getInstance().getPaintedPositions(new Document(content), contentStartLine, contentEndLine));
        result.setMaxDigitsNumber(DVTInspectViewUtils.getInstance().getDigits(endLine));
        result.setLineNumberContent(DVTInspectViewUtils.getInstance().getLineNumberContent(startLine, endLine, true, fileInfo));
        return result;
    }

    private static String getSignature(RfMacro macroInfo) {
        return "define <" + macroInfo.getName() + "> \"" + macroInfo.getStringLiteral() + " \"" + (macroInfo.isAsComputed() ? " as computed " : " as ") + " {...}";
    }

    public FileCompileInfo getCompileInfo(IFile iFile) {
        if (iFile == null) {
            return null;
        }
        RfProject rfProject = this.getPluginConfig().getRfManager().getRfProject(iFile.getProject());
        if (rfProject == null) {
            return null;
        }
        ParserPath parserPath = DVTFileUtils.getInstance().resource2parser((IResource)iFile);
        if (parserPath == null) {
            return null;
        }
        if (rfProject.getCompiledFilesSet() == null) {
            return null;
        }
        RfModule module = rfProject.getModule(parserPath);
        if (module == null) {
            return null;
        }
        int index = module.getModuleIndex() - RfPredefinedCodeLoader.PREDEF_FILES_LIST.length;
        return new FileCompileInfo(Collections.singletonList(index), Collections.singletonList(IBuildConfigParserConstants.LanguageSyntax.E_1647_2011));
    }

    public HistoryItem createHistoryItemForElementAtCursor(IDVTEditor editor, int cursorOffset) {
        IDocument document;
        RfProject rfProject;
        IProject project;
        IFile file;
        block13: {
            AbstractEEditor eEditor;
            block12: {
                block11: {
                    block10: {
                        IEditorInput editorInput;
                        block9: {
                            block8: {
                                try {
                                    if (editor instanceof AbstractEEditor) break block8;
                                    return null;
                                }
                                catch (Exception e) {
                                    DVTLogger.INSTANCE.logError((Throwable)e);
                                    return null;
                                }
                            }
                            eEditor = (AbstractEEditor)editor;
                            editorInput = eEditor.getEditorInput();
                            if (editorInput != null) break block9;
                            return null;
                        }
                        file = (IFile)editorInput.getAdapter(IFile.class);
                        if (file != null) break block10;
                        return null;
                    }
                    project = file.getProject();
                    if (project != null) break block11;
                    return null;
                }
                rfProject = this.getPluginConfig().getRfManager().getRfProject(project);
                if (rfProject != null) break block12;
                return null;
            }
            document = eEditor.getDocument();
            if (document != null) break block13;
            return null;
        }
        cursorOffset = cursorOffset >= document.getLength() ? document.getLength() - 1 : cursorOffset;
        List<Object> object = Arrays.asList(file, rfProject, document);
        return new InspectViewUpdateEvent(object, this.getLanguageKind(), cursorOffset, null, project, InspectViewUpdateEventCommon.TYPE.PRELIMINARY_EDITOR);
    }

    public InspectViewUpdateEvent createEventFromPreliminary(InspectViewUpdateEvent preliminaryEvent) {
        Object preliminaryEventElement = preliminaryEvent.getElement();
        if (!(preliminaryEventElement instanceof List)) {
            return null;
        }
        List preliminaryData = (List)preliminaryEventElement;
        int cursorOffset = preliminaryEvent.getCallOffset();
        IProject project = preliminaryEvent.getProject();
        IFile file = (IFile)preliminaryData.get(0);
        RfProject rfProject = (RfProject)preliminaryData.get(1);
        IDocument document = (IDocument)preliminaryData.get(2);
        if (file == null || rfProject == null || document == null) {
            return null;
        }
        IRfNamedElement element = null;
        InspectViewUpdateEvent returnEvent = null;
        RfWNamedElementAndScope elementAndScope = RfUtils.getRfElement(rfProject, file, document, cursorOffset, false);
        IRfFileDef projectFile = rfProject.getFile((IResource)file);
        if (projectFile == null || projectFile.getParserPath() == null) {
            return null;
        }
        if (elementAndScope == null || elementAndScope.getIRfNamedElement() == null) {
            RfUtilsCommon.MacroRegion macroRegion = RfUtils.getMacro(rfProject, file, document, cursorOffset);
            if (macroRegion != null && macroRegion.getMacro() != null) {
                RfMacro macro = macroRegion.getMacro();
                if ("__etools__table'__etools__expansion".equals(macro.getName())) {
                    macro = rfProject.getTableMacro(macro, file, cursorOffset);
                }
                returnEvent = new InspectViewUpdateEvent((Object)macro, this.getLanguageKind(), cursorOffset, projectFile.getParserPath().path, project, InspectViewUpdateEventCommon.TYPE.EDITOR);
                return returnEvent;
            }
            String number = this.findNumberAtOffset(cursorOffset, document);
            if (number != null && this.parseNumber(number) != null) {
                return new InspectViewUpdateEvent((Object)number, this.getLanguageKind(), cursorOffset, projectFile.getParserPath().path, project, InspectViewUpdateEventCommon.TYPE.NUMBER);
            }
        } else {
            element = elementAndScope.getIRfNamedElement();
        }
        returnEvent = element == null ? new InspectViewUpdateEvent(file, InspectViewUpdateEventCommon.TYPE.FILE) : new InspectViewUpdateEvent((Object)element, element.getLanguageKind(), cursorOffset, projectFile.getParserPath().path, project, InspectViewUpdateEventCommon.TYPE.EDITOR);
        return returnEvent;
    }

    public Number parseNumber(String number) {
        try {
            return AsComputedBase.as_a(new __etools_string(number), _Int.class);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String findNumberAtOffset(int originalOffset, IDocument document) {
        int startOffset;
        int endOffset;
        block9: {
            block8: {
                if (document != null && originalOffset >= 0) break block8;
                return null;
            }
            try {
                char c;
                int length = document.getLength();
                endOffset = originalOffset;
                boolean isTickLeft = this.isTickLeft(startOffset, document);
                boolean tickFound = false;
                for (startOffset = originalOffset; startOffset >= 0; --startOffset) {
                    c = document.getChar(startOffset);
                    if (c == '\'') {
                        tickFound = true;
                    }
                    if (!possibleCharacters.contains(Character.valueOf(c)) && (c != ' ' || tickFound || !isTickLeft)) break;
                }
                tickFound = false;
                while (endOffset < length) {
                    c = document.getChar(endOffset);
                    if (c == '\'') {
                        tickFound = true;
                    }
                    if (!possibleCharacters.contains(Character.valueOf(c)) && (c != ' ' || !tickFound && !isTickLeft)) break;
                    ++endOffset;
                }
                if (startOffset != endOffset) break block9;
                return null;
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
        String number = document.get(startOffset + 1, endOffset - startOffset - 1);
        number = DVTStringUtil.replaceAll((Pattern)WS, (CharSequence)number, (String)"");
        return this.isNumber(number) ? number : null;
    }

    private boolean isNumber(String numberAtOffset) {
        return numberAtOffset != null && DVTStringUtil.matches((Pattern)NUMBER_PATTERN, (CharSequence)numberAtOffset);
    }

    private boolean isTickLeft(int startOffset, IDocument document) throws BadLocationException {
        int length = document.getLength();
        boolean tickFound = false;
        while (startOffset >= 0 && startOffset < length) {
            char c = document.getChar(startOffset);
            if (!possibleCharacters.contains(Character.valueOf(c)) && ' ' != c) break;
            tickFound |= c == '\'';
            --startOffset;
        }
        return tickFound;
    }
}

