/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection.views;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IDVTJob;
import ro.amiq.dvt.ui.views.UpdateJob;
import ro.amiq.dvt.ui.views.UpdateViewEvent;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.layers.LayersViewInput;
import ro.amiq.dvt.ui.views.layers.LayersViewInputConfigurator;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.edt.base.model.reflection.FullName;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfScalarTypeLayer;
import ro.amiq.edt.base.model.reflection.RfStructLayer;
import ro.amiq.edt.base.model.reflection.util.RfUtils;
import ro.amiq.edt.base.model.reflection.views.AbstractELayersViewContributorCommon;
import ro.amiq.edt.base.model.reflection.views.AbstractRfTreeElementWrapper;
import ro.amiq.edt.base.ui.editor.AbstractEEditor;
import ro.amiq.edt.base.ui.editor.hyperlink.RfNamedElementActionHyperlink;
import ro.amiq.edt.base.utils.EDTFileUtils;

public abstract class AbstractELayersViewContributor
extends AbstractELayersViewContributorCommon {
    public LayersViewInput getQuickViewInput(LayersViewInputConfigurator inputConfig) {
        this.fLabelProvider.setUsedByQuickLayersView(true);
        this.fNrTotalLayers = 0;
        this.fNrTotalFiles = 0;
        String bulkDataInfo = "";
        Object namedElement = null;
        boolean showScopeColumn = false;
        boolean showCollectMethods = false;
        List<Object> elements = new ArrayList();
        LayersViewInput defaultInput = new LayersViewInput(this.fNrTotalLayers, this.fNrTotalFiles, this.fNrNotFilteredLayers, this.fNrNotFilteredFiles, namedElement, elements, showScopeColumn, showCollectMethods, bulkDataInfo);
        try {
            if (!inputConfig.getHistoryItem().getLanguage().equals((Object)this.getLanguageKind())) {
                return defaultInput;
            }
            if (!(inputConfig.getHistoryItem() instanceof UpdateViewEvent)) {
                return defaultInput;
            }
            UpdateViewEvent ev = (UpdateViewEvent)inputConfig.getHistoryItem();
            String projectName = ev.getProjectName();
            IProject project = Utils.getProject((String)projectName);
            if (!project.isAccessible() || !project.hasNature(this.getPluginConfig().getNature())) {
                return defaultInput;
            }
            if (!DVTPlugin.getDefault().collect().c(project, this.getPluginConfig().feature())) {
                return defaultInput;
            }
            RfProject rfProject = this.getPluginConfig().getRfManager().getRfProject(project);
            if (rfProject == null) {
                return defaultInput;
            }
            List<IDVTElementWrapper> wrappers = this.getLayersData(rfProject, inputConfig.getShowEAssociatedType(), (FullName)ev.getEdtElementFullName(), ev.getElementType(), (FullName)ev.getEdtStructFullName(), ev.getEdtPackageName(), inputConfig.getStringMather(), true, inputConfig.getUpdateJob());
            if (wrappers == null || wrappers.isEmpty()) {
                return new LayersViewInput(this.fNrTotalLayers, this.fNrTotalFiles, this.fNrNotFilteredLayers, this.fNrNotFilteredFiles, null, elements, showScopeColumn, showCollectMethods, bulkDataInfo);
            }
            elements = this.toQuickViewWrappers(wrappers, rfProject, inputConfig, inputConfig.getShowEAssociatedType(), inputConfig.getUpdateJob());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return new LayersViewInput(this.fNrTotalLayers, this.fNrTotalFiles, this.fNrNotFilteredLayers, this.fNrNotFilteredFiles, namedElement, elements, showScopeColumn, showCollectMethods, bulkDataInfo);
    }

    private List<IDVTElementWrapper> toQuickViewWrappers(List<IDVTElementWrapper> elements, RfProject rfProject, LayersViewInputConfigurator inputSourceConfigurator, boolean shouldShowAssociatedType, UpdateJob updateJob) {
        ArrayList<IDVTElementWrapper> result = new ArrayList<IDVTElementWrapper>();
        try {
            HistoryItem hItem = inputSourceConfigurator.getHistoryItem();
            if (hItem == null) {
                return result;
            }
            if (elements == null) {
                return result;
            }
            for (IDVTElementWrapper wrappedElement : elements) {
                if (ViewsUtils.isCanceled((IDVTJob)updateJob)) {
                    return result;
                }
                RfDefElement element = (RfDefElement)wrappedElement.getRfElement();
                if (element instanceof RfStructLayer || element instanceof RfScalarTypeLayer) {
                    RfDefElement rde = element;
                    AbstractRfTreeElementWrapper module = null;
                    AbstractRfTreeElementWrapper type = this.getPluginConfig().createElementTreeWrapper(rde);
                    module = this.getPluginConfig().createElementTreeWrapper(rde.getLayerModule());
                    module.addChild(type);
                    this.addToFullTreeHelper(result, module, updateJob);
                    continue;
                }
                AbstractRfTreeElementWrapper module = this.getPluginConfig().createElementTreeWrapper(element.getLayerModule());
                RfStructLayer structLayer = element.getStructLayer();
                AbstractRfTreeElementWrapper struct = this.getPluginConfig().createElementTreeWrapper(structLayer);
                struct.setAdditionalInfo(IDVTElementWrapper.Attribute.SHOW_LINE_NUMBERS, "false");
                AbstractRfTreeElementWrapper structMember = this.getPluginConfig().createElementTreeWrapper(element);
                if (structLayer == null) {
                    module.addChild(structMember);
                } else {
                    module.addChild(struct);
                    struct.addChild(structMember);
                }
                this.addToFullTreeHelper(result, module, updateJob);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return result;
    }

    private void addToFullTreeHelper(List<IDVTElementWrapper> allWrappers, IDVTElementWrapper currentWrapper, UpdateJob updateJob) {
        boolean found = false;
        IDVTElementWrapper foundWrapper = null;
        for (IDVTElementWrapper tmpWrapper : allWrappers) {
            if (ViewsUtils.isCanceled((IDVTJob)updateJob)) {
                return;
            }
            if (!this.fLabelProvider.getText(tmpWrapper).equals(this.fLabelProvider.getText(currentWrapper))) continue;
            found = true;
            foundWrapper = tmpWrapper;
            break;
        }
        if (!found) {
            allWrappers.add(currentWrapper);
            return;
        }
        if (foundWrapper != null) {
            List currentChildren = currentWrapper.getChildren();
            if (currentChildren == null || currentChildren.isEmpty()) {
                return;
            }
            List foundChildren = foundWrapper.getChildren();
            if (foundChildren == null || foundChildren.isEmpty()) {
                foundWrapper.addChildren(currentChildren);
                return;
            }
            for (IDVTElementWrapper currentChild : currentChildren) {
                this.addToFullTreeHelper(foundChildren, currentChild, updateJob);
            }
        }
    }

    public boolean isSelectable(Object element, Object referenceData, StringMatcher matcher) {
        if (!(element instanceof AbstractRfTreeElementWrapper)) {
            return false;
        }
        Object rfElement = ((IDVTElementWrapper)element).getRfElement();
        if (rfElement == null) {
            return false;
        }
        if (referenceData instanceof UpdateViewEvent) {
            UpdateViewEvent updateEvent = (UpdateViewEvent)referenceData;
            if (updateEvent.getFileName() == null) {
                return false;
            }
            return this.fLabelProvider.getColumnText(element, 4).equals(updateEvent.getFileName()) && this.fLabelProvider.getColumnText(element, 5).equals(String.valueOf(updateEvent.getOffset())) || this.fLabelProvider.getColumnText(element, 3).equals(updateEvent.getFileName()) && this.fLabelProvider.getColumnText(element, 4).equals(String.valueOf(updateEvent.getOffset()));
        }
        if (referenceData instanceof AbstractRfTreeElementWrapper) {
            return this.fLabelProvider.getColumnText(element, 4).equals(this.fLabelProvider.getColumnText(referenceData, 4)) && this.fLabelProvider.getColumnText(element, 5).equals(this.fLabelProvider.getColumnText(referenceData, 5)) || this.fLabelProvider.getColumnText(element, 3).equals(this.fLabelProvider.getColumnText(referenceData, 3)) && this.fLabelProvider.getColumnText(element, 4).equals(this.fLabelProvider.getColumnText(referenceData, 4));
        }
        if (rfElement instanceof RfDefElement) {
            return matcher == null || ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)this.fLabelProvider.getText(element));
        }
        return false;
    }

    public void collectEMethodLayers(List<IDVTElementWrapper> allLayers) {
        String file = String.valueOf(ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString()) + '/' + "layers.e";
        try {
            File f = new File(file);
            f.createNewFile();
            Throwable throwable = null;
            Object var5_7 = null;
            try (BufferedWriter out = new BufferedWriter(new FileWriter(file));){
                out.write(this.collectMethodLayersSourceCode(allLayers));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            EDTFileUtils.getInstance().openEditor(f, 1);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    protected void gotoElement(RfDefElement element, IProject project) {
        RfNamedElementActionHyperlink actionHyperlink = RfUtils.createOpenAction(this.getPluginConfig(), element, project, null, false);
        if (actionHyperlink == null) {
            return;
        }
        actionHyperlink.open();
    }

    @Override
    protected IDocument provideDocument(AbstractEEditor editor, IEditorInput editorInput) {
        IDocumentProvider documentProvider = editor.getDocumentProvider();
        if (documentProvider == null) {
            return null;
        }
        IDocument document = documentProvider.getDocument((Object)editorInput);
        if (document == null) {
            return null;
        }
        return document;
    }

    @Override
    public List<RfNamedElementActionHyperlink> getNamedElementActionHyperlink(AbstractEEditor eEditor, IProject project, IDocument document, int cursor) {
        return RfUtils.getRfNamedElementActionHyperlink(this.getPluginConfig(), (ITextEditor)eEditor, project, document, cursor, false);
    }
}

