/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection.views;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.editor.IDVTEditor;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IDVTJob;
import ro.amiq.dvt.ui.views.UpdateJob;
import ro.amiq.dvt.ui.views.UpdateViewEvent;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.layers.ILayersViewContributor;
import ro.amiq.dvt.ui.views.layers.LayersViewInput;
import ro.amiq.dvt.ui.views.layers.LayersViewInputConfigurator;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.reflection.Determinant;
import ro.amiq.edt.base.model.reflection.FullName;
import ro.amiq.edt.base.model.reflection.IRfAssociatedType;
import ro.amiq.edt.base.model.reflection.RfCheckThat;
import ro.amiq.edt.base.model.reflection.RfCoverItem;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfMethodLayer;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfScalarTypeLayer;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfTemplateStruct;
import ro.amiq.edt.base.model.reflection.RfTemplateStructInstance;
import ro.amiq.edt.base.model.reflection.views.AbstractRfTreeElementWrapper;
import ro.amiq.edt.base.model.reflection.views.ELayersViewLabelProvider;
import ro.amiq.edt.base.model.reflection.views.EQuickViewersUtil;
import ro.amiq.edt.base.ui.editor.AbstractEEditor;
import ro.amiq.edt.base.ui.editor.hyperlink.RfNamedElementActionHyperlink;

public abstract class AbstractELayersViewContributorCommon
implements ILayersViewContributor {
    protected ELayersViewLabelProvider fLabelProvider = new ELayersViewLabelProvider(this.getPluginConfig());
    protected int fNrTotalLayers;
    protected int fNrTotalFiles;
    protected int fNrNotFilteredLayers;
    protected int fNrNotFilteredFiles;

    public abstract IEPluginConfig getPluginConfig();

    public String getComment(Object wrapper) {
        RfNamedElement namedElement = this.getNamedElement(wrapper);
        return namedElement == null ? "" : DVTStringUtil.replaceAll((Pattern)DVTStringUtil.NEW_LINE, (CharSequence)namedElement.getComment(), (String)" ");
    }

    private RfNamedElement getNamedElement(Object wrapper) {
        if (!(wrapper instanceof AbstractRfTreeElementWrapper)) {
            return null;
        }
        if (!(((AbstractRfTreeElementWrapper)((Object)wrapper)).getRfElement() instanceof RfNamedElement)) {
            return null;
        }
        return (RfNamedElement)((AbstractRfTreeElementWrapper)((Object)wrapper)).getRfElement();
    }

    public void gotoElement(IProject project, Object wrapper) {
        if (!(wrapper instanceof AbstractRfTreeElementWrapper)) {
            return;
        }
        Object element = ((AbstractRfTreeElementWrapper)((Object)wrapper)).getRfElement();
        if (element == null) {
            return;
        }
        if (!(element instanceof RfDefElement)) {
            return;
        }
        this.gotoElement((RfDefElement)element, project);
    }

    public DVTBaseLabelProvider getLabelProvider(Object wrapper) {
        return this.fLabelProvider;
    }

    public LayersViewInput getInput(LayersViewInputConfigurator inputConfig) {
        this.fLabelProvider.setUsedByQuickLayersView(false);
        this.fNrTotalLayers = 0;
        this.fNrTotalFiles = 0;
        this.fNrNotFilteredFiles = 0;
        this.fNrTotalLayers = 0;
        String bulkDataInfo = "";
        Object namedElement = null;
        boolean showScopeColumn = false;
        boolean showCollectMethods = false;
        ArrayList<IDVTElementWrapper> elements = new ArrayList<IDVTElementWrapper>();
        LayersViewInput defaultInput = new LayersViewInput(this.fNrTotalLayers, this.fNrTotalFiles, this.fNrNotFilteredLayers, this.fNrNotFilteredFiles, namedElement, elements, showScopeColumn, showCollectMethods, bulkDataInfo);
        try {
            if (!inputConfig.getHistoryItem().getLanguage().equals((Object)this.getLanguageKind())) {
                return defaultInput;
            }
            if (!(inputConfig.getHistoryItem() instanceof UpdateViewEvent)) {
                return defaultInput;
            }
            UpdateViewEvent ev = (UpdateViewEvent)inputConfig.getHistoryItem();
            String projectName = ev.getProjectName();
            IProject project = Utils.getProject((String)projectName);
            if (!project.isAccessible() || !project.hasNature(this.getPluginConfig().getNature())) {
                return defaultInput;
            }
            if (!DVTPlugin.getDefault().collect().c(project, this.getPluginConfig().feature())) {
                return defaultInput;
            }
            RfProject rfProject = this.getPluginConfig().getRfManager().getRfProject(project);
            if (rfProject == null) {
                return defaultInput;
            }
            List<IDVTElementWrapper> wrappers = this.getLayersData(rfProject, inputConfig.getShowEAssociatedType(), (FullName)ev.getEdtElementFullName(), ev.getElementType(), (FullName)ev.getEdtStructFullName(), ev.getEdtPackageName(), inputConfig.getStringMather(), false, inputConfig.getUpdateJob());
            if (wrappers == null || wrappers.isEmpty()) {
                return new LayersViewInput(this.fNrTotalLayers, this.fNrTotalFiles, this.fNrNotFilteredLayers, this.fNrNotFilteredFiles, null, elements, showScopeColumn, showCollectMethods, ev.getEdtElementFullName().toString());
            }
            if (ev.getElementType() == 4 || ev.getElementType() == 8 || ev.getElementType() == 2) {
                showScopeColumn = true;
            }
            if (ev.getElementType() == 4) {
                showCollectMethods = true;
            }
            this.internalSort(wrappers);
            elements.addAll(wrappers);
            bulkDataInfo = EQuickViewersUtil.getInstance().getCurrentDataInfo((RfDefElement)wrappers.get(0).getRfElement(), (FullName)ev.getEdtStructFullName());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return new LayersViewInput(this.fNrTotalLayers, this.fNrTotalFiles, this.fNrNotFilteredLayers, this.fNrNotFilteredFiles, namedElement, elements, showScopeColumn, showCollectMethods, bulkDataInfo);
    }

    protected List<IDVTElementWrapper> getLayersData(RfProject rfProject, boolean getAssociatedType, FullName elementName, int elementType, FullName structName, String packageName, StringMatcher matcher, boolean triggeredFromQuickView, UpdateJob updateJob) {
        List<RfDefElement> layers;
        List<IDVTElementWrapper> result = new ArrayList<IDVTElementWrapper>();
        RfStruct struct = this.getRfStruct(rfProject, packageName, structName);
        if (struct instanceof RfTemplateStruct) {
            RfStruct origStruct = struct;
            struct = new RfTemplateStructInstance(rfProject, (RfTemplateStruct)struct);
            Determinant determinant = structName.getDeterminant();
            List<IRfAssociatedType> parameters = determinant.getParameters();
            if (parameters != null) {
                ((RfTemplateStructInstance)struct).setParamsValueOverride(new ArrayList<IRfAssociatedType>(parameters));
            }
            origStruct.setParamsValueOverride();
        }
        if ((layers = EQuickViewersUtil.getInstance().getLayersData(elementName, elementType, struct, rfProject, packageName, getAssociatedType)) != null) {
            for (RfDefElement element : layers) {
                if (ViewsUtils.isCanceled((IDVTJob)updateJob)) {
                    return result;
                }
                if (element instanceof RfScalarTypeLayer ? element.isPredefined() && (!element.isEnumType() || "bool".equals(element.getName())) : element.isPredefined()) continue;
                result.add(this.getPluginConfig().createElementTreeWrapper(element));
            }
        }
        this.fNrTotalLayers = result.size();
        this.fNrTotalFiles = this.getFilesNo(result);
        if (matcher != null) {
            result = this.filterElements(result, matcher, triggeredFromQuickView, elementType);
        }
        this.fNrNotFilteredLayers = result.size();
        this.fNrNotFilteredFiles = this.getFilesNo(result);
        return result;
    }

    private RfStruct getRfStruct(RfProject project, String packageName, FullName fStructName) {
        block3: {
            try {
                if (project != null && packageName != null && fStructName != null && fStructName.getName() != null) break block3;
                return null;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return null;
            }
        }
        return (RfStruct)project.getType(packageName, false, 1, fStructName.getName(), -1);
    }

    private int getFilesNo(List<IDVTElementWrapper> layers) {
        HashSet<String> set = new HashSet<String>();
        for (IDVTElementWrapper element : layers) {
            RfDefElement layer = (RfDefElement)element.getRfElement();
            set.add(layer.getLayerModule() == null ? "predefined" : layer.getLayerModule().getName());
        }
        return set.size();
    }

    private void internalSort(List<IDVTElementWrapper> wrappers) {
        if (wrappers == null || wrappers.isEmpty()) {
            return;
        }
        Collections.sort(wrappers, (o1, o2) -> {
            Object obj1 = o1.getRfElement();
            Object obj2 = o2.getRfElement();
            String treeName1 = ((AbstractRfTreeElementWrapper)((Object)o1)).getTreeName();
            String treeName2 = ((AbstractRfTreeElementWrapper)((Object)o2)).getTreeName();
            if (treeName1 != null && !treeName1.isEmpty() && treeName2 != null && !treeName2.isEmpty()) {
                return treeName1.compareTo(treeName2);
            }
            if (obj1 instanceof RfNamedElement && obj2 instanceof RfNamedElement) {
                return ((RfNamedElement)obj1).getName().compareTo(((RfNamedElement)obj2).getName());
            }
            if (obj1 instanceof String && obj2 instanceof String) {
                return ((String)obj1).compareTo((String)obj2);
            }
            return 0;
        });
        for (IDVTElementWrapper wrapper : wrappers) {
            this.internalSort(wrapper.getChildren());
        }
    }

    private List<IDVTElementWrapper> filterElements(List<IDVTElementWrapper> elements, StringMatcher matcher, boolean triggeredFromQuickView, int elementType) {
        if (matcher == null) {
            return elements;
        }
        ArrayList<IDVTElementWrapper> result = new ArrayList<IDVTElementWrapper>();
        for (IDVTElementWrapper wrapper : elements) {
            this.fLabelProvider.setUsedByQuickLayersView(triggeredFromQuickView);
            String name = this.fLabelProvider.getColumnText(wrapper, 0);
            String scope = elementType == 4 || elementType == 8 ? this.fLabelProvider.getColumnText(wrapper, 1) : "";
            String comment = triggeredFromQuickView ? "" : this.fLabelProvider.getColumnText(wrapper, 2);
            String fileName = this.fLabelProvider.getColumnText(wrapper, 3);
            String linenr = this.fLabelProvider.getColumnText(wrapper, 4);
            if (!ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)name) && !ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)scope) && !ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)comment) && !ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)fileName) && !ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)linenr)) continue;
            result.add(wrapper);
        }
        return result;
    }

    public String collectMethodLayersSourceCode(List<IDVTElementWrapper> allLayers) {
        ArrayList<RfDefElement> layers = new ArrayList<RfDefElement>();
        for (IDVTElementWrapper elementWrapper : allLayers) {
            layers.add((RfDefElement)elementWrapper.getRfElement());
        }
        StringBuilder output = new StringBuilder();
        int i = 0;
        while (i < layers.size()) {
            RfDefElement element = (RfDefElement)layers.get(i);
            if (!(element instanceof RfMethodLayer)) break;
            RfMethodLayer methodLayer = (RfMethodLayer)element;
            if (i == 0) {
                output.append("// layers collect for method: ");
                output.append(methodLayer.getName());
                output.append("()\n<'\n{");
            }
            output.append("\n\n\t// struct: ");
            output.append(methodLayer.getDefStructLayerName());
            output.append("\n\t// file: ");
            output.append(methodLayer.getLayerModule().getParserPath());
            output.append("\n\t// at line: ");
            output.append(methodLayer.getStartLine());
            if (methodLayer.isImplicit()) {
                output.append("\n\t// Implicit PREDEFINED method declaration: " + methodLayer.getInfo());
            } else {
                this.codeSnip(output, methodLayer.getLayerModule().getParserPath().path, methodLayer.getStartLine(), methodLayer.getEndLine());
            }
            if (i == layers.size() - 1) {
                output.append("\n\n}\n'>\n");
            }
            ++i;
        }
        return output.toString();
    }

    protected void codeSnip(StringBuilder output, String fileName, int startLine, int endLine) {
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (BufferedReader input = new BufferedReader(new FileReader(fileName));){
                int i = 1;
                while (i < endLine + 1) {
                    String readLine = input.readLine();
                    if (readLine == null) {
                        break;
                    }
                    if (i >= startLine) {
                        output.append("\n" + readLine);
                    }
                    ++i;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public HistoryItem createHistoryItemForElementAtCursor(IDVTEditor editor, int cursor) {
        RfNamedElement namedElement;
        RfNamedElementActionHyperlink hlink;
        IDocument document;
        IProject project;
        IFile file;
        block23: {
            block22: {
                block21: {
                    block20: {
                        List<RfNamedElementActionHyperlink> actionLinks;
                        block19: {
                            AbstractEEditor eEditor;
                            block18: {
                                IEditorInput editorInput;
                                block17: {
                                    block16: {
                                        block15: {
                                            block14: {
                                                block13: {
                                                    try {
                                                        if (editor instanceof AbstractEEditor) break block13;
                                                        return null;
                                                    }
                                                    catch (Exception e) {
                                                        DVTLogger.INSTANCE.logError((Throwable)e);
                                                        return null;
                                                    }
                                                }
                                                eEditor = (AbstractEEditor)editor;
                                                editorInput = eEditor.getEditorInput();
                                                if (editorInput != null) break block14;
                                                return null;
                                            }
                                            file = (IFile)editorInput.getAdapter(IFile.class);
                                            if (file != null) break block15;
                                            return null;
                                        }
                                        project = file.getProject();
                                        if (project != null) break block16;
                                        return null;
                                    }
                                    RfProject rfProject = this.getPluginConfig().getRfManager().getRfProject(project);
                                    if (rfProject != null) break block17;
                                    return null;
                                }
                                document = this.provideDocument(eEditor, editorInput);
                                if (document != null) break block18;
                                return null;
                            }
                            actionLinks = this.getNamedElementActionHyperlink(eEditor, project, document, cursor);
                            if (actionLinks != null && !actionLinks.isEmpty()) break block19;
                            return null;
                        }
                        hlink = actionLinks.get(0);
                        namedElement = hlink.getRfNamedElement();
                        if (namedElement != null) break block20;
                        return null;
                    }
                    if (!RfStruct.isPackageElement(namedElement, false)) break block21;
                    return null;
                }
                if (!(namedElement instanceof RfCheckThat)) break block22;
                return null;
            }
            if (!(namedElement instanceof RfCoverItem)) break block23;
            return null;
        }
        UpdateViewEvent updateEvent = EQuickViewersUtil.getInstance().createViewUpdateEvent(this.getPluginConfig(), namedElement, project, EQuickViewersUtil.getInstance().getEnclosingStruct(hlink.getScope()), true, 1);
        updateEvent.setOffset(document.getLineOfOffset(cursor) + 1);
        updateEvent.setFileName(file.getName());
        return updateEvent;
    }

    protected abstract void gotoElement(RfDefElement var1, IProject var2);

    protected abstract IDocument provideDocument(AbstractEEditor var1, IEditorInput var2);

    public abstract List<RfNamedElementActionHyperlink> getNamedElementActionHyperlink(AbstractEEditor var1, IProject var2, IDocument var3, int var4);
}

