/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection.views;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.views.IRfFilterableTreeAccessor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.symbolcollector.ISymbolCollectorPrerequisite;
import ro.amiq.dvt.symbolcollector.SymbolCollectorConfigurator;
import ro.amiq.dvt.ui.guifilters.DVTGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.DVTNamedElementGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.ViewSet;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.DVTTreeElementWrapper;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.lazy.views.macros.IMacrosViewContributor;
import ro.amiq.dvt.ui.views.lazy.views.macros.MacrosWrapper;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.reflection.RfMacro;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.util.RfUtils;
import ro.amiq.edt.base.model.reflection.views.ELanguageElement;
import ro.amiq.edt.base.model.reflection.views.MacroViewLabelProvider;
import ro.amiq.edt.base.ui.editor.hyperlink.RfNamedElementActionHyperlink;

public abstract class AbstractEMacrosViewContributor
implements IMacrosViewContributor {
    private static final Comparator<Object> MACROS_COMPARATOR = (o1, o2) -> {
        if (!(o1 instanceof RfMacro) || !(o2 instanceof RfMacro)) {
            return -1;
        }
        String objName1 = ((RfMacro)o1).getName();
        String objName2 = ((RfMacro)o2).getName();
        if ("__etools__table'__etools__expansion".equals(objName1) && ((RfMacro)o1).getStringLiteral() != null) {
            objName1 = ((RfMacro)o1).getStringLiteral();
        }
        if ("__etools__table'__etools__expansion".equals(objName2) && ((RfMacro)o2).getStringLiteral() != null) {
            objName2 = ((RfMacro)o2).getStringLiteral();
        }
        if (!objName1.equals(objName2)) {
            return objName1.compareTo(objName2);
        }
        return ((RfMacro)o1).getDeclaration().compareTo(((RfMacro)o2).getDeclaration());
    };
    private final MacroViewLabelProvider labelProvider = new MacroViewLabelProvider(this.getPluginConfig());

    public abstract IEPluginConfig getPluginConfig();

    public MacrosWrapper getLanguageMacrosWrapper(IProject project, IRfFilterableTreeAccessor view, IProgressMonitor monitor) {
        try {
            if (!project.isAccessible() || !project.hasNature(this.getPluginConfig().getNature())) {
                return this.newEmptyMacrosWrapper();
            }
            if (!DVTPlugin.getDefault().collect().c(project, this.getPluginConfig().feature())) {
                return this.newEmptyMacrosWrapper();
            }
            RfProject rfProject = this.getPluginConfig().getRfManager().getRfProject(project);
            if (rfProject == null) {
                return this.newEmptyMacrosWrapper();
            }
            Object[] allMacros = rfProject.getAllMacros(true, true).toArray();
            if (allMacros == null || allMacros.length == 0) {
                return this.newEmptyMacrosWrapper();
            }
            return this.computeMacrosWrapper(allMacros, rfProject, view, monitor);
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return this.newEmptyMacrosWrapper();
        }
    }

    private MacrosWrapper newEmptyMacrosWrapper() {
        return new MacrosWrapper(new ELanguageElement<String>(this.getLanguageKind().VIEW_NAME));
    }

    private MacrosWrapper computeMacrosWrapper(Object[] elements, RfProject rfProject, IRfFilterableTreeAccessor view, IProgressMonitor updateJob) {
        MacrosWrapper result = this.newEmptyMacrosWrapper();
        LinkedHashMap macrosByCategory = result.getAllMacrosByCategory();
        LinkedHashMap<EMacroType, CategoryWrapper> macroTypeToCategory = new LinkedHashMap<EMacroType, CategoryWrapper>();
        LinkedHashMap<IRfNamedElement, TreeSet<Object>> categoryToMacroSet = new LinkedHashMap<IRfNamedElement, TreeSet<Object>>();
        Object[] objectArray = EMacroType.values();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object value = objectArray[n2];
            categoryToMacroSet.put(this.getCategoryWrapper(rfProject, (EMacroType)((Object)value), macroTypeToCategory), new TreeSet<Object>(MACROS_COMPARATOR));
            ++n2;
        }
        try {
            if (elements == null) {
                return result;
            }
            objectArray = elements;
            n = elements.length;
            n2 = 0;
            while (n2 < n) {
                RfMacro macro;
                EMacroType element = objectArray[n2];
                if (updateJob.isCanceled()) {
                    return result;
                }
                if (element instanceof RfMacro && !this.shouldIgnoreMacro(macro = (RfMacro)((Object)element))) {
                    if (DVTNamedElementGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.MACRO, (IRfNamedElement)macro, () -> macro.getName()) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
                        if (!result.hasSearchedElementFiltered() && ViewsUtils.matchesPath((Object)new DVTTreeElementWrapper((Object)macro), (IRfFilterableTreeAccessor)view)) {
                            result.setHasSearchedElementFiltered(true);
                        }
                        result.setHasGUIFilteredElements(true);
                    } else {
                        result.incrementNofMacros();
                        CategoryWrapper categoryWrapper = this.getCategoryWrapper(rfProject, EMacroType.from(macro.getMacroType()), macroTypeToCategory);
                        this.addMacroToMap(categoryToMacroSet, macro, categoryWrapper);
                    }
                }
                ++n2;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        for (Map.Entry entry : categoryToMacroSet.entrySet()) {
            macrosByCategory.put((IRfNamedElement)entry.getKey(), new ArrayList((Collection)entry.getValue()));
        }
        for (Object value : categoryToMacroSet.values()) {
            ((TreeSet)value).clear();
        }
        categoryToMacroSet.clear();
        return result;
    }

    private boolean shouldIgnoreMacro(RfMacro macro) {
        return macro == null || macro.getName() == null || macro.getName().equals("DVT_PATCH") || macro.getName().equals("DVT_INTERNAL_PATCH");
    }

    private void addMacroToMap(Map<IRfNamedElement, TreeSet<Object>> resultTreeMap, RfMacro macro, CategoryWrapper macroType) {
        TreeSet<Object> macros = resultTreeMap.get(macroType);
        macros.add(macro);
        resultTreeMap.put(macroType, macros);
    }

    private CategoryWrapper getCategoryWrapper(RfProject rfProject, EMacroType macroType, Map<EMacroType, CategoryWrapper> macroTypeToCategory) {
        if (macroTypeToCategory.containsKey((Object)macroType)) {
            return macroTypeToCategory.get((Object)macroType);
        }
        CategoryWrapper wrapper = new CategoryWrapper(rfProject, macroType);
        macroTypeToCategory.put(macroType, wrapper);
        return wrapper;
    }

    public DVTBaseLabelProvider getLabelProvider(Object wrapper) {
        return this.labelProvider;
    }

    public String getComment(Object wrapper) {
        if (!(wrapper instanceof RfNamedElement)) {
            return null;
        }
        RfNamedElement namedElement = (RfNamedElement)wrapper;
        return namedElement.getComment();
    }

    public void gotoElement(IProject project, Object wrapper) {
        try {
            if (wrapper == null || !(wrapper instanceof RfNamedElement)) {
                return;
            }
            RfNamedElement namedElement = (RfNamedElement)wrapper;
            RfNamedElementActionHyperlink actionHyperlink = RfUtils.createOpenAction(this.getPluginConfig(), namedElement, project, null);
            if (actionHyperlink == null) {
                return;
            }
            actionHyperlink.open();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public boolean isSelectable(Object rfElement, Object referenceData, StringMatcher matcher) {
        if (rfElement == null) {
            return false;
        }
        if (!(rfElement instanceof RfMacro)) {
            return false;
        }
        return matcher == null || ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)this.labelProvider.getText(rfElement));
    }

    public List<ISymbolCollectorPrerequisite> getSymbolsPrerequisites(SymbolCollectorConfigurator configurator) {
        if (configurator == null || configurator.isSymbolCollectionCanceled()) {
            return Collections.emptyList();
        }
        IProject project = configurator.getProject();
        if (project == null) {
            return Collections.emptyList();
        }
        RfProject rfProject = this.getPluginConfig().getRfManager().getRfProject(project);
        if (rfProject == null) {
            return Collections.emptyList();
        }
        List<RfMacro> allMacros = rfProject.getAllMacros(true, true);
        if (allMacros == null || allMacros.isEmpty()) {
            return Collections.emptyList();
        }
        EnumMap<EMacroType, TreeSet<Object>> macrosByType = new EnumMap<EMacroType, TreeSet<Object>>(EMacroType.class);
        EMacroType[] eMacroTypeArray = EMacroType.values();
        int n = eMacroTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            EMacroType macroType = eMacroTypeArray[n2];
            macrosByType.put(macroType, new TreeSet<Object>(MACROS_COMPARATOR));
            ++n2;
        }
        boolean ignoreContentFilters = configurator.ignoreContentFilters();
        for (RfMacro macro : allMacros) {
            if (configurator.shouldStopCollecting()) break;
            if (this.shouldIgnoreMacro(macro) || !ignoreContentFilters && DVTNamedElementGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.MACRO, (IRfNamedElement)macro, () -> macro.getName()) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED || !this.shouldCollectSymbol((ISymbolCollectorPrerequisite)macro, configurator)) continue;
            EMacroType macroType = EMacroType.from(macro.getMacroType());
            ((TreeSet)macrosByType.get((Object)macroType)).add(macro);
            configurator.countNewSymbol();
        }
        ArrayList<ISymbolCollectorPrerequisite> prerequisites = new ArrayList<ISymbolCollectorPrerequisite>();
        for (TreeSet macros : macrosByType.values()) {
            prerequisites.addAll(macros);
        }
        return prerequisites;
    }

    public static class CategoryWrapper
    extends RfNamedElement {
        private EMacroType macroType;

        public CategoryWrapper(RfProject rfProject, EMacroType type) {
            super(rfProject, type.displayName);
            this.macroType = type;
        }

        public String getSignature() {
            return this.macroType.displayName;
        }

        @Override
        public LanguageKind getLanguageKind() {
            RfProject rfProject = this.getRfProject();
            if (rfProject == null) {
                return null;
            }
            return rfProject.getLanguageKind();
        }
    }

    public static enum EMacroType {
        TABLES("Tables", "__etools__expansion"),
        PREPROCESSING("Preprocessing", "preprocessing"),
        STATEMENTS("Statements", "statement"),
        STRUCT_MEMBERS("Struct Members", "struct_member"),
        ACTIONS("Actions", "action"),
        EXPRESSIONS("Expressions", "exp"),
        NAME("Names", "name"),
        COMMANDS("Commands", "command"),
        FILE("Files", "file"),
        NUM("Nums", "num"),
        BLOCK("Blocks", "block"),
        COVER_ITEMS("Cover Items", "cover_item"),
        TYPES("Types", "type"),
        OTHERS("Others", "");

        private final String displayName;
        private final String internalName;

        private EMacroType(String displayName, String internalName) {
            this.displayName = displayName;
            this.internalName = internalName;
        }

        public static EMacroType from(String macroType) {
            if (macroType == null) {
                return PREPROCESSING;
            }
            EMacroType[] eMacroTypeArray = EMacroType.values();
            int n = eMacroTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                EMacroType type = eMacroTypeArray[n2];
                if (type.internalName != null && type.internalName.equalsIgnoreCase(macroType)) {
                    return type;
                }
                ++n2;
            }
            return OTHERS;
        }
    }
}

