/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection.views;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import ro.amiq.dvt.model.IDVTFile;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.ui.views.ISearchContributor;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.AbstractEModelManager;
import ro.amiq.edt.base.model.IEModel;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.util.RfEnclosingScopeUtils;

public abstract class AbstractESearchContributorCommon
implements ISearchContributor {
    public abstract IEPluginConfig getPluginConfig();

    public boolean isEnabled(IProject project) {
        try {
            return project.hasNature(this.getNature());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean hasValidPartitioner(IDocument document) {
        try {
            IDocumentExtension3 extension3 = (IDocumentExtension3)document;
            IDocumentPartitioner partitioner = extension3.getDocumentPartitioner("__e_partitioning");
            if (partitioner != null) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public boolean validContentType(IDocument document, int index) {
        block7: {
            String[] partitionings;
            block6: {
                partitionings = ((IDocumentExtension3)document).getPartitionings();
                if (partitionings != null) break block6;
                return false;
            }
            boolean hasPartition = false;
            String[] stringArray = partitionings;
            int n = partitionings.length;
            int n2 = 0;
            while (n2 < n) {
                String partitioning = stringArray[n2];
                if (partitioning.equals("__e_partitioning")) {
                    hasPartition = true;
                    break;
                }
                ++n2;
            }
            if (hasPartition) break block7;
            return false;
        }
        try {
            String contentType = ((IDocumentExtension3)document).getContentType("__e_partitioning", index, false);
            return contentType.equals("__dftl_partition_content_type");
        }
        catch (BadLocationException | BadPartitioningException throwable) {
            throw new IndexOutOfBoundsException();
        }
    }

    public String getScopeInfo(IProject project, ParserPath parserPath, int line, int offset) {
        return RfEnclosingScopeUtils.getScopeInfo(this.getPluginConfig().getRfManager(), project, parserPath, line, offset);
    }

    public boolean isInstantiable(IRfNamedElement element) {
        return element instanceof RfStruct && ((RfStruct)element).isUnit();
    }

    public IDVTFile getIDVTFile(IFile file) {
        IEPluginConfig pluginConfig = this.getPluginConfig();
        if (pluginConfig == null) {
            return null;
        }
        AbstractEModelManager modelManager = pluginConfig.getModelManager();
        if (modelManager == null) {
            return null;
        }
        IEModel eModel = modelManager.getEModel();
        if (eModel == null) {
            return null;
        }
        return eModel.getEModule(file);
    }
}

