/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection.views;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.ui.guifilters.DVTGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.DVTNamedElementGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.ViewSet;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.MembersViewInput;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfEnum;
import ro.amiq.edt.base.model.reflection.RfExpect;
import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfScalarType;
import ro.amiq.edt.base.model.reflection.RfScalarTypeLayer;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfVar;
import ro.amiq.edt.base.model.reflection.RfVarLayer;
import ro.amiq.edt.base.model.reflection.util.RfUtils;
import ro.amiq.edt.base.model.reflection.views.AbstractETypesViewContributorCommon;
import ro.amiq.edt.base.model.reflection.views.AbstractRfTreeElementWrapper;
import ro.amiq.edt.base.ui.editor.hyperlink.RfNamedElementActionHyperlink;

public abstract class AbstractETypesViewContributor
extends AbstractETypesViewContributorCommon {
    @Override
    public abstract IEPluginConfig getPluginConfig();

    protected AbstractETypesViewContributor(IEPluginConfig pluginConfig) {
        super(pluginConfig);
    }

    public MembersViewInput getMembersInput(Object wrapper, StringMatcher stringMatcher) {
        ArrayList<IDVTElementWrapper> elements;
        AtomicBoolean hasGUIFilteredMembers;
        block7: {
            RfNamedElement namedElement;
            block6: {
                MembersViewInput emptyResult = new MembersViewInput(Collections.emptyList(), false);
                if (wrapper == null) {
                    return emptyResult;
                }
                Object rfElement = wrapper instanceof IDVTElementWrapper ? ((IDVTElementWrapper)wrapper).getRfElement() : wrapper;
                if (!(rfElement instanceof RfNamedElement)) {
                    return emptyResult;
                }
                namedElement = (RfNamedElement)rfElement;
                hasGUIFilteredMembers = new AtomicBoolean(false);
                elements = new ArrayList<IDVTElementWrapper>();
                if (!(namedElement instanceof RfScalarType)) break block6;
                for (RfDefElement enumLayer : namedElement.getLayers()) {
                    Collection<RfEnum> enums;
                    if (!(enumLayer instanceof RfScalarTypeLayer) || (enums = ((RfScalarTypeLayer)enumLayer).getEnums()) == null) continue;
                    for (RfNamedElement rfNamedElement : enums) {
                        this.checkAndWrapMember(elements, null, rfNamedElement, stringMatcher, hasGUIFilteredMembers);
                    }
                }
                break block7;
            }
            if (!(namedElement instanceof RfStruct)) break block7;
            HashSet<RfNamedElement> visited = new HashSet<RfNamedElement>();
            for (RfDefElement structLayer : namedElement.getDeclarations()) {
                for (RfDefElement rfDefElement : structLayer.getChildren()) {
                    if (rfDefElement instanceof RfVarLayer || !visited.add(rfDefElement.getNamedElement())) continue;
                    this.checkAndWrapMember(elements, rfDefElement, rfDefElement.getNamedElement(), stringMatcher, hasGUIFilteredMembers);
                }
            }
        }
        return new MembersViewInput(elements, hasGUIFilteredMembers.get());
    }

    private void checkAndWrapMember(List<IDVTElementWrapper> result, RfDefElement def, RfNamedElement member, StringMatcher stringMatcher, AtomicBoolean hasGUIFilteredMembers) {
        if (member == null) {
            return;
        }
        if (member instanceof RfVar) {
            return;
        }
        if (member instanceof RfExpect && ((RfExpect)member).isAnonymous()) {
            return;
        }
        if (member instanceof RfMethod && ((RfMethod)member).isByEvent()) {
            return;
        }
        AbstractRfTreeElementWrapper elementWrapper = this.getPluginConfig().createElementTreeWrapper(member, true);
        if (!ViewsUtils.matchCamelCaseOrRegex((StringMatcher)stringMatcher, (String)this.getMembersViewLabelProvider().getText((Object)elementWrapper))) {
            return;
        }
        if (DVTNamedElementGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.TYPES_MEMBERS, (IRfNamedElement)member, () -> this.getMembersViewLabelProvider().getText((Object)elementWrapper)) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
            hasGUIFilteredMembers.set(true);
            return;
        }
        if (member.getDeclaration() != def || member.isPredefined()) {
            elementWrapper.setAdditionalInfo(IDVTElementWrapper.Attribute.TYPES_MEMBERS_DEF, def);
        }
        result.add(elementWrapper);
    }

    public void gotoSelectedMember(IProject project, IDVTElementWrapper element) {
        if (element == null) {
            return;
        }
        RfDefElement customDef = (RfDefElement)element.getAdditionalInfo((Object)IDVTElementWrapper.Attribute.TYPES_MEMBERS_DEF);
        if (customDef != null) {
            RfUtils.createOpenAction(this.getPluginConfig(), customDef, project, null, false).open();
            return;
        }
        Object namedElement = element.getRfElement();
        if (!(namedElement instanceof RfNamedElement)) {
            return;
        }
        RfNamedElementActionHyperlink createOpenAction = RfUtils.createOpenAction(this.getPluginConfig(), (RfNamedElement)namedElement, project, null);
        if (createOpenAction == null) {
            return;
        }
        createOpenAction.open();
    }
}

