/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.LabelProvider;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.model.reflection.IRfKind;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.views.IRfFilterableTreeAccessor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.symbolcollector.ISymbolCollectorPrerequisite;
import ro.amiq.dvt.symbolcollector.SymbolCollectorConfigurator;
import ro.amiq.dvt.symbolcollector.SymbolQueryKey;
import ro.amiq.dvt.ui.guifilters.DVTEPackageGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.DVTGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.DVTNamedElementGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.ViewSet;
import ro.amiq.dvt.ui.views.ComplexFilter;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IMembersLabelProvider;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.ViewsUtilsCommon;
import ro.amiq.dvt.ui.views.lazy.views.types.BaseTypesViewContributor;
import ro.amiq.dvt.ui.views.lazy.views.types.TypesViewInput;
import ro.amiq.dvt.ui.views.lazy.views.types.TypesViewInputConfigurator;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.reflection.RfAnnotationType;
import ro.amiq.edt.base.model.reflection.RfKind;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfType;
import ro.amiq.edt.base.model.reflection.util.RfUtils;
import ro.amiq.edt.base.model.reflection.views.AbstractRfTreeElementWrapper;
import ro.amiq.edt.base.model.reflection.views.ELanguageElement;
import ro.amiq.edt.base.model.reflection.views.EQuickViewersUtil;
import ro.amiq.edt.base.model.reflection.views.TypesViewLabelProvider;
import ro.amiq.edt.base.model.reflection.views.TypesViewMembersLabelProvider;
import ro.amiq.edt.base.ui.editor.hyperlink.RfNamedElementActionHyperlink;

public abstract class AbstractETypesViewContributorCommon
extends BaseTypesViewContributor {
    public abstract IEPluginConfig getPluginConfig();

    protected AbstractETypesViewContributorCommon(IEPluginConfig pluginConfig) {
        super((DVTBaseLabelProvider)new TypesViewLabelProvider(pluginConfig), (IMembersLabelProvider)new TypesViewMembersLabelProvider());
    }

    public TypesViewInput getInput(TypesViewInputConfigurator inputConfigurator) {
        try {
            TypesViewInput input = TypesViewInput.emptyInput();
            if (inputConfigurator == null) {
                return input;
            }
            IProject project = inputConfigurator.getProject();
            if (project == null || !project.isAccessible() || !project.hasNature(this.getPluginConfig().getNature())) {
                return input;
            }
            if (!DVTPlugin.getDefault().collect().c(project, this.getPluginConfig().feature())) {
                return input;
            }
            RfProject rfProject = this.getPluginConfig().getRfManager().getRfProject(project);
            if (rfProject == null) {
                return input;
            }
            List<IDVTElementWrapper> wrappers = this.toWrappers(rfProject.getAllPackages(), inputConfigurator, input);
            AbstractRfTreeElementWrapper tmpRoot = this.getPluginConfig().createElementTreeWrapper();
            tmpRoot.addChildren(wrappers);
            int matchCount = this.filterTree(tmpRoot, inputConfigurator);
            if (matchCount >= 0) {
                input.setNrNotFilteredTypes(matchCount);
            }
            if (inputConfigurator.isCanceled()) {
                return TypesViewInput.emptyInput();
            }
            this.internalSort(wrappers, inputConfigurator.isCategorySort());
            if (wrappers == null || wrappers.isEmpty()) {
                return input;
            }
            if (inputConfigurator.isShowLanguageNameAsRootElement()) {
                int nrTypes = input.getNrTypes();
                String langInfo = String.valueOf(this.getLanguageKind().VIEW_NAME) + " [" + (matchCount != -1 ? String.valueOf(matchCount) + "/" + nrTypes : Integer.valueOf(nrTypes)) + ViewsUtils.getUnitName((String)"type", (int)nrTypes, (String)" ", (String)"") + "]";
                AbstractRfTreeElementWrapper languageWrapper = this.getPluginConfig().createElementTreeWrapper(new ELanguageElement<String>(langInfo));
                languageWrapper.addChildren(tmpRoot.getChildren());
                input.setElements(Arrays.asList(new IDVTElementWrapper[]{languageWrapper}));
                return input;
            }
            input.setElements(new ArrayList<AbstractRfTreeElementWrapper>(tmpRoot.getChildren()));
            return input;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return TypesViewInput.emptyInput();
        }
    }

    private int filterTree(AbstractRfTreeElementWrapper root, TypesViewInputConfigurator viewConfigurator) {
        if (root == null || viewConfigurator == null) {
            return -1;
        }
        if (!viewConfigurator.getView().isFiltered()) {
            return -1;
        }
        if (viewConfigurator.isCollectingSymbols()) {
            return -1;
        }
        ComplexFilter filter = new ComplexFilter(viewConfigurator.getView(), true){

            public boolean shouldSkipCount(IDVTElementWrapper node) {
                if (node.getRfElement() == null) {
                    return true;
                }
                return !(node.getRfElement() instanceof RfNamedElement);
            }
        };
        ViewsUtils.filterElementComplex((IDVTElementWrapper)root, (ComplexFilter)filter, (IProgressMonitor)viewConfigurator.getMonitor());
        return filter.matchCount;
    }

    public void gotoElement(IProject project, Object wrapper) {
        try {
            if (!(wrapper instanceof AbstractRfTreeElementWrapper)) {
                return;
            }
            Object element = ((AbstractRfTreeElementWrapper)((Object)wrapper)).getRfElement();
            if (element == null || !(element instanceof RfNamedElement)) {
                return;
            }
            RfNamedElement namedElement = (RfNamedElement)element;
            RfNamedElementActionHyperlink actionHyperlink = RfUtils.createOpenAction(this.getPluginConfig(), namedElement, project, null);
            if (actionHyperlink == null) {
                return;
            }
            actionHyperlink.open();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public String getComment(Object wrapper) {
        IRfNamedElement namedElement = this.getNamedElement(wrapper);
        return namedElement == null ? "" : namedElement.getComment();
    }

    private void internalSort(List<IDVTElementWrapper> wrappers, boolean sortByType) {
        if (wrappers == null || wrappers.isEmpty()) {
            return;
        }
        DVTBaseLabelProvider labelProvider = this.getLabelProvider(wrappers);
        if (sortByType) {
            Collections.sort(wrappers, EQuickViewersUtil.getInstance().getSortByTypeComparator((LabelProvider)labelProvider));
        } else {
            Collections.sort(wrappers, EQuickViewersUtil.getInstance().getSortByNameComparator((LabelProvider)labelProvider));
        }
        for (IDVTElementWrapper wrapper : wrappers) {
            this.internalSort(wrapper.getChildren(), sortByType);
        }
    }

    private List<IDVTElementWrapper> toWrappers(Collection<? extends Object> elements, TypesViewInputConfigurator configurator, TypesViewInput input) {
        try {
            ArrayList<IDVTElementWrapper> result = new ArrayList<IDVTElementWrapper>();
            if (elements == null || configurator == null) {
                return result;
            }
            boolean ignoreContentFilters = configurator.ignoreContentFilters();
            for (Object object : elements) {
                List<IDVTElementWrapper> childrenWrappers;
                ArrayList<RfType> children;
                Collection<RfType> types;
                boolean containsUserExtendedType;
                if (configurator.isCanceled() || configurator.shouldStopCollecting()) {
                    return result;
                }
                if (object instanceof RfAnnotationType || object instanceof RfStruct && (((RfStruct)object).isSLNComponent() || ((RfStruct)object).isSDLAgent()) && ((RfStruct)object).hasNoLayers() && !(containsUserExtendedType = this.containsUserExtendedType(types = ((RfStruct)object).getTypes()))) continue;
                AbstractRfTreeElementWrapper wrapper = this.getPluginConfig().createElementTreeWrapper(object);
                if (!ignoreContentFilters && object instanceof IRfNamedElement && DVTNamedElementGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.TYPES, (IRfNamedElement)((RfNamedElement)object), () -> this.getLabelProvider((Object)wrapper).getText((Object)wrapper)) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
                    input.setHasGUIFilteredElements(true);
                    if (input.isSearchedElementFiltered()) continue;
                    IRfFilterableTreeAccessor view = configurator.getView();
                    if ((view.getTreeSearchPort() == null || view.getTreeSearchPort().isEmpty()) && ViewsUtilsCommon.matchesPath((Object)((Object)wrapper), (IRfFilterableTreeAccessor)view)) {
                        input.setSearchedElementFiltered(true);
                        continue;
                    }
                    if (view.getTreeSearchPort() == null || view.getTreeSearchPort().isEmpty()) continue;
                    input.setSearchedElementFiltered(this.hasFilteredSearchedPorts((IRfNamedElement)object, view));
                    continue;
                }
                if (!ignoreContentFilters && object instanceof RfStruct && !RfStruct.isPackageElement(object, false) && DVTEPackageGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.TYPES, (IProject)configurator.getProject(), (String)((RfStruct)object).getPackageName()) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
                    input.setHasGUIFilteredElements(true);
                    if (input.isSearchedElementFiltered()) continue;
                    IRfFilterableTreeAccessor view = configurator.getView();
                    if ((view.getTreeSearchPort() == null || view.getTreeSearchPort().isEmpty()) && ViewsUtilsCommon.matchesPath((Object)((Object)wrapper), (IRfFilterableTreeAccessor)view)) {
                        input.setSearchedElementFiltered(true);
                        continue;
                    }
                    if (view.getTreeSearchPort() != null && !view.getTreeSearchPort().isEmpty()) {
                        input.setSearchedElementFiltered(this.hasFilteredSearchedPorts((IRfNamedElement)object, view));
                        continue;
                    }
                    if (!((RfStruct)object).hasLocalMembers()) continue;
                    input.setSearchedElementFiltered(this.hasFilteredSearchedLocalMember((IRfNamedElement)object, view));
                    continue;
                }
                if (object instanceof RfType && !RfStruct.isPackageElement(object, false) || object instanceof RfStruct && ((RfStruct)object).isSLNComponent() || object instanceof RfStruct && ((RfStruct)object).isSDLAgent()) {
                    input.incrementNrTypes();
                }
                if (this.shouldAddType(wrapper, configurator)) {
                    result.add(wrapper);
                }
                if (RfStruct.isPackageElement(object, false)) {
                    RfStruct packg = (RfStruct)object;
                    children = new ArrayList<RfType>();
                    Collection<RfType> types2 = packg.getTypes();
                    for (RfType type : types2) {
                        if (configurator.isCanceled()) {
                            return result;
                        }
                        if (type.hasNoLayers()) continue;
                        children.add(type);
                    }
                    if (children.isEmpty()) {
                        result.remove((Object)wrapper);
                        continue;
                    }
                    List<IDVTElementWrapper> childrenWrappers2 = this.toWrappers(children, configurator, input);
                    if ((childrenWrappers2 == null || childrenWrappers2.isEmpty()) && !configurator.isCollectingSymbols()) {
                        result.remove((Object)wrapper);
                        continue;
                    }
                    this.addChildren(result, wrapper, childrenWrappers2, configurator);
                    continue;
                }
                if (object instanceof RfStruct && ((RfStruct)object).isSDLAgent()) {
                    RfStruct sdlAgent = (RfStruct)object;
                    children = new ArrayList();
                    for (RfStruct sdlScenario : sdlAgent.getLocalSDLScenarios()) {
                        if (configurator.isCollectingSymbols()) {
                            return result;
                        }
                        if (sdlScenario.hasNoLayers()) continue;
                        children.add(sdlScenario);
                    }
                    childrenWrappers = this.toWrappers(children, configurator, input);
                    this.addChildren(result, wrapper, childrenWrappers, configurator);
                    continue;
                }
                if (!(object instanceof RfStruct) || !((RfStruct)object).isSLNComponent()) continue;
                RfStruct slnComponent = (RfStruct)object;
                children = new ArrayList();
                for (RfType slnAction : slnComponent.getLocalSLNTypes()) {
                    if (configurator.isCanceled()) {
                        return result;
                    }
                    if (slnAction.hasNoLayers()) continue;
                    children.add(slnAction);
                }
                childrenWrappers = this.toWrappers(children, configurator, input);
                this.addChildren(result, wrapper, childrenWrappers, configurator);
            }
            return result;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return Collections.emptyList();
        }
    }

    private boolean hasFilteredSearchedLocalMember(IRfNamedElement parentElement, IRfFilterableTreeAccessor view) {
        if (!parentElement.hasLocalMembers()) {
            return false;
        }
        Collection childElements = parentElement.xGetLocalMembers();
        for (IRfNamedElement element : childElements) {
            if (ViewsUtilsCommon.matchesPath((Object)((Object)this.getPluginConfig().createElementTreeWrapper(element)), (IRfFilterableTreeAccessor)view)) {
                return true;
            }
            if (!this.hasFilteredSearchedLocalMember(element, view)) continue;
            return true;
        }
        return false;
    }

    private void addChildren(List<IDVTElementWrapper> result, AbstractRfTreeElementWrapper wrapper, List<IDVTElementWrapper> childrenWrappers, TypesViewInputConfigurator configurator) {
        if (childrenWrappers == null) {
            return;
        }
        if (configurator.isCollectingSymbols()) {
            result.addAll(childrenWrappers);
            return;
        }
        wrapper.addChildren(childrenWrappers);
    }

    public boolean symbolMatchesQueryKey(ISymbolCollectorPrerequisite symbolPrerequisite, SymbolCollectorConfigurator configurator) {
        if (configurator == null) {
            return false;
        }
        String queryKey = configurator.getQueryKey();
        if (SymbolQueryKey.isUvmSpecific((String)queryKey)) {
            return this.symbolMatchesUvmQueryKey(symbolPrerequisite, queryKey);
        }
        return super.symbolMatchesQueryKey(symbolPrerequisite, configurator);
    }

    private boolean symbolMatchesUvmQueryKey(ISymbolCollectorPrerequisite symbolPrerequisite, String queryKey) {
        if (!(symbolPrerequisite instanceof IDVTElementWrapper)) {
            return false;
        }
        Object element = ((IDVTElementWrapper)symbolPrerequisite).getRfElement();
        if (!(element instanceof RfStruct)) {
            return false;
        }
        RfStruct struct = (RfStruct)element;
        while (struct != null) {
            if (SymbolQueryKey.symbolMatchesQueryKey((String)struct.getName(), (String)queryKey)) {
                return true;
            }
            struct = struct.getParentStruct();
        }
        return false;
    }

    private boolean hasFilteredSearchedPorts(IRfNamedElement parentElement, IRfFilterableTreeAccessor view) {
        return ViewsUtilsCommon.matchesUnfilteredPort((IDVTElementWrapper)this.getPluginConfig().createElementTreeWrapper(parentElement), (IRfFilterableTreeAccessor)view);
    }

    private boolean containsUserExtendedType(Collection<RfType> types) {
        boolean containsUserExtendedTypes = false;
        for (RfType type : types) {
            if (type == null || type.hasNoLayers()) continue;
            containsUserExtendedTypes = true;
            break;
        }
        return containsUserExtendedTypes;
    }

    public boolean isSelectable(Object element, Object referenceData, StringMatcher matcher) {
        if (!(element instanceof AbstractRfTreeElementWrapper)) {
            return false;
        }
        Object rfElement = ((IDVTElementWrapper)element).getRfElement();
        if (rfElement == null) {
            return false;
        }
        if (rfElement instanceof ELanguageElement) {
            return false;
        }
        if (RfStruct.isPackageElement(rfElement, false)) {
            return false;
        }
        return matcher == null || ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)this.getLabelProvider(element).getText(element));
    }

    protected IRfKind getKind(IRfNamedElement e) {
        return RfKind.of(e);
    }

    public IRfKind getKind(String rfKindValue) {
        try {
            return RfKind.valueOf(rfKindValue);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

