/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.ViewsUtilsCommon;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.edt.base.model.reflection.RfDummyElement;
import ro.amiq.edt.base.model.reflection.RfField;
import ro.amiq.edt.base.model.reflection.RfListType;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructLayer;
import ro.amiq.edt.base.model.reflection.RfType;
import ro.amiq.edt.base.model.reflection.util.RfUtils;
import ro.amiq.edt.base.model.reflection.views.AbstractEVHViewContributorCommon;
import ro.amiq.edt.base.model.reflection.views.AbstractRfTreeElementWrapper;
import ro.amiq.edt.base.model.reflection.views.EQuickViewersUtil;
import ro.amiq.edt.base.model.reflection.views.VHHistoryItem;
import ro.amiq.edt.base.ui.editor.hyperlink.RfNamedElementActionHyperlink;

public abstract class AbstractEVHViewContributor
extends AbstractEVHViewContributorCommon {
    private boolean hasGUIFilteredTree;

    public void gotoElement(IProject project, Object wrapper) {
        Object element;
        if (project == null) {
            return;
        }
        if (!(wrapper instanceof IDVTElementWrapper) && !(wrapper instanceof TreePath)) {
            return;
        }
        Object object = element = wrapper instanceof IDVTElementWrapper ? ((IDVTElementWrapper)wrapper).getRfElement() : ((TreePath)wrapper).getElement();
        if (element == null) {
            return;
        }
        RfNamedElementActionHyperlink actionHyperlink = null;
        if (element instanceof RfDummyElement) {
            return;
        }
        if (element instanceof RfStructLayer) {
            actionHyperlink = RfUtils.createOpenAction(this.getPluginConfig(), (RfStructLayer)element, project, null, false);
        } else if (element instanceof RfNamedElement) {
            actionHyperlink = RfUtils.createOpenAction(this.getPluginConfig(), (RfNamedElement)element, project, null);
        } else {
            return;
        }
        if (actionHyperlink == null) {
            return;
        }
        actionHyperlink.open();
    }

    public void gotoSelectedMember(IProject project, IDVTElementWrapper element) {
        if (element == null) {
            return;
        }
        this.setVHBreadcrumbData(element, project);
        this.gotoElement(project, element);
    }

    public boolean isSelectable(Object wrapper, Object referenceData, StringMatcher matcher) {
        if (!(wrapper instanceof AbstractRfTreeElementWrapper)) {
            return false;
        }
        Object rfElement = ((IDVTElementWrapper)wrapper).getRfElement();
        if (rfElement == null) {
            return false;
        }
        return !ViewsUtilsCommon.matchCamelCaseOrRegex((StringMatcher)matcher, (String)this.treeLabelProvider.getText(wrapper));
    }

    private RfStruct getStructFromSelectedWrappedInstance(Object selectedWrapper) {
        Object elem = selectedWrapper instanceof IDVTElementWrapper ? ((IDVTElementWrapper)selectedWrapper).getRfElement() : selectedWrapper;
        if (!(elem instanceof RfField)) {
            return null;
        }
        RfField field = (RfField)elem;
        RfType type = field.getAssociatedType();
        if (type instanceof RfListType) {
            type = ((RfListType)type).getAssociatedType();
        }
        if (field.isInstance() && type instanceof RfStruct) {
            return (RfStruct)type;
        }
        return null;
    }

    public void openTypeDeclarationAction(Object selectedWrapper, IProject project) {
        RfStruct struct = this.getStructFromSelectedWrappedInstance(selectedWrapper);
        if (struct == null) {
            return;
        }
        RfNamedElementActionHyperlink actionHyperlink = RfUtils.createOpenAction(this.getPluginConfig(), struct, project, null);
        if (actionHyperlink == null) {
            return;
        }
        actionHyperlink.open();
    }

    public void openCreateCallAction(Object selectedWrapper, IProject project) {
    }

    public List<String> getAdditionalContextMenuActionIds(Object selectedWrapper) {
        Object elem = selectedWrapper instanceof IDVTElementWrapper ? ((IDVTElementWrapper)selectedWrapper).getRfElement() : selectedWrapper;
        ArrayList<String> results = new ArrayList<String>(2);
        results.add("ro.amiq.dvt.ui.views.verification.hierarchy.copyHierarchyPath");
        if (!(elem instanceof RfField) || !((RfField)elem).isInstance()) {
            return results;
        }
        RfStruct struct = this.getStructFromSelectedWrappedInstance(selectedWrapper);
        if (struct != null && struct.isPredefined()) {
            return results;
        }
        results.add("ro.amiq.dvt.ui.views.verification.hierarchy.OpenTypeDeclaration");
        return results;
    }

    public void openViewForElementAtCursor() {
        EQuickViewersUtil.getInstance().openVerificationHierarchyForElementAtCursor(this.getPluginConfig().getRfManager());
    }

    public void copyHierarchyPathAction(Object selectedWrapper, Object port) {
        String textToCopy = this.computeCopyHierarchyPath(selectedWrapper, port);
        Utils.copyToClipboard((String)textToCopy, (int)3);
    }

    public void setHasGUIFilteredTree(boolean hasGUIFilteredTree) {
        this.hasGUIFilteredTree = hasGUIFilteredTree;
    }

    public boolean hasGUIFilteredTree() {
        return this.hasGUIFilteredTree;
    }

    @Override
    protected IProject getIProject(VHHistoryItem selectedTop) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(selectedTop.getProjectName());
    }

    protected Boolean adaptsToLanguageKind(Object adapted) {
        return null;
    }
}

