/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfNamedElement;

public abstract class AbstractRfTreeElementWrapper
extends IDVTElementWrapper {
    private List<AbstractRfTreeElementWrapper> fChildren;
    private boolean fOverlayStatus;
    private boolean fAccessDecoratorEnable;
    private AbstractRfTreeElementWrapper fSelected;
    private AbstractRfTreeElementWrapper fParent;
    private boolean fGrayIcon;
    private int fLineNumber;
    private boolean fOverrideLine;
    private Object fItem;
    private int fExpanded;
    private String fTreeName;
    private long uniqueID;
    private Object fGoToElement;

    public void addChild(IDVTElementWrapper child) {
        if (this.fChildren == null) {
            this.fChildren = new ArrayList<AbstractRfTreeElementWrapper>();
        }
        ((AbstractRfTreeElementWrapper)child).setParent(this);
        this.fChildren.add((AbstractRfTreeElementWrapper)child);
    }

    public List<AbstractRfTreeElementWrapper> getChildren() {
        return this.fChildren;
    }

    public IDVTElementWrapper getFirstChild() {
        return this.fChildren == null || this.fChildren.isEmpty() ? null : (IDVTElementWrapper)this.fChildren.get(0);
    }

    public AbstractRfTreeElementWrapper(Object element, boolean access) {
        super(element);
        this.fElement = element;
        this.fAccessDecoratorEnable = access;
    }

    public AbstractRfTreeElementWrapper(Object element) {
        super(element);
        this.fElement = element;
        this.fAccessDecoratorEnable = false;
    }

    public AbstractRfTreeElementWrapper() {
        super(null);
    }

    public AbstractRfTreeElementWrapper getChild(Object unwrapped) {
        if (this.fChildren == null) {
            return null;
        }
        int i = 0;
        while (i < this.fChildren.size()) {
            AbstractRfTreeElementWrapper child = this.fChildren.get(i);
            if (child.fElement.equals(unwrapped)) {
                return child;
            }
            ++i;
        }
        return null;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IResource.class) {
            if (this.fElement instanceof RfModule) {
                return ((RfModule)this.fElement).getAdapter(adapter);
            }
        } else if (adapter == RfNamedElement.class ? this.fElement instanceof RfNamedElement : adapter == RfDefElement.class && this.fElement instanceof RfDefElement) {
            return this.fElement;
        }
        return null;
    }

    public boolean getOverlayStatus() {
        return this.fOverlayStatus;
    }

    public void setOverlayStatus(boolean status) {
        this.fOverlayStatus = status;
    }

    public boolean getAccessDecoratorEnable() {
        return this.fAccessDecoratorEnable;
    }

    public AbstractRfTreeElementWrapper getSelectedElement() {
        return this.fSelected;
    }

    public void setSelectedElement(Object selected) {
        if (selected instanceof AbstractRfTreeElementWrapper) {
            this.fSelected = (AbstractRfTreeElementWrapper)((Object)selected);
        }
    }

    protected void setParent(AbstractRfTreeElementWrapper parent) {
        this.fParent = parent;
    }

    public void setParent(IDVTElementWrapper parent) {
        this.fParent = parent instanceof AbstractRfTreeElementWrapper ? (AbstractRfTreeElementWrapper)parent : null;
    }

    public AbstractRfTreeElementWrapper getParent() {
        return this.fParent;
    }

    public void setGrayIcon(boolean grayIcon) {
        this.fGrayIcon = grayIcon;
    }

    public boolean isGrayIcon() {
        return this.fGrayIcon;
    }

    public void overrideLineNumber(int line) {
        this.fLineNumber = line;
        this.fOverrideLine = true;
    }

    public int getLineNumber() {
        return this.fLineNumber;
    }

    public boolean isOverrideLine() {
        return this.fOverrideLine;
    }

    public void setItem(Object item) {
        this.fItem = item;
    }

    public Object getItem() {
        return this.fItem;
    }

    public void setExpanded(int expanded) {
        this.fExpanded = expanded;
    }

    public int getExpanded() {
        return this.fExpanded;
    }

    public <T extends IDVTElementWrapper> void setChildren(List<T> children) {
        this.fChildren = children;
    }

    public void setTreeName(String treeName) {
        this.fTreeName = treeName;
    }

    public String getTreeName() {
        return this.fTreeName;
    }

    public void setUniqueID(long id) {
        this.uniqueID = id;
    }

    public long getUniqueID() {
        return this.uniqueID;
    }

    public void deepClean() {
    }

    public <T extends IDVTElementWrapper> void addChildren(List<T> children) {
        if (children == null || children.isEmpty()) {
            return;
        }
        for (IDVTElementWrapper elementWrapper : children) {
            this.addChild(elementWrapper);
        }
    }

    public boolean hasChildren() {
        return this.fChildren != null && !this.fChildren.isEmpty();
    }

    public void removeChild(IDVTElementWrapper child) {
        if (!this.hasChildren()) {
            return;
        }
        this.fChildren.remove(child);
    }

    public String toString() {
        Object rfElement = this.getRfElement();
        return rfElement != null ? rfElement.toString() : "";
    }

    public Object getGoToElement() {
        return this.fGoToElement;
    }

    public void setGoToElement(Object goToElement) {
        this.fGoToElement = goToElement;
    }
}

