/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection.views;

import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.core.IPluginConfig;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.reflection.RfAssert;
import ro.amiq.edt.base.model.reflection.RfCheckThat;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfExpectLayer;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.views.AbstractRfTreeElementWrapper;
import ro.amiq.edt.base.model.reflection.views.ELabelProvider;
import ro.amiq.edt.base.model.reflection.views.ELanguageElement;
import ro.amiq.edt.base.model.reflection.views.TypesViewLabelProvider;

public class ChecksViewLabelProvider
extends ELabelProvider {
    private TypesViewLabelProvider fTypesViewLabelProvider;
    private final boolean fIsInSLNMode;

    public ChecksViewLabelProvider(IEPluginConfig pluginConfig) {
        super(pluginConfig);
        this.fTypesViewLabelProvider = new TypesViewLabelProvider(pluginConfig);
        this.fIsInSLNMode = DVTUtilsCommon.INSTANCE.isInSlnLikeMode((IPluginConfig)pluginConfig);
    }

    public Image getColumnImage(Object wrapper, int columnIndex) {
        if (!(wrapper instanceof AbstractRfTreeElementWrapper)) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        Object element = ((AbstractRfTreeElementWrapper)((Object)wrapper)).getRfElement();
        if (element instanceof ELanguageElement && columnIndex == 0) {
            return DVTImages.imageCache.getImage(this.fIsInSLNMode ? DVTImages.SLN_LANGUAGE : DVTImages.E_LANGUAGE);
        }
        Image result = null;
        if (element instanceof String && columnIndex == 0) {
            result = DVTImages.imageCache.getImage(DVTImages.OUTLINE_PACKAGE);
        } else {
            if (element instanceof RfExpectLayer && columnIndex == 0) {
                if (((RfExpectLayer)element).isExpect()) {
                    return DVTImages.imageCache.getImage(DVTImages.EXPECT);
                }
                return DVTImages.imageCache.getImage(DVTImages.ASSUME);
            }
            if (element instanceof RfCheckThat && columnIndex == 0) {
                return DVTImages.imageCache.getImage(DVTImages.CHECK);
            }
            if (element instanceof RfAssert && columnIndex == 0) {
                return DVTImages.imageCache.getImage(DVTImages.ASSERT);
            }
            if (columnIndex == 0) {
                result = this.fTypesViewLabelProvider.getImage(wrapper);
            }
        }
        if (result == null) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        if (!((AbstractRfTreeElementWrapper)((Object)wrapper)).getOverlayStatus()) {
            return result;
        }
        if (this.fDecorator != null) {
            return this.fDecorator.decorateImage(result, wrapper);
        }
        return result;
    }

    public String getColumnText(Object wrapper, int columnIndex) {
        Object element;
        if (!(wrapper instanceof AbstractRfTreeElementWrapper)) {
            return null;
        }
        AbstractRfTreeElementWrapper treeElementWrapper = (AbstractRfTreeElementWrapper)((Object)wrapper);
        if (treeElementWrapper.getAdditionalInfo(IDVTElementWrapper.Attribute.MATCH) != null && columnIndex == 0) {
            this.setBoldFont(treeElementWrapper);
        }
        if ((element = treeElementWrapper.getRfElement()) instanceof ELanguageElement && columnIndex == 0) {
            return (String)((ELanguageElement)((Object)element)).getInfo();
        }
        if (element instanceof RfCheckThat || element instanceof RfAssert || element instanceof RfExpectLayer) {
            if (columnIndex == 0) {
                return treeElementWrapper.getTreeName();
            }
            if (element instanceof RfNamedElement) {
                RfNamedElement rne = (RfNamedElement)element;
                return ViewsUtils.trimText((String)rne.getComment(), (int)100, (boolean)true);
            }
            if (element instanceof RfDefElement) {
                RfDefElement rde = (RfDefElement)element;
                return ViewsUtils.trimText((String)rde.getLayerComment(), (int)100, (boolean)true);
            }
        }
        if (columnIndex == 0 && element instanceof String) {
            return (String)element;
        }
        if (columnIndex == 0) {
            return this.fTypesViewLabelProvider.getText(wrapper);
        }
        return "";
    }

    public Image getImage(Object element) {
        return this.getColumnImage(element, 0);
    }

    public String getText(Object object) {
        String result = this.getColumnText(object, 0);
        if (result == null) {
            return "";
        }
        return result;
    }

    public String getTextForSearch(Object element) {
        StringBuilder result = new StringBuilder();
        result.append(this.getColumnText(element, 0)).append(" ").append(this.getColumnText(element, 1));
        return result.toString();
    }
}

