/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection.views;

import org.eclipse.core.resources.IResource;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.core.IPluginConfig;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.reflection.RfDummyElement;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.predefined.ecode.RfPredefinedCodeLoader;
import ro.amiq.edt.base.model.reflection.views.AbstractRfTreeElementWrapper;
import ro.amiq.edt.base.model.reflection.views.ELabelProvider;
import ro.amiq.edt.base.model.reflection.views.ELanguageElement;

public class CompileOrderViewLabelProvider
extends ELabelProvider {
    private final boolean fIsInSLNMode;

    public CompileOrderViewLabelProvider(IEPluginConfig pluginConfig) {
        super(pluginConfig);
        this.fIsInSLNMode = DVTUtilsCommon.INSTANCE.isInSlnLikeMode((IPluginConfig)pluginConfig);
    }

    public Image getImage(Object wrapper) {
        if (!(wrapper instanceof IDVTElementWrapper)) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        Object rfElement = ((IDVTElementWrapper)wrapper).getRfElement();
        if (rfElement instanceof ELanguageElement) {
            return DVTImages.imageCache.getImage(this.fIsInSLNMode ? DVTImages.SLN_LANGUAGE : DVTImages.E_LANGUAGE);
        }
        if (!(rfElement instanceof RfModule)) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        RfModule module = (RfModule)rfElement;
        Image result = null;
        IResource iFile = (IResource)module.getAdapter(IResource.class);
        result = iFile != null ? DVTImages.imageCache.getImage(this.fIsInSLNMode ? DVTImages.DESC_SLN_MODULE : DVTImages.DESC_E_MODULE) : DVTImages.imageCache.getImage(this.fIsInSLNMode ? DVTImages.DESC_SLN_MODULE_GRAY : DVTImages.DESC_E_MODULE_GRAY);
        if (result == null) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        if (this.fDecorator != null) {
            return this.fDecorator.decorateImage(result, wrapper);
        }
        return result;
    }

    public String getText(Object object) {
        Object rfElement;
        if (!(object instanceof AbstractRfTreeElementWrapper)) {
            return null;
        }
        AbstractRfTreeElementWrapper treeElementWrapper = (AbstractRfTreeElementWrapper)((Object)object);
        if (treeElementWrapper.getAdditionalInfo(IDVTElementWrapper.Attribute.MATCH) != null) {
            this.setBoldFont(treeElementWrapper);
        }
        if ((rfElement = treeElementWrapper.getRfElement()) instanceof ELanguageElement) {
            return (String)((ELanguageElement)((Object)rfElement)).getInfo();
        }
        if (rfElement instanceof String) {
            return rfElement.toString();
        }
        if (rfElement instanceof RfDummyElement) {
            return ((RfDummyElement)rfElement).getName();
        }
        if (!(rfElement instanceof RfModule)) {
            return null;
        }
        RfModule module = (RfModule)rfElement;
        int index = module.getModuleIndex() - RfPredefinedCodeLoader.PREDEF_FILES_LIST.length;
        if (index < 1) {
            return module.getName();
        }
        return String.valueOf(module.getName()) + " [" + index + "]";
    }
}

