/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection.views;

import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.core.IPluginConfig;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.reflection.RfCoverItem;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfEvent;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.views.AbstractRfTreeElementWrapper;
import ro.amiq.edt.base.model.reflection.views.ELabelProvider;
import ro.amiq.edt.base.model.reflection.views.ELanguageElement;
import ro.amiq.edt.base.model.reflection.views.TypesViewLabelProvider;

public class CoverageViewLabelProvider
extends ELabelProvider {
    private TypesViewLabelProvider fTypesViewLabelProvider;
    private final boolean fIsInSLNMode;

    public CoverageViewLabelProvider(IEPluginConfig pluginConfig) {
        super(pluginConfig);
        this.fTypesViewLabelProvider = new TypesViewLabelProvider(pluginConfig);
        this.fIsInSLNMode = DVTUtilsCommon.INSTANCE.isInSlnLikeMode((IPluginConfig)pluginConfig);
    }

    public Image getColumnImage(Object wrapper, int columnIndex) {
        if (!(wrapper instanceof AbstractRfTreeElementWrapper)) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        AbstractRfTreeElementWrapper rfWrapper = (AbstractRfTreeElementWrapper)((Object)wrapper);
        Object element = rfWrapper.getRfElement();
        if (element instanceof ELanguageElement && columnIndex == 0) {
            return DVTImages.imageCache.getImage(this.fIsInSLNMode ? DVTImages.SLN_LANGUAGE : DVTImages.E_LANGUAGE);
        }
        Image result = null;
        if (element instanceof RfEvent && columnIndex == 0) {
            result = DVTImages.imageCache.getImage(DVTImages.OUTLINE_COVER);
        } else if (element instanceof RfCoverItem && columnIndex == 0) {
            if (((RfCoverItem)element).getKind() == 0) {
                result = DVTImages.imageCache.getImage(DVTImages.COVER_ITEM);
            } else if (((RfCoverItem)element).getKind() == 1) {
                result = DVTImages.imageCache.getImage(DVTImages.COVER_CROSS);
            } else if (((RfCoverItem)element).getKind() == 2) {
                result = DVTImages.imageCache.getImage(DVTImages.COVER_TRANSITION);
            }
        } else if (columnIndex == 0) {
            result = this.fTypesViewLabelProvider.getImage(wrapper);
        }
        if (result == null) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        if (!rfWrapper.getOverlayStatus()) {
            return result;
        }
        if (this.fDecorator != null) {
            return this.fDecorator.decorateImage(result, wrapper);
        }
        return result;
    }

    public String getColumnText(Object wrapper, int columnIndex) {
        Object element;
        if (!(wrapper instanceof AbstractRfTreeElementWrapper)) {
            return null;
        }
        AbstractRfTreeElementWrapper rfWrapper = (AbstractRfTreeElementWrapper)((Object)wrapper);
        if (rfWrapper.getAdditionalInfo(IDVTElementWrapper.Attribute.MATCH) != null && columnIndex == 0) {
            this.setBoldFont(rfWrapper);
        }
        if ((element = rfWrapper.getRfElement()) instanceof ELanguageElement && columnIndex == 0) {
            return (String)((ELanguageElement)((Object)element)).getInfo();
        }
        if (element instanceof RfEvent && columnIndex == 0) {
            RfNamedElement rne = (RfNamedElement)element;
            RfDefElement defElement = rne.getDeclaration(false);
            if (defElement == null) {
                defElement = rne.getFirstLayer();
            }
            if (defElement != null) {
                defElement = defElement.getStructLayer();
            }
            if (defElement != null) {
                return rne.getName();
            }
        }
        if (element instanceof RfEvent && columnIndex == 1) {
            return ViewsUtils.trimText((String)((RfEvent)element).getCoverGroupComment(), (int)100, (boolean)true);
        }
        if (element instanceof RfCoverItem && columnIndex == 0) {
            return ((RfNamedElement)element).getName();
        }
        if (element instanceof RfCoverItem && columnIndex == 1) {
            return ViewsUtils.trimText((String)((RfNamedElement)element).getComment(), (int)100, (boolean)true);
        }
        if (element instanceof RfStruct && columnIndex == 0) {
            return ((RfStruct)element).getName();
        }
        if (columnIndex == 0) {
            return this.fTypesViewLabelProvider.getText(wrapper);
        }
        return "";
    }

    public Image getImage(Object element) {
        return this.getColumnImage(element, 0);
    }

    public String getText(Object object) {
        String result = this.getColumnText(object, 0);
        if (result == null) {
            return "";
        }
        return result;
    }

    public String getTextForSearch(Object element) {
        StringBuilder result = new StringBuilder();
        result.append(this.getColumnText(element, 0)).append(" ").append(this.getColumnText(element, 1));
        return result.toString();
    }
}

