/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection.views;

import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.core.IPluginConfig;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.views.AbstractCallHierarchyTreeElementWrapper;
import ro.amiq.edt.base.model.reflection.views.AbstractRfTreeElementWrapper;
import ro.amiq.edt.base.model.reflection.views.ECallHierarchyWalkerNode;
import ro.amiq.edt.base.model.reflection.views.ECallHierarchyWalkerNodeType;
import ro.amiq.edt.base.model.reflection.views.ELabelProvider;

public class ECallHierarchyLabelProvider
extends ELabelProvider {
    private final boolean fIsInSLNMode;
    private boolean setBold = true;
    private AtomicBoolean fUsedByQuickLayersView = new AtomicBoolean(false);

    public ECallHierarchyLabelProvider(IEPluginConfig pluginConfig) {
        super(pluginConfig);
        this.fIsInSLNMode = DVTUtilsCommon.INSTANCE.isInSlnLikeMode((IPluginConfig)pluginConfig);
    }

    public void setUsedByQuickLayersView(boolean usedByQuickLayersView) {
        this.fUsedByQuickLayersView.set(usedByQuickLayersView);
    }

    public String getText(Object element) {
        String result = this.getColumnText(element, 0);
        if (result == null) {
            return "";
        }
        return result;
    }

    public Image getImage(Object element) {
        return this.getColumnImage(element, 0);
    }

    public Image getColumnImage(Object wrapper, int columnIndex) {
        Image result = null;
        if (!(wrapper instanceof AbstractRfTreeElementWrapper)) {
            return result;
        }
        AbstractRfTreeElementWrapper rfWrapper = (AbstractRfTreeElementWrapper)((Object)wrapper);
        Object node = rfWrapper.getRfElement();
        if (!(node instanceof ECallHierarchyWalkerNode)) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        ECallHierarchyWalkerNode callHierarchyNode = (ECallHierarchyWalkerNode)node;
        RfNamedElement element = ((ECallHierarchyWalkerNode)node).getElement();
        if (columnIndex == 0) {
            if (callHierarchyNode.getNodeType() == ECallHierarchyWalkerNodeType.PREDEFINED_METHOD_CALL) {
                return DVTImages.imageCache.getImage(DVTImages.OUTLINE_PMETHOD);
            }
            if (callHierarchyNode.getNodeType() == ECallHierarchyWalkerNodeType.RECCURENCE) {
                return DVTImages.imageCache.getImage(DVTImages.INSTANCE_LOOP);
            }
            if (element instanceof RfModule) {
                result = DVTImages.imageCache.getImage(this.fIsInSLNMode ? DVTImages.DESC_SLN_MODULE : DVTImages.DESC_E_MODULE);
            } else if (element instanceof RfMethod) {
                result = DVTImages.imageCache.getImage(DVTImages.OUTLINE_METHOD);
                if (((RfMethod)element).isTCM()) {
                    result = DVTImages.imageCache.getImage((ImageDescriptor)new DecorationOverlayIcon(result, DVTImages.OVR_EVENT, 3));
                }
            } else if (element instanceof RfStruct) {
                result = DVTImages.imageCache.getImage(DVTImages.OUTLINE_STRUCT);
            }
            if (!rfWrapper.getOverlayStatus()) {
                return result;
            }
        } else if (columnIndex == 2) {
            IResource file = null;
            if (callHierarchyNode.getNodeType() == ECallHierarchyWalkerNodeType.PREDEFINED_METHOD_CALL) {
                return DVTImages.imageCache.getImage(DVTImages.DESC_E_MODULE);
            }
            if (callHierarchyNode.getNodeType() == ECallHierarchyWalkerNodeType.METHOD_CALL) {
                RfDefElement enclLayer = callHierarchyNode.getEnclosingLayer();
                file = enclLayer.getFileAdapter();
            } else {
                file = element.getFileAdapter();
            }
            if (file == null) {
                if (element.isPredefined()) {
                    return DVTImages.imageCache.getImage(DVTImages.DESC_E_MODULE);
                }
                return DVTImages.imageCache.getImage(DVTImages.DESC_E_MODULE_GRAY);
            }
            result = DVTImages.imageCache.getImage(DVTImages.DESC_E_MODULE);
            IContainer parent = file.getParent();
            while (parent != null && !(parent instanceof IProject)) {
                if (parent.isLinked()) {
                    return DVTImages.imageCache.getImage(DVTImages.DESC_E_MODULE_LINKED);
                }
                parent = parent.getParent();
            }
            return result;
        }
        return result;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (!(element instanceof AbstractCallHierarchyTreeElementWrapper)) {
            return null;
        }
        AbstractCallHierarchyTreeElementWrapper wrapper = (AbstractCallHierarchyTreeElementWrapper)((Object)element);
        if (!(wrapper.getRfElement() instanceof ECallHierarchyWalkerNode)) {
            return null;
        }
        ECallHierarchyWalkerNode callHierarchyNode = (ECallHierarchyWalkerNode)wrapper.getRfElement();
        if (callHierarchyNode == null) {
            return null;
        }
        if (this.setBold && wrapper.getAdditionalInfo(IDVTElementWrapper.Attribute.MATCH) != null && columnIndex == 0) {
            this.setBoldFont(wrapper);
        }
        AbstractCallHierarchyTreeElementWrapper.WrapperKind wrapperKind = wrapper.getWrapperKind();
        switch (wrapperKind) {
            case RECURRENCE: 
            case POTENTIAL: 
            case ACTION_BLOCK: 
            case OVERRIDE: 
            case UPDATING: 
            case MACRO: 
            case NORMAL: {
                switch (columnIndex) {
                    case 0: {
                        if (callHierarchyNode.getNodeType() == ECallHierarchyWalkerNodeType.PREDEFINED_METHOD_CALL) {
                            return callHierarchyNode.getLabel();
                        }
                        boolean prependPackage = PrefConst.getCallHierarchyViewPrependPackage();
                        if (prependPackage && callHierarchyNode.getElement() != null) {
                            return String.valueOf(((RfMethod)callHierarchyNode.getElement()).getPackageName()) + "::" + callHierarchyNode.getLabel();
                        }
                        return callHierarchyNode.getLabel();
                    }
                    case 1: {
                        return "" + callHierarchyNode.getElementStartLine();
                    }
                    case 2: {
                        if (callHierarchyNode.getParserPath() == null) {
                            return "";
                        }
                        String[] pathElements = callHierarchyNode.getParserPath().toString().split("/");
                        return pathElements[pathElements.length - 1];
                    }
                    case 3: {
                        String comment = callHierarchyNode.getComment();
                        if (comment == null) {
                            return "";
                        }
                        return (comment = comment.replace("\\R", " ")).length() > 100 ? String.valueOf(comment.substring(0, 100)) + "..." : comment;
                    }
                }
                return null;
            }
        }
        return null;
    }

    public String getTextForSearch(Object element) {
        StringBuilder result = new StringBuilder();
        result.append(this.getColumnText(element, 0)).append(" ").append(this.getColumnText(element, 1));
        return result.toString();
    }

    public String getTextUtil(Object element, int columnIndex) {
        this.setBold = false;
        String result = this.getColumnText(element, columnIndex);
        this.setBold = true;
        return result == null ? "" : result;
    }
}

