/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection.views;

import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.core.IPluginConfig;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.reflection.views.ELayersViewLabelProviderCommon;

public class ELayersViewLabelProvider
extends ELayersViewLabelProviderCommon {
    private final boolean fIsInSLNMode;
    private AtomicBoolean fUsedByQuickLayersView = new AtomicBoolean(false);

    public ELayersViewLabelProvider(IEPluginConfig pluginConfig) {
        super(pluginConfig);
        this.fIsInSLNMode = DVTUtilsCommon.INSTANCE.isInSlnLikeMode((IPluginConfig)pluginConfig);
    }

    @Override
    public void setUsedByQuickLayersView(boolean usedByQuickLayersView) {
        this.fUsedByQuickLayersView.set(usedByQuickLayersView);
    }

    @Override
    protected boolean isInSLNMode() {
        return this.fIsInSLNMode;
    }

    @Override
    protected boolean isUsedByQuickLayersView() {
        return this.fUsedByQuickLayersView.get();
    }

    @Override
    protected Image getColumnImageForModule(IFile file) {
        Image result = DVTImages.imageCache.getImage(this.isInSLNMode() ? DVTImages.DESC_SLN_MODULE : DVTImages.DESC_E_MODULE);
        IContainer parent = file.getParent();
        while (parent != null && !(parent instanceof IProject)) {
            if (parent.isLinked()) {
                result = DVTImages.imageCache.getImage(this.isInSLNMode() ? DVTImages.DESC_SLN_MODULE_LINKED : DVTImages.DESC_E_MODULE_LINKED);
                break;
            }
            parent = parent.getParent();
        }
        return result;
    }

    @Override
    public String trimText(String text, int maxLength, boolean replaceNewlinesWithSpaces) {
        return ViewsUtils.trimText((String)text, (int)maxLength, (boolean)replaceNewlinesWithSpaces);
    }
}

