/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection.views;

import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.model.FileCompileInfo;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.model.reflection.RfProjectState;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.views.BuildEventManager;
import ro.amiq.dvt.ui.views.DVTViewEvent;
import ro.amiq.dvt.ui.views.UpdateViewEvent;
import ro.amiq.dvt.ui.views.ViewDataContainer;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.VHViewMessages;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.VHViewUtils;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.VerificationHierarchyView;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.AbstractEModelManager;
import ro.amiq.edt.base.model.IEModule;
import ro.amiq.edt.base.model.reflection.AbstractRfManager;
import ro.amiq.edt.base.model.reflection.Determinant;
import ro.amiq.edt.base.model.reflection.FullName;
import ro.amiq.edt.base.model.reflection.IRfScope;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfEnum;
import ro.amiq.edt.base.model.reflection.RfField;
import ro.amiq.edt.base.model.reflection.RfListType;
import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfMethodLayer;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfScalarType;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructLayer;
import ro.amiq.edt.base.model.reflection.RfStructMember;
import ro.amiq.edt.base.model.reflection.RfType;
import ro.amiq.edt.base.model.reflection.RfVar;
import ro.amiq.edt.base.model.reflection.semantic.RfSubtypeElement;
import ro.amiq.edt.base.model.reflection.util.RfUtils;
import ro.amiq.edt.base.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.edt.base.model.reflection.views.AbstractRfTreeElementWrapper;
import ro.amiq.edt.base.model.reflection.views.ECallHierarchyWalkerNode;
import ro.amiq.edt.base.model.reflection.views.EQuickViewersUtilCommon;
import ro.amiq.edt.base.model.reflection.views.ESequenceTreeNode;
import ro.amiq.edt.base.model.reflection.views.VHHistoryItem;

public enum EQuickViewersUtil implements EQuickViewersUtilCommon
{
    INSTANCE;

    private Map<IFile, WaitEditorActiveJob> fWaitEditorJobs = new ConcurrentHashMap<IFile, WaitEditorActiveJob>();
    private static final Object FAMILY_MODULE_REPARSE;
    private TreeItem fBestMatch;

    static {
        FAMILY_MODULE_REPARSE = new Object();
    }

    public static EQuickViewersUtil getInstance() {
        return INSTANCE;
    }

    public static IRfNamedElement getEnclosingMethodOrStruct(IRfScope initialScope, boolean ignoreMethods) {
        if (initialScope == null) {
            return null;
        }
        IRfScope scope = initialScope;
        do {
            if (!ignoreMethods && scope instanceof RfMethod) {
                return (RfMethod)scope;
            }
            if (scope instanceof RfStruct) {
                return (RfStruct)scope;
            }
            if (!ignoreMethods && scope instanceof RfMethodLayer) {
                return ((RfMethodLayer)scope).getMethod();
            }
            if (!(scope instanceof RfStructLayer)) continue;
            return ((RfStructLayer)scope).getStruct();
        } while ((scope = scope.getEnclosingScope()) != null);
        return null;
    }

    public void scheduleReparseIfNonTop(IEPluginConfig pluginConfig, ITextEditor editor, boolean checkBuildDone) {
        IProject project = this.getProject(editor);
        if (project == null) {
            return;
        }
        if (BuildConfigManager.isNonTopFileCompilationDisabled((IProject)project)) {
            return;
        }
        IFile resource = (IFile)editor.getEditorInput().getAdapter(IFile.class);
        if (resource == null) {
            return;
        }
        RfProject rfProject = pluginConfig.getRfManager().getRfProject(project);
        if (rfProject == null) {
            return;
        }
        ParserPath parserPath = DVTFileUtils.getInstance().resource2parser((IResource)resource);
        if (parserPath == null) {
            return;
        }
        RfMixedLangProject rfMixedProject = rfProject.getMixedLangProjectParent();
        if (rfMixedProject == null) {
            return;
        }
        if (checkBuildDone && RfProjectState.BUILT.equals((Object)rfProject.getProjectState()) && !rfMixedProject.isBuildDone()) {
            return;
        }
        if (!RfProjectState.BUILT.equals((Object)rfProject.getProjectState()) && !RfProjectState.RESTORED.equals((Object)rfProject.getProjectState())) {
            return;
        }
        boolean isCompiled = rfProject.isCompiled(parserPath);
        if (isCompiled) {
            return;
        }
        RfModule module = rfProject.getModule((IResource)resource);
        if (module == null && !this.isWaitEditorJobScheduled(resource)) {
            WaitEditorActiveJob fWaitEditorJob = new WaitEditorActiveJob();
            fWaitEditorJob.setFile(resource);
            fWaitEditorJob.setEModelManager(pluginConfig.getModelManager());
            fWaitEditorJob.setProject(rfProject);
            fWaitEditorJob.setPluginConfig(pluginConfig);
            this.fWaitEditorJobs.put(resource, fWaitEditorJob);
            fWaitEditorJob.schedule(0L);
        }
    }

    private boolean isWaitEditorJobScheduled(IFile file) {
        if (file == null) {
            return false;
        }
        return this.fWaitEditorJobs.containsKey(file);
    }

    public void removeWaitEditorJob(IFile file) {
        if (file == null) {
            return;
        }
        this.fWaitEditorJobs.remove(file);
    }

    public IProject getProject(ITextEditor editor) {
        if (editor == null) {
            return null;
        }
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput == null) {
            return null;
        }
        IFile file = (IFile)editorInput.getAdapter(IFile.class);
        if (file == null) {
            return null;
        }
        return file.getProject();
    }

    public TreeItem getSymbolAtLine(Tree tree, int line) {
        TreeItem item = this.getSymbolChildAtLine(tree, line);
        if (item == null) {
            item = this.fBestMatch;
        }
        return item;
    }

    private TreeItem getSymbolChildAtLine(Object parent, int line) {
        TreeItem[] items = null;
        if (parent instanceof Tree) {
            items = ((Tree)parent).getItems();
        } else if (parent instanceof TreeItem) {
            items = ((TreeItem)parent).getItems();
        }
        if (items != null) {
            int i = 0;
            while (i < items.length) {
                Object data;
                TreeItem item = items[i];
                if (!item.isDisposed() && (data = item.getData()) != null) {
                    Object element = ((AbstractRfTreeElementWrapper)((Object)data)).getRfElement();
                    if (!(element instanceof RfDefElement)) {
                        return null;
                    }
                    RfDefElement os = (RfDefElement)element;
                    if (line == os.getStartLine()) {
                        return item;
                    }
                    if (os.getStartLine() < line && (this.fBestMatch == null || this.fBestMatch.isDisposed() || ((RfDefElement)((AbstractRfTreeElementWrapper)((Object)this.fBestMatch.getData())).getRfElement()).getStartLine() > line || ((RfDefElement)((AbstractRfTreeElementWrapper)((Object)this.fBestMatch.getData())).getRfElement()).getStartLine() < os.getStartLine())) {
                        this.fBestMatch = item;
                    }
                    if ((item = this.getSymbolChildAtLine(item, line)) != null) {
                        return item;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    public void updateLayersView(IEPluginConfig pluginConfig, RfNamedElement namedElement, IProject project, RfStruct struct, boolean updateHistory, DVTViewEvent.EventKind kind, String sourceId, boolean forceVisible) {
        UpdateViewEvent updateViewEvent = this.createViewUpdateEvent(pluginConfig, namedElement, project, struct, true, updateHistory ? 1 : 0);
        ViewDataContainer dataContainer = new ViewDataContainer(project, (HistoryItem)updateViewEvent);
        ViewsUtils.notifyViewById((String)"ro.amiq.dvt.ui.views.LayersView", (DVTViewEvent)new DVTViewEvent(kind, sourceId, dataContainer), (boolean)true);
    }

    public void updateTypeHierarchyViewer(IEPluginConfig pluginConfig, RfNamedElement namedElement, IProject project, boolean updateHistory, DVTViewEvent.EventKind kind, String sourceId, boolean forceVisible) {
        try {
            if (namedElement instanceof RfStructMember) {
                namedElement = ((RfStructMember)namedElement).getParentStruct();
            } else if (!(namedElement instanceof RfListType) && !(namedElement instanceof RfStruct)) {
                return;
            }
            UpdateViewEvent updateViewEvent = this.createViewUpdateEvent(pluginConfig, namedElement, project, (IRfScope)namedElement.getEnclosingScope(), true, updateHistory ? 2 : 0);
            ViewDataContainer dataContainer = new ViewDataContainer(project, (HistoryItem)updateViewEvent);
            ViewsUtils.notifyViewById((String)"ro.amiq.dvt.ui.views.TypeHierarchyView", (DVTViewEvent)new DVTViewEvent(kind, sourceId, dataContainer), (boolean)forceVisible);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void updateVerificationHierarchyViewer(RfDefElement defElement, IProject project, LanguageKind languageKind) {
        if (defElement == null || project == null) {
            return;
        }
        RfStruct struct = null;
        Determinant determinant = null;
        RfNamedElement namedElement = defElement.getNamedElement();
        if (namedElement instanceof RfStructMember) {
            struct = ((RfStructMember)namedElement).getParentStruct();
            determinant = struct.getDeterminant();
        } else if (namedElement instanceof RfStruct) {
            struct = (RfStruct)namedElement;
            determinant = ((RfStructLayer)defElement).getDeterminant();
        }
        if (struct == null || determinant == null) {
            VHViewUtils.popDialog((int)2, (String)VHViewMessages.fVHPopUpDialogTextE);
            return;
        }
        if (!struct.isUnit()) {
            VHViewUtils.popDialog((int)2, (String)VHViewMessages.fVHPopUpDialogTextE);
            return;
        }
        this.updateVerificationHierarchyViewer(struct.getPackageName(), struct.getName(), determinant, project, languageKind);
    }

    public void updateVerificationHierarchyViewer(String packageName, String unitName, Determinant determinant, IProject project, LanguageKind languageKind) {
        if (project == null) {
            return;
        }
        try {
            VHHistoryItem item = VHHistoryItem.parseHistoryItem(project.getName(), packageName, new FullName(unitName, determinant), languageKind);
            if (item == null) {
                VHViewUtils.popDialog((int)2, (String)VHViewMessages.fVHPopUpDialogTextE);
                return;
            }
            VerificationHierarchyView view = (VerificationHierarchyView)ViewsUtils.getViewById((String)"ro.amiq.dvt.ui.views.VerificationHierarchyView", (boolean)true);
            if (view == null) {
                return;
            }
            view.setUpAndUpdate((HistoryItem)item, true);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RfWNamedElementAndScope getNamedElementAndScope(IEPluginConfig pluginConfig, ITextEditor editor, int cursorOffset, boolean includeMembers, boolean includeVariables) {
        try {
            if (editor == null) {
                return null;
            }
            IProject project = this.getProject(editor);
            if (project == null) {
                return null;
            }
            RfProject rfProject = pluginConfig.getRfManager().getRfProject(project);
            if (rfProject == null) {
                return null;
            }
            IDocument document = DVTFileUtils.getInstance().getDocument(editor);
            if (document == null) {
                return null;
            }
            if (!DVTPlugin.getDefault().collect().c(project, pluginConfig.feature())) {
                return null;
            }
            RfNamedElement namedElement = null;
            RfWNamedElementAndScope namedElementAndScope = RfUtils.getRfElement(rfProject, editor, document, cursorOffset, false);
            if (namedElementAndScope == null) {
                return null;
            }
            namedElement = namedElementAndScope.getNamedElement();
            if (namedElement instanceof RfEnum) {
                RfEnum enumm = (RfEnum)namedElement;
                RfDefElement parentLayer = enumm.getParentLayer();
                if (parentLayer == null) {
                    return null;
                }
                RfNamedElement parent = parentLayer.getNamedElement();
                if (parent == null) {
                    return null;
                }
                namedElementAndScope.setNamedElement(parent);
                namedElement = parent;
            }
            if (namedElement instanceof RfSubtypeElement) {
                return new RfWNamedElementAndScope(((RfSubtypeElement)namedElement).getNamedElement(), null);
            }
            if (namedElement instanceof RfStruct || namedElement instanceof RfMethod || namedElement instanceof RfScalarType || includeMembers && namedElement instanceof RfStructMember || includeVariables && namedElement instanceof RfVar) {
                return namedElementAndScope;
            }
            return null;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    private RfWNamedElementAndScope getElementAndScopeForElementAtCursor(AbstractRfManager rfManager) {
        IEditorPart editor = DVTFileUtils.getInstance().getActiveEditor();
        if (editor == null) {
            return null;
        }
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput == null) {
            return null;
        }
        IFile file = (IFile)editorInput.getAdapter(IFile.class);
        if (file == null) {
            return null;
        }
        IProject project = file.getProject();
        if (project == null) {
            return null;
        }
        RfProject rfProject = rfManager.getRfProject(project);
        if (rfProject == null) {
            return null;
        }
        IDocument document = Utils.getDocumentFromEditor((ITextEditor)((ITextEditor)editor));
        if (document == null) {
            return null;
        }
        int offset = ((DVTEditor)editor).getCursor();
        return RfUtils.getRfElement(rfProject, file, document, offset, false);
    }

    public void openVerificationHierarchyForElementAtCursor(AbstractRfManager rfManager) {
        RfWNamedElementAndScope element = this.getElementAndScopeForElementAtCursor(rfManager);
        if (element == null) {
            return;
        }
        RfDefElement defElement = null;
        RfNamedElement namedElement = element.getNamedElement();
        IRfScope scope = element.getScope();
        if (scope instanceof RfStructLayer && ((RfStructLayer)scope).getNamedElement() == namedElement) {
            defElement = (RfDefElement)((Object)scope);
        } else if (namedElement instanceof RfStruct && ((RfStruct)namedElement).isUnit() && namedElement.getDeclaration(false) != null) {
            defElement = namedElement.getDeclaration(false);
        } else if (namedElement instanceof RfField) {
            RfField field = (RfField)namedElement;
            RfType type = field.getAssociatedType();
            Determinant determinant = field.getAssociatedTypeDeterminant();
            if (type instanceof RfListType) {
                RfListType associatedType = (RfListType)field.getAssociatedType();
                type = associatedType.getAssociatedType();
                determinant = associatedType.getDeterminant();
            }
            if (field.isInstance() && type instanceof RfStruct) {
                RfStruct typeStruct = (RfStruct)type;
                RfProject rfProject = typeStruct.getRfProject();
                if (rfProject == null) {
                    return;
                }
                if (!typeStruct.isUnit()) {
                    VHViewUtils.popDialog((int)2, (String)VHViewMessages.fVHPopUpDialogTextE);
                    return;
                }
                this.updateVerificationHierarchyViewer(typeStruct.getPackageName(), typeStruct.getName(), determinant, rfProject.getProject(), rfProject.getLanguageKind());
                return;
            }
        }
        if (defElement == null) {
            VHViewUtils.popDialog((int)2, (String)VHViewMessages.fVHPopUpDialogTextE);
            return;
        }
        RfProject rfProject = defElement.getRfProject();
        if (rfProject == null) {
            return;
        }
        this.updateVerificationHierarchyViewer(defElement, rfProject.getProject(), rfProject.getLanguageKind());
    }

    public void updateUVMSequenceTreeView(IEPluginConfig pluginConfig, Object rfElement, RfNamedElement namedElement, IProject project, RfStruct struct, boolean updateHistory, DVTViewEvent.EventKind kind, String sourceId, boolean forceVisible) {
        UpdateViewEvent updateViewEvent = this.createViewUpdateEvent(pluginConfig, namedElement, project, struct, true, updateHistory ? 5 : 0);
        Determinant determinant = null;
        ParserPath moduleParserPath = null;
        int maxModuleIndex = 0;
        if (rfElement instanceof ESequenceTreeNode) {
            ESequenceTreeNode sequenceNode = (ESequenceTreeNode)rfElement;
            determinant = sequenceNode.getDeterminant();
            if (sequenceNode.getParserPath() != null) {
                moduleParserPath = sequenceNode.getParserPath();
                maxModuleIndex = sequenceNode.getMaxModuleIndex();
            } else {
                RfModule module;
                RfNamedElement seqField = sequenceNode.getField();
                if (seqField != null && (module = seqField.getModule()) != null) {
                    moduleParserPath = module.getParserPath();
                    maxModuleIndex = module.getMaxModuleIndex();
                }
            }
        } else if (rfElement instanceof RfStructLayer) {
            determinant = ((RfStructLayer)rfElement).getDeterminant();
            moduleParserPath = ((RfStructLayer)rfElement).getParserPath();
            maxModuleIndex = ((RfStructLayer)rfElement).getMaxModuleIndex();
        }
        if (determinant != null) {
            updateViewEvent.setEdtDeterminant((Object)determinant);
        }
        if (moduleParserPath != null) {
            updateViewEvent.setEdtModuleParserPath(moduleParserPath);
        }
        updateViewEvent.setEdtMaxModuleIndex(maxModuleIndex);
        ViewDataContainer dataContainer = new ViewDataContainer(project, (HistoryItem)updateViewEvent);
        ViewsUtils.notifyViewById((String)"ro.amiq.dvt.ui.views.UVMSequenceTreeView", (DVTViewEvent)new DVTViewEvent(kind, sourceId, dataContainer), (boolean)true);
    }

    public void updateCallHierarchyView(IEPluginConfig pluginConfig, Object rfElement, RfNamedElement namedElement, IProject project, RfStructLayer structlayer, boolean updateHistory, DVTViewEvent.EventKind kind, String sourceId, boolean forceVisible) {
        UpdateViewEvent updateViewEvent = this.createViewUpdateEvent(pluginConfig, namedElement, project, structlayer, true, updateHistory ? 6 : 0);
        Determinant determinant = null;
        ParserPath moduleParserPath = null;
        int maxModuleIndex = 0;
        if (rfElement instanceof RfMethodLayer) {
            updateViewEvent.setElementScope(rfElement);
            updateViewEvent.setOffset(((RfMethodLayer)rfElement).getStartLine());
        }
        if (rfElement instanceof ECallHierarchyWalkerNode) {
            ECallHierarchyWalkerNode callHierarchyNode = (ECallHierarchyWalkerNode)rfElement;
            determinant = callHierarchyNode.getMethodDeterminant();
            if (callHierarchyNode.getParserPath() != null) {
                moduleParserPath = callHierarchyNode.getParserPath();
                maxModuleIndex = callHierarchyNode.getMaxModuleIndex();
            } else {
                RfModule module;
                RfNamedElement chField = callHierarchyNode.getElement();
                if (chField != null && (module = chField.getModule()) != null) {
                    moduleParserPath = module.getParserPath();
                    maxModuleIndex = module.getMaxModuleIndex();
                }
            }
        } else if (structlayer != null && rfElement instanceof RfMethod) {
            determinant = structlayer.getDeterminant();
            moduleParserPath = structlayer.getParserPath();
            maxModuleIndex = structlayer.getMaxModuleIndex();
        } else if (rfElement instanceof RfMethodLayer) {
            determinant = ((RfMethodLayer)rfElement).getDefStructDeterminant();
            moduleParserPath = ((RfMethodLayer)rfElement).getParserPath();
            maxModuleIndex = ((RfMethodLayer)rfElement).getMaxModuleIndex();
        }
        if (determinant != null) {
            updateViewEvent.setEdtDeterminant((Object)determinant);
        }
        if (moduleParserPath != null) {
            updateViewEvent.setEdtModuleParserPath(moduleParserPath);
        }
        updateViewEvent.setEdtMaxModuleIndex(maxModuleIndex);
        ViewDataContainer dataContainer = new ViewDataContainer(project, (HistoryItem)updateViewEvent);
        ViewsUtils.notifyViewById((String)"ro.amiq.dvt.ui.views.CallHierarchyView", (DVTViewEvent)new DVTViewEvent(kind, sourceId, dataContainer), (boolean)true);
    }

    static class NameLine {
        String fName;
        RfDefElement fLayer;

        public NameLine(String name, RfDefElement layer) {
            this.fName = name;
            this.fLayer = layer;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            return this.fName.equals(((NameLine)obj).fName);
        }

        public int hashCode() {
            return this.fName.hashCode();
        }
    }

    private class WaitEditorActiveJob
    extends Job {
        private IFile fFile;
        private AbstractEModelManager fEModelManager;
        private RfProject fRfProject;
        private IEPluginConfig fPluginConfig;

        public WaitEditorActiveJob() {
            super("Wait Editor");
            this.setPriority(50);
            this.setSystem(true);
        }

        public void setPluginConfig(IEPluginConfig pluginConfig) {
            this.fPluginConfig = pluginConfig;
        }

        public void setProject(RfProject rfProject) {
            this.fRfProject = rfProject;
        }

        public void setEModelManager(AbstractEModelManager eModelManager) {
            this.fEModelManager = eModelManager;
        }

        public void setFile(IFile file) {
            this.fFile = file;
        }

        public IFile getFile() {
            return this.fFile;
        }

        public boolean belongsTo(Object family) {
            return family == FAMILY_MODULE_REPARSE;
        }

        public boolean shouldSchedule() {
            boolean shouldSchedule;
            boolean bl = shouldSchedule = super.shouldSchedule() && ResourcesPlugin.getWorkspace().isAutoBuilding();
            if (!shouldSchedule) {
                EQuickViewersUtil.this.fWaitEditorJobs.remove(this.fFile);
            }
            return shouldSchedule;
        }

        public boolean shouldRun() {
            boolean shouldRun;
            boolean bl = shouldRun = super.shouldRun() && ResourcesPlugin.getWorkspace().isAutoBuilding();
            if (!shouldRun) {
                EQuickViewersUtil.this.fWaitEditorJobs.remove(this.fFile);
            }
            return shouldRun;
        }

        public IStatus run(IProgressMonitor monitor) {
            try {
                try {
                    IEModule eModule = this.fEModelManager.getEModel().getOrCreateEModule(this.fFile);
                    eModule.scheduleReparse(true, true, 0L, true);
                    LinkedHashSet<FileCompileInfo> changedFiles = new LinkedHashSet<FileCompileInfo>();
                    changedFiles.add(new FileCompileInfo(this.fFile));
                    EnumMap<LanguageKind, LinkedHashSet<FileCompileInfo>> changedFilesMap = new EnumMap<LanguageKind, LinkedHashSet<FileCompileInfo>>(LanguageKind.class);
                    changedFilesMap.put(this.fPluginConfig.getLanguageKind(), changedFiles);
                    HashSet<String> updateViewIds = new HashSet<String>();
                    this.fRfProject.postMixedLangIncrementalBuild(changedFiles, updateViewIds);
                    BuildEventManager.getInstance().notifyIncrementalBuild(this.fRfProject.getProject(), changedFilesMap, updateViewIds);
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    EQuickViewersUtil.this.fWaitEditorJobs.remove(this.fFile);
                }
            }
            finally {
                EQuickViewersUtil.this.fWaitEditorJobs.remove(this.fFile);
            }
            return Status.OK_STATUS;
        }
    }
}

