/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection.views;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.LabelProvider;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.UpdateViewEvent;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.reflection.Determinant;
import ro.amiq.edt.base.model.reflection.FullName;
import ro.amiq.edt.base.model.reflection.IRfAssociatedType;
import ro.amiq.edt.base.model.reflection.IRfScope;
import ro.amiq.edt.base.model.reflection.RfActionBlockLayer;
import ro.amiq.edt.base.model.reflection.RfConstraint;
import ro.amiq.edt.base.model.reflection.RfConstraintLayer;
import ro.amiq.edt.base.model.reflection.RfCoverLayer;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfEvent;
import ro.amiq.edt.base.model.reflection.RfEventLayer;
import ro.amiq.edt.base.model.reflection.RfExpect;
import ro.amiq.edt.base.model.reflection.RfField;
import ro.amiq.edt.base.model.reflection.RfFieldLayer;
import ro.amiq.edt.base.model.reflection.RfKind;
import ro.amiq.edt.base.model.reflection.RfListType;
import ro.amiq.edt.base.model.reflection.RfMacro;
import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfMethodLayer;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfScalarType;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructLayer;
import ro.amiq.edt.base.model.reflection.RfStructMember;
import ro.amiq.edt.base.model.reflection.RfType;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedEvent;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedField;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedMethod;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedScalar;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedStruct;
import ro.amiq.edt.base.model.reflection.util.NullProtectedList;
import ro.amiq.edt.base.model.reflection.util.RfUtils;
import ro.amiq.edt.base.model.reflection.views.AbstractRfTreeElementWrapper;

public interface EQuickViewersUtilCommon {
    default public List<RfDefElement> getLayersData(FullName name, int kind, RfStruct enclosingStruct, RfProject project, String packageName, boolean getAssociatedType) {
        if (getAssociatedType) {
            RfStructMember candidate = null;
            if (kind == 2) {
                candidate = enclosingStruct.getField(name);
            } else if (kind == 4) {
                candidate = enclosingStruct.getMethod(name);
            }
            if (candidate == null) {
                return this.getLayersData(name, kind, enclosingStruct, project, packageName);
            }
            RfNamedElement associated = this.getAssociatedType(candidate);
            if (associated == null) {
                return this.getLayersData(name, kind, enclosingStruct, project, packageName);
            }
            return this.getLayersData(new FullName(associated.getName(), null), this.getType(associated), null, project, this.getPackageName(associated));
        }
        return this.getLayersData(name, kind, enclosingStruct, project, packageName);
    }

    default public List<RfDefElement> getLayersData(FullName name, int kind, RfStruct enclosingStruct, RfProject project, String packageName) {
        NullProtectedList<RfDefElement> result = new NullProtectedList<RfDefElement>();
        String shortName = name.getName();
        if (kind == 4 || kind == 8) {
            RfStructLayer structLayer;
            if (enclosingStruct == null) {
                return result;
            }
            ArrayList<RfDefElement> layers = new ArrayList<RfDefElement>();
            LinkedHashSet<RfFieldLayer> fieldLayers = new LinkedHashSet<RfFieldLayer>();
            if (kind == 4) {
                RfStruct declStruct;
                enclosingStruct.collectAllMemberLayers(layers, shortName, 1);
                Determinant determinant = name.getDeterminant();
                iterator = layers.iterator();
                if (determinant != null) {
                    while (iterator.hasNext()) {
                        Determinant layerDeterminant;
                        RfDefElement layer = (RfDefElement)iterator.next();
                        if (!(layer instanceof RfMethodLayer) || !(structLayer = layer.getStructLayer()).getStruct().equals(enclosingStruct) || (layerDeterminant = ((RfMethodLayer)layer).getDeterminant()) == null || layerDeterminant.contains(determinant, true) || determinant.contains(layerDeterminant, true)) continue;
                        iterator.remove();
                    }
                }
                if ((declStruct = this.getMethodDeclarationStruct(shortName, enclosingStruct)) != null) {
                    for (RfStruct childStruct : this.getDescendants(declStruct)) {
                        ArrayList<RfDefElement> localFieldLayers = new ArrayList<RfDefElement>();
                        childStruct.getLocalMemberLayers(localFieldLayers, shortName, 2);
                        if (localFieldLayers.isEmpty()) continue;
                        for (RfDefElement defElem : localFieldLayers) {
                            RfFieldLayer fieldLayer;
                            RfField field;
                            if (!(defElem instanceof RfFieldLayer) || (field = (fieldLayer = (RfFieldLayer)defElem).getField()) == null || !"any_method_port".equals(field.getAssociatedTypeName())) continue;
                            fieldLayers.add(fieldLayer);
                        }
                    }
                }
            } else {
                enclosingStruct.collectAllMemberLayers(layers, shortName, 5);
                if (layers.isEmpty()) {
                    enclosingStruct.collectAllMemberLayers(layers, "on_" + name, 1);
                } else {
                    ArrayList<RfDefElement> onLayers = new ArrayList<RfDefElement>();
                    enclosingStruct.collectAllMemberLayers(onLayers, "on_" + name, 1);
                    if (!onLayers.isEmpty()) {
                        iterator = onLayers.iterator();
                        block3: while (iterator.hasNext()) {
                            RfDefElement onLayer = (RfDefElement)iterator.next();
                            for (RfDefElement layer : layers) {
                                if (onLayer.getStartLine() != layer.getStartLine() || !onLayer.getLayerModule().checkEquals(layer.getLayerModule())) continue;
                                iterator.remove();
                                continue block3;
                            }
                        }
                        layers.addAll(onLayers);
                    }
                }
            }
            if (layers.isEmpty()) {
                result.addAll(fieldLayers);
                return result;
            }
            Set<String> filteredLayers = null;
            if (PrefConst.getLayersViewShowESubtypeSupertypeLayers()) {
                filteredLayers = this.getLikeDescendantNames(enclosingStruct);
                if (filteredLayers == null) {
                    filteredLayers = this.getLikeAncestorNames(enclosingStruct);
                } else {
                    filteredLayers.addAll(this.getLikeAncestorNames(enclosingStruct));
                }
            } else if (PrefConst.getLayersViewShowESubtypeLayers()) {
                filteredLayers = this.getLikeDescendantNames(enclosingStruct);
            } else if (PrefConst.getLayersViewShowESupertypeLayers()) {
                filteredLayers = this.getLikeAncestorNames(enclosingStruct);
            } else {
                result.addAll(layers);
                result.addAll(fieldLayers);
                return result;
            }
            for (RfDefElement layer : layers) {
                structLayer = null;
                if (layer instanceof RfMethodLayer) {
                    structLayer = (RfStructLayer)((RfMethodLayer)layer).getEnclosingScope();
                } else {
                    if (!(layer instanceof RfEventLayer)) continue;
                    structLayer = ((RfEventLayer)layer).getStructLayer();
                }
                if (structLayer == null || !filteredLayers.contains(structLayer.getName())) continue;
                result.add(layer);
            }
            for (RfFieldLayer fieldLayer : fieldLayers) {
                structLayer = fieldLayer.getStructLayer();
                if (structLayer == null || !filteredLayers.contains(structLayer.getName())) continue;
                result.add(fieldLayer);
            }
            return result;
        }
        if (kind == 2) {
            if (enclosingStruct == null) {
                return result;
            }
            RfField field = enclosingStruct.getField(name);
            if (field != null && "any_method_port".equals(field.getAssociatedTypeName())) {
                result.addAll(this.getLayersData(name, 4, enclosingStruct, project, packageName));
            }
            if (result.isEmpty()) {
                enclosingStruct.collectAllMemberLayers(result, shortName, 2);
            }
            return result;
        }
        if (kind == 16) {
            if (project == null) {
                return result;
            }
            RfMacro namedElement = project.getMacro(shortName);
            if (namedElement != null) {
                result.addAll(namedElement.getLayers());
            } else {
                namedElement = project.getPreproc(shortName);
                if (namedElement != null) {
                    result.addAll(namedElement.getLayers());
                }
            }
            return result;
        }
        if (kind == 512) {
            RfType namedElement = project.getType(packageName, false, 4, shortName, -1);
            if (namedElement == null) {
                return result;
            }
            result.addAll(namedElement.getLayers());
        } else if (kind == 1) {
            RfType namedElement = project.getType(packageName, false, 1, shortName, -1);
            if (namedElement == null) {
                return result;
            }
            result.addAll(namedElement.getLayers());
        } else if (kind == 32) {
            RfType namedElement = project.getType(packageName, false, 2, shortName, -1);
            if (namedElement == null) {
                return result;
            }
            result.addAll(namedElement.getLayers());
        } else {
            if (kind == 1024) {
                if (enclosingStruct == null) {
                    return result;
                }
                ArrayList<RfDefElement> expects = new ArrayList<RfDefElement>();
                enclosingStruct.collectAllMemberLayers(expects, shortName, 6);
                if (!expects.isEmpty()) {
                    result.addAll(expects);
                }
                return result;
            }
            if (kind == 2048) {
                if (enclosingStruct == null) {
                    return result;
                }
                ArrayList<RfDefElement> expects = new ArrayList<RfDefElement>();
                enclosingStruct.collectAllMemberLayers(expects, shortName, 7);
                if (!expects.isEmpty()) {
                    result.addAll(expects);
                }
                return result;
            }
        }
        return result;
    }

    default public String getPackageName(RfNamedElement namedElement) {
        String packageName = "";
        if (namedElement instanceof RfType) {
            packageName = ((RfType)namedElement).getPackageName();
        } else if (namedElement instanceof RfStructMember) {
            packageName = ((RfStructMember)namedElement).getPackageName();
        } else if (namedElement instanceof RfMacro) {
            packageName = "main";
        }
        return packageName;
    }

    default public String getCurrentDataInfo(IRfNamedElement element, FullName structName) {
        String info = "";
        if (element == null) {
            return info;
        }
        if (element.getSignature() != null) {
            info = element.getSignature();
        }
        info = info.replace("\n", "");
        if (element instanceof RfPredefinedStruct || element instanceof RfPredefinedEvent || element instanceof RfPredefinedField || element instanceof RfPredefinedMethod) {
            info = "[PREDEFINED] " + info;
        }
        if (element instanceof RfStructMember) {
            RfStruct rootStruct = ((RfStructMember)element).getParentStruct();
            if (structName != null) {
                info = info.replace(" " + rootStruct.getName() + ".", " " + structName.getName() + ".");
            }
        }
        return info;
    }

    default public String getCurrentDataInfo(RfDefElement element, FullName structName) {
        if (element == null || element.getNamedElement() == null) {
            return "";
        }
        return this.getCurrentDataInfo(element.getNamedElement(), structName);
    }

    default public RfStruct getMethodDeclarationStruct(String name, RfStruct enclosingStruct) {
        RfStruct struct = enclosingStruct;
        RfStruct firstStructDefiningMethod = enclosingStruct;
        while (struct != null) {
            if (struct.hasLocalMember(name, null, 1)) {
                firstStructDefiningMethod = struct;
            }
            struct = struct.getParentStruct();
        }
        return firstStructDefiningMethod;
    }

    default public Set<String> getLikeAncestorNames(RfStruct struct) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        if (struct == null) {
            return result;
        }
        RfStruct current = struct;
        do {
            result.add(current.getName());
        } while ((current = current.getParentStruct()) != null);
        return result;
    }

    default public Set<String> getLikeDescendantNames(RfStruct struct) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        LinkedList<RfStruct> pending = new LinkedList<RfStruct>();
        pending.add(struct);
        while (!pending.isEmpty()) {
            RfStruct crt = (RfStruct)pending.remove();
            result.add(crt.getName());
            List<RfStruct> children = crt.getChildStructs();
            if (children == null) continue;
            pending.addAll(children);
        }
        return result;
    }

    default public Set<RfStruct> getDescendants(RfStruct struct) {
        LinkedHashSet<RfStruct> allChildren = new LinkedHashSet<RfStruct>();
        LinkedList<RfStruct> pending = new LinkedList<RfStruct>();
        pending.add(struct);
        while (!pending.isEmpty()) {
            RfStruct crt = (RfStruct)pending.remove();
            if (allChildren.contains(crt)) continue;
            allChildren.add(crt);
            List<RfStruct> newStructs = crt.getChildStructs();
            if (newStructs == null) continue;
            pending.addAll(newStructs);
        }
        return allChildren;
    }

    /*
     * Unable to fully structure code
     */
    default public RfStruct getEnclosingStruct(IRfScope scope) {
        if (scope == null) {
            return null;
        }
        if (!(scope instanceof RfStruct)) ** GOTO lbl6
        return (RfStruct)scope;
lbl-1000:
        // 1 sources

        {
            scope = ((RfActionBlockLayer)scope).getEnclosingScope();
lbl6:
            // 2 sources

            ** while (scope instanceof RfActionBlockLayer)
        }
lbl7:
        // 1 sources

        if (scope instanceof RfConstraintLayer) {
            return ((RfConstraintLayer)scope).getStructLayer().getStruct();
        }
        if (scope instanceof RfStructLayer) {
            return ((RfStructLayer)scope).getStruct();
        }
        if (scope instanceof RfCoverLayer) {
            return this.getEnclosingStruct(((RfCoverLayer)scope).getEnclosingScope());
        }
        return null;
    }

    default public Comparator<IDVTElementWrapper> getSortByTypeComparator(LabelProvider labelProvider) {
        return (e1, e2) -> {
            int cat2;
            Object obj1 = e1.getRfElement();
            Object obj2 = e2.getRfElement();
            String treeName1 = ((AbstractRfTreeElementWrapper)((Object)e1)).getTreeName();
            String treeName2 = ((AbstractRfTreeElementWrapper)((Object)e2)).getTreeName();
            if (obj1 instanceof String && obj2 instanceof String) {
                return ((String)obj1).compareTo((String)obj2);
            }
            if (!(obj1 instanceof RfNamedElement) && !(obj2 instanceof RfNamedElement)) {
                return 0;
            }
            if (!(obj1 instanceof RfNamedElement)) {
                return -1;
            }
            if (!(obj2 instanceof RfNamedElement)) {
                return 1;
            }
            int cat1 = RfKind.of((IRfNamedElement)obj1).ordinal();
            if (cat1 != (cat2 = RfKind.of((IRfNamedElement)obj2).ordinal())) {
                return cat2 - cat1;
            }
            if (treeName1 != null && !treeName1.isEmpty() && treeName2 != null && !treeName2.isEmpty()) {
                return treeName1.compareTo(treeName2);
            }
            return labelProvider.getText(e1).compareTo(labelProvider.getText(e2));
        };
    }

    default public Comparator<IDVTElementWrapper> getSortByNameComparator(LabelProvider labelProvider) {
        return (o1, o2) -> {
            Object obj1 = o1.getRfElement();
            Object obj2 = o2.getRfElement();
            String treeName1 = ((AbstractRfTreeElementWrapper)((Object)o1)).getTreeName();
            String treeName2 = ((AbstractRfTreeElementWrapper)((Object)o2)).getTreeName();
            if (treeName1 != null && !treeName1.isEmpty() && treeName2 != null && !treeName2.isEmpty()) {
                return treeName1.compareTo(treeName2);
            }
            if (obj1 instanceof RfNamedElement && obj2 instanceof RfNamedElement) {
                return ((RfNamedElement)obj1).getName().compareTo(((RfNamedElement)obj2).getName());
            }
            if (obj1 instanceof String && obj2 instanceof String) {
                return ((String)obj1).compareTo((String)obj2);
            }
            return 0;
        };
    }

    default public RfNamedElement getAssociatedType(RfNamedElement namedElement) {
        if (!(namedElement instanceof IRfAssociatedType)) {
            return null;
        }
        if ((namedElement = (RfNamedElement)((IRfAssociatedType)((Object)namedElement)).getAssociatedType()) instanceof RfListType) {
            namedElement = ((RfListType)namedElement).getAssociatedType();
        }
        return namedElement;
    }

    default public int getType(RfNamedElement source) {
        if (source instanceof RfStruct) {
            return 1;
        }
        if (source instanceof RfField) {
            return 2;
        }
        if (source instanceof RfMethod && ((RfMethod)source).isByEvent()) {
            return 8;
        }
        if (source instanceof RfMethod) {
            return 4;
        }
        if (source instanceof RfEvent) {
            return 8;
        }
        if (source instanceof RfMacro) {
            return 16;
        }
        if (source instanceof RfExpect) {
            return 1024;
        }
        if (source instanceof RfConstraint) {
            return 2048;
        }
        if (source instanceof RfScalarType) {
            return 32;
        }
        return 0;
    }

    default public UpdateViewEvent createViewUpdateEvent(IEPluginConfig pluginConfig, IRfNamedElement element, IProject project, IRfScope scope, boolean isTriggeredFromAction, int updateHistory) {
        return this.createViewUpdateEvent(pluginConfig, "", element, project, scope, isTriggeredFromAction, updateHistory);
    }

    default public UpdateViewEvent createViewUpdateEvent(IEPluginConfig pluginConfig, String text, IRfNamedElement element, IProject project, IRfScope scope, boolean isTriggeredFromAction, int updateHistory) {
        block18: {
            try {
                if (element != null) break block18;
                return null;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return null;
            }
        }
        FullName structFullName = null;
        String packageName = "";
        String projectName = "";
        FullName elementFullName = null;
        boolean elementHasAssociatedType = false;
        int elementType = 0;
        RfStruct struct = element instanceof RfStruct ? (RfStruct)element : RfUtils.getEnclosingStruct(scope);
        if (struct != null) {
            structFullName = new FullName(struct.getName(), struct.getDeterminant());
            packageName = struct.getPackageName();
        }
        if (project != null) {
            projectName = project.getName();
        }
        if (element instanceof RfMethod && ((RfMethod)element).isByEvent() && element.getName().startsWith("on_")) {
            elementFullName = new FullName(element.getName().substring(3), null);
            elementHasAssociatedType = false;
        } else if (element instanceof RfStructMember) {
            elementFullName = ((RfStructMember)element).getFullName();
            RfNamedElement associatedType = this.getAssociatedType((RfNamedElement)element);
            elementHasAssociatedType = associatedType != null && !"bool".equals(associatedType.getName()) && !(associatedType instanceof RfPredefinedScalar);
        } else if (struct != null) {
            elementFullName = new FullName(element.getName(), struct.getDeterminant());
            elementHasAssociatedType = false;
        } else {
            elementFullName = new FullName(element.getName(), null);
            elementHasAssociatedType = false;
        }
        elementType = this.getType((RfNamedElement)element);
        if (element instanceof RfType) {
            packageName = ((RfType)element).getPackageName();
        } else if (element instanceof RfStructMember) {
            packageName = ((RfStructMember)element).getPackageName();
        } else if (element instanceof RfMacro) {
            packageName = "main";
        }
        if (structFullName == null) {
            structFullName = elementFullName;
        }
        if (text == null || text.isEmpty()) {
            text = this.getCurrentDataInfo(element, structFullName);
        }
        return new UpdateViewEvent(text, projectName, elementType, packageName, (Object)structFullName, (Object)elementFullName, elementHasAssociatedType, isTriggeredFromAction, pluginConfig.getLanguageKind(), updateHistory, (Object)element);
    }

    default public UpdateViewEvent createViewUpdateEvent(IEPluginConfig pluginConfig, String text, RfStructLayer element, IProject project, IRfScope scope, boolean isTriggeredFromAction, int updateHistory) {
        try {
            FullName structFullName = null;
            String packageName = "";
            String projectName = "";
            FullName elementFullName = null;
            boolean elementHasAssociatedType = false;
            int elementType = 0;
            RfStruct struct = RfUtils.getEnclosingStruct(scope);
            if (struct != null) {
                structFullName = new FullName(struct.getName(), struct.getDeterminant());
                packageName = struct.getPackageName();
            }
            if (project != null) {
                projectName = project.getName();
            }
            if (element != null) {
                elementFullName = new FullName(element.getName(), element.getDeterminant());
                elementType = 1;
                packageName = element.getPackageName();
            }
            return new UpdateViewEvent(text, projectName, elementType, packageName, (Object)structFullName, (Object)elementFullName, elementHasAssociatedType, isTriggeredFromAction, pluginConfig.getLanguageKind(), updateHistory);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public static IRfNamedElement getEnclosingMethodOrStruct(IRfScope initialScope, boolean ignoreMethods) {
        if (initialScope == null) {
            return null;
        }
        IRfScope scope = initialScope;
        do {
            if (!ignoreMethods && scope instanceof RfMethod) {
                return (RfMethod)scope;
            }
            if (scope instanceof RfStruct) {
                return (RfStruct)scope;
            }
            if (!ignoreMethods && scope instanceof RfMethodLayer) {
                return ((RfMethodLayer)scope).getMethod();
            }
            if (!(scope instanceof RfStructLayer)) continue;
            return ((RfStructLayer)scope).getStruct();
        } while ((scope = scope.getEnclosingScope()) != null);
        return null;
    }
}

