/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection.views;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigProperty;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.edt.base.model.reflection.Determinant;
import ro.amiq.edt.base.model.reflection.FullName;
import ro.amiq.edt.base.model.reflection.RfEnum;
import ro.amiq.edt.base.model.reflection.RfField;
import ro.amiq.edt.base.model.reflection.RfListType;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructMember;
import ro.amiq.edt.base.model.reflection.views.VHHistoryItem;

public enum EVHTopUnitContributor {
    INSTANCE;


    public List<HistoryItem> getTops(RfProject project, boolean inSLNMode, LanguageKind languageKind) {
        ArrayList<HistoryItem> results = new ArrayList<HistoryItem>();
        ArrayList<RfStructDeterminat> values = new ArrayList<RfStructDeterminat>();
        Collection<RfStructDeterminat> temp = this.getTopUnits(project, inSLNMode);
        if (temp != null) {
            values.addAll(temp);
        }
        for (RfStructDeterminat structDeterminant : values) {
            FullName structName = new FullName(structDeterminant.struct.getName(), structDeterminant.determinant);
            VHHistoryItem item = VHHistoryItem.parseHistoryItem(project.getName(), structDeterminant.struct.getPackageName(), structName, languageKind);
            if (item == null) continue;
            results.add(item);
        }
        return results;
    }

    public Map<String, RfStruct> getTops(RfProject project, boolean inSLNMode) {
        LinkedHashMap<String, RfStruct> results = new LinkedHashMap<String, RfStruct>();
        ArrayList<RfStructDeterminat> values = new ArrayList<RfStructDeterminat>();
        Collection<RfStructDeterminat> temp = this.getTopUnits(project, inSLNMode);
        if (temp != null) {
            values.addAll(temp);
        }
        for (RfStructDeterminat structDeterminant : values) {
            if (structDeterminant.struct.getName().equals("sys") || structDeterminant.struct.getName().equals("DVE")) continue;
            results.put(String.valueOf(structDeterminant.struct.getPackageName()) + DVTStringUtil.COLON_COLON.toString() + structDeterminant.determinant.toString(), structDeterminant.struct);
        }
        return results;
    }

    public List<RfStruct> getAllTops(RfProject project) {
        ArrayList<RfStructDeterminat> values = new ArrayList<RfStructDeterminat>();
        Collection<RfStructDeterminat> temp = this.getTopUnits(project, false);
        if (temp != null) {
            values.addAll(temp);
        }
        return values.stream().map(determinant -> determinant.struct).toList();
    }

    private boolean fieldAlreadyChecked(RfField field, List<RfField> fields) {
        for (RfField checkedField : fields) {
            if (!field.equals(checkedField)) continue;
            return true;
        }
        return false;
    }

    private boolean findDeterminant(RfStruct rfStruct, Determinant determinant) {
        if (rfStruct == null) {
            return false;
        }
        if (determinant.equals(rfStruct.getDeterminant())) {
            return true;
        }
        List<Determinant> subTypeDeterminants = rfStruct.getSubTypeDeterminants(determinant);
        if (subTypeDeterminants != null && !subTypeDeterminants.isEmpty()) {
            return true;
        }
        String[] subTypes = determinant.toArray();
        LinkedList<RfField> checkedFields = new LinkedList<RfField>();
        List<RfStructMember> fields = rfStruct.getFields();
        RfStruct parentStruct = rfStruct.getParentStruct();
        while (parentStruct != null) {
            fields.addAll(parentStruct.getFields());
            parentStruct = parentStruct.getParentStruct();
        }
        int i = 0;
        while (i < subTypes.length - 1) {
            String fieldName = "";
            String[] subType = DVTStringUtil.split((Pattern)DVTStringUtil.APOSTROPHE, (String)subTypes[i]);
            boolean found = false;
            if (subType.length > 1) {
                fieldName = subType[1];
            }
            if ((subType[0].equals("TRUE") || subType[0].equals("FALSE")) && fieldName.isEmpty()) {
                return false;
            }
            block2: for (RfStructMember rfStructMember : fields) {
                List<RfEnum> associatedTypeEnums;
                RfField field;
                if (!fieldName.isEmpty() && !rfStructMember.getName().equals(fieldName) || !(rfStructMember instanceof RfField) || this.fieldAlreadyChecked(field = (RfField)rfStructMember, checkedFields) || (associatedTypeEnums = field.getAssociatedTypeEnums()) == null || associatedTypeEnums.isEmpty()) continue;
                for (RfEnum associatedType : associatedTypeEnums) {
                    if (!associatedType.getName().equals(subType[0])) continue;
                    found = true;
                    checkedFields.add(field);
                    continue block2;
                }
            }
            if (!found) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean alreadyInList(List<RfStructDeterminat> structs, RfStruct struct, Determinant determinant) {
        for (RfStructDeterminat rfStructDeterminat : structs) {
            if (!rfStructDeterminat.struct.equals(struct) || !rfStructDeterminat.determinant.equals(determinant)) continue;
            return true;
        }
        return false;
    }

    private List<RfStructDeterminat> resolveVerificationConfiguration(boolean inSLNMode, RfProject rfProject) {
        LinkedList<RfStructDeterminat> result = new LinkedList<RfStructDeterminat>();
        List verificationTopConfigurationProperties = BuildConfigManager.getVerificationTopConfigurationProperties((IProject)rfProject.getProject());
        if (verificationTopConfigurationProperties == null || verificationTopConfigurationProperties.isEmpty()) {
            return result;
        }
        List<RfStruct> allStructs = rfProject.getAllStructs();
        for (RfStruct struct : allStructs) {
            if (!inSLNMode && struct.getName().equals("sys")) {
                result.add(new RfStructDeterminat(struct, struct.getDeterminant()));
                continue;
            }
            if (inSLNMode && struct.getName().equals("DVE")) {
                result.add(new RfStructDeterminat(struct, struct.getDeterminant()));
                continue;
            }
            for (BuildConfigProperty property : verificationTopConfigurationProperties) {
                String structName = property.getValue();
                String packageName = "";
                String[] qualifiedName = DVTStringUtil.split((Pattern)DVTStringUtil.COLON_COLON, (String)structName);
                if (qualifiedName.length > 1) {
                    packageName = qualifiedName[0];
                    structName = qualifiedName[1];
                }
                if (!packageName.equals("") && !struct.getPackageName().equals(packageName)) continue;
                String[] structIdentifier = DVTStringUtil.split((Pattern)DVTStringUtil.MULTIPLE_WS, (String)structName);
                Determinant determinant = new Determinant(structIdentifier);
                if (structIdentifier.length > 1) {
                    structName = structIdentifier[structIdentifier.length - 1];
                }
                if (!struct.getName().equals(structName) || !this.findDeterminant(struct, determinant) || this.alreadyInList(result, struct, determinant)) continue;
                result.add(new RfStructDeterminat(struct, determinant));
            }
        }
        return result;
    }

    private Collection<RfStructDeterminat> getTopUnits(RfProject rfProject, boolean inSLNMode) {
        Collection<RfStruct> allStructs;
        HashMap<String, RfStructDeterminat> result = new HashMap<String, RfStructDeterminat>();
        if (rfProject == null) {
            return result.values();
        }
        List<RfStructDeterminat> structs = this.resolveVerificationConfiguration(inSLNMode, rfProject);
        if (!structs.isEmpty()) {
            return structs;
        }
        Collection<RfStruct> collection = allStructs = inSLNMode ? rfProject.getAllPackages() : rfProject.getAllStructs();
        if (allStructs == null) {
            return result.values();
        }
        HashSet<String> nonTopUnitNames = new HashSet<String>();
        for (RfStruct struct : allStructs) {
            String name = String.valueOf(struct.getPackageName()) + DVTStringUtil.COLON_COLON + struct.getName();
            if (!inSLNMode && struct.getName().equals("sys")) {
                result.put(struct.getName(), new RfStructDeterminat(struct, struct.getDeterminant()));
                continue;
            }
            if (inSLNMode && struct.getName().equals("DVE")) {
                result.put(struct.getName(), new RfStructDeterminat(struct, struct.getDeterminant()));
                continue;
            }
            if (struct.isPredefined() || !struct.isUnit() || nonTopUnitNames.contains(name)) continue;
            List<RfStructMember> fields = struct.getFields();
            for (RfStructMember field : fields) {
                if (!((RfField)field).isInstance() || !(field.getAssociatedType() instanceof RfStruct) || field.getAssociatedType() instanceof RfListType && !(((RfListType)field.getAssociatedType()).getAssociatedType() instanceof RfStruct)) continue;
                result.put(name, new RfStructDeterminat(struct, field.getFullName().getDeterminant()));
                if (field.getAssociatedType() instanceof RfListType) {
                    nonTopUnitNames.add(String.valueOf(((RfListType)field.getAssociatedType()).getAssociatedType().getPackageName()) + DVTStringUtil.COLON_COLON + ((RfListType)field.getAssociatedType()).getAssociatedType().getName());
                    continue;
                }
                nonTopUnitNames.add(String.valueOf(field.getAssociatedType().getPackageName()) + DVTStringUtil.COLON_COLON + field.getAssociatedType().getName());
            }
        }
        for (String nonTopUnitName : nonTopUnitNames) {
            result.remove(nonTopUnitName);
        }
        ArrayList<RfStructDeterminat> topUnits = new ArrayList<RfStructDeterminat>(result.values());
        Collections.sort(topUnits, (o1, o2) -> o1.struct.getName().compareTo(o2.struct.getName()));
        return topUnits;
    }

    static class RfStructDeterminat {
        private Determinant determinant;
        private RfStruct struct;

        public RfStructDeterminat(RfStruct struct, Determinant determinant) {
            this.struct = struct;
            this.determinant = determinant;
        }
    }
}

