/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection.views;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.progress.UIJob;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.decorators.util.ILazyOverlayElement;

public class LazyOverlayRefreshListener
implements Listener {
    private int MAX_NUMBER_OF_ELEMENTS = 30;
    private Tree fTree;
    private TreeItem[] fRefreshList = new TreeItem[this.MAX_NUMBER_OF_ELEMENTS];
    private int fRefreshPointer = 0;
    private UIJob fRefreshJob = null;
    private ILabelProvider fLabelProvider;

    public LazyOverlayRefreshListener(Tree tree, ILabelProvider labelProvider, String name) {
        this.fTree = tree;
        this.fLabelProvider = labelProvider;
        this.fRefreshJob = new RefreshJob(name);
    }

    public void handleEvent(Event event) {
        try {
            if (event.item == null || event.item.isDisposed()) {
                return;
            }
            ILazyOverlayElement element = (ILazyOverlayElement)((TreeItem)event.item).getData();
            if (element == null) {
                return;
            }
            if (!element.getOverlayStatus()) {
                this.fRefreshList[this.fRefreshPointer] = (TreeItem)event.item;
                this.fRefreshPointer = (this.fRefreshPointer + 1) % this.MAX_NUMBER_OF_ELEMENTS;
                this.fRefreshJob.cancel();
                this.fRefreshJob.schedule(150L);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private class RefreshJob
    extends UIJob {
        public RefreshJob(String name) {
            super(name);
            this.setSystem(true);
            this.setPriority(50);
        }

        public boolean shouldSchedule() {
            return super.shouldSchedule() && LazyOverlayRefreshListener.this.fTree != null && !LazyOverlayRefreshListener.this.fTree.isDisposed();
        }

        public boolean shouldRun() {
            return super.shouldRun() && LazyOverlayRefreshListener.this.fTree != null && !LazyOverlayRefreshListener.this.fTree.isDisposed();
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (LazyOverlayRefreshListener.this.fTree == null || LazyOverlayRefreshListener.this.fTree.isDisposed()) {
                return Status.CANCEL_STATUS;
            }
            LazyOverlayRefreshListener.this.fTree.setRedraw(false);
            int i = 0;
            while (i < LazyOverlayRefreshListener.this.MAX_NUMBER_OF_ELEMENTS) {
                ILazyOverlayElement element;
                TreeItem item = LazyOverlayRefreshListener.this.fRefreshList[i];
                if (item != null && !item.isDisposed() && (element = (ILazyOverlayElement)item.getData()) != null && !element.getOverlayStatus()) {
                    element.setOverlayStatus(true);
                    item.setImage(LazyOverlayRefreshListener.this.fLabelProvider.getImage((Object)element));
                    LazyOverlayRefreshListener.this.fRefreshList[i] = null;
                }
                ++i;
            }
            LazyOverlayRefreshListener.this.fTree.setRedraw(true);
            return Status.OK_STATUS;
        }
    }
}

