/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection.views;

import java.util.LinkedHashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.core.IPluginConfig;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.views.DVTTreeElementWrapper;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.utils.DVTDocumentCommon;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.reflection.RfMacro;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.views.AbstractRfTreeElementWrapper;
import ro.amiq.edt.base.model.reflection.views.ELabelProvider;
import ro.amiq.edt.base.model.reflection.views.ELanguageElement;

public class MacroViewLabelProvider
extends ELabelProvider {
    private static final int MAX_CHARS_IN_MACRO_EXPANSION = 100;
    private final boolean fIsInSLNMode;

    public MacroViewLabelProvider(IEPluginConfig pluginConfig) {
        super(pluginConfig);
        this.fIsInSLNMode = DVTUtilsCommon.INSTANCE.isInSlnLikeMode((IPluginConfig)pluginConfig);
    }

    public Image getImage(Object wrapper) {
        return this.getColumnImage(wrapper, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    public Image getColumnImage(Object wrapper, int columnIndex) {
        Image result = null;
        Object element = null;
        boolean overlayStatus = false;
        if (!(wrapper instanceof AbstractRfTreeElementWrapper)) {
            if (!(wrapper instanceof RfMacro)) {
                if (!(wrapper instanceof ELanguageElement)) return DVTImages.imageCache.getImage(DVTImages.TRANSPARENT);
                if (columnIndex != 0) return DVTImages.imageCache.getImage(DVTImages.TRANSPARENT);
                return DVTImages.imageCache.getImage(DVTImages.E_LANGUAGE);
            }
            element = wrapper;
        } else {
            IDVTElementWrapper rfWrapper = (IDVTElementWrapper)wrapper;
            element = rfWrapper.getRfElement();
            overlayStatus = rfWrapper.getOverlayStatus();
        }
        if (columnIndex == 0) {
            if (element instanceof AbstractRfTreeElementWrapper) {
                return DVTImages.imageCache.getImage(DVTImages.TRANSPARENT);
            }
            if (element instanceof String) {
                return DVTImages.imageCache.getImage(DVTImages.TRANSPARENT);
            }
            if (element instanceof ELanguageElement) {
                ImageDescriptor imageDescriptor;
                if (this.fIsInSLNMode) {
                    imageDescriptor = DVTImages.SLN_LANGUAGE;
                    return DVTImages.imageCache.getImage(imageDescriptor);
                }
                imageDescriptor = DVTImages.E_LANGUAGE;
                return DVTImages.imageCache.getImage(imageDescriptor);
            }
            if (!(element instanceof RfNamedElement)) {
                ImageDescriptor imageDescriptor;
                if (this.fIsInSLNMode) {
                    imageDescriptor = DVTImages.SLN_LANGUAGE;
                    return DVTImages.imageCache.getImage(imageDescriptor);
                }
                imageDescriptor = DVTImages.E_LANGUAGE;
                return DVTImages.imageCache.getImage(imageDescriptor);
            }
            RfNamedElement namedElement = (RfNamedElement)element;
            if (namedElement instanceof RfMacro) {
                RfMacro macro = (RfMacro)namedElement;
                if (macro.isPreprocessing()) {
                    result = DVTImages.imageCache.getImage(DVTImages.PREPROC_DEFINE);
                } else if (macro.getMacroType() != null) {
                    result = macro.isAsComputed() ? DVTImages.imageCache.getImage(DVTImages.DEFINE_AS_COMPUTED) : DVTImages.imageCache.getImage(DVTImages.DEFINE_AS);
                }
            }
            if (!overlayStatus) {
                if (result == null) return DVTImages.imageCache.getImage(DVTImages.TRANSPARENT);
                return result;
            }
            if (result != null && this.fDecorator != null) {
                return this.fDecorator.decorateImage(result, wrapper);
            }
        } else if (columnIndex == 2) {
            if (!(element instanceof RfMacro)) {
                return DVTImages.imageCache.getImage(DVTImages.TRANSPARENT);
            }
            RfMacro macro = (RfMacro)element;
            IResource file = macro.getFileAdapter();
            if (file == null) {
                result = DVTImages.imageCache.getImage(this.fIsInSLNMode ? DVTImages.DESC_SLN_MODULE_GRAY : DVTImages.DESC_E_MODULE_GRAY);
            } else {
                result = DVTImages.imageCache.getImage(this.fIsInSLNMode ? DVTImages.DESC_SLN_MODULE : DVTImages.DESC_E_MODULE);
                IContainer parent = file.getParent();
                while (parent != null && !(parent instanceof IProject)) {
                    if (parent.isLinked()) {
                        result = DVTImages.imageCache.getImage(this.fIsInSLNMode ? DVTImages.DESC_SLN_MODULE_LINKED : DVTImages.DESC_E_MODULE_LINKED);
                        break;
                    }
                    parent = parent.getParent();
                }
            }
            if (result != null && this.fDecorator != null) {
                return this.fDecorator.decorateImage(result, wrapper);
            }
        }
        if (result != null) return result;
        return DVTImages.imageCache.getImage(DVTImages.TRANSPARENT);
    }

    private String internalGetText(Object wrapper) {
        Object element = null;
        if (!(wrapper instanceof AbstractRfTreeElementWrapper)) {
            if (!(wrapper instanceof RfMacro)) {
                return "";
            }
            element = wrapper;
        } else {
            AbstractRfTreeElementWrapper rfWrapper = (AbstractRfTreeElementWrapper)((Object)wrapper);
            element = rfWrapper.getRfElement();
        }
        if (element instanceof String) {
            return (String)element;
        }
        if (element instanceof ELanguageElement) {
            return (String)((ELanguageElement)((Object)element)).getInfo();
        }
        RfNamedElement namedElement = (RfNamedElement)element;
        String result = "";
        if (namedElement instanceof RfMacro) {
            RfMacro macro = (RfMacro)namedElement;
            if ("__etools__table'__etools__expansion".equals(macro.getName())) {
                result = macro.getStringLiteral();
                result = result.substring(0, Math.min(50, result.length())).replace('\r', ' ').replace('\n', ' ');
            } else {
                result = macro.getStringLiteral() != null ? "<" + macro.getName() + "> : " + macro.getStringLiteral() : macro.getName();
            }
        }
        return result;
    }

    public String getColumnText(Object wrapper, int columnIndex) {
        String result = "";
        Object element = null;
        if (!(wrapper instanceof AbstractRfTreeElementWrapper)) {
            if (!(wrapper instanceof RfMacro) && !(wrapper instanceof DVTTreeElementWrapper)) {
                if (columnIndex != 0) {
                    return result;
                }
                if (wrapper instanceof IRfNamedElement) {
                    result = ((IRfNamedElement)wrapper).getName();
                } else if (wrapper instanceof ELanguageElement) {
                    result = (String)((ELanguageElement)((Object)wrapper)).getInfo();
                }
                return result;
            }
            if (wrapper instanceof RfMacro) {
                element = wrapper;
            } else if (wrapper instanceof DVTTreeElementWrapper) {
                element = ((DVTTreeElementWrapper)wrapper).getRfElement();
            }
        } else {
            IDVTElementWrapper rfWrapper = (IDVTElementWrapper)wrapper;
            element = rfWrapper.getRfElement();
        }
        if (element instanceof ELanguageElement && columnIndex == 0) {
            return (String)((ELanguageElement)((Object)element)).getInfo();
        }
        if (element instanceof IRfNamedElement && !(element instanceof RfMacro) && columnIndex == 0) {
            return ((IRfNamedElement)element).getName();
        }
        String lineDelimiter = DVTDocumentCommon.getLineDelimiterByProject(null);
        block0 : switch (columnIndex) {
            case 0: {
                if (!(element instanceof RfMacro)) break;
                result = this.internalGetText(element);
                if (result == null) {
                    result = "";
                }
                if (!result.contains(lineDelimiter)) break;
                result = result.substring(0, result.indexOf(lineDelimiter));
                break;
            }
            case 1: {
                if (!(element instanceof RfMacro) || !((RfMacro)element).isPreprocessing()) break;
                LinkedHashSet<String> macroReplacements = ((RfMacro)element).getPreprocessingReplacements();
                for (String uniMacro : macroReplacements) {
                    if (uniMacro == null || uniMacro.isEmpty()) continue;
                    result = uniMacro.substring(0, Math.min(100, uniMacro.length()));
                    if (result.contains(lineDelimiter)) {
                        result = result.substring(0, result.indexOf(lineDelimiter));
                    }
                    if (macroReplacements.size() <= 1) break block0;
                    result = DVTStringUtil.appendString((Object[])new Object[]{result, "..."});
                    break block0;
                }
                break;
            }
            case 2: {
                RfMacro macro;
                if (!(element instanceof RfMacro) || (macro = (RfMacro)element).getModule() == null) break;
                result = macro.getModule().getName();
                break;
            }
            case 3: {
                if (!(element instanceof RfMacro)) break;
                result = Integer.toString(((RfMacro)element).getLine());
                break;
            }
        }
        return result;
    }

    public String getText(Object wrapper) {
        return this.getColumnText(wrapper, 0);
    }
}

