/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection.views;

import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.core.IPluginConfig;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.views.IOutlineTreeViewProvider;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.edt.base.model.reflection.RfConstraintLayer;
import ro.amiq.edt.base.model.reflection.RfCoverLayer;
import ro.amiq.edt.base.model.reflection.RfDummyElement;
import ro.amiq.edt.base.model.reflection.RfEventLayer;
import ro.amiq.edt.base.model.reflection.RfExpectLayer;
import ro.amiq.edt.base.model.reflection.RfField;
import ro.amiq.edt.base.model.reflection.RfFieldLayer;
import ro.amiq.edt.base.model.reflection.RfFieldPropConstraint;
import ro.amiq.edt.base.model.reflection.RfFieldTypeConstraint;
import ro.amiq.edt.base.model.reflection.RfMacro;
import ro.amiq.edt.base.model.reflection.RfMacroLayer;
import ro.amiq.edt.base.model.reflection.RfMethodLayer;
import ro.amiq.edt.base.model.reflection.RfMethodTypeLayer;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfOnEventLayer;
import ro.amiq.edt.base.model.reflection.RfSLNTokenField;
import ro.amiq.edt.base.model.reflection.RfScalarTypeLayer;
import ro.amiq.edt.base.model.reflection.RfSpecman;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructLayer;
import ro.amiq.edt.base.model.reflection.views.ELabelProvider;
import ro.amiq.etools.eparser.EAST;

public class OutlineTreeViewProvider
extends ELabelProvider
implements ITreeContentProvider,
IStructuredContentProvider,
IOutlineTreeViewProvider {
    public static final int MAX_LABEL_TEXT_LEN = TestHelper.isTestMode() ? 30 : 100;

    public OutlineTreeViewProvider(IPluginConfig pluginConfig) {
        super(pluginConfig);
    }

    public Object[] getElements(Object wrapper) {
        List elements;
        if (wrapper == null) {
            return new Object[0];
        }
        if (wrapper instanceof IDVTElementWrapper && (elements = ((IDVTElementWrapper)wrapper).getChildren()) != null) {
            return elements.toArray();
        }
        return new Object[0];
    }

    public Object[] getChildren(Object wrapper) {
        List elements;
        if (wrapper == null) {
            return null;
        }
        if (wrapper instanceof IDVTElementWrapper && (elements = ((IDVTElementWrapper)wrapper).getChildren()) != null) {
            return elements.toArray();
        }
        return null;
    }

    public Object getParent(Object wrapper) {
        return null;
    }

    public boolean hasChildren(Object wrapper) {
        if (wrapper == null) {
            return false;
        }
        return ((IDVTElementWrapper)wrapper).getChildren() != null;
    }

    public Image getImage(Object wrapper) {
        Object element = null;
        element = wrapper instanceof IDVTElementWrapper ? ((IDVTElementWrapper)wrapper).getRfElement() : ((TreePath)wrapper).getElement();
        if (element instanceof IDVTElementWrapper || element instanceof EAST) {
            return this.getASTImage(wrapper);
        }
        if (element instanceof RfDummyElement) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        if (element instanceof String) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        if (!(element instanceof IRfDefElement)) {
            return null;
        }
        IRfDefElement defElement = (IRfDefElement)element;
        Image result = null;
        if (defElement instanceof RfMethodTypeLayer) {
            result = DVTImages.imageCache.getImage(DVTImages.METHOD_TYPE);
        } else if (defElement instanceof RfStructLayer) {
            RfStructLayer layer = (RfStructLayer)defElement;
            RfStruct struct = layer.getStruct();
            if (struct != null && struct.isSDLAgent()) {
                result = DVTImages.imageCache.getImage(DVTImages.OUTLINE_SDL_AGENT);
            } else if (struct != null && struct.isSDLScenario()) {
                result = DVTImages.imageCache.getImage(DVTImages.OUTLINE_SDL_SCENARIO);
            } else if (struct != null && struct.isSDLRole()) {
                result = DVTImages.imageCache.getImage(DVTImages.OUTLINE_SDL_ROLE);
            } else if (struct != null && struct.isSLNToken()) {
                result = DVTImages.imageCache.getImage(DVTImages.OUTLINE_SLN_TOKEN);
            } else if (struct != null && struct.isSLNComponent()) {
                result = DVTImages.imageCache.getImage(DVTImages.OUTLINE_SLN_COMPONENT);
            } else if (struct != null && struct.isSLNAction()) {
                result = DVTImages.imageCache.getImage(DVTImages.OUTLINE_SLN_ACTION);
            } else if (layer.getStruct() != null && layer.getStruct().isLike("any_sequence")) {
                result = DVTImages.imageCache.getImage(DVTImages.OUTLINE_SEQUENCE);
            } else {
                boolean isUnit = layer.isUnit();
                boolean isExtend = layer.isExtend();
                boolean isLike = layer.isLike();
                boolean isWhen = layer.isWhen();
                result = isLike ? (isExtend && isUnit ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_UNIT_EXTEND) : (isExtend ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_STRUCT_EXTEND) : (isUnit ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_UNIT) : DVTImages.imageCache.getImage(DVTImages.OUTLINE_STRUCT)))) : (isWhen ? (isUnit ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_UNIT_WHEN) : DVTImages.imageCache.getImage(DVTImages.OUTLINE_STRUCT_WHEN)) : (isUnit ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_UNIT_EXTEND) : DVTImages.imageCache.getImage(DVTImages.OUTLINE_STRUCT_EXTEND)));
            }
        } else if (defElement instanceof RfMethodLayer) {
            result = DVTImages.imageCache.getImage(DVTImages.OUTLINE_METHOD);
        } else if (defElement instanceof RfFieldLayer) {
            RfFieldLayer layer = (RfFieldLayer)defElement;
            RfField field = layer.getField();
            String associatedTypeName = field.getAssociatedTypeName();
            int direction = layer.getField().getDirection();
            if (field instanceof RfFieldPropConstraint) {
                result = DVTImages.imageCache.getImage(DVTImages.OUTLINE_CONSTRAINT);
            } else if (field instanceof RfFieldTypeConstraint) {
                result = DVTImages.imageCache.getImage(DVTImages.OUTLINE_CONSTRAINT);
            } else if (field instanceof RfSLNTokenField) {
                if (direction == 1) {
                    result = DVTImages.imageCache.getImage(DVTImages.PORT_SIMPLE_IN);
                } else if (direction == 2) {
                    result = DVTImages.imageCache.getImage(DVTImages.PORT_SIMPLE_OUT);
                }
            } else {
                result = associatedTypeName == null ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_FIELD) : (associatedTypeName.equals("any_simple_port") ? (direction == 1 ? DVTImages.imageCache.getImage(DVTImages.PORT_SIMPLE_IN) : (direction == 2 ? DVTImages.imageCache.getImage(DVTImages.PORT_SIMPLE_OUT) : DVTImages.imageCache.getImage(DVTImages.PORT_SIMPLE_INOUT))) : (associatedTypeName.equals("any_event_port") ? (direction == 1 ? DVTImages.imageCache.getImage(DVTImages.PORT_EVENT_IN) : (direction == 2 ? DVTImages.imageCache.getImage(DVTImages.PORT_EVENT_OUT) : DVTImages.imageCache.getImage(DVTImages.PORT_EVENT_INOUT))) : (associatedTypeName.equals("any_buffer_port") ? (direction == 1 ? DVTImages.imageCache.getImage(DVTImages.PORT_BUFFER_IN) : DVTImages.imageCache.getImage(DVTImages.PORT_BUFFER_OUT)) : (associatedTypeName.equals("any_method_port") ? (direction == 1 ? DVTImages.imageCache.getImage(DVTImages.PORT_METHOD_IN) : DVTImages.imageCache.getImage(DVTImages.PORT_METHOD_OUT)) : (RfSpecman.isTLMPort(associatedTypeName) ? (direction == 1 ? DVTImages.imageCache.getImage(DVTImages.PORT_INTERFACE_IN) : DVTImages.imageCache.getImage(DVTImages.PORT_INTERFACE_OUT)) : (layer.isInstance() ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_UNIT_INSTANCE) : DVTImages.imageCache.getImage(DVTImages.OUTLINE_FIELD)))))));
            }
        } else if (defElement instanceof RfScalarTypeLayer) {
            RfScalarTypeLayer sLayer = (RfScalarTypeLayer)defElement;
            result = sLayer.isExtend() ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_TYPE_EXTEND) : DVTImages.imageCache.getImage(DVTImages.OUTLINE_TYPE);
        } else if (defElement instanceof RfOnEventLayer) {
            result = DVTImages.imageCache.getImage(DVTImages.OUTLINE_ON_EVENT);
        } else if (defElement instanceof RfCoverLayer) {
            result = DVTImages.imageCache.getImage(DVTImages.OUTLINE_COVER);
        } else if (defElement instanceof RfEventLayer) {
            result = DVTImages.imageCache.getImage(DVTImages.OUTLINE_EVENT);
        } else if (defElement instanceof RfExpectLayer) {
            result = DVTImages.imageCache.getImage(DVTImages.EXPECT);
        } else if (defElement instanceof RfConstraintLayer) {
            result = DVTImages.imageCache.getImage(DVTImages.OUTLINE_CONSTRAINT);
        } else if (defElement instanceof RfMacroLayer) {
            RfMacro macro = (RfMacro)defElement.getNamedElement();
            result = macro.isPreprocessing() ? (((RfMacroLayer)element).isConditional() ? (((RfMacroLayer)element).isUndef() ? DVTImages.imageCache.getImage(DVTImages.PREPROC_IFNDEF) : DVTImages.imageCache.getImage(DVTImages.PREPROC_IFDEF)) : (((RfMacroLayer)element).isUndef() ? DVTImages.imageCache.getImage(DVTImages.PREPROC_UNDEF) : DVTImages.imageCache.getImage(DVTImages.PREPROC_DEFINE))) : (((RfMacroLayer)defElement).isDeclaration() ? (((RfMacroLayer)defElement).getMacro().isAsComputed() ? DVTImages.imageCache.getImage(DVTImages.DEFINE_AS_COMPUTED) : DVTImages.imageCache.getImage(DVTImages.DEFINE_AS)) : (((RfMacroLayer)defElement).getMacro().isAsComputed() ? DVTImages.imageCache.getImage(DVTImages.DEFINE_INSTANCE_AS_COMPUTED) : DVTImages.imageCache.getImage(DVTImages.DEFINE_AS_INSTANCE)));
        }
        if (wrapper instanceof IDVTElementWrapper && !((IDVTElementWrapper)wrapper).getOverlayStatus()) {
            return result;
        }
        if (result != null && this.fDecorator != null) {
            return this.fDecorator.decorateImage(result, wrapper);
        }
        return DVTImages.imageCache.getImage(DVTImages.NONE);
    }

    public String getText(Object object) {
        return this.getText(object, true);
    }

    public String getText(Object object, boolean trim) {
        String result = this.internalGetText(object, trim);
        if (result == null) {
            return "";
        }
        return result;
    }

    private String internalGetText(Object wrapper, boolean trim) {
        RfMacro macro;
        String name;
        Object element = null;
        element = wrapper instanceof IDVTElementWrapper ? ((IDVTElementWrapper)wrapper).getRfElement() : ((TreePath)wrapper).getElement();
        if (element instanceof IDVTElementWrapper || element instanceof EAST) {
            return this.getASTText(wrapper);
        }
        if (element instanceof RfDummyElement) {
            return ((RfDummyElement)element).getName();
        }
        if (element instanceof String) {
            return (String)element;
        }
        if (!(element instanceof IRfDefElement)) {
            return null;
        }
        IRfDefElement defElement = (IRfDefElement)element;
        String result = null;
        result = defElement instanceof RfMacroLayer ? ("__etools__table'__etools__expansion".equals(name = (macro = ((RfMacroLayer)defElement).getMacro()).getName()) ? ((RfMacroLayer)defElement).getMacroInstanceStringLiteral() : (macro.getStringLiteral() != null ? macro.getStringLiteral().replace(" \r\n", " ").replace(" \r", " ").replace(" \n", " ") : macro.getName())) : (defElement instanceof RfStructLayer ? ((RfStructLayer)defElement).getInfo() : (defElement instanceof RfMethodLayer ? (((RfMethodLayer)defElement).getMethod().isTCM() ? DVTStringUtil.appendString((Object[])new Object[]{defElement.getName(), "()@"}) : DVTStringUtil.appendString((Object[])new Object[]{defElement.getName(), "()"})) : defElement.getName()));
        if (result != null) {
            if (trim && result.length() > MAX_LABEL_TEXT_LEN) {
                result = String.valueOf(result.substring(0, MAX_LABEL_TEXT_LEN)) + "...";
            }
            result = result.replace('\r', ' ');
            result = result.replace('\n', ' ');
            return result;
        }
        return "";
    }

    public Image getImageByFieldName(String fieldName) {
        try {
            ImageDescriptor descriptor = (ImageDescriptor)DVTImages.class.getDeclaredField(fieldName).get(null);
            return DVTImages.imageCache.getImage(descriptor);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    private String getASTText(Object o) {
        String[] tokenNames;
        String signature;
        IDVTElementWrapper wrapper = null;
        if (o instanceof IDVTElementWrapper) {
            wrapper = (IDVTElementWrapper)o;
        } else if (o instanceof TreePath) {
            wrapper = (IDVTElementWrapper)((TreePath)o).getElement();
        }
        if (wrapper == null) {
            return null;
        }
        EAST east = (EAST)wrapper.getRfElement();
        if (east == null) {
            return "null";
        }
        String result = east.getText();
        if (east.transientResult instanceof IRfNamedElement && (signature = ((RfNamedElement)east.transientResult).getSignature()) != null) {
            result = String.valueOf(result) + " : " + signature.replace("\\R", " ");
        }
        if ((tokenNames = EAST.getTokenNames()) == null) {
            return "[not initialized]";
        }
        result = String.valueOf(result) + " <" + tokenNames[east.getType()] + ">";
        return result;
    }

    private Image getASTImage(Object o) {
        IDVTElementWrapper wrapper = null;
        if (o instanceof IDVTElementWrapper) {
            wrapper = (IDVTElementWrapper)o;
        } else if (o instanceof TreePath) {
            wrapper = (IDVTElementWrapper)((TreePath)o).getElement();
        }
        if (wrapper == null) {
            return null;
        }
        if (wrapper.getChildren() != null) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        }
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
    }
}

