/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection.views;

import java.util.Comparator;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.edt.base.model.reflection.RfCoverLayer;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfEventLayer;
import ro.amiq.edt.base.model.reflection.RfFieldLayer;
import ro.amiq.edt.base.model.reflection.RfMethodLayer;
import ro.amiq.edt.base.model.reflection.RfOnEventLayer;
import ro.amiq.edt.base.model.reflection.RfScalarTypeLayer;
import ro.amiq.edt.base.model.reflection.RfStructLayer;
import ro.amiq.edt.base.model.reflection.views.AbstractRfTreeElementWrapper;
import ro.amiq.edt.base.ui.editor.outline.CategorySortingAction;
import ro.amiq.edt.base.ui.editor.outline.IUpdateElement;

public class QuickViewCategorySortingAction
extends CategorySortingAction {
    Comparator<IDVTElementWrapper> fComparator;
    private IUpdateElement fAtic;

    public QuickViewCategorySortingAction(AbstractUIPlugin plugin, IUpdateElement atic) {
        super(plugin);
        this.fAtic = atic;
        boolean disabled = plugin.getPreferenceStore().getBoolean("outline.lexical_sort");
        this.setEnabled(!disabled);
        if (!disabled) {
            boolean checked = plugin.getPreferenceStore().getBoolean("outline.category_sort");
            super.valueChanged(checked);
        }
    }

    @Override
    protected void valueChanged(boolean on) {
        super.valueChanged(on);
        this.fAtic.update(true);
    }

    public Comparator<IDVTElementWrapper> getComparator() {
        if (this.fComparator == null) {
            this.fComparator = new Comparator<IDVTElementWrapper>(){

                public int category(IDVTElementWrapper wrapper) {
                    if (wrapper instanceof AbstractRfTreeElementWrapper) {
                        Object elem = wrapper.getRfElement();
                        if (elem instanceof RfScalarTypeLayer) {
                            return 0;
                        }
                        if (elem instanceof RfStructLayer) {
                            if (((RfStructLayer)elem).isUnit()) {
                                return 2;
                            }
                            if (((RfStructLayer)elem).isLike() || ((RfStructLayer)elem).isWhen()) {
                                return 3;
                            }
                            return 1;
                        }
                        if (elem instanceof RfFieldLayer) {
                            return 0;
                        }
                        if (elem instanceof RfEventLayer) {
                            return 1;
                        }
                        if (elem instanceof RfMethodLayer) {
                            return 2;
                        }
                        if (elem instanceof RfOnEventLayer) {
                            return 3;
                        }
                        if (elem instanceof RfCoverLayer) {
                            return 4;
                        }
                    }
                    return 0;
                }

                @Override
                public int compare(IDVTElementWrapper e1, IDVTElementWrapper e2) {
                    int line2;
                    int cat2;
                    if (!(e1.getRfElement() instanceof RfDefElement) || !(e2.getRfElement() instanceof RfDefElement)) {
                        return 0;
                    }
                    int cat1 = this.category(e1);
                    if (cat1 != (cat2 = this.category(e2))) {
                        return cat1 - cat2;
                    }
                    int line1 = ((RfDefElement)e1.getRfElement()).getStartLine();
                    if (line1 == (line2 = ((RfDefElement)e2.getRfElement()).getStartLine())) {
                        return 0;
                    }
                    if (line1 > line2) {
                        return 1;
                    }
                    return -1;
                }
            };
        }
        return this.fComparator;
    }
}

