/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection.views;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.progress.UIJob;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.decorators.util.ILazyOverlayElement;
import ro.amiq.edt.base.model.reflection.views.AbstractRfTreeElementWrapper;
import ro.amiq.edt.base.model.reflection.views.ELabelProvider;
import ro.amiq.edt.base.model.reflection.views.ILazyTableContentProvider;

public class TableViewContentProvider
implements ILazyTableContentProvider {
    private Table fTable;
    private ILabelProvider fLabelProvider;
    private UpdateItemCountJob fUpdateItemCountJob;
    private ILabelDecorator fDecorator;
    private boolean fDisableUpdateTree;

    public TableViewContentProvider(Table table, ELabelProvider labelProvider) {
        this.fTable = table;
        this.fLabelProvider = labelProvider;
        this.fDecorator = labelProvider.getDecorator();
        this.fUpdateItemCountJob = new UpdateItemCountJob();
        this.fTable.addListener(36, new Listener(){

            public void handleEvent(Event event) {
                TableViewContentProvider.this.updateItemWrapperData((TableItem)event.item, event.index);
            }
        });
        final ILabelProviderListener listener = new ILabelProviderListener(){

            public void labelProviderChanged(LabelProviderChangedEvent event) {
                Object[] elements = event.getElements();
                if (elements != null && elements.length > 0) {
                    Object[] objectArray = elements;
                    int n = elements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem item;
                        Object itemCandidate;
                        Object element = objectArray[n2];
                        if (element instanceof AbstractRfTreeElementWrapper && (itemCandidate = ((AbstractRfTreeElementWrapper)((Object)element)).getItem()) instanceof TableItem && (item = (TableItem)itemCandidate) != null && !item.isDisposed() && item.getParent() == TableViewContentProvider.this.fTable) {
                            item.setImage(TableViewContentProvider.this.fLabelProvider.getImage(element));
                        }
                        ++n2;
                    }
                }
            }
        };
        labelProvider.addListener(listener);
        this.fTable.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TableViewContentProvider.this.fLabelProvider.removeListener(listener);
            }
        });
        final LazyOverlayRefreshListener overlayRefreshlistener = new LazyOverlayRefreshListener();
        if (!this.fTable.isDisposed()) {
            this.fTable.addListener(42, (Listener)overlayRefreshlistener);
        }
        this.fTable.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TableViewContentProvider.this.fTable.removeListener(42, (Listener)overlayRefreshlistener);
            }
        });
    }

    @Override
    public void setInput(List<AbstractRfTreeElementWrapper> input) {
        this.fDisableUpdateTree = true;
        this.fUpdateItemCountJob.cancel();
        this.fUpdateItemCountJob.setItemCount(0, 0);
        this.fTable.setRedraw(false);
        this.fTable.removeAll();
        List oldData = (List)this.fTable.getData();
        if (oldData != null) {
            oldData.clear();
        }
        this.fTable.setData(input);
        this.fTable.setRedraw(true);
        this.fDisableUpdateTree = false;
        if (input == null) {
            return;
        }
        this.fUpdateItemCountJob.setItemCount(input.size(), 0);
        this.fUpdateItemCountJob.schedule();
    }

    @Override
    public void updateItemWrapperData(TableItem item, int index) {
        try {
            List elements = (List)this.fTable.getData();
            int oldItemCount = this.fTable.getItemCount();
            int totalItemCount = elements.size();
            if (oldItemCount < totalItemCount && oldItemCount - 50 < index) {
                int newItemCount = Math.min(oldItemCount + 100, totalItemCount);
                this.setItemCount(newItemCount, oldItemCount);
                this.fUpdateItemCountJob.cancel();
                this.fUpdateItemCountJob.setItemCount(totalItemCount, newItemCount);
                this.fUpdateItemCountJob.schedule();
            }
            if (index >= elements.size()) {
                return;
            }
            Object element = elements.get(index);
            item.setData(element);
            ((AbstractRfTreeElementWrapper)((Object)element)).setItem(item);
            item.setText(this.fLabelProvider.getText(element));
            item.setImage(this.fLabelProvider.getImage(element));
            if (((AbstractRfTreeElementWrapper)((Object)element)).getSelectedElement() != null) {
                ((AbstractRfTreeElementWrapper)((Object)element)).setSelectedElement(null);
                this.fTable.setSelection(item);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private boolean setItemCount(int newItemCount, int oldItemCount) {
        if (this.fDisableUpdateTree) {
            return false;
        }
        if (this.fTable != null && !this.fTable.isDisposed()) {
            int i = oldItemCount;
            while (i < newItemCount) {
                if (this.fDisableUpdateTree) {
                    return false;
                }
                new TableItem(this.fTable, 0);
                ++i;
            }
            return true;
        }
        return false;
    }

    class LazyOverlayRefreshListener
    implements Listener {
        private int MAX_NUMBER_OF_ELEMENTS = 30;
        private TableItem[] fRefreshList = new TableItem[this.MAX_NUMBER_OF_ELEMENTS];
        private int fRefreshPointer = 0;
        private UIJob fRefreshJob = new RefreshJob();

        public void handleEvent(Event event) {
            try {
                if (event.item == null || event.item.isDisposed()) {
                    return;
                }
                ILazyOverlayElement element = (ILazyOverlayElement)((TableItem)event.item).getData();
                if (element == null) {
                    return;
                }
                if (!element.getOverlayStatus()) {
                    this.fRefreshList[this.fRefreshPointer] = (TableItem)event.item;
                    this.fRefreshPointer = (this.fRefreshPointer + 1) % this.MAX_NUMBER_OF_ELEMENTS;
                    this.fRefreshJob.cancel();
                    this.fRefreshJob.schedule(150L);
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }

        private class RefreshJob
        extends UIJob {
            public RefreshJob() {
                super("LazyTypesOverlayUpdater");
                this.setSystem(true);
                this.setPriority(50);
            }

            public boolean shouldSchedule() {
                return super.shouldSchedule() && ((LazyOverlayRefreshListener)LazyOverlayRefreshListener.this).TableViewContentProvider.this.fTable != null && !((LazyOverlayRefreshListener)LazyOverlayRefreshListener.this).TableViewContentProvider.this.fTable.isDisposed();
            }

            public boolean shouldRun() {
                return super.shouldRun() && ((LazyOverlayRefreshListener)LazyOverlayRefreshListener.this).TableViewContentProvider.this.fTable != null && !((LazyOverlayRefreshListener)LazyOverlayRefreshListener.this).TableViewContentProvider.this.fTable.isDisposed();
            }

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (((LazyOverlayRefreshListener)LazyOverlayRefreshListener.this).TableViewContentProvider.this.fTable == null || ((LazyOverlayRefreshListener)LazyOverlayRefreshListener.this).TableViewContentProvider.this.fTable.isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                ((LazyOverlayRefreshListener)LazyOverlayRefreshListener.this).TableViewContentProvider.this.fTable.setRedraw(false);
                int i = 0;
                while (i < LazyOverlayRefreshListener.this.MAX_NUMBER_OF_ELEMENTS) {
                    ILazyOverlayElement element;
                    TableItem item = LazyOverlayRefreshListener.this.fRefreshList[i];
                    if (item != null && !item.isDisposed() && (element = (ILazyOverlayElement)item.getData()) != null && !element.getOverlayStatus()) {
                        element.setOverlayStatus(true);
                        ((LazyOverlayRefreshListener)LazyOverlayRefreshListener.this).TableViewContentProvider.this.fDecorator.decorateImage(item.getImage(), (Object)element);
                        LazyOverlayRefreshListener.this.fRefreshList[i] = null;
                    }
                    ++i;
                }
                ((LazyOverlayRefreshListener)LazyOverlayRefreshListener.this).TableViewContentProvider.this.fTable.setRedraw(true);
                return Status.OK_STATUS;
            }
        }
    }

    class UpdateItemCountJob
    extends UIJob {
        private int fCurrentItemCount;
        private int fTotalItemCount;

        public UpdateItemCountJob() {
            super(Display.getCurrent(), "Update Item Count");
            this.setSystem(true);
            this.setPriority(30);
        }

        public void setItemCount(int totalItemCount, int currentItemCount) {
            this.fTotalItemCount = totalItemCount;
            this.fCurrentItemCount = currentItemCount;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (TableViewContentProvider.this.fDisableUpdateTree) {
                return Status.OK_STATUS;
            }
            if (this.fCurrentItemCount < this.fTotalItemCount) {
                int oldItemCount = this.fCurrentItemCount;
                this.fCurrentItemCount = Math.min(this.fCurrentItemCount + 500, this.fTotalItemCount);
                if (TableViewContentProvider.this.setItemCount(this.fCurrentItemCount, oldItemCount)) {
                    this.schedule(50L);
                }
            }
            return Status.OK_STATUS;
        }
    }
}

