/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection.views;

import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.core.IPluginConfig;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfEvent;
import ro.amiq.edt.base.model.reflection.RfField;
import ro.amiq.edt.base.model.reflection.RfFieldPropConstraint;
import ro.amiq.edt.base.model.reflection.RfFieldTypeConstraint;
import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfMethodType;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfScalarType;
import ro.amiq.edt.base.model.reflection.RfSpecman;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.views.AbstractRfTreeElementWrapper;
import ro.amiq.edt.base.model.reflection.views.ELabelProvider;
import ro.amiq.edt.base.model.reflection.views.ELanguageElement;

public class TypesViewLabelProvider
extends ELabelProvider {
    private final boolean fIsInSLNMode;

    public TypesViewLabelProvider(IEPluginConfig pluginConfig) {
        super(pluginConfig);
        this.fIsInSLNMode = DVTUtilsCommon.INSTANCE.isInSlnLikeMode((IPluginConfig)pluginConfig);
    }

    public Image getImage(Object wrapper) {
        IDVTElementWrapper rfWrapper = null;
        Object element = null;
        if (wrapper instanceof IDVTElementWrapper) {
            rfWrapper = (IDVTElementWrapper)wrapper;
            element = rfWrapper.getRfElement();
        } else {
            element = wrapper;
        }
        if (element instanceof AbstractRfTreeElementWrapper) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        if (element instanceof String) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        if (RfStruct.isPackageElement(element, false)) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_PACKAGE);
        }
        if (element instanceof ELanguageElement) {
            return DVTImages.imageCache.getImage(DVTImages.E_LANGUAGE);
        }
        RfNamedElement namedElement = null;
        Image result = null;
        if (element instanceof RfDefElement) {
            namedElement = ((RfDefElement)element).getNamedElement();
        } else if (element instanceof RfNamedElement) {
            namedElement = (RfNamedElement)element;
        } else {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        if (namedElement instanceof RfMethodType) {
            result = DVTImages.imageCache.getImage(DVTImages.METHOD_TYPE);
        } else {
            boolean isGrayIcon;
            boolean bl = isGrayIcon = namedElement.isPredefined() && namedElement.hasNoLayers();
            if (namedElement instanceof RfStruct) {
                RfStruct struct = (RfStruct)namedElement;
                result = struct.isSLNToken() ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_SLN_TOKEN) : (struct.isSDLAgent() ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_SDL_AGENT) : (struct.isSDLScenario() ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_SDL_SCENARIO) : (struct.isSDLRole() ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_SDL_ROLE) : (struct.isSLNComponent() ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_SLN_COMPONENT) : (struct.isSLNAction() ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_SLN_ACTION) : (struct.isInterface() ? (isGrayIcon ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_INTERFACE_CLASS_GRAY) : (struct.isPredefined() ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_INTERFACE_CLASS_GRAY) : DVTImages.imageCache.getImage(DVTImages.OUTLINE_INTERFACE_CLASS))) : (struct.isUnit() ? (isGrayIcon ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_PUNIT) : (struct.isPredefined() ? (struct.getFirstLayer() != null ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_PUNIT_HALF) : DVTImages.imageCache.getImage(DVTImages.OUTLINE_PUNIT)) : DVTImages.imageCache.getImage(DVTImages.OUTLINE_UNIT))) : (isGrayIcon ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_PSTRUCT) : (struct.getFirstLayer() != null && struct.isLike("any_sequence") ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_SEQUENCE) : (struct.isPredefined() ? (struct.getFirstLayer() != null ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_PSTRUCT_HALF) : DVTImages.imageCache.getImage(DVTImages.OUTLINE_PSTRUCT)) : DVTImages.imageCache.getImage(DVTImages.OUTLINE_STRUCT)))))))))));
            } else if (namedElement instanceof RfMethod) {
                result = isGrayIcon ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_PMETHOD) : DVTImages.imageCache.getImage(DVTImages.OUTLINE_METHOD);
            } else if (namedElement instanceof RfField) {
                RfField field = (RfField)namedElement;
                String associatedTypeName = field.getAssociatedTypeName();
                int direction = field.getDirection();
                result = associatedTypeName.equals("any_simple_port") ? (direction == 1 ? DVTImages.imageCache.getImage(DVTImages.PORT_SIMPLE_IN) : (direction == 2 ? DVTImages.imageCache.getImage(DVTImages.PORT_SIMPLE_OUT) : DVTImages.imageCache.getImage(DVTImages.PORT_SIMPLE_INOUT))) : (associatedTypeName.equals("any_event_port") ? (direction == 1 ? DVTImages.imageCache.getImage(DVTImages.PORT_EVENT_IN) : (direction == 2 ? DVTImages.imageCache.getImage(DVTImages.PORT_EVENT_OUT) : DVTImages.imageCache.getImage(DVTImages.PORT_EVENT_INOUT))) : (associatedTypeName.equals("any_buffer_port") ? (direction == 1 ? DVTImages.imageCache.getImage(DVTImages.PORT_BUFFER_IN) : DVTImages.imageCache.getImage(DVTImages.PORT_BUFFER_OUT)) : (associatedTypeName.equals("any_method_port") ? (direction == 1 ? DVTImages.imageCache.getImage(DVTImages.PORT_METHOD_IN) : DVTImages.imageCache.getImage(DVTImages.PORT_METHOD_OUT)) : (RfSpecman.isTLMPort(associatedTypeName) ? (direction == 1 ? DVTImages.imageCache.getImage(DVTImages.PORT_INTERFACE_IN) : DVTImages.imageCache.getImage(DVTImages.PORT_INTERFACE_OUT)) : (field.isInstance() ? (isGrayIcon ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_PUNIT_INSTANCE) : (field.isPredefined() ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_PUNIT_INSTANCE) : DVTImages.imageCache.getImage(DVTImages.OUTLINE_UNIT_INSTANCE))) : (isGrayIcon ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_PFIELD) : (field instanceof RfFieldPropConstraint ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_CONSTRAINT) : (field instanceof RfFieldTypeConstraint ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_CONSTRAINT) : DVTImages.imageCache.getImage(DVTImages.OUTLINE_FIELD)))))))));
            } else if (namedElement instanceof RfScalarType) {
                result = DVTImages.imageCache.getImage(DVTImages.OUTLINE_TYPE);
            } else if (namedElement instanceof RfEvent) {
                result = isGrayIcon ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_PEVENT) : DVTImages.imageCache.getImage(DVTImages.OUTLINE_EVENT);
            }
        }
        if (result == null) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        if (rfWrapper != null && !rfWrapper.getOverlayStatus()) {
            return result;
        }
        if (this.fDecorator != null) {
            return this.fDecorator.decorateImage(result, wrapper);
        }
        return result;
    }

    public String getText(Object object) {
        String result = this.internalGetText(object);
        if (result == null) {
            return "";
        }
        return result;
    }

    protected String internalGetText(Object wrapper) {
        RfMethod method;
        Object element;
        AbstractRfTreeElementWrapper rfWrapper = (AbstractRfTreeElementWrapper)((Object)wrapper);
        if (rfWrapper.getAdditionalInfo(IDVTElementWrapper.Attribute.MATCH) != null) {
            this.setBoldFont(rfWrapper);
        }
        if ((element = rfWrapper.getRfElement()) instanceof ELanguageElement) {
            return (String)((ELanguageElement)((Object)element)).getInfo();
        }
        if (element instanceof AbstractRfTreeElementWrapper) {
            return (String)((AbstractRfTreeElementWrapper)((Object)element)).getRfElement();
        }
        if (element instanceof String) {
            return (String)element;
        }
        if (RfStruct.isPackageElement(element, false)) {
            return ((RfStruct)element).getName();
        }
        if (!(element instanceof RfNamedElement)) {
            return "";
        }
        RfNamedElement namedElement = (RfNamedElement)element;
        String result = "";
        result = namedElement instanceof RfStruct ? String.valueOf(namedElement.getName()) + ((RfStruct)namedElement).getParametersInfo(true) : (namedElement instanceof RfMethod ? ((method = (RfMethod)namedElement).isTCM() ? DVTStringUtil.appendString((Object[])new Object[]{namedElement.getName(), "()@"}) : DVTStringUtil.appendString((Object[])new Object[]{namedElement.getName(), "()"})) : namedElement.getName());
        return result;
    }
}

