/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection.views;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.views.DVTRfLabelProvider;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.edt.base.model.reflection.Determinant;
import ro.amiq.edt.base.model.reflection.FullName;
import ro.amiq.edt.base.model.reflection.RfKind;
import ro.amiq.edt.base.model.reflection.RfStructMember;

public class TypesViewMembersLabelProvider
extends DVTRfLabelProvider {
    public String getNamedElementText(IRfNamedElement element) {
        Determinant determinant;
        if (!(element instanceof RfStructMember)) {
            return super.getNamedElementText(element);
        }
        RfStructMember structMember = (RfStructMember)element;
        String result = super.getNamedElementText((IRfNamedElement)structMember);
        if (RfKind.of(element) == RfKind.TCM) {
            result = String.valueOf(element.getName()) + "@";
        }
        String subtypeName = null;
        FullName fullName = structMember.getFullName();
        if (fullName != null && (determinant = fullName.getDeterminant()) != null && !determinant.toString().equals(determinant.getName())) {
            subtypeName = determinant.toString();
        }
        if (subtypeName != null) {
            result = DVTStringUtil.appendString((Object[])new Object[]{result, " [", subtypeName, "]"});
        }
        return result;
    }

    public Image getNamedElementImage(IRfNamedElement element) {
        RfKind kind = RfKind.of(element);
        ImageDescriptor id = DVTImages.NONE;
        switch (kind) {
            case FIELD: {
                id = DVTImages.OUTLINE_FIELD;
                break;
            }
            case PORT_SIMPLE_IN: {
                id = DVTImages.PORT_SIMPLE_IN;
                break;
            }
            case PORT_SIMPLE_OUT: {
                id = DVTImages.PORT_SIMPLE_OUT;
                break;
            }
            case PORT_SIMPLE_INOUT: {
                id = DVTImages.PORT_SIMPLE_INOUT;
                break;
            }
            case PORT_EVENT_IN: {
                id = DVTImages.PORT_EVENT_IN;
                break;
            }
            case PORT_EVENT_OUT: {
                id = DVTImages.PORT_EVENT_OUT;
                break;
            }
            case PORT_EVENT_INOUT: {
                id = DVTImages.PORT_EVENT_INOUT;
                break;
            }
            case PORT_BUFFER_IN: {
                id = DVTImages.PORT_BUFFER_IN;
                break;
            }
            case PORT_BUFFER_OUT: {
                id = DVTImages.PORT_BUFFER_OUT;
                break;
            }
            case PORT_METHOD_IN: {
                id = DVTImages.PORT_METHOD_IN;
                break;
            }
            case PORT_METHOD_OUT: {
                id = DVTImages.PORT_METHOD_OUT;
                break;
            }
            case PORT_INTERFACE_IN: {
                id = DVTImages.PORT_INTERFACE_IN;
                break;
            }
            case PORT_INTERFACE_OUT: {
                id = DVTImages.PORT_INTERFACE_OUT;
                break;
            }
            case UNIT_INSTANCE: {
                id = DVTImages.OUTLINE_UNIT_INSTANCE;
                break;
            }
            case EVENT: {
                id = DVTImages.OUTLINE_EVENT;
                break;
            }
            case CONSTRAINT: {
                id = DVTImages.OUTLINE_CONSTRAINT;
                break;
            }
            case METHOD: {
                id = DVTImages.OUTLINE_METHOD;
                break;
            }
            case TCM: {
                id = DVTImages.OUTLINE_METHOD;
                break;
            }
            case ENUM_ELEMENT: {
                id = DVTImages.OUTLINE_ENUM_ITEM;
                break;
            }
            case EXPECT: {
                id = DVTImages.EXPECT;
                break;
            }
            case SLN_COMPONENT_INSTANCE: {
                id = DVTImages.SLN_COMPONENT_INSTANCE;
                break;
            }
            case SLN_EXECUTABLE_INSTANCE: {
                id = DVTImages.SLN_EXECUTABLE_INSTANCE;
                break;
            }
            case SLN_PLACE_INSTANCE: {
                id = DVTImages.SLN_PLACE_INSTANCE;
                break;
            }
            case SLN_THREAD_INSTANCE: {
                id = DVTImages.SLN_THREAD_INSTANCE;
            }
        }
        return DVTImages.imageCache.getImage(id);
    }
}

