/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection.views;

import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.edt.base.model.reflection.Determinant;
import ro.amiq.edt.base.model.reflection.FullName;

public class VHHistoryItem
extends HistoryItem {
    private FullName fStructFullName;
    private String fProjectName;
    private String fPackageName;
    private LanguageKind fLanguageKind;

    private VHHistoryItem(String projectName, String packageName, FullName structFullName, LanguageKind languageKind) {
        super("[" + projectName + "] " + packageName + "::" + structFullName);
        this.fProjectName = projectName;
        this.fPackageName = packageName;
        this.fStructFullName = structFullName;
        this.fLanguageKind = languageKind;
    }

    public static HistoryItem parseHistoryItem(String projectName, String structTop, LanguageKind languageKind) {
        if (projectName == null || structTop == null) {
            return null;
        }
        String[] pieces = DVTStringUtil.split((String)"::", (String)structTop);
        if (pieces.length != 2) {
            DVTLogger.INSTANCE.logInfo("Unexpected history item for the Verification Hierarchy View: [" + projectName + "] " + structTop);
            return null;
        }
        String packageName = pieces[0];
        if ((pieces = DVTStringUtil.split((String)".", (String)pieces[1])).length != 2) {
            DVTLogger.INSTANCE.logInfo("Unexpected history item for the Verification Hierarchy View: [" + projectName + "] " + structTop);
            return null;
        }
        String structName = pieces[1];
        pieces = DVTStringUtil.split((String)" ", (String)pieces[0]);
        FullName fullName = new FullName(structName, new Determinant(pieces));
        return VHHistoryItem.parseHistoryItem(projectName, packageName, fullName, languageKind);
    }

    public static VHHistoryItem parseHistoryItem(String projectName, String packageName, FullName fullName, LanguageKind languageKind) {
        if (projectName == null || packageName == null || fullName == null) {
            return null;
        }
        return new VHHistoryItem(projectName, packageName, fullName, languageKind);
    }

    public LanguageKind getLanguage() {
        return this.fLanguageKind;
    }

    public FullName getStructFullName() {
        return this.fStructFullName;
    }

    public String getProjectName() {
        return this.fProjectName;
    }

    public String getPackageName() {
        return this.fPackageName;
    }

    public boolean equals(Object hi) {
        if (hi instanceof VHHistoryItem) {
            VHHistoryItem vhi = (VHHistoryItem)((Object)hi);
            return this.fProjectName.equals(vhi.fProjectName) && this.fPackageName.equals(vhi.getPackageName()) && this.fStructFullName.equals(vhi.fStructFullName);
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode() + this.fProjectName.hashCode() + this.fPackageName.hashCode() + this.fStructFullName.hashCode();
    }

    public String toString() {
        return String.valueOf(this.fPackageName) + "::" + this.fStructFullName.getDeterminant().toString() + "." + this.fStructFullName.getName();
    }

    public IProject getProject() {
        if (this.fProjectName == null) {
            return null;
        }
        return Utils.getProject((String)this.fProjectName);
    }
}

