/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection.views;

import java.util.HashMap;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.model.reflection.semantic.extension2.DummyElement;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.IVHLabelProvider;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.reflection.Determinant;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfDummyElement;
import ro.amiq.edt.base.model.reflection.RfField;
import ro.amiq.edt.base.model.reflection.RfFieldLayer;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructLayer;
import ro.amiq.edt.base.model.reflection.RfTemplateStructInstance;
import ro.amiq.edt.base.model.reflection.RfType;
import ro.amiq.edt.base.model.reflection.views.AbstractRfTreeElementWrapper;
import ro.amiq.edt.base.model.reflection.views.TypesViewLabelProvider;

public class VHLabelProvider
extends TypesViewLabelProvider
implements IVHLabelProvider {
    public VHLabelProvider(IEPluginConfig pluginConfig) {
        super(pluginConfig);
    }

    @Override
    protected String internalGetText(Object wrapper) {
        if (wrapper instanceof IDVTElementWrapper) {
            return this.getTextUsingParentNode(wrapper, ((IDVTElementWrapper)wrapper).getParent());
        }
        return this.getTextUsingParentNode(wrapper, null);
    }

    protected String getTextUsingParentNode(Object wrapper, Object parent) {
        Object additionalInfoSubtype;
        if (wrapper.equals(DummyElement.RECURRENCE_NODE)) {
            return DummyElement.RECURRENCE_NODE.getName();
        }
        Object element = wrapper instanceof IDVTElementWrapper ? ((IDVTElementWrapper)wrapper).getRfElement() : wrapper;
        if (wrapper instanceof IDVTElementWrapper && ((IDVTElementWrapper)wrapper).getAdditionalInfo((Object)IDVTElementWrapper.Attribute.MATCH) != null) {
            this.setBoldFont((AbstractRfTreeElementWrapper)((Object)wrapper));
        }
        if (element instanceof TreePath) {
            element = ((TreePath)element).getElement();
        }
        if (element instanceof String) {
            return (String)element;
        }
        if (element instanceof RfDummyElement) {
            return ((RfDummyElement)element).getName();
        }
        String instName = "";
        String packName = "";
        String typeName = "";
        boolean additionalInfoPrependText = PrefConst.getVHViewPrependPackage();
        Object object = additionalInfoSubtype = wrapper instanceof IDVTElementWrapper ? ((IDVTElementWrapper)wrapper).getAdditionalInfo((Object)IDVTElementWrapper.Attribute.WHEN_SUBTYPE) : null;
        if (element instanceof RfDefElement) {
            typeName = ((RfDefElement)element).getInfo();
            if (additionalInfoPrependText) {
                packName = ((RfDefElement)element).getPackageName();
            }
            if (additionalInfoSubtype != null) {
                typeName = String.valueOf(typeName) + " [ " + additionalInfoSubtype + " ]";
            }
            return this.internalGetText(instName, packName, typeName);
        }
        if (element instanceof RfNamedElement) {
            RfNamedElement namedElement = (RfNamedElement)element;
            if (namedElement instanceof RfField) {
                RfType assocType;
                RfField field = (RfField)namedElement;
                if (field.isPort()) {
                    return field.toString();
                }
                instName = field.getName();
                additionalInfoSubtype = this.computeSubTypeInfoForField(field, parent);
                if (additionalInfoPrependText) {
                    packName = field.getPackageName();
                }
                if ((assocType = field.getAssociatedType()) instanceof RfStruct) {
                    typeName = field.getAssociatedFullTypeName();
                    int i = 0;
                    while (i < field.getAssociatedTypeList()) {
                        typeName = "list of " + typeName;
                        ++i;
                    }
                }
            } else if (namedElement instanceof RfStruct) {
                if (additionalInfoPrependText) {
                    packName = ((RfStruct)namedElement).getPackageName();
                }
                typeName = namedElement.getName();
            }
            if (additionalInfoSubtype != null) {
                typeName = String.valueOf(typeName) + " [ " + additionalInfoSubtype + " ]";
            }
            return this.internalGetText(instName, packName, typeName);
        }
        return null;
    }

    private Object computeSubTypeInfoForField(RfField field, Object parent) {
        if (parent == null) {
            return null;
        }
        HashMap<Determinant, RfFieldLayer> fieldDetList = new HashMap<Determinant, RfFieldLayer>();
        for (RfDefElement fieldLayer : field.getLayers()) {
            fieldDetList.put(((RfFieldLayer)fieldLayer).getField().getAssociatedTypeDeterminant(), (RfFieldLayer)fieldLayer);
        }
        Determinant fieldDeterminant = field.getAssociatedTypeDeterminant();
        RfFieldLayer fieldLayer = (RfFieldLayer)fieldDetList.get(fieldDeterminant);
        if (fieldLayer == null) {
            return null;
        }
        RfStructLayer enclosingScope = fieldLayer.getStructLayer();
        Determinant determinant = enclosingScope.getDeterminant();
        if (determinant == null) {
            return null;
        }
        Object parentElement = parent instanceof TreePath ? ((TreePath)parent).getElement() : (parent instanceof IDVTElementWrapper ? ((IDVTElementWrapper)parent).getRfElement() : parent);
        if (parentElement instanceof RfStructLayer) {
            parentElement = ((RfStructLayer)parentElement).getDeterminant();
        } else if (parentElement instanceof RfField) {
            parentElement = ((RfField)parentElement).getAssociatedTypeDeterminant();
        }
        if (parentElement.equals(determinant)) {
            return null;
        }
        return determinant.toString();
    }

    @Override
    public Image getImage(Object wrapper) {
        if (DummyElement.RECURRENCE_NODE.equals(wrapper)) {
            return DVTImages.imageCache.getImage(DVTImages.INSTANCE_LOOP);
        }
        Object element = wrapper instanceof IDVTElementWrapper ? ((IDVTElementWrapper)wrapper).getRfElement() : wrapper;
        Image result = null;
        if (element instanceof RfDummyElement) {
            if (((RfDummyElement)element).getName().equals("[...max_random_depth]")) {
                return DVTImages.imageCache.getImage(DVTImages.INSTANCE_LOOP);
            }
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        if (element instanceof RfStructLayer) {
            RfStructLayer layer = (RfStructLayer)element;
            RfStruct struct = layer.getStruct();
            result = struct != null && struct.isSLNToken() ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_SLN_TOKEN) : (struct != null && struct.isSDLAgent() ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_SDL_AGENT) : (struct != null && struct.isSDLScenario() ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_SDL_SCENARIO) : (struct != null && struct.isSLNComponent() ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_SLN_COMPONENT) : (struct != null && struct.isSLNAction() ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_SLN_ACTION) : (struct != null && struct.isLike("any_sequence") ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_SEQUENCE) : (layer.isLike() ? (layer.isExtend() ? (layer.getStruct().isUnit() ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_UNIT_EXTEND) : DVTImages.imageCache.getImage(DVTImages.OUTLINE_STRUCT_EXTEND)) : (layer.isUnit() ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_UNIT) : DVTImages.imageCache.getImage(DVTImages.OUTLINE_STRUCT))) : (layer.isWhen() ? (layer.isUnit() ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_UNIT_WHEN) : DVTImages.imageCache.getImage(DVTImages.OUTLINE_STRUCT_WHEN)) : (layer.isUnit() ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_UNIT_EXTEND) : DVTImages.imageCache.getImage(DVTImages.OUTLINE_STRUCT_EXTEND)))))))));
        } else if (element instanceof RfField) {
            RfType associatedType;
            if (((RfField)element).isInstance() && (associatedType = ((RfField)element).getAssociatedBaseType()) instanceof RfStruct) {
                RfStruct rfStruct = (RfStruct)associatedType;
                if (associatedType instanceof RfTemplateStructInstance) {
                    rfStruct = ((RfTemplateStructInstance)associatedType).getTemplateStruct();
                }
                if (rfStruct.isLike("sln_component")) {
                    result = DVTImages.imageCache.getImage(DVTImages.SLN_COMPONENT_INSTANCE);
                } else if (rfStruct.isLike("sln_place")) {
                    result = DVTImages.imageCache.getImage(DVTImages.SLN_PLACE_INSTANCE);
                } else if (rfStruct.isLike("sln_thread")) {
                    result = DVTImages.imageCache.getImage(DVTImages.SLN_THREAD_INSTANCE);
                } else if (rfStruct.isLike("sln_executable")) {
                    result = DVTImages.imageCache.getImage(DVTImages.SLN_EXECUTABLE_INSTANCE);
                }
            }
        } else if (element instanceof String) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        if (result != null && this.fDecorator != null) {
            return this.fDecorator.decorateImage(result, wrapper);
        }
        return super.getImage(wrapper);
    }

    private String internalGetText(String instName, String packName, String objName) {
        boolean hasPackName;
        StringBuilder result = new StringBuilder("");
        boolean hasInstName = instName != null && !instName.isEmpty();
        boolean hasObjName = objName != null && !objName.isEmpty();
        boolean bl = hasPackName = packName != null && !packName.isEmpty();
        if (hasInstName) {
            result.append(instName);
            if (hasObjName) {
                result.append(" : ");
            }
        }
        if (hasPackName) {
            result.append(packName);
            if (hasObjName) {
                result.append("::");
            }
        }
        if (hasObjName) {
            result.append(objName);
        }
        return result.toString();
    }
}

