/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection.views;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IDVTJob;
import ro.amiq.dvt.ui.views.UpdateJob;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.reflection.Determinant;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfDummyElement;
import ro.amiq.edt.base.model.reflection.RfField;
import ro.amiq.edt.base.model.reflection.RfSpecman;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructLayer;
import ro.amiq.edt.base.model.reflection.RfStructMember;
import ro.amiq.edt.base.model.reflection.RfType;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedStruct;
import ro.amiq.edt.base.model.reflection.views.AbstractRfTreeElementWrapper;

public class VHViewUtil {
    public static final String MAX_RANDOM_DEPTH_TEXT = "[...max_random_depth]";
    private static final Comparator<AbstractRfTreeElementWrapper> fLexicalSorter = new Comparator<AbstractRfTreeElementWrapper>(){

        @Override
        public int compare(AbstractRfTreeElementWrapper w1, AbstractRfTreeElementWrapper w2) {
            Object o1 = w1.getRfElement();
            Object o2 = w2.getRfElement();
            boolean firstIsField = o1 instanceof RfField;
            boolean secondIsField = o2 instanceof RfField;
            if (firstIsField && secondIsField) {
                return ((RfField)o1).getName().compareTo(((RfField)o2).getName());
            }
            if (firstIsField) {
                return -1;
            }
            if (secondIsField) {
                return 1;
            }
            return 0;
        }
    };

    protected static void solveDeterminants(RfStruct struct, Determinant determinant, Set<Determinant> visited) {
        visited.add(determinant);
        Map<String, ListContainer<RfStructMember>> rawFields = struct.getRawFields();
        if (rawFields == null) {
            return;
        }
        for (ListContainer<RfStructMember> fields : rawFields.values()) {
            for (RfStructMember field : fields) {
                Determinant associatedTypeDeterminant;
                Determinant fieldDeterminant;
                String associatedTypeName;
                RfType associatedBaseType;
                if (!((RfField)field).isInstance() || !((associatedBaseType = field.getAssociatedBaseType()) instanceof RfStruct) || field instanceof RfField && (RfPredefinedStruct.PORT_STRUCT_NAMES.contains(associatedTypeName = associatedBaseType.getName()) || RfSpecman.isTLMPort(associatedTypeName)) || !determinant.contains(fieldDeterminant = field.getFullName().getDeterminant(), true) || visited.contains(associatedTypeDeterminant = field.getAssociatedTypeDeterminant())) continue;
                VHViewUtil.solveDeterminants((RfStruct)associatedBaseType, associatedTypeDeterminant, visited);
            }
        }
    }

    public static void getRecursiveInstances(IEPluginConfig pluginConfig, AbstractRfTreeElementWrapper root, RfStruct struct, Determinant determinant, Set<Determinant> visited, boolean sorting, boolean prependPackage, UpdateJob updateJob) {
        List<AbstractRfTreeElementWrapper> children;
        visited.add(determinant);
        if (ViewsUtils.isCanceled((IDVTJob)updateJob)) {
            return;
        }
        Iterator<RfStructMember> fieldsIterator = struct.getRawFieldsIterator(true);
        if (fieldsIterator != null) {
            while (fieldsIterator.hasNext()) {
                Determinant associatedTypeDeterminant;
                String associatedTypeName;
                RfType associatedBaseType;
                RfStructMember field = fieldsIterator.next();
                if (field == null) continue;
                if (ViewsUtils.isCanceled((IDVTJob)updateJob)) {
                    return;
                }
                if (!((RfField)field).isInstance() || !((associatedBaseType = field.getAssociatedBaseType()) instanceof RfStruct) || field instanceof RfField && (RfPredefinedStruct.PORT_STRUCT_NAMES.contains(associatedTypeName = associatedBaseType.getName()) || RfSpecman.isTLMPort(associatedTypeName))) continue;
                HashMap<Determinant, RfStructLayer> detList = new HashMap<Determinant, RfStructLayer>();
                for (RfDefElement layer : struct.getLayers()) {
                    detList.put(((RfStructLayer)layer).getDeterminant(), (RfStructLayer)layer);
                }
                RfType associatedType = field.getAssociatedBaseType();
                if (!(associatedType instanceof RfStruct)) continue;
                AbstractRfTreeElementWrapper fieldWrapper = pluginConfig.createElementTreeWrapper(field);
                Determinant fieldDeterminant = field.getFullName().getDeterminant();
                if (detList.containsKey(fieldDeterminant) && !fieldDeterminant.equals(determinant)) {
                    if (determinant.contains(fieldDeterminant, true)) {
                        fieldWrapper.setAdditionalInfo(IDVTElementWrapper.Attribute.WHEN_SUBTYPE, fieldDeterminant.toString());
                        root.addChild(fieldWrapper);
                    }
                } else {
                    if (!determinant.contains(fieldDeterminant, true) && !struct.isLike(field.getParentStruct().getName())) continue;
                    root.addChild(fieldWrapper);
                }
                if (prependPackage) {
                    fieldWrapper.setAdditionalInfo(IDVTElementWrapper.Attribute.PREPEND_TEXT, "package");
                }
                if (visited.contains(associatedTypeDeterminant = field.getAssociatedTypeDeterminant())) {
                    AbstractRfTreeElementWrapper dummyWrapper = pluginConfig.createElementTreeWrapper(new RfDummyElement(null, MAX_RANDOM_DEPTH_TEXT));
                    fieldWrapper.addChild(dummyWrapper);
                    continue;
                }
                VHViewUtil.getRecursiveInstances(pluginConfig, fieldWrapper, (RfStruct)associatedType, associatedTypeDeterminant, visited, sorting, prependPackage, updateJob);
            }
        }
        if (sorting && (children = root.getChildren()) != null) {
            Collections.sort(children, fLexicalSorter);
        }
        visited.remove(determinant);
    }
}

