/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.r2lparser;

import java.util.regex.Pattern;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.util.RfUtils;

public class R2LCoverItemOption
extends RfNamedElement {
    private String name;
    private String comment;
    private String value;
    public static final String WHEN_COMMENT = "The item is sampled only when bool-exp is TRUE. The bool-exp is evaluated in the context of the parent struct.<br>The sampling is done at run time.";
    public static final String WEIGHT_COMMENT = "Specifies the weight of the current item relative to other items in the same cover group.<br>It is a non-negative integer with a default of 1.";
    public static final String TEXT_COMMENT = "A text description for this cover item. This can only be a quoted string, not a variable or expression.<br>";
    public static final String RANGES_COMMENT = "Create buckets for this item\u2019s values or ranges of values. <br>This option cannot be used for string items. The range() has up to four parameters that specify how the values are separated into buckets.<br> The syntax is: range( range : range, name : string, every-count : int, at_least-num : int)<br>The first parameter, range , is required. The other three are optional.";
    public static final String RADIX_COMMENT = "Legal values are DEC (decimal), HEX (hexadecimal), and BIN (binary). The value must be in upper case letters.<br>If the radix is not used, int or uint bucket names are displayed in decimal.";
    public static final String PER_INSTANCE_COMMENT = "When per_instance[=TRUE], coverage data is collected and graded for all the other items in a separate sub-group for each bucket of this item.<br>This option can only be used for gradeable items.";
    public static final String NUM_OF_BUCKETS_COMMENT = "Specifies how many buckets are to be created for the cover item. This option overrides the max_int_buckets coverage configuration option for this cover item. <br>It cannot be used for string items or items that have ranges specified with the ranges cover item option. <br>It can be set to any value, including greater than max_int_buckets. For items greater than 32 bits, size of each bucket can exceed the 2^32 limit.";
    public static final String NO_TRACE_COMMENT = "When no_trace[=TRUE], this item is not traced by the simulator. Use this option to collect data for trace event.";
    public static final String NO_COLLECT_COMMENT = "The boolean expression can be a constant (FALSE/TRUE), or a global scope expression \u2013 a reference to a field under sys. <br>When no_collect[=TRUE], this cover item is not displayed in coverage reports and is not saved in the coverage files.";
    public static final String INSTANCE_RANGES_COMMENT = "Create context-dependent buckets for this item's values or ranges of values.<br>Can contain constants and global values.";
    public static final String INSTANCE_NO_COLLECT_COMMENT = "Define a context-dependent no_collect expression on items in per_unit_instance groups. The expr argument can include an inst field.<br>In the context of an explicit per-unit instance or for cover groups defined under a struct or unit, the inst field contains a pointer to the unit defined by the per_unit_instance option.<br>In the case of an implicit per-unit instance collection of cover groups defined under units, the inst field refers to the enclosing unit.";
    public static final String INSTANCE_ILLEGAL_COMMENT = "Define a context-dependent illegal expression on items in per_unit_instance groups.<br>This option lets you set illegal expressions for an instance, depending on the scope. An illegal value causes a DUT error.";
    public static final String INSTANCE_IGNORE_COMMENT = "Define a context-dependent ignore expression on items in per_unit_instance groups.";
    public static final String ILLEGAL_COMMENT = "Define values that are illegal. An illegal value causes a DUT error.<br>The Boolean expression is evaluated in a global context, not in instances of the struct.";
    public static final String AT_LEAST_COMMENT = "A non-negative integer specifying the minimum number of samples for each bucket of each of the transition items.<br>Anything less than num is considered a hole. The default is 1.<br>This option cannot be used with string items or for unconstrained integers (items that have no specified ranges).";
    public static final String FIRST_HIGH_BIT_COMMENT = "Collect power-of-two coverage. The sampled value is the location of the most significant bit, which is set to 1";
    public static final String IGNORE_COMMENT = "Define values that are to be completely ignored. They do not appear in the statistics at all.<br> The expression is a Boolean expression that can contain a cover item name and constants.<br>The Boolean expression is evaluated in a global context, not in instances of the struct.";
    public static final String NAME_COMMENT = "Specifies a name for a cross or transition cover item. No white spaces are allowed in the label.";

    public R2LCoverItemOption(String name, String value, String comment) {
        super(null, name);
        this.name = name;
        this.comment = comment;
        this.value = value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getSignature() {
        return String.valueOf(this.name) + this.value;
    }

    @Override
    public boolean isPredefined() {
        return true;
    }

    @Override
    public boolean isEPredefined() {
        return true;
    }

    @Override
    public String getComment(boolean removeHTMLTags) {
        String commentText = "<i>PREDEFINED: </i>" + (this.comment == null ? "[Description not available]" : this.comment);
        if (removeHTMLTags) {
            return DVTStringUtil.replaceAll((Pattern)RfUtils.HTML_TAGS_PATTERN, (CharSequence)commentText, (String)"");
        }
        return commentText;
    }
}

