/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.r2lparser;

import java.io.File;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.edt.base.model.reflection.Determinant;
import ro.amiq.edt.base.model.reflection.IRfAssociatedType;
import ro.amiq.edt.base.model.reflection.IRfScope;
import ro.amiq.edt.base.model.reflection.RfActionBlockLayer;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfListType;
import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfMethodType;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructLayer;
import ro.amiq.edt.base.model.reflection.RfTemplateStructInstance;
import ro.amiq.edt.base.model.reflection.RfType;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedStruct;
import ro.amiq.edt.base.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.edt.base.r2lparser.R2LCoverItemOption;
import ro.amiq.edt.base.r2lparser.R2LResultContainer;
import ro.amiq.edt.base.r2lparser.R2LScopeContainer;
import ro.amiq.edt.base.r2lparser.R2LTokenizer;
import ro.amiq.edt.base.r2lparser.R2LTreeNode;

public abstract class R2LManager {
    public static final Set<R2LCoverItemOption> fPredefinedItemOptions = new HashSet<R2LCoverItemOption>();
    private static final Set<String> PORT_STRUCT_NAMES;
    public static final int UNDEF_ACCESS = -1;
    public static final int DOT_ACCESS = 0;
    public static final int COLON_ACCESS = 1;
    public static final int COLON_COLON_ACCESS = 2;
    public static final int CLASS_NAME = 1;
    public static final int FUNCTION_NAME = 2;
    public static final int RETURN_NAME = 3;
    public static final int ALL_TYPES = 0;
    public static final int SEQ_ITEM_TYPES = 1;
    protected IRfScope fInitialScope;
    protected IDocument fDocument;
    protected int fOffset;
    protected int fLine;
    protected RfProject fRfProject;
    protected RfModule fModule;
    protected String fModulePackageName;
    protected R2LTokenizer fLexer;
    protected boolean fIsMethodProposal;
    protected boolean fIsNotEventProposal;

    static {
        fPredefinedItemOptions.add(new R2LCoverItemOption("at_least", "= num", "A non-negative integer specifying the minimum number of samples for each bucket of each of the transition items.<br>Anything less than num is considered a hole. The default is 1.<br>This option cannot be used with string items or for unconstrained integers (items that have no specified ranges)."));
        fPredefinedItemOptions.add(new R2LCoverItemOption("first_high_bit", "", "Collect power-of-two coverage. The sampled value is the location of the most significant bit, which is set to 1"));
        fPredefinedItemOptions.add(new R2LCoverItemOption("ignore", "= item-bool-ex", "Define values that are to be completely ignored. They do not appear in the statistics at all.<br> The expression is a Boolean expression that can contain a cover item name and constants.<br>The Boolean expression is evaluated in a global context, not in instances of the struct."));
        fPredefinedItemOptions.add(new R2LCoverItemOption("illegal", "= bool-exp [with dut_error[f] (...)[action-block]]", "Define values that are illegal. An illegal value causes a DUT error.<br>The Boolean expression is evaluated in a global context, not in instances of the struct."));
        fPredefinedItemOptions.add(new R2LCoverItemOption("instance_ignore", "= expr", "Define a context-dependent ignore expression on items in per_unit_instance groups."));
        fPredefinedItemOptions.add(new R2LCoverItemOption("instance_illegal", "= bool-exp [with dut_error[f](...) [action-block]]", "Define a context-dependent illegal expression on items in per_unit_instance groups.<br>This option lets you set illegal expressions for an instance, depending on the scope. An illegal value causes a DUT error."));
        fPredefinedItemOptions.add(new R2LCoverItemOption("instance_no_collect", "= expr", "Define a context-dependent no_collect expression on items in per_unit_instance groups. The expr argument can include an inst field.<br>In the context of an explicit per-unit instance or for cover groups defined under a struct or unit, the inst field contains a pointer to the unit defined by the per_unit_instance option.<br>In the case of an implicit per-unit instance collection of cover groups defined under units, the inst field refers to the enclosing unit."));
        fPredefinedItemOptions.add(new R2LCoverItemOption("instance_ranges", "= expr", "Create context-dependent buckets for this item's values or ranges of values.<br>Can contain constants and global values."));
        fPredefinedItemOptions.add(new R2LCoverItemOption("no_collect", "= bool-exp", "The boolean expression can be a constant (FALSE/TRUE), or a global scope expression \u2013 a reference to a field under sys. <br>When no_collect[=TRUE], this cover item is not displayed in coverage reports and is not saved in the coverage files."));
        fPredefinedItemOptions.add(new R2LCoverItemOption("no_trace", "= bool", "When no_trace[=TRUE], this item is not traced by the simulator. Use this option to collect data for trace event."));
        fPredefinedItemOptions.add(new R2LCoverItemOption("num_of_buckets", "= num", "Specifies how many buckets are to be created for the cover item. This option overrides the max_int_buckets coverage configuration option for this cover item. <br>It cannot be used for string items or items that have ranges specified with the ranges cover item option. <br>It can be set to any value, including greater than max_int_buckets. For items greater than 32 bits, size of each bucket can exceed the 2^32 limit."));
        fPredefinedItemOptions.add(new R2LCoverItemOption("per_instance", "= bool", "When per_instance[=TRUE], coverage data is collected and graded for all the other items in a separate sub-group for each bucket of this item.<br>This option can only be used for gradeable items."));
        fPredefinedItemOptions.add(new R2LCoverItemOption("radix", "=DEC|HEX|BIN", "Legal values are DEC (decimal), HEX (hexadecimal), and BIN (binary). The value must be in upper case letters.<br>If the radix is not used, int or uint bucket names are displayed in decimal."));
        fPredefinedItemOptions.add(new R2LCoverItemOption("ranges", "= {range(parameters);...}", "Create buckets for this item\u2019s values or ranges of values. <br>This option cannot be used for string items. The range() has up to four parameters that specify how the values are separated into buckets.<br> The syntax is: range( range : range, name : string, every-count : int, at_least-num : int)<br>The first parameter, range , is required. The other three are optional."));
        fPredefinedItemOptions.add(new R2LCoverItemOption("text", "= string", "A text description for this cover item. This can only be a quoted string, not a variable or expression.<br>"));
        fPredefinedItemOptions.add(new R2LCoverItemOption("weight", "= int", "Specifies the weight of the current item relative to other items in the same cover group.<br>It is a non-negative integer with a default of 1."));
        fPredefinedItemOptions.add(new R2LCoverItemOption("when", "= bool-exp", "The item is sampled only when bool-exp is TRUE. The bool-exp is evaluated in the context of the parent struct.<br>The sampling is done at run time."));
        fPredefinedItemOptions.add(new R2LCoverItemOption("name", "= label", "Specifies a name for a cross or transition cover item. No white spaces are allowed in the label."));
        PORT_STRUCT_NAMES = RfPredefinedStruct.PORT_STRUCT_NAMES;
    }

    protected R2LManager(RfProject rfProject, IRfScope initialScope, String packageName, ParserPath parserPath, IDocument document, int offset, int line) {
        try {
            this.fModule = rfProject.getModule(parserPath);
            this.fModulePackageName = packageName;
            this.fLine = line;
            this.fInitialScope = initialScope;
            this.fDocument = document;
            this.fOffset = offset;
            this.fRfProject = rfProject;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public abstract RfWNamedElementAndScope getElement();

    public abstract R2LResultContainer getProposals();

    public R2LScopeContainer getScope(R2LScopeContainer scopeContainer, String name, String[] params, boolean methodCall, int arrayKind, boolean asA, boolean isList, int offset) {
        Determinant customDeterminant;
        RfMethod method;
        List<IRfAssociatedType> params2;
        IRfNamedElement assocType;
        if (scopeContainer == null || scopeContainer.scope == null || name == null) {
            return null;
        }
        R2LScopeContainer result = new R2LScopeContainer(scopeContainer);
        if (this.isNumber(name)) {
            result.isNumber = true;
            return result;
        }
        IRfScope scope = scopeContainer.scope;
        RfStruct enclosingStruct = this.getEnclosingStruct(this.fInitialScope);
        RfNamedElement candidate = null;
        boolean bl = asA = asA || name.equals("try_enclosing_unit") || name.equals("get_enclosing_unit");
        if (asA && params != null && params.length == 1) {
            RfType struct;
            String typeName = params[0];
            boolean strictPackage = typeName.contains("::");
            String packageName = strictPackage ? this.extractPackageName(typeName) : this.fModulePackageName;
            int index = -1;
            Determinant determinant = new Determinant(typeName);
            index = typeName.indexOf("of");
            if (index > 0 && index + 2 < typeName.length() && Character.isWhitespace(typeName.charAt(index - 1)) && !Character.isJavaIdentifierPart(typeName.charAt(index + 2))) {
                determinant = new Determinant(typeName.substring(0, index).trim());
            }
            if ((struct = this.fRfProject.getType(packageName, strictPackage, 1, determinant.getName(), -1)) == null) {
                return null;
            }
            if (isList) {
                result.scope = new RfListType(this.fRfProject, struct, typeName, null, 1);
                result.element = struct;
            } else {
                LineInfo line = new LineInfo(0, 0, -1);
                result.scope = new RfStructLayer(determinant.toString(), null, 1, line, line, null, null, null);
                ((RfStructLayer)result.scope).setNamedElement(struct);
                result.element = struct;
            }
            return result;
        }
        boolean portAccess = name.endsWith("$");
        if (portAccess) {
            name = name.substring(0, name.length() - 1);
        } else if ("soft".equals(name) && scope instanceof RfActionBlockLayer) {
            name = "it";
        }
        if (methodCall && (name.equals("value") || name.equals("read_only") || name.equals("deep_copy") || this.fRfProject.isInSLNMode() && name.equals("enabled")) && params != null && params.length == 1) {
            RfModule.IdentifierPosition idPos = this.fModule.getIdentifier(name, offset);
            candidate = idPos == null ? null : idPos.getNamedElement();
            methodCall = false;
        } else if (scope instanceof RfDefElement) {
            candidate = ((RfDefElement)((Object)scope)).semanticGetMember(this.fRfProject, this.fModulePackageName, name, EnumSet.of(IRfNamedElement.ElementKind.E_FIELD, IRfNamedElement.ElementKind.E_METHOD, IRfNamedElement.ElementKind.E_EVENT, IRfNamedElement.ElementKind.E_TYPE, IRfNamedElement.ElementKind.E_VARIABLE), new LineInfo(Integer.MAX_VALUE, offset, -1), this.fModule.getMaxModuleIndex(), this.fModule.getParserPath(), null);
        } else if (scope instanceof RfStruct) {
            candidate = ((RfStruct)scope).semanticGetMember(this.fRfProject, null, this.fModulePackageName, enclosingStruct, name, EnumSet.of(IRfNamedElement.ElementKind.E_FIELD, IRfNamedElement.ElementKind.E_METHOD, IRfNamedElement.ElementKind.E_EVENT, IRfNamedElement.ElementKind.E_TYPE, IRfNamedElement.ElementKind.E_VARIABLE), 31, this.fModule.getMaxModuleIndex(), this.fModule.getParserPath(), null);
        }
        if (methodCall && candidate instanceof IRfAssociatedType && portAccess && (assocType = ((IRfAssociatedType)((Object)candidate)).getAssociatedType()) instanceof RfTemplateStructInstance && "any_method_port".equals(assocType.getName()) && (params2 = ((RfTemplateStructInstance)assocType).getParameters()) != null && params2.size() == 1 && (assocType = params2.get(0).getAssociatedType()) instanceof RfMethodType && (method = ((RfMethodType)assocType).getAssociatedMethod()) != null) {
            candidate = method;
        }
        if (candidate == null && name.equals("apply")) {
            result.element = scopeContainer.element;
            result.scope = scope;
            return result;
        }
        if (candidate == null) {
            candidate = this.fRfProject.getType(this.fModulePackageName, false, -1, name, this.fModule.getMaxModuleIndex());
        }
        if (candidate == null) {
            candidate = this.fRfProject.getPreproc(name);
        }
        result.element = candidate;
        if (arrayKind > 0) {
            scope = null;
            if (candidate instanceof IRfAssociatedType && (scope = (IRfScope)((IRfAssociatedType)((Object)candidate)).getAssociatedType()) instanceof RfListType) {
                customDeterminant = ((RfListType)scope).getAssociatedTypeDeterminant();
                temp = scope = ((RfListType)scope).getAssociatedType();
                if (temp instanceof RfTemplateStructInstance) {
                    temp = ((RfTemplateStructInstance)temp).getTemplateStruct();
                }
                if (temp instanceof RfStruct && PORT_STRUCT_NAMES.contains(temp.getName())) {
                    customDeterminant = null;
                }
                if (scope != null) {
                    scope.setTransientDeterminant(customDeterminant);
                }
            }
        } else {
            scope = null;
            if (candidate instanceof IRfAssociatedType) {
                customDeterminant = ((IRfAssociatedType)((Object)candidate)).getAssociatedTypeDeterminant();
                scope = (IRfScope)((IRfAssociatedType)((Object)candidate)).getAssociatedType();
                temp = scope;
                if (temp instanceof RfListType) {
                    temp = (IRfScope)((IRfAssociatedType)((Object)scope)).getAssociatedType();
                }
                if (temp instanceof RfTemplateStructInstance) {
                    temp = ((RfTemplateStructInstance)temp).getTemplateStruct();
                }
                if (temp instanceof RfStruct && PORT_STRUCT_NAMES.contains(temp.getName())) {
                    customDeterminant = null;
                }
                if (scope != null) {
                    scope.setTransientDeterminant(customDeterminant);
                }
            } else if (candidate instanceof RfType) {
                scope = (RfType)candidate;
                scope.setTransientDeterminant(null);
            }
        }
        if (scope == null && scopeContainer.scope instanceof RfStruct) {
            scope = scopeContainer.scope;
            customDeterminant = new Determinant(new String[]{name, ((RfStruct)scope).getName()});
            scope.setTransientDeterminant(customDeterminant);
        }
        result.scope = scope;
        result.scopeDeterminant = scope instanceof RfStruct ? scope.getTransientDeterminant() : null;
        return result;
    }

    public static String isListOf(String input) {
        if (input == null) {
            return null;
        }
        int index1 = (input = input.trim()).indexOf("list");
        if (index1 != 0) {
            return null;
        }
        int index2 = input.indexOf("of");
        if (index2 < 0) {
            return null;
        }
        int i = 4;
        while (i < index2) {
            char ch = input.charAt(i);
            if (!Character.isWhitespace(ch)) {
                return null;
            }
            ++i;
        }
        char ch = input.charAt(index2 + 2);
        if (Character.isJavaIdentifierPart(ch)) {
            return null;
        }
        String result = input.substring(index2 + 2).trim();
        if (result.charAt(0) == '(' && result.charAt(result.length() - 1) == ')') {
            return result.substring(1, result.length() - 1).trim();
        }
        return result;
    }

    protected String extractPackageName(String subtypeText) {
        int endIndex = subtypeText.indexOf(58);
        if (endIndex == -1) {
            return null;
        }
        subtypeText = subtypeText.substring(0, endIndex);
        int i = subtypeText.length() - 1;
        while (i >= 0) {
            char ch = subtypeText.charAt(i);
            if (Character.isWhitespace(ch)) {
                if (i == subtypeText.length() - 1) {
                    return null;
                }
                return subtypeText.substring(i + 1, subtypeText.length());
            }
            --i;
        }
        return subtypeText;
    }

    protected boolean isNumber(String name) {
        if (name.length() > 2 && name.charAt(0) == '\'') {
            name = name.substring(2);
        }
        return DVTStringUtil.isNumber((String)name);
    }

    public RfStruct getEnclosingStruct(IRfScope scope) {
        IRfScope temp = scope;
        if (temp instanceof RfActionBlockLayer) {
            while ((temp = ((RfActionBlockLayer)temp).getEnclosingScope()) instanceof RfActionBlockLayer) {
            }
        }
        if (temp instanceof RfStructLayer) {
            return ((RfStructLayer)temp).getStruct();
        }
        return null;
    }

    public abstract RfNamedElement[] getStructOrUnits(String var1, String var2, String var3, String var4, String var5);

    public abstract RfNamedElement[] getIfdefCandidates(String var1);

    public abstract RfNamedElement[] getMacroArgumentsCandidates(String var1, String var2);

    public abstract File[] getImportCandidates(String var1);

    public abstract RfNamedElement[] getStructAndUnits(String var1, String var2, boolean var3);

    public abstract RfNamedElement[] getKeepBind(R2LScopeContainer var1, String var2, R2LScopeContainer var3, String var4);

    public abstract RfNamedElement[] getEnumItems(R2LScopeContainer var1, List<String> var2, String var3);

    public abstract RfNamedElement[] getPackages(String var1);

    public abstract RfNamedElement[] getListKey(R2LScopeContainer var1, String var2, String var3);

    public abstract RfNamedElement[] getFieldAndCoverItems(R2LScopeContainer var1, String var2, String var3);

    public abstract RfNamedElement[] getFieldItems(R2LScopeContainer var1, String var2, String var3);

    public abstract RfNamedElement[] getEventItems(R2LScopeContainer var1, String var2, String var3, String var4, boolean var5, boolean var6);

    public abstract RfNamedElement[] getCoverItems(R2LScopeContainer var1, List<String> var2, String var3);

    public abstract RfNamedElement[] getCoverItemOptions(String var1);

    public abstract RfNamedElement[] getExprCandidates(R2LScopeContainer var1, String var2, String var3, String var4, boolean var5);

    public abstract RfNamedElement[] getPreprocessing(String var1);

    public abstract RfNamedElement[] getFieldTypes(R2LScopeContainer var1, String var2, String var3, String var4, int var5, int var6);

    public abstract RfNamedElement[] getExtendType(List<R2LTreeNode> var1, String var2, String var3, String var4, int var5);

    public abstract RfNamedElement[] getWhenSubtype(String var1, String var2, String var3, int var4);

    public abstract RfNamedElement[] getAsAInside(List<R2LTreeNode> var1, R2LScopeContainer var2, String var3, String var4, String var5, int var6);

    public abstract RfNamedElement[] getIsSubtypeOf(R2LScopeContainer var1, String var2, String var3, String var4, int var5);

    public abstract RfNamedElement[] getListOfBitMembers(String var1);

    public abstract RfNamedElement[] getEnumItem(R2LScopeContainer var1, String var2, String var3, String var4);

    public abstract RfNamedElement[] getArgsCandidates(R2LScopeContainer var1, String var2, String var3, int var4, int var5);

    public abstract RfNamedElement[] getDoOrGenSubtype(R2LScopeContainer var1, String var2, String var3, boolean var4, int var5);

    public abstract RfNamedElement[] getCondCandidates(R2LScopeContainer var1, R2LScopeContainer var2, R2LScopeContainer var3, String var4, String var5);

    public abstract RfNamedElement[] getSequenceCandidates(R2LScopeContainer var1, String var2, String var3, String var4);

    public abstract RfNamedElement[] getSLNPlaceFieldItems(R2LScopeContainer var1, String var2);

    public abstract RfNamedElement[] getSLNTokensForDeclaration(String var1);

    public abstract RfNamedElement[] getSDLScenarioInvocations(R2LScopeContainer var1, boolean var2, int var3, String var4);

    public abstract RfNamedElement[] getSDLScenarioArg(R2LScopeContainer var1, boolean var2, String var3, R2LScopeContainer var4, boolean var5, String var6, String var7, boolean var8, List<String> var9);

    public boolean isInSLNMode() {
        return this.fRfProject.isInSLNMode();
    }

    public boolean isInSDLMode() {
        return this.fRfProject.isInSDLMode();
    }
}

