/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.r2lparser;

import antlr.collections.AST;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.model.IDVTProject;
import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.util.MaxNofItemsReached;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.AbstractEModelManager;
import ro.amiq.edt.base.model.CompilationUnitProperties;
import ro.amiq.edt.base.model.IEModel;
import ro.amiq.edt.base.model.IEProject;
import ro.amiq.edt.base.model.reflection.Determinant;
import ro.amiq.edt.base.model.reflection.FullName;
import ro.amiq.edt.base.model.reflection.IRfAssociatedType;
import ro.amiq.edt.base.model.reflection.IRfScope;
import ro.amiq.edt.base.model.reflection.RfActionBlockLayer;
import ro.amiq.edt.base.model.reflection.RfArg;
import ro.amiq.edt.base.model.reflection.RfCoverLayer;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfEnum;
import ro.amiq.edt.base.model.reflection.RfField;
import ro.amiq.edt.base.model.reflection.RfListType;
import ro.amiq.edt.base.model.reflection.RfMacro;
import ro.amiq.edt.base.model.reflection.RfMacroLayer;
import ro.amiq.edt.base.model.reflection.RfMeImplicitVariable;
import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfSDLToolEditorAvoidCallLayer;
import ro.amiq.edt.base.model.reflection.RfSDLToolEditorPrioritizeCallLayer;
import ro.amiq.edt.base.model.reflection.RfScalarType;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructLayer;
import ro.amiq.edt.base.model.reflection.RfStructMember;
import ro.amiq.edt.base.model.reflection.RfTemplateStructInstance;
import ro.amiq.edt.base.model.reflection.RfType;
import ro.amiq.edt.base.model.reflection.RfVar;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedField;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedMethod;
import ro.amiq.edt.base.model.reflection.semantic.RfDummyField;
import ro.amiq.edt.base.model.reflection.semantic.SemanticUtils;
import ro.amiq.edt.base.model.reflection.util.NullProtectedList;
import ro.amiq.edt.base.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.edt.base.r2lparser.R2LAmbiguousType;
import ro.amiq.edt.base.r2lparser.R2LCoverItemOption;
import ro.amiq.edt.base.r2lparser.R2LInfoProposalElement;
import ro.amiq.edt.base.r2lparser.R2LMacroArgument;
import ro.amiq.edt.base.r2lparser.R2LManager;
import ro.amiq.edt.base.r2lparser.R2LNoProposalElement;
import ro.amiq.edt.base.r2lparser.R2LOverrideWizardElement;
import ro.amiq.edt.base.r2lparser.R2LParser;
import ro.amiq.edt.base.r2lparser.R2LResultContainer;
import ro.amiq.edt.base.r2lparser.R2LSDLScenarioInvocationByNameArgElement;
import ro.amiq.edt.base.r2lparser.R2LScopeContainer;
import ro.amiq.edt.base.r2lparser.R2LStructLayerWrapper;
import ro.amiq.edt.base.r2lparser.R2LSubtypeElement;
import ro.amiq.edt.base.r2lparser.R2LToken;
import ro.amiq.edt.base.r2lparser.R2LTokenizer;
import ro.amiq.edt.base.r2lparser.R2LTooltipManager;
import ro.amiq.edt.base.r2lparser.R2LTreeNode;
import ro.amiq.edt.base.r2lparser.R2LUtils;
import ro.amiq.edt.base.r2lparser.R2LWalker;
import ro.amiq.edt.base.ui.editor.override.OverrideMethodsUtils;

public class R2LProposalManager
extends R2LManager {
    public static final int MAX_NOF_TOTAL_PROPOSALS = 500;
    public static final long INCDIR_PROPOSALS_TIMEOUT = 2000L;
    public static final long MAX_NOF_INCDIR_PROPOSALS = 20L;
    public static final File DUMMY_TIMEOUT_FILE = new File("TIMEOUT");
    public static final File DUMMY_NUMBER_FILE = new File("NUMBER");
    private static final Pattern MACRO_NAME_PATTERN = Pattern.compile("<[a-zA-Z0-9'_]+>");
    private int fMatchType;
    private AbstractEModelManager fEModelManager;

    public R2LProposalManager(IEPluginConfig pluginConfig, RfProject rfProject, IRfScope initialScope, String packageName, ParserPath parserPath, IDocument document, int offset, int line) {
        super(rfProject, initialScope, packageName, parserPath, document, offset, line);
        boolean ignoreCase = pluginConfig.getPlugin().getPreferenceStore().getBoolean("ca.ignore_case");
        boolean camelCase = pluginConfig.getPlugin().getPreferenceStore().getBoolean("ca.camel_case");
        boolean prefixMatch = pluginConfig.getPlugin().getPreferenceStore().getBoolean("ca.prefix_match");
        this.fMatchType = (ignoreCase ? 8 : 0) | (camelCase ? 4 : 0) | (prefixMatch || !camelCase ? 2 : 0);
        this.fEModelManager = pluginConfig.getModelManager();
    }

    public R2LProposalManager(IEPluginConfig pluginConfig, RfProject rfProject, IRfScope initialScope, String packageName, ParserPath parserPath, IDocument document, int offset, int line, boolean wordDistanceSearch) {
        super(rfProject, initialScope, packageName, parserPath, document, offset, line);
        this.fMatchType = 48;
        this.fEModelManager = pluginConfig.getModelManager();
    }

    @Override
    public RfWNamedElementAndScope getElement() {
        return null;
    }

    @Override
    public R2LResultContainer getProposals() {
        block14: {
            try {
                if (this.fInitialScope != null) break block14;
                return null;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return null;
            }
        }
        R2LResultContainer result = null;
        R2LScopeContainer scopeContainer = new R2LScopeContainer(this.fInitialScope);
        this.fLexer = new R2LTokenizer(this.fRfProject, this.fModule, this.fDocument, this.fOffset, false);
        R2LParser parser = new R2LParser(this.fLexer, false);
        parser.setASTNodeClass(R2LTreeNode.class);
        R2LWalker walker = new R2LWalker(this);
        walker.setASTNodeClass(R2LTreeNode.class);
        if (this.fRfProject.isInSLNMode()) {
            parser.sln_rules();
        } else if (this.fRfProject.isInSDLMode()) {
            boolean fallBackToDefaultRules = true;
            if (this.fInitialScope instanceof RfActionBlockLayer && RfActionBlockLayer.ActionKind.SDL_SCENARIO_INVOCATION == ((RfActionBlockLayer)this.fInitialScope).getActionKind()) {
                fallBackToDefaultRules = false;
                parser.sdl_scenario_invocation_rules();
            } else if (this.fInitialScope instanceof RfStructLayer && ((RfStructLayer)this.fInitialScope).getStruct().isSDLScenario()) {
                fallBackToDefaultRules = false;
                parser.sdl_do_scenario_invocation_rules();
            }
            if (!fallBackToDefaultRules && parser.getAST() == null) {
                fallBackToDefaultRules = true;
                this.fLexer = new R2LTokenizer(this.fRfProject, this.fModule, this.fDocument, this.fOffset, false);
                parser = new R2LParser(this.fLexer, false);
                parser.setASTNodeClass(R2LTreeNode.class);
            }
            if (fallBackToDefaultRules) {
                parser.sdl_rules();
            }
        } else {
            RfMacro macroScope = this.getMacroScope();
            parser.rules(macroScope != null ? macroScope.getName() : null);
        }
        AST pAST = parser.getAST();
        if (pAST != null) {
            walker.fStartsWithWhiteSpace = this.fLexer.fStartsWithWhiteSpace;
            result = walker.rules(pAST, scopeContainer);
        }
        if (result == null || !result.isNumber && !result.hasProposals() && result.rule != 176) {
            List<String> path = result == null ? null : result.path;
            result = new R2LResultContainer();
            result.candidates = new RfNamedElement[]{new R2LNoProposalElement()};
            result.prefix = "";
            result.path = path;
        }
        result.initialScope = this.fInitialScope;
        return result;
    }

    private RfMacro getMacroScope() throws BadLocationException {
        IRfScope scope = this.fInitialScope;
        if (!(scope instanceof RfModule)) {
            while (scope != null && !(scope.getEnclosingScope() instanceof RfModule)) {
                scope = scope.getEnclosingScope();
            }
            if (!(scope instanceof RfActionBlockLayer) || !(scope.getEnclosingScope() instanceof RfModule)) {
                return null;
            }
            scope = scope.getEnclosingScope();
        }
        if (!(scope instanceof RfModule)) {
            return null;
        }
        int lineOfOffset = this.fDocument.getLineOfOffset(this.fOffset);
        List<RfMacroLayer> macroLayers = ((RfModule)scope).getMacrosLayers(lineOfOffset + 1);
        if (macroLayers == null || macroLayers.isEmpty()) {
            return null;
        }
        RfMacroLayer macroLayer = macroLayers.get(0);
        if (macroLayer.getEndOffset() < this.fOffset) {
            return null;
        }
        RfNamedElement macroScope = macroLayer.getNamedElement();
        return macroScope instanceof RfMacro ? (RfMacro)macroScope : null;
    }

    @Override
    public RfNamedElement[] getStructOrUnits(String currentPackageName, String currentStructName, String likePackageName, String prefix, String kind) {
        if (this.fRfProject.isInSLNMode() && "component".equals(kind)) {
            Collection<RfStruct> candidates = this.fRfProject.getAllPackages();
            if (candidates == null) {
                return new RfNamedElement[]{new R2LNoProposalElement()};
            }
            Iterator<RfStruct> iterator = candidates.iterator();
            while (iterator.hasNext()) {
                RfStruct candidate = iterator.next();
                if (!candidate.isSLNComponent()) {
                    iterator.remove();
                    continue;
                }
                if (!DVTStringUtil.regionMatches((String)candidate.getName(), (String)prefix, (int)this.fMatchType)) {
                    iterator.remove();
                    continue;
                }
                if (candidate.getName().equals(currentStructName) && (currentPackageName == null || currentPackageName.equals(candidate.getPackageName()))) {
                    iterator.remove();
                    continue;
                }
                if (likePackageName == null || likePackageName.equals(candidate.getPackageName())) continue;
                iterator.remove();
            }
            RfNamedElement[] sortedCandidates = candidates.toArray(new RfNamedElement[candidates.size()]);
            Arrays.sort(sortedCandidates, R2LUtils.getLexicalSorter(prefix, this.fRfProject.getLanguageKind()));
            return sortedCandidates;
        }
        if (this.fRfProject.isInSDLMode() && "agent".equals(kind)) {
            Collection<RfStruct> candidates = this.fRfProject.getAllPackages();
            if (candidates == null) {
                return new RfNamedElement[]{new R2LNoProposalElement()};
            }
            Iterator<RfStruct> iterator = candidates.iterator();
            while (iterator.hasNext()) {
                RfStruct candidate = iterator.next();
                if (!candidate.isSDLAgent()) {
                    iterator.remove();
                    continue;
                }
                if (!DVTStringUtil.regionMatches((String)candidate.getName(), (String)prefix, (int)this.fMatchType)) {
                    iterator.remove();
                    continue;
                }
                if (candidate.getName().equals(currentStructName) && (currentPackageName == null || currentPackageName.equals(candidate.getPackageName()))) {
                    iterator.remove();
                    continue;
                }
                if (likePackageName == null || likePackageName.equals(candidate.getPackageName())) continue;
                iterator.remove();
            }
            RfNamedElement[] sortedCandidates = candidates.toArray(new RfNamedElement[candidates.size()]);
            Arrays.sort(sortedCandidates, R2LUtils.getLexicalSorter(prefix, this.fRfProject.getLanguageKind()));
            return sortedCandidates;
        }
        List<RfStruct> candidates = this.fRfProject.getStructsWithPrefix(this.fMatchType, prefix);
        if (candidates == null) {
            return new RfNamedElement[]{new R2LNoProposalElement()};
        }
        Iterator<RfStruct> iterator = candidates.iterator();
        while (iterator.hasNext()) {
            RfStruct candidate = iterator.next();
            if (candidate.isUnit() && !"unit".equals(kind) || candidate.isSLNAction() && !"action".equals(kind) || candidate.isSDLScenario() && !"scenario".equals(kind)) {
                iterator.remove();
                continue;
            }
            if (candidate.getName().equals(currentStructName) && (currentPackageName == null || currentPackageName.equals(candidate.getPackageName()))) {
                iterator.remove();
                continue;
            }
            if (likePackageName == null || likePackageName.equals(candidate.getPackageName())) continue;
            iterator.remove();
        }
        RfNamedElement[] sortedCandidates = candidates.toArray(new RfNamedElement[candidates.size()]);
        Arrays.sort(sortedCandidates, R2LUtils.getLexicalSorter(prefix, this.fRfProject.getLanguageKind()));
        return sortedCandidates;
    }

    @Override
    public RfNamedElement[] getIfdefCandidates(String prefix) {
        List<RfMacro> candidates = this.fRfProject.getPreprocesingWithPrefix(this.fMatchType, prefix);
        if (candidates == null) {
            return new RfNamedElement[]{new R2LNoProposalElement()};
        }
        Iterator<RfMacro> iterator = candidates.iterator();
        while (iterator.hasNext()) {
            RfMacro candidate = iterator.next();
            if (candidate.isPreprocessing()) continue;
            iterator.remove();
        }
        RfNamedElement[] sortedCandidates = candidates.toArray(new RfNamedElement[candidates.size()]);
        Arrays.sort(sortedCandidates, R2LUtils.getLexicalSorter(prefix, this.fRfProject.getLanguageKind()));
        return sortedCandidates;
    }

    @Override
    public RfNamedElement[] getMacroArgumentsCandidates(String macroName, String prefix) {
        RfMacro macro = this.fRfProject.getMacro(macroName);
        if (macro == null) {
            return new RfNamedElement[]{new R2LNoProposalElement()};
        }
        String stringLiteral = macro.getStringLiteral();
        ArrayList<String> arguments = new ArrayList<String>();
        Matcher matcher = MACRO_NAME_PATTERN.matcher(stringLiteral);
        while (matcher.find()) {
            String group = matcher.group();
            if (group == null || group.isEmpty()) continue;
            group = DVTStringUtil.replace((String)group, (String)"<", (String)"", (boolean)true);
            group = DVTStringUtil.replace((String)group, (String)">", (String)"", (boolean)true);
            arguments.add(group);
        }
        List<RfNamedElement> candidates = arguments.stream().filter(s -> s.startsWith(prefix)).map(element -> new R2LMacroArgument((String)element)).collect(Collectors.toList());
        if (candidates == null) {
            return new RfNamedElement[]{new R2LNoProposalElement()};
        }
        RfNamedElement[] sortedCandidates = candidates.toArray(new RfNamedElement[candidates.size()]);
        Arrays.sort(sortedCandidates, R2LUtils.getLexicalSorter(prefix, this.fRfProject.getLanguageKind()));
        return sortedCandidates;
    }

    @Override
    public File[] getImportCandidates(String pattern) {
        if (this.fModule == null || this.fModule.getParserPath() == null) {
            return null;
        }
        if (pattern == null) {
            pattern = "";
        }
        IEModel eModel = this.fEModelManager.getEModel();
        IProject project = this.fRfProject.getProject();
        IEProject eProject = eModel.getEProject(project);
        String finalPattern = pattern.replaceFirst("([^" + File.separator + "]*" + File.separator + ")*", "");
        TreeMap<String, File> includeCandidates = new TreeMap<String, File>();
        String[] fileExtensions = null;
        fileExtensions = this.fModule.isSLN() ? DVTFileUtils.getInstance().getExtensionsForContentType("ro.amiq.slndt.SLNSource", false) : DVTFileUtils.getInstance().getExtensionsForContentType("ro.amiq.edt.ESource", false);
        HashSet<String> incDirs = new HashSet<String>();
        CompilationUnitProperties compilationUnitProperties = eProject.getCompilationUnitProperties(false);
        if (!compilationUnitProperties.hasFilesToCompile()) {
            return null;
        }
        String rawSpecmanPath = compilationUnitProperties.getDvtSpecmanPath();
        if (rawSpecmanPath != null && rawSpecmanPath.length() != 0) {
            String[] specmanPath = DVTStringUtil.split((String)IDVTProject.DEFAULT_PATH_SPLIT_SEPARATOR, (String)rawSpecmanPath);
            incDirs.addAll(Arrays.asList(specmanPath));
        }
        incDirs.add(new File(this.fModule.getParserPath().path).getParent());
        for (String incDir : incDirs) {
            String finalFolder;
            if (incDir.isEmpty() || !Path.fromOSString((String)(finalFolder = String.valueOf(incDir.replaceFirst(String.valueOf(File.separator) + "$", "")) + File.separator + pattern.replaceFirst("[^" + File.separator + "]*$", ""))).toFile().isDirectory() || finalPattern.startsWith(File.separator)) continue;
            ArrayList<File> listResult = new ArrayList<File>();
            new SafeFileLister(listResult, Path.fromOSString((String)finalFolder).toFile(), fileExtensions, finalPattern, 20L, 2000L).listFilesSafely();
            for (File file : listResult) {
                if (file.equals(new File(this.fModule.getParserPath().path))) continue;
                includeCandidates.put(String.valueOf(file.getName()) + (file.isDirectory() ? File.separator : ""), file);
            }
        }
        return includeCandidates.values().toArray(new File[includeCandidates.size()]);
    }

    @Override
    public RfNamedElement[] getKeepBind(R2LScopeContainer leftScopeContainer, String leftPort, R2LScopeContainer scopeContainer, String prefix) {
        if (scopeContainer == null || scopeContainer.scope == null) {
            return new RfNamedElement[]{new R2LNoProposalElement()};
        }
        int direction = 0;
        if (leftPort != null && leftScopeContainer != null && leftScopeContainer.scope != null) {
            List<RfField> fields;
            if (leftPort.endsWith("$")) {
                leftPort = leftPort.substring(0, leftPort.length() - 1);
            }
            if ((fields = leftScopeContainer.scope.getFieldsWithPrefix(null, this.getEnclosingStruct(this.fInitialScope), 1, leftPort, 31)) != null && !fields.isEmpty()) {
                direction = fields.get(0).isInput() ? 1 : (fields.get(0).isOutput() ? 2 : 0);
            }
        }
        NullProtectedList<RfStructMember> candidates = new NullProtectedList<RfStructMember>();
        candidates.setMaxNofItems(500);
        try {
            List<RfMethod> methods;
            List<RfField> fields = scopeContainer.scope.getFieldsWithPrefix(null, this.getEnclosingStruct(this.fInitialScope), this.fMatchType, prefix, 31);
            if (fields != null) {
                for (RfField field : fields) {
                    if (direction == 0 && !(field.getAssociatedType() instanceof RfScalarType)) {
                        candidates.add(field);
                        continue;
                    }
                    if (!field.isPort()) {
                        candidates.add(field);
                        continue;
                    }
                    if (direction == 1 && (field.isOutput() || field.isInout())) {
                        candidates.add(field);
                        continue;
                    }
                    if (direction != 2 || !field.isInput() && !field.isInout()) continue;
                    candidates.add(field);
                }
            }
            if ((methods = scopeContainer.scope.getMethodsWithPrefix(null, this.getEnclosingStruct(this.fInitialScope), this.fMatchType, prefix, 31)) != null) {
                for (RfMethod method : methods) {
                    if (direction != 0 || method.getAssociatedType() == null || method.getAssociatedType() instanceof RfScalarType || method.getAssociatedTypeName().equals("string")) continue;
                    candidates.add(method);
                }
            }
        }
        catch (MaxNofItemsReached maxNofItemsReached) {}
        if (candidates.isEmpty()) {
            return new RfNamedElement[]{new R2LNoProposalElement()};
        }
        RfNamedElement[] sortedCandidates = candidates.toArray(new RfNamedElement[candidates.size()]);
        Arrays.sort(sortedCandidates, R2LUtils.getContextSorter(prefix, this.fRfProject.getLanguageKind()));
        return sortedCandidates;
    }

    @Override
    public RfNamedElement[] getEnumItems(R2LScopeContainer scopeContainer, List<String> enums, String prefix) {
        List<RfEnum> candidates;
        if (scopeContainer == null || scopeContainer.scope == null) {
            return null;
        }
        RfNamedElement element = scopeContainer.element;
        RfScalarType enumScope = this.computePortType(element);
        IRfScope scope = scopeContainer.scope;
        List<RfEnum> list = candidates = enumScope == null ? scope.getEnumsWithPrefix(this.fMatchType, prefix) : enumScope.getEnumsWithPrefix(this.fMatchType, prefix);
        if (candidates == null || candidates.isEmpty()) {
            return null;
        }
        Iterator<RfEnum> iterator = candidates.iterator();
        while (iterator.hasNext()) {
            RfEnum candidate = iterator.next();
            if (enums == null || !enums.contains(candidate.getName())) continue;
            iterator.remove();
        }
        RfNamedElement[] sortedCandidates = candidates.toArray(new RfNamedElement[candidates.size()]);
        Arrays.sort(sortedCandidates, R2LUtils.getLexicalSorter(prefix, this.fRfProject.getLanguageKind()));
        return sortedCandidates;
    }

    private RfScalarType computePortType(RfNamedElement element) {
        if (!(element instanceof RfField) || !((RfField)element).isPort()) {
            return null;
        }
        RfType associatedType = ((RfField)element).getAssociatedType();
        if (!(associatedType instanceof RfTemplateStructInstance)) {
            return null;
        }
        List<IRfAssociatedType> parameters = ((RfTemplateStructInstance)associatedType).getParameters();
        if (parameters == null || parameters.size() != 1) {
            return null;
        }
        IRfAssociatedType type = parameters.get(0);
        if (!(type instanceof RfDummyField) || !(type.getAssociatedType() instanceof RfScalarType)) {
            return null;
        }
        return (RfScalarType)type.getAssociatedType();
    }

    @Override
    public RfNamedElement[] getPackages(String prefix) {
        List<RfStruct> candidates = this.getPackagesWithPrefix(this.fMatchType, prefix);
        RfNamedElement[] sortedCandidates = candidates.toArray(new RfNamedElement[candidates.size()]);
        Arrays.sort(sortedCandidates, R2LUtils.getLexicalSorter(prefix, this.fRfProject.getLanguageKind()));
        return sortedCandidates;
    }

    @Override
    public RfNamedElement[] getFieldAndCoverItems(R2LScopeContainer scopeContainer, String packageName, String prefix) {
        List<RfVar> candidates2;
        if (scopeContainer == null || scopeContainer.scope == null) {
            return new RfNamedElement[]{new R2LNoProposalElement()};
        }
        IRfScope scope = scopeContainer.scope;
        int accessModifier = 31;
        ArrayList<RfNamedElement> candidates = new ArrayList<RfNamedElement>();
        List<RfField> candidates1 = scope.getFieldsWithPrefix(this.fModulePackageName, this.getEnclosingStruct(this.fInitialScope), this.fMatchType, prefix, accessModifier);
        if (candidates1 != null) {
            candidates.addAll(candidates1);
        }
        while (scope != null && !(scope instanceof RfCoverLayer)) {
            scope = scope.getEnclosingScope();
        }
        if (scope instanceof RfCoverLayer && (candidates2 = scope.getVariablesWithPrefix(Integer.MAX_VALUE, this.fMatchType, prefix)) != null) {
            candidates.addAll(candidates2);
        }
        if (candidates.isEmpty()) {
            return new RfNamedElement[]{new R2LNoProposalElement()};
        }
        RfNamedElement[] sortedCandidates = candidates.toArray(new RfNamedElement[candidates.size()]);
        Arrays.sort(sortedCandidates, R2LUtils.getContextSorter(prefix, this.fRfProject.getLanguageKind()));
        return sortedCandidates;
    }

    @Override
    public RfNamedElement[] getFieldItems(R2LScopeContainer scopeContainer, String packageName, String prefix) {
        if (scopeContainer == null || scopeContainer.scope == null) {
            return new RfNamedElement[]{new R2LNoProposalElement()};
        }
        IRfScope scope = scopeContainer.scope;
        int accessModifier = 31;
        boolean structInsteadOfMember = false;
        if (packageName == null) {
            packageName = this.fModulePackageName;
        } else {
            RfStruct packg = this.fRfProject.getPackage(packageName);
            if (packg != null) {
                structInsteadOfMember = true;
            }
        }
        List<RfNamedElement> candidates = null;
        candidates = structInsteadOfMember ? this.fRfProject.getStructsWithPrefix(this.fMatchType, prefix) : scope.getFieldsWithPrefix(this.fModulePackageName, this.getEnclosingStruct(this.fInitialScope), this.fMatchType, prefix, accessModifier);
        if (candidates == null || candidates.isEmpty()) {
            return new RfNamedElement[]{new R2LNoProposalElement()};
        }
        RfNamedElement[] sortedCandidates = candidates.toArray(new RfNamedElement[candidates.size()]);
        Arrays.sort(sortedCandidates, R2LUtils.getLexicalSorter(prefix, this.fRfProject.getLanguageKind()));
        return sortedCandidates;
    }

    @Override
    public RfNamedElement[] getSLNPlaceFieldItems(R2LScopeContainer scopeContainer, String prefix) {
        return new RfNamedElement[]{new R2LNoProposalElement()};
    }

    @Override
    public RfNamedElement[] getEventItems(R2LScopeContainer scopeContainer, String packageName, String structName, String prefix, boolean eventsOnly, boolean noMethods) {
        if (scopeContainer == null || scopeContainer.scope == null) {
            return new RfNamedElement[]{new R2LNoProposalElement()};
        }
        IRfScope scope = scopeContainer.scope;
        RfStruct enclosingStruct = this.getEnclosingStruct(this.fInitialScope);
        boolean structInsteadOfMember = false;
        boolean onlyStatic = false;
        if (packageName == null) {
            packageName = this.fModulePackageName;
        } else if (structName == null) {
            RfStruct packg = this.fRfProject.getPackage(packageName);
            if (packg != null) {
                structInsteadOfMember = true;
            } else {
                scope = this.fRfProject.getType(this.fModulePackageName, false, 1, packageName, Integer.MAX_VALUE);
                packageName = this.fModulePackageName;
                onlyStatic = true;
            }
        } else {
            scope = this.fRfProject.getType(packageName, false, 1, structName, Integer.MAX_VALUE);
            onlyStatic = true;
        }
        if (scope == null) {
            return new RfNamedElement[]{new R2LNoProposalElement()};
        }
        NullProtectedList<RfNamedElement> candidates = new NullProtectedList<RfNamedElement>();
        candidates.setMaxNofItems(500);
        try {
            if (structInsteadOfMember) {
                candidates.addAll(this.fRfProject.getStructsWithPrefix(this.fMatchType, prefix));
            } else if (onlyStatic) {
                candidates.addAll(this.filterNonStatic(scope.getEventsWithPrefix(packageName, enclosingStruct, this.fMatchType, prefix, 31)));
            } else {
                candidates.addAll(scope.getEventsWithPrefix(this.fModulePackageName, this.getEnclosingStruct(this.fInitialScope), this.fMatchType, prefix, 31));
                if (!eventsOnly) {
                    candidates.addAll(scope.getVariablesWithPrefix(this.fLine, this.fMatchType, prefix));
                    candidates.addAll(scope.getArgumentsWithPrefix(this.fMatchType, prefix));
                    candidates.addAll(scope.getFieldsWithPrefix(this.fModulePackageName, enclosingStruct, this.fMatchType, prefix, 31));
                    if (!noMethods) {
                        candidates.addAll(scope.getMethodsWithPrefix(this.fModulePackageName, enclosingStruct, this.fMatchType, prefix, 31));
                    }
                    if (scopeContainer.path == null || scopeContainer.path.isEmpty()) {
                        RfPredefinedField comp;
                        RfMeImplicitVariable me;
                        List<RfField> fields = this.fRfProject.getGlobalFieldsWithPrefix(this.fModulePackageName, this.fMatchType, prefix);
                        if (fields != null) {
                            for (RfField field : fields) {
                                if (candidates.contains(field)) continue;
                                candidates.add(field);
                            }
                        }
                        List<RfMethod> methods = this.fRfProject.getGlobalMethodsWithPrefix(this.fModulePackageName, this.fMatchType, prefix);
                        if (!noMethods && methods != null) {
                            for (RfMethod method : methods) {
                                if (candidates.contains(method)) continue;
                                candidates.add(method);
                            }
                        }
                        if ((me = scope.getMeImplicitVariable(this.fMatchType, prefix)) != null && !candidates.contains(me)) {
                            candidates.add(me);
                        }
                        if ((comp = scope.getCompImplicitVariable(this.fRfProject, this.fMatchType, prefix)) != null && !candidates.contains(comp)) {
                            candidates.add(comp);
                        }
                    }
                }
            }
        }
        catch (MaxNofItemsReached maxNofItemsReached) {}
        if (candidates.isEmpty()) {
            return new RfNamedElement[]{new R2LNoProposalElement()};
        }
        Iterator iterator = candidates.iterator();
        while (iterator.hasNext()) {
            RfNamedElement candidate = (RfNamedElement)iterator.next();
            if (candidate.getName().equals("rf_manager")) continue;
            if (candidate instanceof RfField && (((RfField)candidate).getAssociatedType() == null || !(((RfField)candidate).getAssociatedType() instanceof RfStruct))) {
                iterator.remove();
                continue;
            }
            if (candidate instanceof RfMethod && (((RfMethod)candidate).getAssociatedType() == null || !(((RfMethod)candidate).getAssociatedType() instanceof RfStruct))) {
                iterator.remove();
                continue;
            }
            if (!(candidate instanceof RfVar) || ((RfVar)candidate).getAssociatedType() != null && ((RfVar)candidate).getAssociatedType() instanceof RfStruct) continue;
            iterator.remove();
        }
        RfNamedElement[] sortedCandidates = candidates.toArray(new RfNamedElement[candidates.size()]);
        Arrays.sort(sortedCandidates, R2LUtils.getContextSorter(prefix, this.fRfProject.getLanguageKind()));
        return sortedCandidates;
    }

    @Override
    public RfNamedElement[] getCoverItems(R2LScopeContainer scopeContainer, List<String> items, String prefix) {
        if (scopeContainer == null || scopeContainer.scope == null) {
            return new RfNamedElement[]{new R2LNoProposalElement()};
        }
        IRfScope scope = scopeContainer.scope;
        while (scope != null && !(scope instanceof RfCoverLayer)) {
            scope = scope.getEnclosingScope();
        }
        if (scope == null || !(scope instanceof RfCoverLayer)) {
            return new RfNamedElement[]{new R2LNoProposalElement()};
        }
        List<RfVar> candidates = scope.getVariablesWithPrefix(Integer.MAX_VALUE, this.fMatchType, prefix);
        if (candidates == null || candidates.isEmpty()) {
            return new RfNamedElement[]{new R2LNoProposalElement()};
        }
        Iterator<RfVar> iterator = candidates.iterator();
        while (iterator.hasNext()) {
            RfVar candidate = iterator.next();
            if (items == null || !items.contains(candidate.getName())) continue;
            iterator.remove();
        }
        RfNamedElement[] sortedCandidates = candidates.toArray(new RfNamedElement[candidates.size()]);
        Arrays.sort(sortedCandidates, R2LUtils.getLexicalSorter(prefix, this.fRfProject.getLanguageKind()));
        return sortedCandidates;
    }

    @Override
    public RfNamedElement[] getCoverItemOptions(String prefix) {
        ArrayList candidates = new ArrayList(fPredefinedItemOptions);
        Iterator iterator = candidates.iterator();
        while (iterator.hasNext()) {
            R2LCoverItemOption candidate = (R2LCoverItemOption)iterator.next();
            if (prefix == null || candidate.getName().startsWith(prefix)) continue;
            iterator.remove();
        }
        RfNamedElement[] sortedCandidates = candidates.toArray(new RfNamedElement[candidates.size()]);
        Arrays.sort(sortedCandidates, R2LUtils.getLexicalSorter(prefix, this.fRfProject.getLanguageKind()));
        return sortedCandidates;
    }

    @Override
    public RfNamedElement[] getExprCandidates(R2LScopeContainer scopeContainer, String packageName, String structName, String prefix, boolean noProposalReturn) {
        if (scopeContainer == null || scopeContainer.scope == null) {
            if (noProposalReturn) {
                return new RfNamedElement[]{new R2LNoProposalElement()};
            }
            return null;
        }
        IRfScope scope = scopeContainer.scope;
        boolean structInsteadOfMember = false;
        boolean onlyStatic = false;
        if (packageName == null) {
            packageName = this.fModulePackageName;
        } else if (structName == null) {
            RfStruct packg = this.fRfProject.getPackage(packageName);
            if (packg != null) {
                structInsteadOfMember = true;
            } else {
                scope = this.fRfProject.getType(this.fModulePackageName, false, 1, packageName, Integer.MAX_VALUE);
                packageName = this.fModulePackageName;
                onlyStatic = true;
            }
        } else {
            scope = this.fRfProject.getType(packageName, false, 1, structName, Integer.MAX_VALUE);
            onlyStatic = true;
        }
        if (scope == null) {
            return new RfNamedElement[]{new R2LNoProposalElement()};
        }
        RfStruct enclosingStruct = this.getEnclosingStruct(this.fInitialScope);
        NullProtectedList<RfNamedElement> candidates = new NullProtectedList<RfNamedElement>();
        candidates.setMaxNofItems(500);
        try {
            if (structInsteadOfMember) {
                candidates.addAll(this.fRfProject.getStructsWithPrefix(this.fMatchType, prefix));
            } else if (onlyStatic) {
                candidates.addAll(this.filterNonStatic(scope.getFieldsWithPrefix(packageName, enclosingStruct, this.fMatchType, prefix, 31)));
                candidates.addAll(this.filterNonStatic(scope.getMethodsWithPrefix(packageName, enclosingStruct, this.fMatchType, prefix, 31)));
            } else {
                if (scopeContainer.path == null || scopeContainer.path.isEmpty()) {
                    candidates.addAll(scope.getEnumsWithPrefix(this.fMatchType, prefix));
                }
                int index = candidates.size();
                candidates.addAll(scope.getVariablesWithPrefix(this.fLine, this.fMatchType, prefix));
                candidates.addAll(scope.getArgumentsWithPrefix(this.fMatchType, prefix));
                candidates.addAll(scope.getFieldsWithPrefix(packageName, enclosingStruct, this.fMatchType, prefix, 31));
                int i = index;
                while (i < candidates.size()) {
                    RfNamedElement candidate = (RfNamedElement)candidates.get(i);
                    if (!(candidate instanceof IRfAssociatedType) || !(candidate instanceof RfField) || ((RfField)candidate).getDirection() == 1) {
                        // empty if block
                    }
                    ++i;
                }
                candidates.addAll(scope.getMethodsWithPrefix(packageName, enclosingStruct, this.fMatchType, prefix, 31));
                if (scopeContainer.path != null && !scopeContainer.path.isEmpty() && "as_a".startsWith(prefix)) {
                    candidates.add(new RfPredefinedMethod(this.fRfProject, this.fRfProject.getSpecman().getPseudoStruct(this.fRfProject), "as_a", "type", "type", null, "Cast pseudo-method."));
                }
                if (scopeContainer.path == null || scopeContainer.path.isEmpty()) {
                    RfPredefinedField comp;
                    RfMeImplicitVariable me;
                    List<RfMethod> methods;
                    List<RfField> fields = this.fRfProject.getGlobalFieldsWithPrefix(packageName, this.fMatchType, prefix);
                    if (fields != null) {
                        for (RfField field : fields) {
                            if (candidates.contains(field)) continue;
                            candidates.add(field);
                        }
                    }
                    if ((methods = this.fRfProject.getGlobalMethodsWithPrefix(packageName, this.fMatchType, prefix)) != null) {
                        for (RfMethod method : methods) {
                            if (candidates.contains(method)) continue;
                            candidates.add(method);
                        }
                    }
                    if ((me = scope.getMeImplicitVariable(this.fMatchType, prefix)) != null && !candidates.contains(me)) {
                        candidates.add(me);
                    }
                    if ((comp = scope.getCompImplicitVariable(this.fRfProject, this.fMatchType, prefix)) != null && !candidates.contains(comp)) {
                        candidates.add(comp);
                    }
                }
                if (scopeContainer.path == null || scopeContainer.path.isEmpty()) {
                    List<RfMacro> preproc = this.fRfProject.getPreprocesingWithPrefix(this.fMatchType, prefix);
                    candidates.addAll(preproc);
                }
                if (scopeContainer.path == null || scopeContainer.path.isEmpty()) {
                    List<RfStruct> packages = this.getPackagesWithPrefix(this.fMatchType, prefix);
                    candidates.addAll(packages);
                }
            }
        }
        catch (MaxNofItemsReached maxNofItemsReached) {}
        RfNamedElement[] sortedCandidates = candidates.toArray(new RfNamedElement[candidates.size()]);
        Arrays.sort(sortedCandidates, R2LUtils.getContextSorter(prefix, this.fRfProject.getLanguageKind()));
        if (this.fLexer.isShowMethodOverridesWizard()) {
            sortedCandidates = this.addOverrideMethodsWizardElement(sortedCandidates, prefix);
        }
        return sortedCandidates;
    }

    private Collection<? extends RfStructMember> filterNonStatic(List<? extends RfStructMember> members) {
        if (members == null) {
            return null;
        }
        ArrayList<RfStructMember> result = new ArrayList<RfStructMember>();
        for (RfStructMember rfStructMember : members) {
            if (!rfStructMember.isStatic()) continue;
            result.add(rfStructMember);
        }
        return result;
    }

    private RfNamedElement[] addOverrideMethodsWizardElement(RfNamedElement[] candidates, String prefix) {
        RfStructLayer struct;
        RfDefElement defElement = null;
        boolean disableWizards = false;
        if (this.fInitialScope instanceof RfDefElement) {
            defElement = (RfDefElement)((Object)this.fInitialScope);
            Collection children = ((RfDefElement)((Object)this.fInitialScope)).getChildren();
            if (children != null && !children.isEmpty()) {
                for (RfDefElement child : children) {
                    if ((child.getStartOffset() > this.fOffset || child.getEndOffset() < this.fOffset) && (child.getStartLine() != this.fLine || this.isAFieldWithSameNameAsType(child))) continue;
                    disableWizards = true;
                    break;
                }
            }
        } else if (this.fInitialScope instanceof RfNamedElement) {
            defElement = ((RfNamedElement)((Object)this.fInitialScope)).getDeclaration();
        }
        if (!disableWizards && defElement != null && defElement instanceof RfStructLayer && OverrideMethodsUtils.INSTANCE.checkOverrideContext(this.fOffset, struct = (RfStructLayer)defElement, prefix)) {
            R2LOverrideWizardElement r2lOverrideMethodElement = new R2LOverrideWizardElement(this.fRfProject, struct);
            RfNamedElement[] newCandidates = new RfNamedElement[candidates.length + 1];
            newCandidates[0] = r2lOverrideMethodElement;
            System.arraycopy(candidates, 0, newCandidates, 1, candidates.length);
            candidates = newCandidates;
        }
        return candidates;
    }

    private boolean isAFieldWithSameNameAsType(RfDefElement child) {
        if (!(child.getNamedElement() instanceof RfField)) {
            return false;
        }
        return child.getNamedElement().getName().equals(((RfField)child.getNamedElement()).getAssociatedTypeName());
    }

    private List<? extends RfNamedElement> internalGetSubtypeProposals(RfStruct struct, Determinant determinant, String prefix, int insertIndex) {
        NullProtectedList<R2LSubtypeElement> candidates = new NullProtectedList<R2LSubtypeElement>();
        candidates.setMaxNofItems(500);
        try {
            boolean hasTick;
            List fields = struct.getMembersWithPrefix(false, 2, determinant, this.fModulePackageName, this.getEnclosingStruct(this.fInitialScope), 2, "", 31);
            if (fields == null) {
                return candidates;
            }
            List<String> qualifiedList = Arrays.asList(determinant.toArray());
            boolean bl = hasTick = prefix.indexOf(39) > -1;
            if ((this.fMatchType & 0x10) == 0) {
                block2: for (RfField field : fields) {
                    String customName;
                    List<RfEnum> enums;
                    RfScalarType scalarType;
                    RfType assocType;
                    if (field.getAssociatedTypeName().equals("uint") || field.getAssociatedTypeName().equals("int") || field.getAssociatedTypeName().equals("bool") && qualifiedList != null && qualifiedList.contains(field.getName()) || (assocType = field.getAssociatedType()) == null || !(assocType instanceof RfScalarType) || (scalarType = (RfScalarType)assocType).isIntegerAlias() || (enums = scalarType.getEnumsWithPrefix(this.fMatchType, "")) == null) continue;
                    boolean isBool = assocType.getName().equals("bool");
                    for (RfEnum enumItem : enums) {
                        customName = String.valueOf(enumItem.getName()) + "'" + field.getName();
                        if (qualifiedList != null && (!hasTick && (!this.hasPrefix(enumItem.getName(), prefix) || prefix.isEmpty()) && qualifiedList.contains(enumItem.getName()) || !hasTick && (!this.hasPrefix(field.getName(), prefix) || prefix.isEmpty()) && qualifiedList.contains(field.getName()) || (this.hasPrefix(String.valueOf(customName) + " ", prefix) || prefix.isEmpty()) && qualifiedList.contains(prefix) && qualifiedList.contains(customName) || (!this.hasPrefix(String.valueOf(customName) + " ", prefix) || prefix.isEmpty()) && (qualifiedList.contains(customName) || isBool && enumItem.getName().equals("TRUE") && qualifiedList.contains(field.getName())))) continue block2;
                    }
                    for (RfEnum enumItem : enums) {
                        customName = enumItem.getName();
                        boolean enumNameOnly = false;
                        int i = 0;
                        while (qualifiedList != null && i < qualifiedList.size() - 1) {
                            if (qualifiedList.get(i).startsWith("'" + field.getName())) {
                                enumNameOnly = true;
                                break;
                            }
                            ++i;
                        }
                        if (!enumNameOnly) {
                            customName = String.valueOf(customName) + "'" + field.getName() + " ";
                        }
                        if (!DVTStringUtil.regionMatches((String)customName, (String)prefix, (int)this.fMatchType)) continue;
                        R2LSubtypeElement whenSubtype = new R2LSubtypeElement(customName, insertIndex, struct.getName());
                        candidates.add(whenSubtype);
                    }
                }
            } else {
                for (RfField field : fields) {
                    List<RfEnum> enums;
                    RfScalarType scalarType;
                    RfType assocType;
                    if (field.getAssociatedTypeName().equals("uint") || field.getAssociatedTypeName().equals("int") || field.getAssociatedTypeName().equals("bool") && qualifiedList != null && qualifiedList.contains(field.getName()) || (assocType = field.getAssociatedType()) == null || !(assocType instanceof RfScalarType) || (scalarType = (RfScalarType)assocType).isIntegerAlias() || (enums = scalarType.getEnumsWithPrefix(this.fMatchType, prefix)) == null) continue;
                    for (RfEnum enumItem : enums) {
                        String customName = enumItem.getName();
                        R2LSubtypeElement whenSubtype = new R2LSubtypeElement(customName, insertIndex, struct.getName());
                        candidates.add(whenSubtype);
                    }
                }
            }
        }
        catch (MaxNofItemsReached maxNofItemsReached) {}
        return candidates;
    }

    private List<? extends RfNamedElement> internalGetSubtypeProposals(RfStruct struct, Determinant determinant, String prefix, int insertIndex, String alreadyWrittenText) {
        NullProtectedList<R2LSubtypeElement> candidates = new NullProtectedList<R2LSubtypeElement>();
        List<String> words = Arrays.asList(alreadyWrittenText.split(" "));
        candidates.setMaxNofItems(500);
        try {
            boolean hasTick;
            List fields = struct.getMembersWithPrefix(false, 2, determinant, this.fModulePackageName, this.getEnclosingStruct(this.fInitialScope), 2, "", 31);
            if (fields == null) {
                return candidates;
            }
            List<String> qualifiedList = Arrays.asList(determinant.toArray());
            boolean bl = hasTick = prefix.indexOf(39) > -1;
            if ((this.fMatchType & 0x10) == 0) {
                block2: for (RfField field : fields) {
                    String customName;
                    List<RfEnum> enums;
                    RfScalarType scalarType;
                    RfType assocType;
                    if (field.getAssociatedTypeName().equals("uint") || field.getAssociatedTypeName().equals("int") || field.getAssociatedTypeName().equals("bool") && qualifiedList != null && qualifiedList.contains(field.getName()) || (assocType = field.getAssociatedType()) == null || !(assocType instanceof RfScalarType) || (scalarType = (RfScalarType)assocType).isIntegerAlias() || (enums = scalarType.getEnumsWithPrefix(this.fMatchType, "")) == null) continue;
                    boolean isBool = assocType.getName().equals("bool");
                    for (RfEnum enumItem : enums) {
                        customName = String.valueOf(enumItem.getName()) + "'" + field.getName();
                        if (qualifiedList != null && (!hasTick && (!this.hasPrefix(enumItem.getName(), prefix) || prefix.isEmpty()) && qualifiedList.contains(enumItem.getName()) || !hasTick && (!this.hasPrefix(field.getName(), prefix) || prefix.isEmpty()) && qualifiedList.contains(field.getName()) || (this.hasPrefix(String.valueOf(customName) + " ", prefix) || prefix.isEmpty()) && qualifiedList.contains(prefix) && qualifiedList.contains(customName) || (!this.hasPrefix(String.valueOf(customName) + " ", prefix) || prefix.isEmpty()) && (qualifiedList.contains(customName) || isBool && enumItem.getName().equals("TRUE") && qualifiedList.contains(field.getName())))) continue block2;
                    }
                    for (RfEnum enumItem : enums) {
                        customName = enumItem.getName();
                        boolean enumNameOnly = false;
                        int i = 0;
                        while (qualifiedList != null && i < qualifiedList.size() - 1) {
                            if (qualifiedList.get(i).startsWith("'" + field.getName())) {
                                enumNameOnly = true;
                                break;
                            }
                            ++i;
                        }
                        if (!enumNameOnly) {
                            customName = String.valueOf(customName) + "'" + field.getName() + " ";
                        }
                        if (!DVTStringUtil.regionMatches((String)customName, (String)prefix, (int)this.fMatchType) || words.contains(customName.substring(0, customName.length() - 1))) continue;
                        R2LSubtypeElement whenSubtype = new R2LSubtypeElement(customName, insertIndex, struct.getName());
                        candidates.add(whenSubtype);
                    }
                }
            } else {
                for (RfField field : fields) {
                    List<RfEnum> enums;
                    RfScalarType scalarType;
                    RfType assocType;
                    if (field.getAssociatedTypeName().equals("uint") || field.getAssociatedTypeName().equals("int") || field.getAssociatedTypeName().equals("bool") && qualifiedList != null && qualifiedList.contains(field.getName()) || (assocType = field.getAssociatedType()) == null || !(assocType instanceof RfScalarType) || (scalarType = (RfScalarType)assocType).isIntegerAlias() || (enums = scalarType.getEnumsWithPrefix(this.fMatchType, prefix)) == null) continue;
                    for (RfEnum enumItem : enums) {
                        String customName = enumItem.getName();
                        if (words.contains(customName)) continue;
                        R2LSubtypeElement whenSubtype = new R2LSubtypeElement(customName, insertIndex, struct.getName());
                        candidates.add(whenSubtype);
                    }
                }
            }
        }
        catch (MaxNofItemsReached maxNofItemsReached) {}
        return candidates;
    }

    private boolean hasPrefix(String text, String prefix) {
        return text.startsWith(prefix) || (this.fMatchType & 8) != 0 && text.toLowerCase().startsWith(prefix.toLowerCase());
    }

    private RfNamedElement[] internalGetTypes(IRfScope enclosingScope, String packageName, boolean strictPackage, String prefix, int typeKind, boolean isExtend, int backOffset, int kind) {
        NullProtectedList<RfNamedElement> candidates = new NullProtectedList<RfNamedElement>();
        candidates.setMaxNofItems(500);
        try {
            R2LToken potentialWhenSubtype = this.fLexer.collectPotentialWhenSubtype(isExtend, backOffset);
            if (potentialWhenSubtype != null) {
                String potentialSubtypeText = potentialWhenSubtype.getText();
                boolean potentialStrictPackage = potentialSubtypeText.contains("::");
                String potentialPackageName = potentialStrictPackage ? this.extractPackageName(potentialSubtypeText) : packageName;
                Determinant determinant = new Determinant(potentialSubtypeText);
                if (enclosingScope instanceof RfStructLayer) {
                    RfStruct struct = ((RfStructLayer)enclosingScope).getStruct();
                    Determinant enclosingDeterminant = enclosingScope.getDeterminant();
                    Determinant fullDeterminant = new Determinant(String.valueOf(potentialSubtypeText) + " " + enclosingDeterminant.toString());
                    int insertIndex = this.fOffset;
                    String oldPrefix = prefix;
                    if (this.hasPrefix(struct.getName(), prefix)) {
                        prefix = "";
                        insertIndex = potentialWhenSubtype.getOffset();
                    }
                    candidates.addAll(this.internalGetSubtypeProposals(struct, fullDeterminant, prefix, insertIndex, potentialSubtypeText));
                    if (candidates.isEmpty() && potentialSubtypeText.equals(oldPrefix)) {
                        candidates.addAll(this.fRfProject.getTypesWithPrefixConsideringAmbiguities(potentialPackageName, potentialStrictPackage, this.fMatchType, oldPrefix, typeKind, potentialSubtypeText));
                        if (!strictPackage) {
                            candidates.addAll(this.getPackagesWithPrefix(this.fMatchType, oldPrefix, potentialSubtypeText));
                        }
                    }
                    RfNamedElement[] sortedCandidates = candidates.toArray(new RfNamedElement[candidates.size()]);
                    Arrays.sort(sortedCandidates, R2LUtils.getContextSorter(prefix, this.fRfProject.getLanguageKind()));
                    return sortedCandidates;
                }
                RfType struct = this.fRfProject.getType(packageName, false, 1, determinant.getName(), -1);
                while (struct == null && determinant.toArray().length > 1) {
                    determinant.removeLastName();
                    struct = this.fRfProject.getType(packageName, false, 1, determinant.getName(), -1);
                    if (kind != 1 || struct == null || ((RfStruct)struct).isLike("any_sequence_item")) continue;
                    struct = null;
                }
                NullProtectedList<? extends RfNamedElement> whenCandidates = new NullProtectedList<RfNamedElement>();
                String oldPrefix = prefix;
                if (struct != null) {
                    int insertIndex = this.fOffset;
                    if (this.hasPrefix(struct.getName(), prefix)) {
                        prefix = "";
                        insertIndex = potentialWhenSubtype.getOffset();
                    }
                    if (struct instanceof RfStruct && !((RfStruct)struct).isSLNAction() && !((RfStruct)struct).isSLNComponent()) {
                        whenCandidates.addAll(this.internalGetSubtypeProposals((RfStruct)struct, determinant, prefix, insertIndex, potentialSubtypeText));
                    }
                }
                prefix = oldPrefix;
                if (enclosingScope != null && enclosingScope instanceof RfStruct) {
                    candidates.addAll(this.getAllChildren(enclosingScope, packageName, this.fRfProject.getDuplicateNames(), potentialSubtypeText));
                } else {
                    candidates.addAll(this.fRfProject.getTypesWithPrefixConsideringAmbiguities(packageName, strictPackage, this.fMatchType, prefix, typeKind, potentialSubtypeText));
                }
                if (!strictPackage) {
                    candidates.addAll(this.getPackagesWithPrefix(this.fMatchType, prefix, potentialSubtypeText));
                }
                RfNamedElement[] sortedCandidates = candidates.toArray(new RfNamedElement[candidates.size()]);
                Arrays.sort(sortedCandidates, R2LUtils.getContextSorter(prefix, this.fRfProject.getLanguageKind()));
                if (!whenCandidates.isEmpty()) {
                    RfNamedElement[] newSortedCandidates = new RfNamedElement[sortedCandidates.length + whenCandidates.size()];
                    System.arraycopy(whenCandidates.toArray(), 0, newSortedCandidates, 0, whenCandidates.size());
                    System.arraycopy(sortedCandidates, 0, newSortedCandidates, whenCandidates.size(), sortedCandidates.length);
                    return newSortedCandidates;
                }
                return sortedCandidates;
            }
            if (enclosingScope instanceof RfStructLayer) {
                RfStruct struct = ((RfStructLayer)enclosingScope).getStruct();
                Determinant determinant = enclosingScope.getDeterminant();
                candidates.addAll(this.internalGetSubtypeProposals(struct, determinant, prefix, this.fOffset));
                RfNamedElement[] sortedCandidates = candidates.toArray(new RfNamedElement[candidates.size()]);
                Arrays.sort(sortedCandidates, R2LUtils.getContextSorter(prefix, this.fRfProject.getLanguageKind()));
                return sortedCandidates;
            }
            candidates.addAll(this.fRfProject.getTypesWithPrefixConsideringAmbiguities(packageName, strictPackage, this.fMatchType, prefix, typeKind, ""));
            if (!strictPackage) {
                candidates.addAll(this.getPackagesWithPrefix(this.fMatchType, prefix));
            }
        }
        catch (MaxNofItemsReached maxNofItemsReached) {}
        RfNamedElement[] sortedCandidates = candidates.toArray(new RfNamedElement[candidates.size()]);
        Arrays.sort(sortedCandidates, R2LUtils.getContextSorter(prefix, this.fRfProject.getLanguageKind()));
        return sortedCandidates;
    }

    public List<RfNamedElement> getAllChildren(IRfScope enclosingScope, String packageName, Set<String> duplicateNames) {
        LinkedList<RfNamedElement> result = new LinkedList<RfNamedElement>();
        if (enclosingScope == null || !(enclosingScope instanceof RfType)) {
            return result;
        }
        if (duplicateNames.contains(enclosingScope.getName())) {
            result.add(new R2LAmbiguousType((RfType)enclosingScope));
        } else {
            result.add((RfType)enclosingScope);
        }
        if (!(enclosingScope instanceof RfStruct)) {
            return result;
        }
        List<RfStruct> children = ((RfStruct)enclosingScope).getChildStructs();
        if (children == null) {
            return result;
        }
        for (RfStruct child : children) {
            result.addAll(this.getAllChildren(child, packageName, duplicateNames));
        }
        return result;
    }

    public List<RfNamedElement> getAllChildren(IRfScope enclosingScope, String packageName, Set<String> duplicateNames, String alreadyWrittenText) {
        String[] components;
        LinkedList<RfNamedElement> result = new LinkedList<RfNamedElement>();
        if (alreadyWrittenText.contains(" ")) {
            components = DVTStringUtil.split((String)" ", (String)alreadyWrittenText);
            alreadyWrittenText = components[components.length - 1];
        }
        if (alreadyWrittenText.contains("::")) {
            components = DVTStringUtil.split((String)"::", (String)alreadyWrittenText);
            alreadyWrittenText = components[components.length - 1];
        }
        if (enclosingScope == null || !(enclosingScope instanceof RfType)) {
            return result;
        }
        if (!alreadyWrittenText.equals(enclosingScope.getName())) {
            if (duplicateNames.contains(enclosingScope.getName())) {
                result.add(new R2LAmbiguousType((RfType)enclosingScope));
            } else {
                result.add((RfType)enclosingScope);
            }
        }
        if (!(enclosingScope instanceof RfStruct)) {
            return result;
        }
        List<RfStruct> children = ((RfStruct)enclosingScope).getChildStructs();
        if (children == null) {
            return result;
        }
        for (RfStruct child : children) {
            result.addAll(this.getAllChildren(child, packageName, duplicateNames, alreadyWrittenText));
        }
        return result;
    }

    public List<RfStruct> getPackagesWithPrefix(int matchType, String prefix) {
        ArrayList<RfStruct> result = new ArrayList<RfStruct>();
        Collection<RfStruct> packages = this.fRfProject.getAllPackages();
        for (RfStruct packg : packages) {
            if (!DVTStringUtil.regionMatches((String)packg.getPackageName(), (String)prefix, (int)matchType)) continue;
            result.add(packg);
        }
        return result;
    }

    public List<RfStruct> getPackagesWithPrefix(int matchType, String prefix, String alreadyWrittenText) {
        String[] components;
        ArrayList<RfStruct> result = new ArrayList<RfStruct>();
        if (alreadyWrittenText.contains(" ")) {
            components = DVTStringUtil.split((String)" ", (String)alreadyWrittenText);
            alreadyWrittenText = components[components.length - 1];
        }
        if (alreadyWrittenText.contains("::")) {
            components = DVTStringUtil.split((String)"::", (String)alreadyWrittenText);
            alreadyWrittenText = components[0];
        }
        Collection<RfStruct> packages = this.fRfProject.getAllPackages();
        for (RfStruct packg : packages) {
            if (!DVTStringUtil.regionMatches((String)packg.getPackageName(), (String)prefix, (int)matchType) || alreadyWrittenText.equals(packg.getName())) continue;
            result.add(packg);
        }
        return result;
    }

    @Override
    public RfNamedElement[] getPreprocessing(String prefix) {
        List<RfMacro> preprocs = this.fRfProject.getPreprocesingWithPrefix(this.fMatchType, prefix);
        RfNamedElement[] result = preprocs.toArray(new RfNamedElement[preprocs.size()]);
        Arrays.sort(result, R2LUtils.getLexicalSorter(prefix, this.fRfProject.getLanguageKind()));
        return result;
    }

    @Override
    public RfNamedElement[] getFieldTypes(R2LScopeContainer scopeContainer, String packageName, String prefix, String qualifiedName, int backOffset, int kind) {
        boolean strictPackage = true;
        if (packageName == null) {
            packageName = this.fModulePackageName;
            strictPackage = false;
        }
        RfNamedElement[] result = this.internalGetTypes(null, packageName, strictPackage, prefix, -1, false, backOffset, kind);
        R2LToken potentialWhenSubtype = this.fLexer.collectPotentialWhenSubtype(false, backOffset);
        if (potentialWhenSubtype == null && this.isSequenceScope(this.fInitialScope)) {
            NullProtectedList<RfNamedElement> candidates = new NullProtectedList<RfNamedElement>();
            candidates.setMaxNofItems(500);
            try {
                String structName = ((RfStructLayer)this.fInitialScope).getNamedElement().getName();
                List<RfDefElement> layers = ((RfStructLayer)this.fInitialScope).getNamedElement().getLayers();
                int i = 0;
                while (layers != null && i < layers.size()) {
                    RfStructLayer layer = (RfStructLayer)layers.get(i);
                    String subtypeName = DVTStringUtil.replaceAll((Pattern)DVTStringUtil.MULTIPLE_WS, (CharSequence)layer.getInfo(), (String)" ");
                    if (!subtypeName.trim().equals(structName) && DVTStringUtil.regionMatches((String)subtypeName, (String)prefix, (int)this.fMatchType)) {
                        boolean isAlreadyIn = false;
                        for (RfNamedElement structWrapper : candidates) {
                            if (!DVTStringUtil.replaceAll((Pattern)DVTStringUtil.MULTIPLE_WS, (CharSequence)((R2LStructLayerWrapper)structWrapper).getStructLayer().getInfo(), (String)" ").equals(subtypeName)) continue;
                            isAlreadyIn = true;
                        }
                        if (!isAlreadyIn) {
                            candidates.add(new R2LStructLayerWrapper(layer));
                        }
                    }
                    ++i;
                }
                if (result != null && result.length > 0) {
                    candidates.addAll(Arrays.asList(result));
                }
            }
            catch (MaxNofItemsReached maxNofItemsReached) {}
            result = candidates.toArray(new RfNamedElement[candidates.size()]);
            Arrays.sort(result, R2LUtils.getContextSorter(prefix, this.fRfProject.getLanguageKind()));
        }
        if (result == null || result.length == 0) {
            return new RfNamedElement[]{new R2LNoProposalElement()};
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isSequenceScope(IRfScope scope) {
        try {
            RfStruct struct;
            if (!(scope instanceof RfStructLayer)) {
                return false;
            }
            RfStructLayer layer = (RfStructLayer)scope;
            RfStruct parent = struct = (RfStruct)layer.getNamedElement();
            do {
                if ((parent = parent.getParentStruct()) != null) continue;
                return false;
            } while (!parent.getName().equals("any_sequence"));
            return true;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return false;
        }
    }

    @Override
    public RfNamedElement[] getExtendType(List<R2LTreeNode> qualifiedList, String packageName, String prefix, String qualifiedName, int backOffset) {
        boolean strictPackage = true;
        if (packageName == null) {
            packageName = this.fModulePackageName;
            strictPackage = false;
        }
        RfNamedElement[] elements = null;
        elements = qualifiedList == null || qualifiedList.isEmpty() ? this.internalGetTypes(null, packageName, strictPackage, prefix, 3, true, backOffset, 0) : this.internalGetTypes(null, packageName, strictPackage, prefix, 1, true, backOffset, 0);
        if (elements == null) {
            return null;
        }
        boolean hasEnumCandidates = false;
        RfNamedElement[] rfNamedElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            RfNamedElement candidate = rfNamedElementArray[n2];
            if (candidate instanceof R2LSubtypeElement) {
                hasEnumCandidates = true;
                break;
            }
            ++n2;
        }
        if (!(hasEnumCandidates || prefix != null && prefix.length() != 0)) {
            RfNamedElement[] result = new RfNamedElement[elements.length + 1];
            result[0] = new R2LInfoProposalElement("Chose the struct first, and then the subtype.", "Please chose first the struct type and after that invoke the content assist again to complete the subtype.");
            System.arraycopy(elements, 0, result, 1, elements.length);
            return result;
        }
        return elements;
    }

    @Override
    public RfNamedElement[] getWhenSubtype(String packageName, String prefix, String qualifiedName, int backOffset) {
        RfNamedElement[] result;
        boolean strictPackage = true;
        if (packageName == null) {
            packageName = this.fModulePackageName;
            strictPackage = false;
        }
        if ((result = this.internalGetTypes(this.fInitialScope, packageName, strictPackage, prefix, 1, true, backOffset, 0)) == null || result.length == 0) {
            return new RfNamedElement[]{new R2LNoProposalElement()};
        }
        return result;
    }

    @Override
    public RfNamedElement[] getAsAInside(List<R2LTreeNode> qualifiedList, R2LScopeContainer scopeContainer, String packageName, String prefix, String qualifiedName, int backOffset) {
        boolean strictPackage = true;
        if (packageName == null) {
            RfNamedElement el = scopeContainer.element;
            packageName = el instanceof RfVar ? ((RfVar)el).getAssociatedType().getPackageName() : this.fModulePackageName;
            boolean bl = strictPackage = el instanceof RfVar ? ((RfVar)scopeContainer.element).getTypeName().contains("::") : false;
        }
        if (qualifiedList == null || qualifiedList.isEmpty()) {
            if (scopeContainer == null || scopeContainer.element == null) {
                return this.internalGetTypes(null, packageName, strictPackage, prefix, 3, true, backOffset, 0);
            }
            if (scopeContainer.element instanceof IRfAssociatedType) {
                type = (RfType)((IRfAssociatedType)((Object)scopeContainer.element)).getAssociatedType();
                if (type == null) {
                    return this.internalGetTypes(null, packageName, strictPackage, prefix, 3, true, backOffset, 0);
                }
                if (type instanceof RfScalarType) {
                    return this.internalGetTypes(null, packageName, strictPackage, prefix, 2, true, backOffset, 0);
                }
                if (type instanceof RfStruct) {
                    scopeContainer.element = type;
                    return this.getIsSubtypeOf(scopeContainer, packageName, prefix, qualifiedName, backOffset);
                }
            }
        } else if (!qualifiedList.isEmpty()) {
            if (scopeContainer == null || scopeContainer.element == null) {
                return this.internalGetTypes(null, packageName, strictPackage, prefix, 1, true, backOffset, 0);
            }
            if (scopeContainer.element instanceof IRfAssociatedType) {
                type = (RfType)((IRfAssociatedType)((Object)scopeContainer.element)).getAssociatedType();
                if (type == null) {
                    return this.internalGetTypes(null, packageName, strictPackage, prefix, 1, true, backOffset, 0);
                }
                if (type instanceof RfStruct) {
                    scopeContainer.element = type;
                    return this.getIsSubtypeOf(scopeContainer, packageName, prefix, qualifiedName, backOffset);
                }
            }
        }
        return this.internalGetTypes(null, packageName, strictPackage, prefix, -1, true, backOffset, 0);
    }

    @Override
    public RfNamedElement[] getIsSubtypeOf(R2LScopeContainer scopeContainer, String packageName, String prefix, String qualifiedName, int backOffset) {
        RfNamedElement candidate;
        RfNamedElement el = scopeContainer.element;
        boolean strictPackage = true;
        if (packageName == null) {
            packageName = el instanceof RfVar ? ((RfVar)el).getAssociatedType().getPackageName() : this.fModulePackageName;
            strictPackage = el instanceof RfVar ? ((RfVar)scopeContainer.element).getTypeName().contains("::") : false;
        }
        NullProtectedList<RfNamedElement> candidates = new NullProtectedList<RfNamedElement>();
        candidates.setMaxNofItems(500);
        try {
            candidates.addAll(Arrays.asList(this.internalGetTypes(scopeContainer.scope, packageName, strictPackage, prefix, 1, true, backOffset, 0)));
            if (scopeContainer != null && scopeContainer.scope != null && scopeContainer.scope instanceof RfNamedElement) {
                String candidateName = ((RfNamedElement)((Object)scopeContainer.scope)).getName();
                Iterator iterator = candidates.iterator();
                while (iterator.hasNext()) {
                    RfStruct struct;
                    candidate = (RfNamedElement)iterator.next();
                    if (candidate instanceof R2LAmbiguousType) {
                        candidate = ((R2LAmbiguousType)candidate).getRfType();
                    }
                    if (!(candidate instanceof RfStruct) || (struct = (RfStruct)candidate).isLike(candidateName)) continue;
                    iterator.remove();
                }
            }
        }
        catch (MaxNofItemsReached maxNofItemsReached) {}
        RfNamedElement[] sortedCandidates = candidates.toArray(new RfNamedElement[candidates.size()]);
        Arrays.sort(sortedCandidates, R2LUtils.getContextSorter(prefix, this.fRfProject.getLanguageKind()));
        boolean hasEnumCandidates = false;
        RfNamedElement[] rfNamedElementArray = sortedCandidates;
        int n = sortedCandidates.length;
        int n2 = 0;
        while (n2 < n) {
            candidate = rfNamedElementArray[n2];
            if (candidate instanceof R2LSubtypeElement) {
                hasEnumCandidates = true;
                break;
            }
            ++n2;
        }
        if (!(hasEnumCandidates || prefix != null && prefix.length() != 0)) {
            RfNamedElement[] result = new RfNamedElement[sortedCandidates.length + 1];
            result[0] = new R2LInfoProposalElement("Chose the struct first, and then the subtype.", "Please chose first the struct type and after that invoke the content assist again to complete the subtype.");
            System.arraycopy(sortedCandidates, 0, result, 1, sortedCandidates.length);
            return result;
        }
        return sortedCandidates;
    }

    @Override
    public RfNamedElement[] getListOfBitMembers(String prefix) {
        RfType associatedType = this.fRfProject.getType("main", true, 2, "bit", -1);
        RfListType type = new RfListType(this.fRfProject, associatedType, null, 1);
        NullProtectedList<RfStructMember> candidates = new NullProtectedList<RfStructMember>();
        candidates.setMaxNofItems(500);
        try {
            candidates.addAll(type.getMethodsWithPrefix(null, null, this.fMatchType, prefix, 31));
            if (!this.fIsMethodProposal) {
                candidates.addAll(type.getFieldsWithPrefix(null, null, this.fMatchType, prefix, 31));
            }
        }
        catch (MaxNofItemsReached maxNofItemsReached) {}
        RfNamedElement[] sortedCandidates = candidates.toArray(new RfNamedElement[candidates.size()]);
        Arrays.sort(sortedCandidates, R2LUtils.getContextSorter(prefix, this.fRfProject.getLanguageKind()));
        return sortedCandidates;
    }

    @Override
    public RfNamedElement[] getEnumItem(R2LScopeContainer scopeContainer, String packageName, String typeName, String prefix) {
        List candidates;
        RfType type;
        boolean strictPackage = true;
        if (packageName == null) {
            packageName = this.fModulePackageName;
            strictPackage = false;
        }
        if ((type = this.fRfProject.getType(packageName, strictPackage, 2, typeName, -1)) == null) {
            RfStructLayer scope;
            RfField field;
            if (scopeContainer != null && scopeContainer.scope instanceof RfStructLayer && (field = (RfField)((RfStruct)(scope = (RfStructLayer)scopeContainer.scope).getNamedElement()).getLocalMember(new FullName(typeName, scope.getDeterminant()), 2)) != null) {
                type = field.getAssociatedType();
            }
            if (type == null) {
                return null;
            }
        }
        if ((candidates = type.getEnumsWithPrefix(1, prefix)) == null) {
            return null;
        }
        RfNamedElement[] sortedCandidates = candidates.toArray(new RfNamedElement[candidates.size()]);
        Arrays.sort(sortedCandidates, R2LUtils.getLexicalSorter(prefix, this.fRfProject.getLanguageKind()));
        return sortedCandidates;
    }

    @Override
    public RfNamedElement[] getArgsCandidates(R2LScopeContainer prefixScopeContainer, String packageName, String prefix, int offset, int argumentNumber) {
        if (this.fInitialScope == null) {
            return new RfNamedElement[]{new R2LNoProposalElement()};
        }
        if (packageName != null && packageName.length() > 0) {
            return this.getExprCandidates(prefixScopeContainer, packageName, null, prefix, true);
        }
        if (this.fModule == null) {
            return new RfNamedElement[]{new R2LNoProposalElement()};
        }
        R2LTooltipManager manager = new R2LTooltipManager(this.fRfProject, this.fInitialScope, this.fModulePackageName, this.fModule.getParserPath(), this.fDocument, offset, this.fLine);
        RfWNamedElementAndScope element = manager.getElement();
        if (element == null || element.getNamedElement() == null || !(element.getNamedElement() instanceof RfMethod)) {
            return this.getExprCandidates(prefixScopeContainer, packageName, null, prefix, true);
        }
        RfMethod method = (RfMethod)element.getNamedElement();
        RfDefElement methodDeclarationLayer = method.getDeclaration(false);
        if (!(methodDeclarationLayer instanceof IRfScope)) {
            RfNamedElement[] candidates = this.getExprCandidates(prefixScopeContainer, packageName, null, prefix, true);
            return candidates;
        }
        NullProtectedList candidates = new NullProtectedList();
        candidates.setMaxNofItems(500);
        try {
            RfType type;
            List<RfArg> arguments = ((IRfScope)((Object)methodDeclarationLayer)).getArgumentsWithPrefix(2, "");
            if (arguments != null && arguments.size() > argumentNumber && (type = arguments.get(argumentNumber).getAssociatedType()) instanceof RfScalarType) {
                candidates.addAll(type.getEnumsWithPrefix(this.fMatchType, prefix));
            }
        }
        catch (MaxNofItemsReached maxNofItemsReached) {}
        if (candidates.isEmpty()) {
            return this.getExprCandidates(prefixScopeContainer, packageName, null, prefix, true);
        }
        RfNamedElement[] sortedCandidates = candidates.toArray(new RfNamedElement[candidates.size()]);
        Arrays.sort(sortedCandidates, R2LUtils.getLexicalSorter(prefix, this.fRfProject.getLanguageKind()));
        RfNamedElement[] exprCandidates = this.getExprCandidates(prefixScopeContainer, packageName, null, prefix, false);
        if (exprCandidates == null || exprCandidates.length == 0) {
            return sortedCandidates;
        }
        RfNamedElement[] result = new RfNamedElement[sortedCandidates.length + exprCandidates.length];
        System.arraycopy(sortedCandidates, 0, result, 0, sortedCandidates.length);
        System.arraycopy(exprCandidates, 0, result, sortedCandidates.length, exprCandidates.length);
        return result;
    }

    @Override
    public RfNamedElement[] getDoOrGenSubtype(R2LScopeContainer scopeContainer, String prefix, String qualifiedName, boolean isDoNotGen, int backOffset) {
        if (this.fInitialScope == null) {
            return null;
        }
        NullProtectedList<? extends RfNamedElement> candidates = new NullProtectedList<RfNamedElement>();
        candidates.setMaxNofItems(500);
        try {
            RfStruct enclosingStruct = this.getEnclosingStruct(this.fInitialScope);
            if (!isDoNotGen) {
                candidates.addAll(this.fInitialScope.getVariablesWithPrefix(this.fLine, this.fMatchType, prefix));
                candidates.addAll(this.fInitialScope.getArgumentsWithPrefix(this.fMatchType, prefix));
            }
            candidates.addAll(this.fInitialScope.getFieldsWithPrefix(this.fModulePackageName, enclosingStruct, this.fMatchType, prefix, 31));
            R2LToken potentialWhenSubtype = this.fLexer.collectPotentialWhenSubtype(true, backOffset);
            if (potentialWhenSubtype != null) {
                Determinant determinant = new Determinant(potentialWhenSubtype.getText().replaceAll("\\s+keeping$", ""));
                RfField field = this.fInitialScope.getFieldWithPrefix(this.fModulePackageName, enclosingStruct, 1, determinant.getName(), 31);
                while (field == null && determinant.toArray().length > 1) {
                    determinant.removeLastName();
                    field = this.fInitialScope.getFieldWithPrefix(this.fModulePackageName, enclosingStruct, 1, determinant.getName(), 31);
                }
                RfStruct struct = null;
                if (field != null && field.getAssociatedType() instanceof RfStruct) {
                    struct = (RfStruct)field.getAssociatedType();
                }
                if (field != null && struct != null) {
                    int insertIndex = this.fOffset;
                    if (this.hasPrefix(field.getName(), prefix)) {
                        prefix = "";
                        insertIndex = potentialWhenSubtype.getOffset();
                    }
                    determinant = new Determinant(field.getAssociatedFullTypeName());
                    List<? extends RfNamedElement> subtypes = this.internalGetSubtypeProposals(struct, determinant, prefix, insertIndex);
                    candidates.addAll(subtypes);
                }
            }
        }
        catch (MaxNofItemsReached maxNofItemsReached) {}
        if (isDoNotGen) {
            Iterator iterator = candidates.iterator();
            while (iterator.hasNext()) {
                RfType assocType;
                RfNamedElement candidate = (RfNamedElement)iterator.next();
                if (!(candidate instanceof IRfAssociatedType) || (assocType = (RfType)((IRfAssociatedType)((Object)candidate)).getAssociatedType()) instanceof RfStruct && ((RfStruct)assocType).isLike("any_sequence_item")) continue;
                iterator.remove();
            }
        }
        RfNamedElement[] sortedCandidates = candidates.toArray(new RfNamedElement[candidates.size()]);
        Arrays.sort(sortedCandidates, R2LUtils.getContextSorter(prefix, this.fRfProject.getLanguageKind()));
        return sortedCandidates;
    }

    @Override
    public RfNamedElement[] getCondCandidates(R2LScopeContainer scopeContainer, R2LScopeContainer leftScopeContainer, R2LScopeContainer rightScopeContainer, String packageName, String prefix) {
        RfNamedElement[] enumCandidates = null;
        if (leftScopeContainer != null && leftScopeContainer.scope != null) {
            enumCandidates = this.getEnumItems(leftScopeContainer, null, prefix);
        }
        if (enumCandidates == null && rightScopeContainer != null && rightScopeContainer.scope != null) {
            enumCandidates = this.getEnumItems(rightScopeContainer, null, prefix);
        }
        if (enumCandidates == null && scopeContainer != null && scopeContainer.scope != null) {
            enumCandidates = this.getEnumItems(scopeContainer, null, prefix);
        }
        RfNamedElement[] exprCandidates = null;
        if (scopeContainer != null && scopeContainer.scope != null) {
            exprCandidates = this.getExprCandidates(scopeContainer, packageName, null, prefix, false);
        }
        if (exprCandidates == null || exprCandidates.length == 0) {
            return enumCandidates;
        }
        if (enumCandidates == null || enumCandidates.length == 0) {
            return exprCandidates;
        }
        RfNamedElement[] result = new RfNamedElement[enumCandidates.length + exprCandidates.length];
        System.arraycopy(enumCandidates, 0, result, 0, enumCandidates.length);
        System.arraycopy(exprCandidates, 0, result, enumCandidates.length, exprCandidates.length);
        return result;
    }

    @Override
    public RfNamedElement[] getStructAndUnits(String packageName, String prefix, boolean unitsOnly) {
        return null;
    }

    @Override
    public RfNamedElement[] getSequenceCandidates(R2LScopeContainer scopeContainer, String kind, String packageName, String prefix) {
        boolean strictPackage = true;
        if (packageName == null) {
            packageName = this.fModulePackageName;
            strictPackage = false;
        }
        NullProtectedList<RfType> candidates = new NullProtectedList<RfType>();
        candidates.setMaxNofItems(500);
        try {
            if (!("item".equals(kind) || "created_kind".equals(kind) || "created_driver".equals(kind))) {
                if ("sequence_type".equals(kind)) {
                    candidates.addAll(this.fRfProject.getTypesWithPrefix(packageName, strictPackage, this.fMatchType, prefix, 1));
                    iterator = candidates.iterator();
                    while (iterator.hasNext()) {
                        RfNamedElement candidate = (RfNamedElement)iterator.next();
                        if (candidate instanceof RfStruct && ((RfStruct)candidate).isLike("any_sequence")) continue;
                        iterator.remove();
                    }
                } else if ("sequence_driver_type".equals(kind)) {
                    candidates.addAll(this.fRfProject.getTypesWithPrefix(packageName, strictPackage, this.fMatchType, prefix, 1));
                    iterator = candidates.iterator();
                    while (iterator.hasNext()) {
                        RfNamedElement candidate = (RfNamedElement)iterator.next();
                        if (candidate instanceof RfStruct && ((RfStruct)candidate).isLike("any_sequence_driver")) continue;
                        iterator.remove();
                    }
                }
            }
        }
        catch (MaxNofItemsReached maxNofItemsReached) {}
        RfNamedElement[] sortedCandidates = candidates.toArray(new RfNamedElement[candidates.size()]);
        Arrays.sort(sortedCandidates, R2LUtils.getContextSorter(prefix, this.fRfProject.getLanguageKind()));
        return sortedCandidates;
    }

    @Override
    public RfNamedElement[] getListKey(R2LScopeContainer scopeContainer, String fieldName, String prefix) {
        RfStruct enclosingStruct = this.getEnclosingStruct(this.fInitialScope);
        RfField field = this.fInitialScope.getFieldWithPrefix(this.fModulePackageName, enclosingStruct, 1, fieldName, 31);
        if (field == null || field.getAssociatedTypeList() == 0) {
            return null;
        }
        RfType assocType = field.getAssociatedType();
        if (assocType == null || !(assocType instanceof RfListType)) {
            return null;
        }
        if ((assocType = ((RfListType)assocType).getAssociatedType()) == null || !(assocType instanceof RfStruct)) {
            return null;
        }
        List candidates = assocType.getFieldsWithPrefix(assocType.getPackageName(), enclosingStruct, this.fMatchType, prefix, 31);
        if (candidates == null) {
            return null;
        }
        RfNamedElement[] sortedCandidates = candidates.toArray(new RfNamedElement[candidates.size()]);
        Arrays.sort(sortedCandidates, R2LUtils.getLexicalSorter(prefix, this.fRfProject.getLanguageKind()));
        return sortedCandidates;
    }

    @Override
    public RfNamedElement[] getSLNTokensForDeclaration(String prefix) {
        return null;
    }

    @Override
    public RfNamedElement[] getSDLScenarioInvocations(R2LScopeContainer scopeContainer, boolean isDotAccess, int invocationKind, String prefix) {
        RfStruct itemVarStruct;
        RfType itemVarType;
        RfActionBlockLayer actionBlockLayer;
        RfVar itemVar;
        ArrayList<RfStruct> scenarioCandidates = new ArrayList<RfStruct>();
        RfStruct enclosingStruct = this.getEnclosingStruct(this.fInitialScope);
        RfStruct enclosingSDLScenario = null;
        RfStruct enclosingSDLAgent = null;
        if (enclosingStruct != null && enclosingStruct.isSDLScenario()) {
            enclosingSDLScenario = enclosingStruct;
            enclosingSDLAgent = enclosingStruct.getSDLEnclosingAgent();
        }
        if (isDotAccess) {
            if (scopeContainer != null && scopeContainer.scope instanceof RfStruct && ((RfStruct)scopeContainer.scope).isSDLAgent()) {
                scenarioCandidates.addAll(((RfStruct)scopeContainer.scope).getSDLScenarios());
            }
        } else {
            Collection<RfStruct> allStructs;
            if (enclosingSDLAgent != null) {
                scenarioCandidates.addAll(enclosingSDLAgent.getSDLScenarios());
            }
            if ((allStructs = this.fRfProject.getAllPackages()) != null) {
                for (RfStruct struct : allStructs) {
                    if (!struct.isSDLAgent() || enclosingSDLAgent == struct || "top".equals(struct.getName())) continue;
                    if (struct.getSDLRole("singleton") != null) {
                        scenarioCandidates.addAll(struct.getSDLScenarios());
                        continue;
                    }
                    if (!"builtin".equals(struct.getName())) continue;
                    scenarioCandidates.addAll(struct.getSDLScenarios());
                }
            }
        }
        Iterator iterator = scenarioCandidates.iterator();
        while (iterator.hasNext()) {
            RfStruct candidate = (RfStruct)iterator.next();
            if (!DVTStringUtil.regionMatches((String)candidate.getName(), (String)prefix, (int)this.fMatchType)) {
                iterator.remove();
                continue;
            }
            if (!"start".equals(candidate.getName())) continue;
            iterator.remove();
        }
        Collections.sort(scenarioCandidates, R2LUtils.getLexicalSorter(prefix, this.fRfProject.getLanguageKind()));
        boolean insideTopLevel = false;
        RfStruct insideScenario = null;
        if (scopeContainer != null && scopeContainer.scope instanceof RfStructLayer && ((RfStructLayer)scopeContainer.scope).getStruct() != null && ((RfStructLayer)scopeContainer.scope).getStruct().isSDLScenario()) {
            insideTopLevel = true;
            insideScenario = ((RfStructLayer)scopeContainer.scope).getStruct();
        }
        if (scopeContainer != null && scopeContainer.scope instanceof RfActionBlockLayer && RfActionBlockLayer.ActionKind.SDL_SCENARIO_INVOCATION == ((RfActionBlockLayer)scopeContainer.scope).getActionKind() && (itemVar = (actionBlockLayer = (RfActionBlockLayer)scopeContainer.scope).getLocalVariable("it", LineInfo.INFINITE, null)) != null && (itemVarType = itemVar.getAssociatedType()) instanceof RfStruct && (itemVarStruct = (RfStruct)itemVarType).isSDLScenario()) {
            insideScenario = itemVarStruct;
        }
        if (insideScenario != null) {
            List<RfSDLToolEditorPrioritizeCallLayer> prioritizeCalls = this.fRfProject.collectSDLToolEditorPrioritizeCalls();
            List<RfSDLToolEditorAvoidCallLayer> avoidCalls = this.fRfProject.collectSDLToolEditorAvoidCalls();
            ArrayList<RfSDLToolEditorPrioritizeCallLayer> relevantPrioritizeCalls = new ArrayList<RfSDLToolEditorPrioritizeCallLayer>();
            for (RfSDLToolEditorPrioritizeCallLayer prioritizeCall : prioritizeCalls) {
                String whatToPrioritize = prioritizeCall.getRole1();
                String whereToPrioritize = prioritizeCall.getRole2();
                String scenarioInvocationKind = prioritizeCall.getScenarioInvocationKind();
                if (whatToPrioritize == null || whereToPrioritize == null || scenarioInvocationKind == null || 151 == invocationKind && "simple".equals(scenarioInvocationKind) || (152 == invocationKind || 153 == invocationKind) && "plus".equals(scenarioInvocationKind)) continue;
                if ("TOP_LEVEL".equals(whereToPrioritize)) {
                    if (!insideTopLevel) continue;
                    relevantPrioritizeCalls.add(prioritizeCall);
                    continue;
                }
                if (insideScenario.getSDLRole(whereToPrioritize) == null) continue;
                relevantPrioritizeCalls.add(prioritizeCall);
            }
            ArrayList<RfStruct> beforeScenarioCandidates = new ArrayList<RfStruct>();
            ArrayList<RfStruct> afterScenarioCandidates = new ArrayList<RfStruct>();
            for (RfStruct scenarioCandidate : scenarioCandidates) {
                boolean avoided = false;
                boolean prioritized = false;
                for (RfSDLToolEditorAvoidCallLayer avoidCall : avoidCalls) {
                    String whatToAvoid = avoidCall.getRole1();
                    String whereToAvoid = avoidCall.getRole2();
                    if ("TOP_LEVEL".equals(whereToAvoid)) {
                        if (insideTopLevel && avoidCall.inside() && scenarioCandidate.getSDLRole(whatToAvoid) != null) {
                            avoided = true;
                            break;
                        }
                        if (insideTopLevel || !avoidCall.outside() || scenarioCandidate.getSDLRole(whatToAvoid) == null) continue;
                        avoided = true;
                        break;
                    }
                    if (insideScenario.getSDLRole(whereToAvoid) != null && avoidCall.inside() && scenarioCandidate.getSDLRole(whatToAvoid) != null) {
                        avoided = true;
                        break;
                    }
                    if (insideScenario.getSDLRole(whereToAvoid) != null || !avoidCall.outside() || scenarioCandidate.getSDLRole(whatToAvoid) == null) continue;
                    avoided = true;
                    break;
                }
                if (avoided) continue;
                for (RfSDLToolEditorPrioritizeCallLayer prioritizeCall : relevantPrioritizeCalls) {
                    String whatToPrioritize = prioritizeCall.getRole1();
                    if (scenarioCandidate.getSDLRole(whatToPrioritize) == null) continue;
                    prioritized = true;
                    break;
                }
                if (prioritized) {
                    beforeScenarioCandidates.add(scenarioCandidate);
                    continue;
                }
                afterScenarioCandidates.add(scenarioCandidate);
            }
            scenarioCandidates = beforeScenarioCandidates;
            scenarioCandidates.addAll(afterScenarioCandidates);
        }
        ArrayList<RfField> fields = new ArrayList<RfField>();
        if (isDotAccess) {
            if (scopeContainer != null && scopeContainer.scope instanceof RfStruct && ((RfStruct)scopeContainer.scope).isSDLAgent() && (tmpFields = ((RfStruct)scopeContainer.scope).getFieldsWithPrefix(this.fModulePackageName, (RfStruct)scopeContainer.scope, this.fMatchType, prefix, 31)) != null) {
                fields.addAll(tmpFields);
            }
        } else if (enclosingSDLScenario != null) {
            tmpFields = enclosingSDLScenario.getFieldsWithPrefix(this.fModulePackageName, enclosingSDLScenario, this.fMatchType, prefix, 31);
            if (tmpFields != null) {
                fields.addAll(tmpFields);
            }
            if (enclosingSDLAgent != null && (tmpFields = enclosingSDLAgent.getFieldsWithPrefix(this.fModulePackageName, enclosingSDLAgent, this.fMatchType, prefix, 31)) != null) {
                fields.addAll(tmpFields);
            }
            if ((tmpFields = this.fRfProject.getGlobalFieldsWithPrefix(this.fModulePackageName, this.fMatchType, prefix)) != null) {
                fields.addAll(tmpFields);
            }
        }
        ArrayList<RfField> sdlAgentFields = new ArrayList<RfField>();
        for (RfField field : fields) {
            RfStruct struct;
            if (!(field.getAssociatedType() instanceof RfStruct) || !(struct = (RfStruct)field.getAssociatedType()).isSDLAgent()) continue;
            sdlAgentFields.add(field);
        }
        Collections.sort(sdlAgentFields, R2LUtils.getLexicalSorter(prefix, this.fRfProject.getLanguageKind()));
        ArrayList<RfNamedElement> candidates = new ArrayList<RfNamedElement>();
        candidates.addAll(scenarioCandidates);
        candidates.addAll(sdlAgentFields);
        return candidates.toArray(new RfNamedElement[scenarioCandidates.size()]);
    }

    @Override
    public RfNamedElement[] getSDLScenarioArg(R2LScopeContainer scenarioDotScopeContainer, boolean isScenarioDotAccess, String scenarioName, R2LScopeContainer argDotScopeContainer, boolean isArgDotAccess, String prefix, String argName, boolean isDefault, List<String> prevArgs) {
        ArrayList<RfNamedElement> candidates = new ArrayList<RfNamedElement>();
        boolean allPrevArgsByPosition = true;
        HashSet<String> usedParamNames = new HashSet<String>();
        for (String prevArg : prevArgs) {
            if (prevArg.isEmpty()) continue;
            allPrevArgsByPosition = false;
            usedParamNames.add(prevArg);
        }
        RfStruct calledScenario = null;
        RfStruct enclosingStruct = this.getEnclosingStruct(this.fInitialScope);
        RfStruct enclosingSDLAgent = null;
        if (enclosingStruct != null && enclosingStruct.isSDLScenario()) {
            enclosingSDLAgent = enclosingStruct.getSDLEnclosingAgent();
        }
        if (isScenarioDotAccess) {
            if (scenarioDotScopeContainer != null && scenarioDotScopeContainer.scope instanceof RfStruct && ((RfStruct)scenarioDotScopeContainer.scope).isSDLAgent()) {
                calledScenario = ((RfStruct)scenarioDotScopeContainer.scope).getSDLScenario(scenarioName);
            }
        } else {
            Collection<RfStruct> allStructs;
            if (enclosingSDLAgent != null) {
                calledScenario = enclosingSDLAgent.getSDLScenario(scenarioName);
            }
            if (calledScenario == null && (allStructs = this.fRfProject.getAllPackages()) != null) {
                for (RfStruct struct : allStructs) {
                    if (struct.isSDLAgent() && (calledScenario = struct.getSDLScenario(scenarioName)) != null) break;
                }
            }
        }
        RfField assignToParam = null;
        if (calledScenario != null) {
            if (argName != null) {
                assignToParam = calledScenario.getSDLParam(argName);
            } else {
                List<RfField> params = calledScenario.getSDLParams();
                if (allPrevArgsByPosition && params.size() > prevArgs.size()) {
                    assignToParam = params.get(prevArgs.size());
                }
                int paramIndex = -1;
                for (RfField param : params) {
                    int prevArgIndex = prevArgs.size() - ++paramIndex - 1;
                    if (prevArgIndex >= 0 && prevArgs.size() > prevArgIndex && prevArgs.get(prevArgIndex).isEmpty()) {
                        usedParamNames.add(param.getName());
                        continue;
                    }
                    if (usedParamNames.contains(param.getName()) || isDefault || !DVTStringUtil.regionMatches((String)param.getName(), (String)prefix, (int)this.fMatchType)) continue;
                    candidates.add(new R2LSDLScenarioInvocationByNameArgElement(param));
                }
            }
        }
        if (assignToParam != null) {
            ArrayList<R2LCandidateWrapper> r2lWrapperCandidates = new ArrayList<R2LCandidateWrapper>();
            if (isArgDotAccess) {
                if (argDotScopeContainer != null && argDotScopeContainer.scope != null) {
                    r2lWrapperCandidates.addAll(this.createR2LCandidateWrappers(0, assignToParam, argDotScopeContainer.scope.getFieldsWithPrefix(null, enclosingStruct, this.fMatchType, prefix, 31)));
                }
                r2lWrapperCandidates.add(new R2LCandidateWrapper(3, new RfPredefinedMethod(this.fRfProject, this.fRfProject.getSpecman().getPseudoStruct(this.fRfProject), "as_a", "type", "type", null, "Cast pseudo-method."), false));
            } else {
                List enumItems;
                RfType assignToParamAssociatedType = assignToParam.getAssociatedType();
                if (assignToParamAssociatedType instanceof RfScalarType && (enumItems = assignToParamAssociatedType.getEnumsWithPrefix(this.fMatchType, prefix)) != null) {
                    for (RfEnum enumItem : enumItems) {
                        r2lWrapperCandidates.add(new R2LCandidateWrapper(-1, enumItem, true));
                    }
                }
                if (this.fInitialScope != null) {
                    r2lWrapperCandidates.addAll(this.createR2LCandidateWrappers(0, assignToParam, this.fInitialScope.getFieldsWithPrefix(null, enclosingStruct, this.fMatchType, prefix, 31)));
                }
                if (enclosingSDLAgent != null) {
                    r2lWrapperCandidates.addAll(this.createR2LCandidateWrappers(1, assignToParam, enclosingSDLAgent.getFieldsWithPrefix(null, enclosingSDLAgent, this.fMatchType, prefix, 31)));
                }
                r2lWrapperCandidates.addAll(this.createR2LCandidateWrappers(2, assignToParam, this.fRfProject.getGlobalFieldsWithPrefix(null, this.fMatchType, prefix)));
            }
            Collections.sort(r2lWrapperCandidates, new R2LCandidateWrapperComparator(prefix));
            for (R2LCandidateWrapper r2lCandidateWrapper : r2lWrapperCandidates) {
                candidates.add(r2lCandidateWrapper.element);
            }
        }
        return candidates.toArray(new RfNamedElement[candidates.size()]);
    }

    private List<R2LCandidateWrapper> createR2LCandidateWrappers(int scope, RfField assignToParam, List<RfField> tmpFields) {
        ArrayList<R2LCandidateWrapper> candidates = new ArrayList<R2LCandidateWrapper>();
        if (tmpFields != null) {
            RfType assignToParamAssociatedType = assignToParam.getAssociatedType();
            for (RfField field : tmpFields) {
                if (SemanticUtils.compatibleAssign(this.fRfProject, assignToParam, field, SemanticUtils.AssignKind.ASSIGN)) {
                    candidates.add(new R2LCandidateWrapper(scope, field, true));
                    continue;
                }
                RfType fieldAssociatedType = field.getAssociatedType();
                if (assignToParamAssociatedType instanceof RfStruct && !(fieldAssociatedType instanceof RfStruct)) continue;
                if (assignToParamAssociatedType instanceof RfScalarType && fieldAssociatedType instanceof RfScalarType) {
                    candidates.add(new R2LCandidateWrapper(scope, field, false));
                }
                if (!(fieldAssociatedType instanceof RfStruct)) continue;
                candidates.add(new R2LCandidateWrapper(scope, field, false));
            }
        }
        return candidates;
    }

    static class R2LCandidateWrapper {
        int scopeLevel;
        RfNamedElement element;
        boolean typeMatch;

        public R2LCandidateWrapper(int scopeLevel, RfNamedElement element, boolean typeMatch) {
            this.scopeLevel = scopeLevel;
            this.element = element;
            this.typeMatch = typeMatch;
        }
    }

    static class R2LCandidateWrapperComparator
    implements Comparator<R2LCandidateWrapper> {
        String prefix;

        public R2LCandidateWrapperComparator(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public int compare(R2LCandidateWrapper el1, R2LCandidateWrapper el2) {
            if (el1.typeMatch && !el2.typeMatch) {
                return -1;
            }
            if (!el1.typeMatch && el2.typeMatch) {
                return 1;
            }
            if (this.prefix != null && this.prefix.equals(el1.element.getName()) && this.prefix.equals(el2.element.getName())) {
                return el1.scopeLevel - el2.scopeLevel;
            }
            if (this.prefix != null && this.prefix.equals(el1.element.getName())) {
                return -1;
            }
            if (this.prefix != null && this.prefix.equals(el2.element.getName())) {
                return 1;
            }
            if (el1.scopeLevel != el2.scopeLevel) {
                return el1.scopeLevel - el2.scopeLevel;
            }
            return el1.element.getName().compareToIgnoreCase(el2.element.getName());
        }
    }

    static class SafeFileLister {
        File folder;
        String[] fileExtensions;
        String matchString;
        long maxNofFilesToReturn;
        long timeToLiveMillis;
        List<File> listResult;
        long startTime = System.currentTimeMillis();

        public SafeFileLister(List<File> listResult, File folder, String[] fileExtensions, String matchString, long maxNofFilesToReturn, long timeToLiveMillis) {
            this.listResult = listResult;
            this.folder = folder;
            this.fileExtensions = fileExtensions;
            this.matchString = matchString;
            this.maxNofFilesToReturn = maxNofFilesToReturn;
            this.timeToLiveMillis = timeToLiveMillis;
        }

        public void listFilesSafely() {
            final long startTime = System.currentTimeMillis();
            try {
                this.folder.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        if (maxNofFilesToReturn == 0L) {
                            listResult.add(DUMMY_NUMBER_FILE);
                            throw new RuntimeException();
                        }
                        if (System.currentTimeMillis() - startTime > timeToLiveMillis) {
                            listResult.add(DUMMY_TIMEOUT_FILE);
                            throw new RuntimeException();
                        }
                        if (!DVTFileUtils.getInstance().validExtension(fileExtensions, file.getName()) && file.isFile()) {
                            return false;
                        }
                        if (!file.getName().contains(matchString)) {
                            return false;
                        }
                        --maxNofFilesToReturn;
                        listResult.add(file);
                        return true;
                    }
                });
            }
            catch (Exception exception) {}
        }
    }
}

