/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.r2lparser;

import antlr.Token;
import antlr.TokenStream;
import antlr.TokenStreamException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTCharacterScanner;
import ro.amiq.dvt.utils.DVTStringBuilder;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfMacro;
import ro.amiq.edt.base.model.reflection.RfMacroLayer;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.util.RfUtils;
import ro.amiq.edt.base.model.reflection.util.RfUtilsCommon;
import ro.amiq.edt.base.r2lparser.R2LToken;

public class R2LTokenizer
implements TokenStream {
    private IDocumentExtension3 fDocument;
    private int fInitialOffset;
    private DVTCharacterScanner fScanner;
    private Map<String, Integer> fKeywordsMap = new HashMap<String, Integer>();
    public boolean fStartsWithWhiteSpace;
    private boolean fFirstCharacter;
    private boolean fIsMethodProposal;
    private boolean fIsNotEventProposal;
    private String fText;
    private int fTextOffset;
    private int fCursorOffset;
    private RfProject fRfProject;
    private RfModule fModule;
    private R2LTokenizer fReplacementTokenizer;
    private boolean fFirstToken;
    private boolean fFirstChar;
    private boolean fFirstCharWordBoundary;
    private boolean fStopTokenizer;
    private boolean fShowMethodOverridesWizard;
    private static final char BEGINNING_OF_WORD = ' ';
    private static final char END_OF_WORD = ';';
    private static final char VAR_DECLARATION_COLON = ':';
    private static final char INSIDE_BRACKETS = '(';

    public R2LTokenizer(RfProject rfProject, RfModule rfModule, IDocument document, int offset, boolean enableTooltip) {
        this.fDocument = (IDocumentExtension3)document;
        this.fRfProject = rfProject;
        this.fModule = rfModule;
        this.fStopTokenizer = false;
        this.fCursorOffset = offset - 1;
        this.fInitialOffset = this.adjustTooltipOffset(document, enableTooltip, offset);
        this.fFirstCharacter = true;
        this.fStartsWithWhiteSpace = false;
        this.fScanner = new DVTCharacterScanner(100, document, Math.max(0, this.fInitialOffset - 1), false);
        this.initTokensMap(enableTooltip);
        this.fFirstToken = true;
        this.fShowMethodOverridesWizard = false;
        this.fFirstChar = !enableTooltip;
    }

    public R2LTokenizer(RfProject rfProject, String text) {
        this.fText = text;
        this.fRfProject = rfProject;
        this.fCursorOffset = this.fInitialOffset = text.length();
        this.fTextOffset = this.fInitialOffset;
        this.fFirstCharacter = true;
        this.fStartsWithWhiteSpace = false;
        this.initTokensMap(true);
        this.fFirstChar = false;
    }

    private void initTokensMap(boolean enableTooltip) {
        if (enableTooltip) {
            this.fKeywordsMap.put("type", 132);
        } else {
            this.fKeywordsMap.put("import", 119);
            this.fKeywordsMap.put("new", 126);
            this.fKeywordsMap.put("package", 124);
            this.fKeywordsMap.put("get_enclosing_unit", 133);
            this.fKeywordsMap.put("try_enclosing_unit", 133);
        }
        this.fKeywordsMap.put("emit", 105);
        this.fKeywordsMap.put("event", 105);
        this.fKeywordsMap.put("keeping", 134);
        this.fKeywordsMap.put("case", 129);
        this.fKeywordsMap.put("struct", 111);
        this.fKeywordsMap.put("unit", 111);
        this.fKeywordsMap.put("extend", 112);
        this.fKeywordsMap.put("when", 113);
        this.fKeywordsMap.put("like", 114);
        this.fKeywordsMap.put("cover", 105);
        this.fKeywordsMap.put("on", 105);
        this.fKeywordsMap.put("as_a", 117);
        this.fKeywordsMap.put("cross", 122);
        this.fKeywordsMap.put("item", 128);
        this.fKeywordsMap.put("return", 135);
        this.fKeywordsMap.put("transition", 125);
        this.fKeywordsMap.put("#ifdef", 115);
        this.fKeywordsMap.put("#ifndef", 115);
        this.fKeywordsMap.put("using", 141);
        if (this.fRfProject.isInSLNMode()) {
            this.fKeywordsMap.put("action", 111);
            this.fKeywordsMap.put("component", 111);
            this.fKeywordsMap.put("token", 136);
        }
        if (this.fRfProject.isInSDLMode()) {
            this.fKeywordsMap.put("agent", 111);
            this.fKeywordsMap.put("scenario", 111);
        }
    }

    public int getInitialOffset() {
        return this.fInitialOffset;
    }

    public boolean isMethodProposal() {
        return this.fIsMethodProposal;
    }

    public boolean isNotEventProposal() {
        return this.fIsNotEventProposal;
    }

    public boolean isShowMethodOverridesWizard() {
        return this.fShowMethodOverridesWizard;
    }

    private int adjustTooltipOffset(IDocument document, boolean enableLeftScan, int offset) {
        block9: {
            if (!enableLeftScan) {
                return offset;
            }
            this.fScanner = new DVTCharacterScanner(20, document, offset, true);
            String content = this.fDocument.getContentType("__e_partitioning", this.fScanner.getOffset(), false);
            if (content.equals("__dftl_partition_content_type")) break block9;
            return -1;
        }
        try {
            int mark = offset;
            char ch = '0';
            do {
                mark = this.mark();
            } while ((ch = (char)this.readChar()) != '\uffff' && (Character.isJavaIdentifierPart(ch) || ch == 39));
            while (Character.isWhitespace(ch)) {
                ch = this.readChar();
                if (ch == '\uffff') break;
            }
            if (ch == '(') {
                this.fIsNotEventProposal = true;
                this.fIsMethodProposal = true;
            } else if (ch == '.') {
                this.fIsNotEventProposal = true;
            }
            return mark;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return offset;
        }
    }

    protected void adjustOffsetToFirstOpenParen() {
        try {
            int nested = 0;
            while (this.mark() > 0) {
                char ch = this.readChar();
                if (ch == '\uffff') {
                    return;
                }
                if (ch == '(' && nested <= 0) {
                    return;
                }
                if (ch == '(') {
                    --nested;
                    continue;
                }
                if (ch != ')') continue;
                ++nested;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected R2LToken collectPotentialWhenSubtype(boolean isExtend, int backOffset) {
        originalScanner = this.fScanner;
        result = new DVTStringBuilder();
        try {
            if (this.fInitialOffset < 0) {
                return null;
            }
            this.fScanner = new DVTCharacterScanner(20, (IDocument)this.fDocument, this.fInitialOffset, true);
            ch = '\u0000';
            while ((ch = this.readChar()) != '\uffff') {
                block8: {
                    if ((Character.isJavaIdentifierPart(ch) || Character.isWhitespace(ch) || ch == '\'' || ch == ':') && (!isExtend || ch != '\n')) break block8;
                    originalScanner.setOffset(this.fInitialOffset);
                    this.fScanner = originalScanner;
                    ch = this.readChar();
                    if (ch == '\uffff') {
                        break;
                    }
                    ** GOTO lbl34
                }
                if (!Character.isJavaIdentifierPart(ch) && !Character.isWhitespace(ch) && ch != '\'' && ch != ':') {
                    this.fScanner = originalScanner;
                    return null;
                }
                result.append(ch);
                if (this.fScanner.getOffset() >= 0) continue;
                break;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        this.fScanner = originalScanner;
        return null;
lbl-1000:
        // 1 sources

        {
            result.prepend(ch);
            ch = this.readChar();
            if (ch == '\uffff') break;
lbl34:
            // 2 sources

            ** while (this.shouldNotStopAtColon((char)ch, (DVTStringBuilder)result) || (Character.isWhitespace((char)ch) || ch == '\'') && backOffset < this.mark())
        }
lbl35:
        // 2 sources

        this.fScanner.setOffset(this.fInitialOffset);
        return new R2LToken(0, result.toString().trim(), this.calculateOffset());
    }

    private int calculateOffset() throws BadLocationException {
        char ch;
        this.fScanner = new DVTCharacterScanner(20, (IDocument)this.fDocument, this.fInitialOffset - 1, false);
        int counter = 0;
        int beginningOfWord = -1;
        while ((ch = this.readChar()) != '\uffff') {
            switch (ch) {
                case ' ': {
                    if (beginningOfWord == -1) {
                        beginningOfWord = this.fInitialOffset - counter;
                    }
                    ++counter;
                    break;
                }
                case ';': {
                    if (beginningOfWord != -1) {
                        return beginningOfWord;
                    }
                    ++counter;
                    break;
                }
                case ':': {
                    ch = this.readChar();
                    if (ch == ':') {
                        counter += 2;
                        break;
                    }
                    return this.fInitialOffset - counter;
                }
                case '(': {
                    return this.fInitialOffset - counter;
                }
                default: {
                    ++counter;
                }
            }
        }
        if (beginningOfWord != -1) {
            return beginningOfWord;
        }
        return this.fInitialOffset - counter;
    }

    private boolean shouldNotStopAtColon(char ch, DVTStringBuilder result) {
        if (ch == ':') {
            ch = this.readChar();
            if (ch == ':') {
                result.prepend(":");
                return true;
            }
            return false;
        }
        return Character.isJavaIdentifierPart(ch);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private char readChar() {
        try {
            boolean isString;
            block9: {
                if (this.fText != null) {
                    --this.fTextOffset;
                    if (this.fTextOffset < 0) return '\uffff';
                    return this.fText.charAt(this.fTextOffset);
                }
                isString = false;
                while (this.fScanner.getOffset() > 0) {
                    if (this.fScanner.getOffset() > ((IDocument)this.fDocument).getLength()) {
                        return '\uffff';
                    }
                    if (this.fDocument.getDocumentPartitioner("__e_partitioning") != null) {
                        String content = this.fDocument.getContentType("__e_partitioning", this.fScanner.getOffset() - 1, false);
                        if (content.equals("__e_expansion")) {
                            return '\uffff';
                        }
                        if (!content.equals("__dftl_partition_content_type")) {
                            this.fScanner.read();
                            if (!content.equals("__e_string")) continue;
                            isString = true;
                            continue;
                        }
                    }
                    break block9;
                }
                return '\uffff';
            }
            if (isString) {
                return 'S';
            }
            char ch = (char)this.fScanner.read();
            if (!this.fFirstCharacter) return ch;
            this.fStartsWithWhiteSpace = Character.isWhitespace(ch);
            this.fFirstCharacter = false;
            return ch;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return '\uffff';
        }
    }

    public Token nextToken() throws TokenStreamException {
        Token result = this.internalNextToken();
        if (this.fFirstToken && result != null && (result.getType() == 121 || result.getType() == 120)) {
            this.fShowMethodOverridesWizard = true;
        } else if (this.fFirstToken && result != null && result.getType() == 103) {
            int offset = this.mark();
            try {
                Token next = this.internalNextToken();
                if (next != null && (next.getType() == 121 || next.getType() == 120)) {
                    this.fShowMethodOverridesWizard = true;
                }
            }
            catch (Exception exception) {}
            this.rewind(offset);
        }
        this.fFirstToken = false;
        if (this.fStopTokenizer) {
            return new R2LToken(1, "", this.mark());
        }
        if (result != null && result.getText() != null && result.getText().length() > 20000) {
            this.fStopTokenizer = true;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Token internalNextToken() throws TokenStreamException {
        try {
            int nested;
            char ch;
            DVTStringBuilder charBuff;
            block52: {
                block51: {
                    block50: {
                        int offset;
                        block49: {
                            block48: {
                                block47: {
                                    String structName;
                                    String packageName;
                                    int offset2;
                                    boolean noIdentifier;
                                    charBuff = new DVTStringBuilder();
                                    while (true) {
                                        RfMacro preproc;
                                        String replacement;
                                        block55: {
                                            block56: {
                                                block54: {
                                                    String userDefineReplace;
                                                    IRegion region2;
                                                    RfUtilsCommon.MacroRegion region;
                                                    if (this.fReplacementTokenizer != null) {
                                                        Token token = this.fReplacementTokenizer.internalNextToken();
                                                        if (token.getType() != 1) return token;
                                                        this.fReplacementTokenizer = null;
                                                    }
                                                    if (this.mark() == 0) {
                                                        return new R2LToken(1, "", this.mark());
                                                    }
                                                    ch = this.readChar();
                                                    if (this.fFirstChar) {
                                                        this.fFirstChar = false;
                                                        boolean bl = this.fFirstCharWordBoundary = !Character.isJavaIdentifierPart(ch);
                                                    }
                                                    if (this.fScanner != null && !this.fFirstToken && (region = this.getMacroStartOffset((IDocument)this.fDocument, (offset = this.fScanner.getOffset()) + 1)) != null && (region2 = region.getRegion()).getOffset() + region2.getLength() == offset + 1 && (userDefineReplace = region.getUserDefineReplace()) != null && userDefineReplace.length() > 0) {
                                                        this.fReplacementTokenizer = new R2LTokenizer(this.fRfProject, userDefineReplace);
                                                        if (region2.getOffset() < offset) {
                                                            this.fScanner.setOffset(region2.getOffset());
                                                            continue;
                                                        }
                                                    }
                                                    if (Character.isWhitespace(ch)) continue;
                                                    if (ch == '.') {
                                                        return new R2LToken(101, ".", this.mark());
                                                    }
                                                    if (ch == ';') {
                                                        return new R2LToken(121, ";", this.mark());
                                                    }
                                                    if (ch == '?') {
                                                        return new R2LToken(123, "?", this.mark());
                                                    }
                                                    if (!Character.isJavaIdentifierPart(ch) && ch != ':' && ch != '\'') break block54;
                                                    noIdentifier = ch == ':';
                                                    offset2 = this.mark();
                                                    packageName = null;
                                                    structName = null;
                                                    if (!Character.isJavaIdentifierPart(ch)) break block55;
                                                    break block56;
                                                }
                                                if (ch == '>' && this.fRfProject.isInSLNMode()) break block47;
                                                if (ch == '+' && this.fRfProject.isInSDLMode()) break block48;
                                                if (ch == '=') break block49;
                                                if (ch == '@') {
                                                    return new R2LToken(105, "@", this.mark());
                                                }
                                                if (ch == ',') {
                                                    return new R2LToken(108, ",", this.mark());
                                                }
                                                if (ch == ']') break block50;
                                                if (ch == ')') break block51;
                                                if (ch != '}') {
                                                    if (ch == '(') {
                                                        return new R2LToken(110, "(", this.mark());
                                                    }
                                                    if (ch == '[') {
                                                        return new R2LToken(131, "[", this.mark());
                                                    }
                                                    if (ch != '{') return new R2LToken(100, "" + ch, this.mark());
                                                    return new R2LToken(120, "{", this.mark());
                                                }
                                                break block52;
                                            }
                                            do {
                                                charBuff.prepend(ch);
                                                offset2 = this.mark();
                                            } while ((ch = this.readChar()) != '\uffff' && this.mark() >= 0 && Character.isJavaIdentifierPart(ch));
                                        }
                                        if (this.fRfProject == null || this.fFirstToken || (replacement = this.getPreprocReplacement(this.fModule, preproc = this.fRfProject.getPreproc(charBuff.toString().trim()))) == null) break;
                                        this.fReplacementTokenizer = new R2LTokenizer(this.fRfProject, replacement);
                                        this.rewind(offset2);
                                    }
                                    if (ch == ':') {
                                        char nch = this.readChar();
                                        if (nch != ':') {
                                            this.rewind(offset2);
                                            String text = charBuff.toString();
                                            if (!noIdentifier) return new R2LToken(103, text, this.mark());
                                            return new R2LToken(102, ":", this.mark());
                                        }
                                        Token t = this.internalNextToken();
                                        if (t.getType() != 103) {
                                            this.rewind(offset2);
                                            String text = charBuff.toString();
                                            return new R2LToken(103, text, this.mark());
                                        }
                                        offset2 = this.mark();
                                        packageName = ((R2LToken)t).getPackageName();
                                        if (packageName != null) {
                                            structName = t.getText();
                                        } else {
                                            packageName = t.getText();
                                        }
                                    } else if (ch == '\'') {
                                        boolean beforeTick = this.fCursorOffset < this.mark();
                                        String prefix = charBuff.toString();
                                        Token t = this.internalNextToken();
                                        if (t.getType() != 103 && t.getType() != 118) {
                                            this.rewind(offset2);
                                            String text = charBuff.toString();
                                            if (!this.isKeyword(text)) return new R2LToken(103, text, packageName, null, this.mark());
                                            return new R2LToken(this.fKeywordsMap.get(text), text, this.mark());
                                        }
                                        charBuff.prepend(ch);
                                        String qualifiedName = ((R2LToken)t).getQualifiedName();
                                        charBuff.prepend(qualifiedName == null ? t.getText() : qualifiedName);
                                        String text = charBuff.toString();
                                        prefix = beforeTick ? t.getText() : prefix;
                                        return new R2LToken(118, prefix, this.mark(), text);
                                    }
                                    String text = charBuff.toString();
                                    if (Character.isWhitespace(ch) && (text.equals("a") || text.equals("an"))) {
                                        int tokenOffset = this.mark();
                                        Token t = this.internalNextToken();
                                        if (t.getType() == 103 && t.getText().equals("is")) {
                                            return new R2LToken(127, text, tokenOffset);
                                        }
                                        if (t.getType() == 103 && t.getText().equals("not") && (t = this.internalNextToken()).getType() == 103 && t.getText().equals("is")) {
                                            return new R2LToken(127, text, tokenOffset);
                                        }
                                        this.rewind(offset2);
                                        if (!this.isKeyword(text)) return new R2LToken(103, text, this.mark());
                                        return new R2LToken(this.fKeywordsMap.get(text), text, this.mark());
                                    }
                                    if (ch == '#' && this.isKeyword("#" + text)) {
                                        return new R2LToken(this.fKeywordsMap.get("#" + text), "#" + text, this.mark());
                                    }
                                    this.rewind(offset2);
                                    if (!this.isKeyword(text)) return new R2LToken(103, text, packageName, structName, this.mark());
                                    return new R2LToken(this.fKeywordsMap.get(text), text, this.mark());
                                }
                                while ((ch = this.readChar()) != '\uffff' && this.mark() > 0 && Character.isWhitespace(ch)) {
                                }
                                if (ch == '{') return new R2LToken(139, ">", this.mark());
                                if (ch != ';') return new R2LToken(100, ">", this.mark());
                                return new R2LToken(139, ">", this.mark());
                            }
                            while ((ch = this.readChar()) != '\uffff' && this.mark() > 0 && Character.isWhitespace(ch)) {
                            }
                            if (ch == '{') return new R2LToken(140, "+", this.mark());
                            if (ch != ';') return new R2LToken(100, "+", this.mark());
                            return new R2LToken(140, "+", this.mark());
                        }
                        offset = this.mark();
                        do {
                            charBuff.prepend(ch);
                            offset = this.mark();
                        } while ((ch = this.readChar()) != '\uffff' && this.mark() > 0 && (ch == '=' || ch == '!' || ch == '<' || ch == '>'));
                        this.rewind(offset);
                        return new R2LToken(104, charBuff.toString(), this.mark());
                    }
                    nested = 0;
                    boolean ended = false;
                    do {
                        if ((ch = this.readChar()) == '\uffff') {
                            return new R2LToken(106, charBuff.deleteFirstChar().toString(), this.mark());
                        }
                        if (this.mark() == 0) {
                            return new R2LToken(100, "" + ch, this.mark());
                        }
                        charBuff.prepend(ch);
                        if (ch == '[' && nested < 0) {
                            ++nested;
                            continue;
                        }
                        if (ch == '[' && nested == 0) {
                            ended = true;
                            continue;
                        }
                        if (ch != ']') continue;
                        --nested;
                    } while (ch != '[' || !ended);
                    return new R2LToken(106, charBuff.deleteFirstChar().toString(), this.mark());
                }
                nested = 0;
                boolean ended = false;
                do {
                    if ((ch = this.readChar()) == '\uffff') {
                        return new R2LToken(107, charBuff.deleteFirstChar().toString(), this.mark());
                    }
                    if (this.mark() == 0) {
                        return new R2LToken(100, "" + ch, this.mark());
                    }
                    charBuff.prepend(ch);
                    if (ch == '(' && nested < 0) {
                        ++nested;
                        continue;
                    }
                    if (ch == '(' && nested == 0) {
                        ended = true;
                        continue;
                    }
                    if (ch != ')') continue;
                    --nested;
                } while (ch != '(' || !ended);
                return new R2LToken(107, charBuff.deleteFirstChar().toString(), this.mark());
            }
            nested = 0;
            boolean ended = false;
            do {
                if ((ch = this.readChar()) == '\uffff') {
                    return new R2LToken(116, charBuff.deleteFirstChar().toString(), this.mark());
                }
                if (this.mark() == 0) {
                    return new R2LToken(100, "" + ch, this.mark());
                }
                charBuff.prepend(ch);
                if (ch == '{' && nested < 0) {
                    ++nested;
                    continue;
                }
                if (ch == '{' && nested == 0) {
                    ended = true;
                    continue;
                }
                if (ch != '}') continue;
                --nested;
            } while (ch != '{' || !ended);
            return new R2LToken(116, charBuff.deleteFirstChar().toString(), this.mark());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return new R2LToken(1, "", this.mark());
        }
    }

    private String getPreprocReplacement(RfModule module, RfMacro preproc) {
        if (module == null || preproc == null) {
            return null;
        }
        List<RfDefElement> layers = preproc.getLayers();
        if (layers == null) {
            return null;
        }
        String result = null;
        for (RfDefElement layer : layers) {
            if (layer.getLayerModule() != null && layer.getLayerModule().getModuleIndex() > module.getModuleIndex()) break;
            RfMacroLayer preprocLayer = (RfMacroLayer)layer;
            result = preprocLayer.getReplacement();
        }
        return result;
    }

    protected int mark() {
        return this.fScanner == null ? this.fTextOffset : this.fScanner.getOffset();
    }

    private boolean isKeyword(String text) {
        if ((this.fFirstCharWordBoundary || !this.fFirstToken) && this.fKeywordsMap.containsKey(text)) {
            if ("cover".equals(text)) {
                this.fIsNotEventProposal = false;
                this.fIsMethodProposal = false;
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RfUtilsCommon.MacroRegion getMacroStartOffset(IDocument document, int offset) {
        try {
            Region region2;
            RfMacroLayer macroLayer;
            int length;
            int index;
            if (this.fModule == null) return null;
            if (document == null) return null;
            if (offset < 0) return null;
            if (offset >= document.getLength()) {
                return null;
            }
            int line = document.getLineOfOffset(offset) + 1;
            List<RfMacroLayer> macrosLayers = this.fModule.getMacrosLayers(line);
            if (macrosLayers == null) {
                return null;
            }
            Iterator<RfMacroLayer> iterator = macrosLayers.iterator();
            do {
                if (!iterator.hasNext()) {
                    return null;
                }
                macroLayer = iterator.next();
                int startOffset = Math.max(0, macroLayer.getStartOffset());
                int endOffset = Math.max(0, macroLayer.getEndOffset());
                Region defReg = new Region(startOffset, endOffset - startOffset);
                String defText = document.get(defReg.getOffset(), defReg.getLength());
                String macroString = macroLayer.getMacroInstanceStringLiteral();
                if (macroString == null) {
                    return null;
                }
                index = defReg.getOffset();
                length = 0;
                length = macroLayer.isDeclaration() ? defText.trim().length() : RfUtils.getLengthNoComments(document, index, macroString.length());
                region2 = new Region(index, length);
            } while (offset < index || offset > index + length);
            return new RfUtilsCommon.MacroRegion(macroLayer.getMacro(), (IRegion)region2, macroLayer.getUserDefinedReplace(), macroLayer);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        catch (Exception x) {
            DVTLogger.INSTANCE.logError((Throwable)x);
        }
        return null;
    }

    protected void rewind(int offset) {
        if (offset == -1) {
            offset = this.fInitialOffset;
            this.fTextOffset = this.fInitialOffset;
        }
        this.fTextOffset = offset;
        while (this.fScanner != null && this.fScanner.getOffset() < offset) {
            this.fScanner.unread();
        }
    }
}

