/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.statistics;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.statistics.FileInfo;
import ro.amiq.dvt.statistics.Info;
import ro.amiq.dvt.statistics.Metric;
import ro.amiq.dvt.statistics.RelevantInfo;
import ro.amiq.dvt.statistics.StatisticsUtilProviderBase;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfMacro;
import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfScalarType;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructMember;
import ro.amiq.edt.base.model.reflection.RfType;

public abstract class AbstractStatisticsUtilProvider
extends StatisticsUtilProviderBase {
    private EInfo structInfo;
    private EInfo methodInfo;
    private EInfo structLayerInfo;
    private EInfo methodLayerInfo;

    public void clean() {
        super.clean();
        this.structInfo = null;
        this.methodInfo = null;
        this.structLayerInfo = null;
        this.methodLayerInfo = null;
    }

    public abstract IEPluginConfig getPluginConfig();

    public void init() {
        super.init();
        this.structInfo = new EStructInfo();
        this.methodInfo = new EMethodInfo();
        this.structLayerInfo = new EStructLayerInfo();
        this.methodLayerInfo = new EMethodLayerInfo();
    }

    protected void collectSpecificStatistics(IProject project, IProgressMonitor progressMonitor) {
        super.collectSpecificStatistics(project, progressMonitor);
        RfProject rfProject = (RfProject)this.getRfProject(project);
        if (!this.setCurrentTask("Collecting preprocessing statistics ...", true)) {
            return;
        }
        int allNofPreprocessing = 0;
        int allNofDefineAs = 0;
        int allNofDefineAsInstances = 0;
        int allNofDefineAsComputed = 0;
        int allNofDefineAsComputedInstances = 0;
        List<RfMacro> allMacros = rfProject.getAllMacros(true, false);
        for (RfMacro rfMacro : allMacros) {
            List<RfDefElement> macroLayers;
            if (this.isFiltered(rfMacro)) continue;
            if (rfMacro.isAsComputed()) {
                ++allNofDefineAsComputed;
                macroLayers = rfMacro.getLayers();
                allNofDefineAsComputedInstances += macroLayers == null ? 0 : macroLayers.size() - 1;
                continue;
            }
            if (rfMacro.isPreprocessing()) {
                ++allNofPreprocessing;
                continue;
            }
            ++allNofDefineAs;
            macroLayers = rfMacro.getLayers();
            allNofDefineAsInstances += macroLayers == null ? 0 : macroLayers.size() - 1;
        }
        this.addSeparator();
        this.createAndAddMetric("Nof Preprocessing Macros", allNofPreprocessing);
        this.createAndAddMetric("Nof Define As Macros", allNofDefineAs);
        this.createAndAddMetric("Nof Define As Macro Instances", allNofDefineAsInstances);
        this.createAndAddMetric("Nof Define As Computed Macros", allNofDefineAsComputed);
        this.createAndAddMetric("Nof Define As Computed Macro Instances", allNofDefineAsComputedInstances);
        int allNofScalarTypes = 0;
        int allNofStructTypes = 0;
        int allNofUnitTypes = 0;
        int allNofMethodTypes = 0;
        if (!this.setCurrentTask("Collecting type statistics ...", true)) {
            return;
        }
        List<RfNamedElement> allTypes = rfProject.getAllTypes(false, false);
        for (RfType rfType : allTypes) {
            if (this.isFiltered(rfType)) continue;
            if (!this.setCurrentTask("Collecting type statistics for " + rfType.getSignature() + " ...", false)) {
                return;
            }
            if (rfType instanceof RfScalarType) {
                ++allNofScalarTypes;
                continue;
            }
            if (rfType instanceof RfStruct) {
                RfStruct rfStruct = (RfStruct)rfType;
                if (rfStruct.isPredefined()) continue;
                if (((RfStruct)rfType).isUnit()) {
                    ++allNofUnitTypes;
                } else {
                    ++allNofStructTypes;
                }
                EInfo structInfo = this.computeStructInfo(rfStruct);
                this.structInfo.update(structInfo);
                continue;
            }
            ++allNofMethodTypes;
        }
        this.addSeparator();
        this.createAndAddMetric("Nof Structs", allNofStructTypes);
        this.createAndAddMetric("Nof Units", allNofUnitTypes);
        this.createAndAddMetric("Nof Scalar Types", allNofScalarTypes);
        this.createAndAddMetric("Nof Method Types", allNofMethodTypes);
        if (allNofStructTypes > 0) {
            this.addSeparator();
            this.createAndAddMetrics(this.structInfo);
            this.createAndAddMetrics(this.structLayerInfo);
        }
        if (allNofMethodTypes > 0) {
            this.addSeparator();
            this.createAndAddMetrics(this.methodInfo);
            this.createAndAddMetrics(this.methodLayerInfo);
        }
        this.fProgressMonitor = null;
    }

    protected FileInfo computeFileInfo(String fileName) {
        FileInfo result;
        block19: {
            result = new FileInfo(fileName);
            BufferedReader in = null;
            try {
                try {
                    in = new BufferedReader(new FileReader(fileName));
                    String line = null;
                    boolean inComment = true;
                    while ((line = in.readLine()) != null) {
                        ++result.totalNofLines;
                        if ((line = line.trim()).startsWith("<'")) {
                            inComment = false;
                            ++result.commentNofLines;
                            continue;
                        }
                        if (line.startsWith("'>")) {
                            inComment = true;
                            ++result.commentNofLines;
                            continue;
                        }
                        if (line.startsWith("//")) {
                            ++result.commentNofLines;
                            continue;
                        }
                        if (line.startsWith("--")) {
                            ++result.commentNofLines;
                            continue;
                        }
                        if (line.length() == 0) {
                            ++result.emptyNofLines;
                            continue;
                        }
                        if (inComment) {
                            ++result.commentNofLines;
                            continue;
                        }
                        ++result.codeNofLines;
                        result.codeNofChars += line.length();
                    }
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    if (in == null) break block19;
                    try {
                        in.close();
                    }
                    catch (IOException e2) {
                        DVTLogger.INSTANCE.logError((Throwable)e2);
                    }
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                }
            }
        }
        return result;
    }

    private EInfo computeStructInfo(RfStruct rfStruct) {
        EInfo result = new EInfo(rfStruct.getName());
        RfStruct struct = rfStruct;
        while ((struct = struct.getParentStruct()) != null) {
            if (struct.isPredefined()) break;
            if (this.isFiltered(struct)) continue;
            ++result.nofLikeParents.counter;
        }
        result.nofLikeChildren.counter = this.countUnfiltered(rfStruct.getChildStructs());
        List<RfDefElement> layers = rfStruct.getLayers();
        if (layers != null) {
            for (RfDefElement layer : layers) {
                if (this.isFiltered(layer)) continue;
                ++result.nofLayers.counter;
                result.nofDefinitionLines.counter += layer.getEndLine() - layer.getStartLine() + 1;
                EInfo eInfo = this.computeStructLayerInfo(rfStruct, layer);
                this.structLayerInfo.update(eInfo);
            }
        }
        result.nofFields.counter = this.countUnfiltered(rfStruct.getFields());
        List<RfStructMember> methods = rfStruct.getMethods();
        if (methods != null) {
            ArrayList<RfMethod> filteredMethods = new ArrayList<RfMethod>();
            for (RfStructMember rfStructMember : methods) {
                if (((RfMethod)rfStructMember).isByEvent() || this.isFiltered(rfStructMember)) continue;
                filteredMethods.add((RfMethod)rfStructMember);
            }
            result.nofMethods.counter = filteredMethods.size();
            for (RfMethod rfMethod : filteredMethods) {
                EInfo methodInfo = this.computeMethodInfo(rfMethod);
                this.methodInfo.update(methodInfo);
            }
        }
        result.nofEvents.counter = this.countUnfiltered(rfStruct.getEvents());
        result.nofWhenSubtypes.counter = this.countUnfiltered(rfStruct.getSubTypeLayers());
        return result;
    }

    private EInfo computeMethodInfo(RfMethod rfMethod) {
        EInfo result = new EInfo(String.valueOf(rfMethod.getParentStruct().getName()) + "." + rfMethod.getName());
        List<RfDefElement> layers = rfMethod.getLayers();
        if (layers != null) {
            if (result.nofMethodLayers.counter < layers.size()) {
                result.nofMethodLayers.counter = layers.size();
            }
            for (RfDefElement layer : layers) {
                if (this.isFiltered(layer)) continue;
                result.nofDefinitionLines.counter += layer.getEndLine() - layer.getStartLine() + 1;
                EInfo methodLayerInfo = this.computeMethodLayerInfo(rfMethod, layer);
                this.methodLayerInfo.update(methodLayerInfo);
            }
        }
        return result;
    }

    private EInfo computeStructLayerInfo(RfStruct rfStruct, RfDefElement rfStructLayer) {
        EInfo result = new EInfo(String.valueOf(rfStruct.getName()) + " at line " + rfStructLayer.getStartLine() + " in file " + rfStructLayer.getLayerModule().getName());
        result.nofDefinitionLines.counter = rfStructLayer.getEndLine() - rfStructLayer.getStartLine() + 1;
        return result;
    }

    private EInfo computeMethodLayerInfo(RfMethod rfMethod, RfDefElement rfMethodLayer) {
        EInfo result = new EInfo(String.valueOf(rfMethod.getParentStruct().getName()) + "." + rfMethod.getName() + " at line " + rfMethodLayer.getStartLine() + " in file " + rfMethodLayer.getLayerModule().getName());
        result.nofDefinitionLines.counter = rfMethodLayer.getEndLine() - rfMethodLayer.getStartLine() + 1;
        return result;
    }

    protected boolean isFiltered(Object o) {
        if (o instanceof RfNamedElement) {
            RfNamedElement rfNamedElement = (RfNamedElement)o;
            List<RfDefElement> layers = rfNamedElement.getLayers();
            if (layers != null) {
                for (RfDefElement layer : layers) {
                    if (this.isFiltered(layer)) continue;
                    return false;
                }
            }
        } else {
            if (o instanceof RfDefElement) {
                RfDefElement defElement = (RfDefElement)o;
                RfModule layerModule = defElement.getLayerModule();
                if (layerModule == null) {
                    return true;
                }
                return this.isFiltered(layerModule.getParserPath().path);
            }
            if (o instanceof String) {
                return this.fSpm.isFiltered((String)o);
            }
        }
        return true;
    }

    protected int countUnfiltered(List<?> l) {
        int result = 0;
        if (l == null) {
            return result;
        }
        for (Object o : l) {
            if (this.isFiltered(o)) continue;
            ++result;
        }
        return result;
    }

    protected IRfSingleLangProject getRfProject(IProject project) {
        return this.getPluginConfig().getRfManager().getRfProject(project);
    }

    protected List<ParserPath> getCompiledParserPaths(IRfSingleLangProject rfProject) {
        RfProject edtProject = (RfProject)rfProject;
        Collection<RfModule> allModules = edtProject.getAllModules();
        return allModules.stream().filter(x -> !x.getName().startsWith(this.getPluginConfig().getTopPathPrefix())).map(x -> x.getParserPath()).distinct().collect(Collectors.toList());
    }

    private static class EInfo
    extends Info {
        public RelevantInfo nofLikeParents;
        public RelevantInfo nofLikeChildren;
        public RelevantInfo nofLayers;
        public RelevantInfo nofWhenSubtypes;
        public RelevantInfo nofDefinitionLines;
        public RelevantInfo nofFields;
        public RelevantInfo nofMethods;
        public RelevantInfo nofEvents;
        public RelevantInfo nofMethodLayers;

        protected EInfo(String elementName) {
            this.nofLikeParents = new RelevantInfo(elementName);
            this.nofLikeChildren = new RelevantInfo(elementName);
            this.nofLayers = new RelevantInfo(elementName);
            this.nofWhenSubtypes = new RelevantInfo(elementName);
            this.nofDefinitionLines = new RelevantInfo(elementName);
            this.nofFields = new RelevantInfo(elementName);
            this.nofMethods = new RelevantInfo(elementName);
            this.nofEvents = new RelevantInfo(elementName);
            this.nofMethodLayers = new RelevantInfo(elementName);
        }

        public void update(EInfo info) {
            ++this.counter;
            this.nofLikeParents.update(info.nofLikeParents);
            this.nofLikeChildren.update(info.nofLikeChildren);
            this.nofLayers.update(info.nofLayers);
            this.nofWhenSubtypes.update(info.nofWhenSubtypes);
            this.nofDefinitionLines.update(info.nofDefinitionLines);
            this.nofFields.update(info.nofFields);
            this.nofMethods.update(info.nofMethods);
            this.nofEvents.update(info.nofEvents);
            this.nofMethodLayers.update(info.nofMethodLayers);
        }
    }

    private static class EMethodInfo
    extends EInfo {
        public EMethodInfo() {
            super("N/A");
        }

        public List<Metric> getMetrics() {
            ArrayList<Metric> result = new ArrayList<Metric>();
            result.addAll(this.createMetric("Nof Method Layers", this.nofMethodLayers));
            result.addAll(this.createMetric("Method Size (lines)", this.nofDefinitionLines));
            return result;
        }
    }

    private static class EMethodLayerInfo
    extends EInfo {
        public EMethodLayerInfo() {
            super("N/A");
        }

        public List<Metric> getMetrics() {
            ArrayList<Metric> result = new ArrayList<Metric>();
            result.addAll(this.createMetric("Method Layer Size (lines)", this.nofDefinitionLines));
            return result;
        }
    }

    private static class EStructInfo
    extends EInfo {
        public MaxLineAndLayersMetric nofDefinitionLinesLayers = new MaxLineAndLayersMetric("N/A");

        public EStructInfo() {
            super("N/A");
        }

        @Override
        public void update(EInfo info) {
            super.update(info);
            this.nofDefinitionLinesLayers.update(info.nofDefinitionLines, info.nofLayers);
        }

        public List<Metric> getMetrics() {
            ArrayList<Metric> result = new ArrayList<Metric>();
            result.addAll(this.createMetric("Nof Like Hierarchy", this.nofLikeParents));
            result.addAll(this.createMetric("Nof Like Children", this.nofLikeChildren));
            result.addAll(this.createMetric("Nof Struct Layers", this.nofLayers));
            result.addAll(this.createMetric("Nof Explicit When Subtypes", this.nofWhenSubtypes));
            result.addAll(this.createMetric("Struct Size (lines)", this.nofDefinitionLinesLayers));
            result.addAll(this.createMetric("Nof Fields", this.nofFields));
            result.addAll(this.createMetric("Nof Methods", this.nofMethods));
            result.addAll(this.createMetric("Nof Events", this.nofEvents));
            return result;
        }
    }

    private static class EStructLayerInfo
    extends EInfo {
        public EStructLayerInfo() {
            super("N/A");
        }

        public List<Metric> getMetrics() {
            ArrayList<Metric> result = new ArrayList<Metric>();
            result.addAll(this.createMetric("Struct Layer Size (lines)", this.nofDefinitionLines));
            return result;
        }
    }

    private static class MaxLineAndLayersMetric
    extends RelevantInfo {
        int peekLinesNofLayers;

        public MaxLineAndLayersMetric(String elementName) {
            super(elementName);
        }

        public void update(RelevantInfo nofDefinitionLines, RelevantInfo nofLayers) {
            if (super.update(nofDefinitionLines)) {
                this.peekLinesNofLayers = nofLayers.counter;
            }
        }

        public List<Metric> getMetrics(String title, int counter) {
            List result = super.getMetrics(title, counter);
            result.add(new Metric.LongMetric("Max Struct Size (lines) Nof Layers", (long)this.peekLinesNofLayers));
            return result;
        }
    }
}

