/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.test;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.PerformRefactoringOperation;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.views.IOutlineTreeViewProvider;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.ForTestingOrDebuggingOnly;
import ro.amiq.dvt.test.ProductSafe;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.lazy.outline.DVTLazyOutlinePage;
import ro.amiq.dvt.ui.refactor.rename.DVTRenameDelegate;
import ro.amiq.dvt.ui.refactor.rename.DVTRenameProcessor;
import ro.amiq.dvt.ui.refactor.rename.DVTRenameRefactorInfo;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.util.RfUtils;
import ro.amiq.edt.base.model.reflection.util.RfUtilsCommon;
import ro.amiq.edt.base.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.edt.base.model.reflection.views.AbstractRfTreeElementWrapper;
import ro.amiq.edt.base.model.reflection.views.OutlineTreeViewProvider;
import ro.amiq.edt.base.ui.editor.AbstractEEditor;
import ro.amiq.edt.base.ui.editor.EEditorMessages;
import ro.amiq.edt.base.ui.editor.actions.ERenameRefactorAction;
import ro.amiq.edt.base.ui.refactor.rename.ERenameDelegate;
import ro.amiq.etools.eparser.EAST;

@ForTestingOrDebuggingOnly
public abstract class AbstractTestHelper
extends TestHelper {
    public static IOutlineTreeViewProvider wrp;
    private static List<Identifier> fIdentifiers;

    public abstract IEPluginConfig getPluginConfig();

    public Object getTypesRoot() {
        return TestHelper.getInstance().getTypesRoot();
    }

    public void navigateTo(int line, int column) {
        try {
            IEditorPart currentEditor = AbstractTestHelper.getActiveEditor();
            if (!(currentEditor instanceof DVTEditor)) {
                return;
            }
            ((DVTEditor)currentEditor).setCursor(((DVTEditor)currentEditor).getDocument().getLineOffset(line) + column);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private static IOutlineTreeViewProvider getUIRfOutlineTreeViewProvider() {
        DVTLazyOutlinePage eOutlinePage;
        ILabelProvider tmp;
        if (wrp == null && (tmp = (eOutlinePage = (DVTLazyOutlinePage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getAdapter(IContentOutlinePage.class)).getLabelProvider()) instanceof IOutlineTreeViewProvider) {
            wrp = (IOutlineTreeViewProvider)tmp;
        }
        return wrp;
    }

    public static String getOutlineText(Object wrapper) {
        return ((OutlineTreeViewProvider)AbstractTestHelper.getUIRfOutlineTreeViewProvider()).getText(wrapper, false);
    }

    public static Image getOutlineImage(Object wrapper) {
        return AbstractTestHelper.getUIRfOutlineTreeViewProvider().getImage(wrapper);
    }

    public static Object[] getOutlineChildren(Object wrapper) {
        List children;
        if (wrapper instanceof IDVTElementWrapper && (children = ((IDVTElementWrapper)wrapper).getChildren()) != null) {
            return children.toArray();
        }
        return null;
    }

    public static Object[] getChildren(Object wrapper) {
        List<AbstractRfTreeElementWrapper> children = ((AbstractRfTreeElementWrapper)((Object)wrapper)).getChildren();
        if (children == null || children.isEmpty()) {
            return null;
        }
        return children.toArray();
    }

    public static Object[] getTypeHierarchyChildren(Object wrapper) {
        List<AbstractRfTreeElementWrapper> children = ((AbstractRfTreeElementWrapper)((Object)wrapper)).getChildren();
        if (children == null) {
            return null;
        }
        return children.toArray();
    }

    public static String getFieldNameByImage(Image image) {
        try {
            Field[] fields;
            Field[] fieldArray = fields = DVTImages.class.getFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                Object candidate = field.get(null);
                if (candidate instanceof ImageDescriptor && image.equals((Object)DVTImages.imageCache.getImage((ImageDescriptor)candidate))) {
                    return field.getName();
                }
                ++n2;
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Image getImageByFieldName(String fieldName) {
        try {
            return AbstractTestHelper.getUIRfOutlineTreeViewProvider().getImageByFieldName(fieldName);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Image getImageByFieldName(String fieldName, Object with) {
        try {
            if (with instanceof IDVTElementWrapper) {
                ImageDescriptor descriptor = (ImageDescriptor)DVTImages.class.getDeclaredField(fieldName).get(null);
                return DVTImages.imageCache.getImage(descriptor);
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int getCurrentLine() {
        DVTEditor editor = (DVTEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        return editor.testGetCurrentLine();
    }

    public static void resetRfManager() {
        RfMixedLangManager.getInstance().reset();
    }

    @ProductSafe
    public static void addIdentifier(EAST node, String filename) {
        if (fIdentifiers == null) {
            return;
        }
        fIdentifiers.add(new Identifier(node, filename));
    }

    @ProductSafe
    public static boolean isRecordIdentifiers() {
        return fIdentifiers != null;
    }

    public static void clearIdentifiers() {
        fIdentifiers.clear();
    }

    public static void initIdentifiers() {
        fIdentifiers = new ArrayList<Identifier>();
    }

    public static List<Identifier> getIdentifiers() {
        return fIdentifiers;
    }

    public static boolean hasTooltip(int line, int column) {
        block3: {
            RfProject rfProject;
            int offset;
            IDocument document;
            AbstractEEditor editor;
            block4: {
                editor = (AbstractEEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
                offset = document.getLineOffset(line) + column;
                String contextType = ((IDocumentExtension3)document).getContentType("__e_partitioning", offset, false);
                if (!contextType.equals("__dftl_partition_content_type")) break block3;
                offset = Math.min(offset + 1, document.getLength() - 1);
                rfProject = editor.getRfProject();
                RfWNamedElementAndScope elementAndScope = RfUtils.getRfElement(rfProject, (ITextEditor)editor, document, offset, false);
                RfNamedElement element = null;
                if (elementAndScope == null || (element = elementAndScope.getNamedElement()) == null || element.getSignature() == null) break block4;
                return true;
            }
            try {
                RfUtilsCommon.MacroRegion macroRegion = RfUtils.getMacro(rfProject, (ITextEditor)editor, document, offset);
                return macroRegion != null;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        return false;
    }

    public static int selectText(int startLineNo, int startLineCol, int endLineNo, int endLineCol) {
        int selectedTextLength = 0;
        AbstractEEditor editor = (AbstractEEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        int startSelOffset = TestHelper.getInstance().computeOffset((DVTEditor)editor, startLineNo - 1, startLineCol - 1);
        int endSelOffset = TestHelper.getInstance().computeOffset((DVTEditor)editor, endLineNo - 1, endLineCol - 1);
        selectedTextLength = endSelOffset - startSelOffset;
        editor.selectAndReveal(startSelOffset, selectedTextLength);
        return selectedTextLength;
    }

    public static Object doRenameRefactorE(IEPluginConfig pluginConfig, DVTRenameRefactorInfo info) {
        Refactoring kk = AbstractTestHelper.getRefactorRenameE(AbstractTestHelper.getRenameProcessorE(pluginConfig, info));
        PerformRefactoringOperation pro = new PerformRefactoringOperation(kk, 6);
        try {
            pro.run((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return pro;
    }

    public static DVTRenameProcessor getRenameProcessorE(IEPluginConfig pluginConfig, DVTRenameRefactorInfo info) {
        ERenameDelegate delegate = new ERenameDelegate(pluginConfig, info, true);
        DVTRenameProcessor crp = new DVTRenameProcessor((DVTRenameDelegate)delegate);
        return crp;
    }

    public static Refactoring getRefactorRenameE(final DVTRenameProcessor processor) {
        Refactoring kk = new Refactoring(){

            public String getName() {
                return "kk";
            }

            public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
                return processor.createChange(pm);
            }

            public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
                return processor.checkInitialConditions(pm);
            }

            public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
                return processor.checkFinalConditions(pm, null);
            }
        };
        return kk;
    }

    public static void executeRefactoringRename(IEPluginConfig pluginConfig, DVTEditor editor) {
        ERenameRefactorAction rra = new ERenameRefactorAction(EEditorMessages.getResourceBundle(), "RefactorRename.", editor, pluginConfig);
        rra.run();
    }

    public List<String> getAsComputedMacroConsoleContent(IProject project) {
        RfProject rfProject = this.getPluginConfig().getRfManager().getRfProject(project);
        String consoleContent = rfProject.testGetAsComputedConsoleContent();
        if (consoleContent == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(consoleContent.split("\n"));
    }

    public static class Identifier {
        private String text;
        private String filename;
        private int line;
        private int column;

        public Identifier(EAST node, String filename) {
            this.text = node.getText();
            this.line = node.getLine();
            this.column = node.getColumn();
            this.filename = filename;
        }

        public String getFilename() {
            return this.filename;
        }

        public String getText() {
            return this.text;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }

        public void setColumn(int column) {
            this.column = column;
        }
    }
}

