/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.actions;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.diagrams.ch.utils.CHConfig;
import ro.amiq.dvt.diagrams.uml.UMLDiagram;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbUtils;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbInput;
import ro.amiq.dvt.ui.editor.breadcrumb.IDVTBreadcrumbHost;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.VHBreadcrumbViewer;
import ro.amiq.dvt.ui.search.BaseReferencesInWorkspaceAction;
import ro.amiq.dvt.ui.search.RWSearchTypeEnum;
import ro.amiq.dvt.ui.views.DVTTreeElementWrapper;
import ro.amiq.dvt.ui.views.DVTViewEvent;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.tree.utils.TreePathUtils;
import ro.amiq.dvt.ui.views.lazy.views.DVTLazyViewUtils;
import ro.amiq.dvt.ui.views.lazy.views.IDVTLazyView;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.IVHLabelProvider;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.edt.base.diagrams.chd.ECHDiagramHelper;
import ro.amiq.edt.base.diagrams.uml.EUMLHelper;
import ro.amiq.edt.base.model.reflection.Determinant;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfEvent;
import ro.amiq.edt.base.model.reflection.RfField;
import ro.amiq.edt.base.model.reflection.RfListType;
import ro.amiq.edt.base.model.reflection.RfMacro;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructLayer;
import ro.amiq.edt.base.model.reflection.RfType;
import ro.amiq.edt.base.model.reflection.views.AbstractEMacrosViewContributor;
import ro.amiq.edt.base.model.reflection.views.AbstractRfTreeElementWrapper;
import ro.amiq.edt.base.model.reflection.views.EQuickViewersUtil;
import ro.amiq.edt.base.model.reflection.views.ESequenceTreeNode;
import ro.amiq.edt.base.model.reflection.views.VHLabelProvider;
import ro.amiq.edt.base.ui.actions.AbstractMenuCommandDelegateCommon;
import ro.amiq.edt.base.ui.editor.AbstractEVHBreadcrumbUtils;
import ro.amiq.edt.base.ui.editor.actions.ReferencesInWorkspaceAction;
import ro.amiq.edt.base.ui.editor.actions.ShowConstraintsAction;
import ro.amiq.edt.base.ui.editor.actions.ShowEmittersAction;
import ro.amiq.edt.base.ui.editor.actions.ShowInstancesAction;

public abstract class AbstractMenuCommandDelegate
extends AbstractMenuCommandDelegateCommon {
    public boolean canHandle(IDVTElementWrapper wrapper) {
        if (wrapper == null) {
            return false;
        }
        if (wrapper.getLanguageKind() != this.getPluginConfig().getLanguageKind()) {
            return false;
        }
        if (wrapper.getRfElement() instanceof RfMacro) {
            return true;
        }
        if (wrapper.getRfElement() instanceof AbstractEMacrosViewContributor.CategoryWrapper) {
            return false;
        }
        return wrapper instanceof AbstractRfTreeElementWrapper || wrapper.getRfElement() instanceof AbstractRfTreeElementWrapper || wrapper.getRfElement() instanceof ESequenceTreeNode || wrapper instanceof DVTTreeElementWrapper && wrapper.getAdditionalInfo((Object)IDVTElementWrapper.Attribute.TREE_PATH) != null;
    }

    public boolean showUsages(IDVTElementWrapper wrapper) {
        IRfNamedElement namedElement = this.getNamedElement(wrapper);
        if (!this.canShowUsages(namedElement)) {
            return false;
        }
        try {
            IProject project = wrapper.getProject();
            RfProject rfProject = this.getPluginConfig().getRfManager().getRfProject(project);
            String[] fileExtensions = BaseReferencesInWorkspaceAction.getFileExtensions((IRfSingleLangProject)rfProject);
            FileTextSearchScope searchScope = FileTextSearchScope.newSearchScope((IResource[])new IResource[]{project}, (String[])fileExtensions, (boolean)false);
            ReferencesInWorkspaceAction.searchReferencesHelper(this.getPluginConfig(), project, (RfNamedElement)namedElement, searchScope, RWSearchTypeEnum.USAGES);
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return true;
    }

    public boolean showReadersUsages(IDVTElementWrapper wrapper) {
        IRfNamedElement namedElement = this.getNamedElement(wrapper);
        if (!this.canShowReaders(namedElement)) {
            return false;
        }
        try {
            IProject project = wrapper.getProject();
            RfProject rfProject = this.getPluginConfig().getRfManager().getRfProject(project);
            String[] fileExtensions = BaseReferencesInWorkspaceAction.getFileExtensions((IRfSingleLangProject)rfProject);
            FileTextSearchScope searchScope = FileTextSearchScope.newSearchScope((IResource[])new IResource[]{project}, (String[])fileExtensions, (boolean)false);
            ReferencesInWorkspaceAction.searchReferencesHelper(this.getPluginConfig(), project, (RfNamedElement)namedElement, searchScope, RWSearchTypeEnum.READERS);
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return true;
    }

    public boolean showWritersUsages(IDVTElementWrapper wrapper) {
        IRfNamedElement namedElement = this.getNamedElement(wrapper);
        if (!this.canShowWriters(namedElement)) {
            return false;
        }
        try {
            IProject project = wrapper.getProject();
            RfProject rfProject = this.getPluginConfig().getRfManager().getRfProject(project);
            String[] fileExtensions = BaseReferencesInWorkspaceAction.getFileExtensions((IRfSingleLangProject)rfProject);
            FileTextSearchScope searchScope = FileTextSearchScope.newSearchScope((IResource[])new IResource[]{project}, (String[])fileExtensions, (boolean)false);
            ReferencesInWorkspaceAction.searchReferencesHelper(this.getPluginConfig(), project, (RfNamedElement)namedElement, searchScope, RWSearchTypeEnum.WRITERS);
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return true;
    }

    public boolean showLayers(IDVTElementWrapper wrapper) {
        IRfNamedElement namedElement = this.getNamedElement(wrapper);
        if (!this.canShowLayers(namedElement)) {
            return false;
        }
        RfStructLayer structLayer = null;
        if (wrapper.getRfElement() instanceof RfDefElement) {
            RfDefElement rfElement = (RfDefElement)wrapper.getRfElement();
            if (rfElement != null) {
                structLayer = rfElement.getStructLayer();
            }
        } else {
            RfDefElement declaration = (RfDefElement)namedElement.getDeclaration();
            if (declaration != null) {
                structLayer = declaration.getStructLayer();
            }
        }
        RfStruct struct = null;
        if (structLayer != null) {
            struct = structLayer.getStruct();
        }
        EQuickViewersUtil.getInstance().updateLayersView(this.getPluginConfig(), (RfNamedElement)namedElement, wrapper.getProject(), struct, true, DVTViewEvent.EventKind.TRIGGER, "context_menu", true);
        return true;
    }

    public boolean showDesignHierarchy(IDVTElementWrapper wrapper, String partID) {
        return false;
    }

    public boolean showVerificationHierarchy(IDVTElementWrapper wrapper) {
        IRfNamedElement namedElement = this.getNamedElement(wrapper);
        if (!this.canShowVerificationHierarchy(namedElement)) {
            return false;
        }
        Object element = wrapper.getRfElement();
        RfDefElement defElement = null;
        if (namedElement instanceof RfField) {
            RfField field = (RfField)namedElement;
            RfType type = field.getAssociatedType();
            Determinant determinant = field.getAssociatedTypeDeterminant();
            if (type instanceof RfListType) {
                RfListType associatedType = (RfListType)field.getAssociatedType();
                type = associatedType.getAssociatedType();
                determinant = associatedType.getDeterminant();
            }
            if (field.isInstance() && type instanceof RfStruct) {
                RfStruct typeStruct = (RfStruct)type;
                RfProject rfProject = typeStruct.getRfProject();
                if (rfProject == null) {
                    return false;
                }
                if (!typeStruct.isUnit()) {
                    return false;
                }
                EQuickViewersUtil.getInstance().updateVerificationHierarchyViewer(typeStruct.getPackageName(), typeStruct.getName(), determinant, rfProject.getProject(), wrapper.getLanguageKind());
                return true;
            }
        } else if (element instanceof RfStructLayer) {
            defElement = (RfStructLayer)element;
        } else if (namedElement instanceof RfStruct) {
            defElement = ((RfStruct)namedElement).getDeclaration(false);
        }
        EQuickViewersUtil.getInstance().updateVerificationHierarchyViewer(defElement, wrapper.getProject(), wrapper.getLanguageKind());
        return true;
    }

    public boolean showTypeHierarchy(IDVTElementWrapper wrapper) {
        IRfNamedElement iRfNamedElement = this.getNamedElement(wrapper);
        if (!this.canShowHierarchy(iRfNamedElement)) {
            return false;
        }
        EQuickViewersUtil.getInstance().updateTypeHierarchyViewer(this.getPluginConfig(), (RfNamedElement)iRfNamedElement, wrapper.getProject(), true, DVTViewEvent.EventKind.TRIGGER, "context_menu", true);
        return true;
    }

    public boolean showDiagram(IDVTElementWrapper wrapper, String partID) {
        if (wrapper == null) {
            return false;
        }
        IRfNamedElement namedElement = this.getNamedElement(wrapper);
        Object umlElement = null;
        umlElement = wrapper.getRfElement() instanceof RfStructLayer ? wrapper.getRfElement() : namedElement;
        if (umlElement == null) {
            return false;
        }
        IProject project = wrapper.getProject();
        if (project == null) {
            IResource fileAdapter = namedElement.getFileAdapter();
            IProject iProject = project = fileAdapter != null ? fileAdapter.getProject() : DVTPlugin.getSelectionManager().getLastSelectedProject();
        }
        if ("ro.amiq.dvt.ui.views.VerificationHierarchyView".equals(partID) || "ro.amiq.dvt.ui.editor.breadcrumb.VHBreadcrumbViewer".equals(partID)) {
            if (!this.canShowComponentDiagram(wrapper)) {
                return false;
            }
            this.showComponentDiagramWithBreacrumb(wrapper, partID);
            return true;
        }
        if (!this.canShowDiagram(wrapper)) {
            return false;
        }
        UMLDiagram diagram = EUMLHelper.INSTANCE.makeStructDiagramFor(Collections.singleton(umlElement), project, this.getPluginConfig());
        if (diagram == null) {
            return false;
        }
        EUMLHelper.INSTANCE.openUMLDiagramEditor(diagram);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean showComponentDiagramWithBreacrumb(IDVTElementWrapper wrapper, String partID) {
        try {
            List segments = null;
            Object treePath = wrapper.getAdditionalInfo((Object)IDVTElementWrapper.Attribute.TREE_PATH);
            if ("ro.amiq.dvt.ui.views.VerificationHierarchyView".equals(partID)) {
                segments = treePath instanceof TreePath ? TreePathUtils.getAllElementsToRoot((TreePath)((TreePath)treePath), (boolean)true, (boolean)true) : wrapper.getAllElementsToRoot(true, true);
            } else if ("ro.amiq.dvt.ui.editor.breadcrumb.VHBreadcrumbViewer".equals(partID)) {
                IEditorPart activeEditor = DVTFileUtils.getInstance().getActiveEditor();
                if (!(activeEditor instanceof IDVTBreadcrumbHost)) {
                    return false;
                }
                BreadcrumbInput breadcrumbInput = AbstractBreadcrumbUtils.getBreadcrumbInput(VHBreadcrumbViewer.class, (IDVTBreadcrumbHost)((IDVTBreadcrumbHost)activeEditor));
                if (breadcrumbInput == null) {
                    return false;
                }
                Object element = wrapper.getRfElement();
                if (!(element instanceof IRfBreadcrumbElement)) {
                    return false;
                }
                if (element instanceof IRfNamedElement) {
                    element = ((AbstractEVHBreadcrumbUtils)this.getVHBreadcrumbUtils()).getDefElementUsingDeterminant((IRfNamedElement)element);
                }
                segments = breadcrumbInput.getSegmentsUpTo((IRfBreadcrumbElement)element);
            }
            if (treePath == null) {
                treePath = TreePathUtils.getTreePathFromBreadcrumb((List)segments, (IVHLabelProvider)new VHLabelProvider(this.getPluginConfig()));
            }
            wrapper.setAdditionalInfo((Object)IDVTElementWrapper.Attribute.TREE_PATH, treePath);
            CHConfig config = new CHConfig(null, LanguageKind.E);
            config.setBreadcrumbInput(new BreadcrumbInput(wrapper.getProject(), segments, this.getVHBreadcrumbUtils().getBreadcrumbSerializer()));
            ECHDiagramHelper.makeComponentDiagramFor(this.getPluginConfig(), wrapper, wrapper.getProject(), config);
            return true;
        }
        catch (Throwable e) {
            DVTLogger.INSTANCE.logError(e);
            return false;
        }
    }

    public boolean showConnectionsDiagram(IDVTElementWrapper wrapper) {
        return false;
    }

    public boolean showImports(IDVTElementWrapper wrapper) {
        return false;
    }

    public boolean showPDDefinition(IDVTElementWrapper wrapper) {
        return false;
    }

    public boolean showSNDiagram(IDVTElementWrapper wrapper) {
        return false;
    }

    public boolean copyInView(IDVTElementWrapper wrapper, String partID) {
        String itemName = "";
        TreeItem item = (TreeItem)wrapper.getItem();
        if (item == null) {
            if (DVTLazyViewUtils.ALL_LAZY_VIEWS.contains(partID)) {
                IViewPart viewById = ViewsUtils.getViewById((String)partID, (boolean)false);
                if (!(viewById instanceof IDVTLazyView)) {
                    return false;
                }
                ILabelProvider labelProvider = ((IDVTLazyView)viewById).getLabelProvider();
                itemName = labelProvider.getText((Object)wrapper);
            } else {
                itemName = "org.eclipse.ui.views.ContentOutline".equals(partID) ? (String)wrapper.getAdditionalInfo((Object)IDVTElementWrapper.Attribute.TO_STRING) : wrapper.getRfElement().toString();
            }
        } else {
            itemName = item.getText();
        }
        Utils.copyToClipboard((String)itemName, (int)3);
        return true;
    }

    public boolean showUVMSequenceTree(IDVTElementWrapper wrapper) {
        IRfNamedElement namedElement = this.getNamedElement(wrapper);
        if (!this.canShowUVMSequenceTree(namedElement)) {
            return false;
        }
        RfStructLayer structLayer = null;
        Object rfElement = wrapper.getRfElement();
        if (rfElement instanceof RfDefElement) {
            RfDefElement defElement = (RfDefElement)rfElement;
            structLayer = defElement.getStructLayer();
        } else {
            RfDefElement declaration = (RfDefElement)namedElement.getDeclaration();
            if (declaration != null) {
                structLayer = declaration.getStructLayer();
            }
        }
        RfStruct struct = null;
        if (structLayer != null) {
            struct = structLayer.getStruct();
        }
        EQuickViewersUtil.getInstance().updateUVMSequenceTreeView(this.getPluginConfig(), rfElement, (RfNamedElement)namedElement, wrapper.getProject(), struct, true, DVTViewEvent.EventKind.TRIGGER, "context_menu", true);
        return true;
    }

    public boolean showCallHierarchy(IDVTElementWrapper wrapper) {
        IRfNamedElement namedElement = this.getNamedElement(wrapper);
        if (!this.canShowCallHierarchy(namedElement)) {
            return false;
        }
        RfStructLayer structLayer = null;
        Object rfElement = wrapper.getRfElement();
        if (rfElement instanceof RfDefElement) {
            RfDefElement defElement = (RfDefElement)rfElement;
            structLayer = defElement.getStructLayer();
        } else {
            RfDefElement declaration = (RfDefElement)namedElement.getDeclaration();
            if (declaration != null) {
                structLayer = declaration.getStructLayer();
            }
        }
        EQuickViewersUtil.getInstance().updateCallHierarchyView(this.getPluginConfig(), rfElement, (RfNamedElement)namedElement, wrapper.getProject(), structLayer, true, DVTViewEvent.EventKind.TRIGGER, "context_menu", true);
        return true;
    }

    public boolean showConstraints(IDVTElementWrapper wrapper) {
        IRfNamedElement rfElement = this.getNamedElement(wrapper);
        if (rfElement instanceof RfDefElement) {
            rfElement = ((RfDefElement)rfElement).getNamedElement();
        }
        if (!(rfElement instanceof RfField)) {
            return false;
        }
        ShowConstraintsAction.showConstraints((RfField)rfElement);
        return true;
    }

    public boolean showEmitters(IDVTElementWrapper wrapper) {
        IRfNamedElement rfElement = this.getNamedElement(wrapper);
        if (rfElement instanceof RfDefElement) {
            rfElement = ((RfDefElement)rfElement).getNamedElement();
        }
        if (!this.canShowEmitters(rfElement)) {
            return false;
        }
        ShowEmittersAction.showEmitters((RfEvent)rfElement, this.getPluginConfig());
        return true;
    }

    public boolean showInstances(IDVTElementWrapper wrapper) {
        IRfNamedElement rfElement = this.getNamedElement(wrapper);
        if (rfElement instanceof RfDefElement) {
            rfElement = ((RfDefElement)rfElement).getNamedElement();
        }
        if (!this.canShowInstances(rfElement)) {
            return false;
        }
        ShowInstancesAction.showInstances(rfElement);
        return true;
    }

    public boolean showInstancesInDH(IDVTElementWrapper wrapper) {
        return false;
    }

    public boolean showAllInstancesInDH(IDVTElementWrapper wrapper) {
        return this.showInstancesInDH(wrapper);
    }
}

