/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.actions;

import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.utils.DVTDocumentCommon;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.edt.base.ui.actions.MacroActionUtils;
import ro.amiq.edt.base.ui.editor.AbstractEEditor;
import ro.amiq.edt.base.ui.macroexpansion.MacroExpansionManager;
import ro.amiq.edt.base.ui.macroexpansion.MacroExpansionScanner;

public abstract class MacroCollapseInlineExpansionActionCommon
extends TextEditorAction {
    public static final String NO_MACRO_EXPANSION_AT_CURSOR = "There is no macro expansion starting at the current cursor position!";
    public static final String BROKEN_MACRO_EXPANSION = "The expansion you are trying to collapse has been broken! (DVT pragmas modified/removed)";
    public static final String NESTED_MACROS_FOUND = "There are nested expansions inside the expansion you want to collapse. Do you wish to proceed?";
    protected Shell fShell;
    private static final Pattern NEW_LINE_WS = Pattern.compile("\n\\s*// ");

    protected MacroCollapseInlineExpansionActionCommon(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
    }

    public void run() {
        this.doReplacement(this.getTextEditor(), -1);
    }

    public void doReplacement(ITextEditor textEditor, int offset) {
        if (textEditor == null) {
            return;
        }
        this.initShell(textEditor);
        if (!this.checkIfValidShell()) {
            return;
        }
        IDocument document = this.getDocument();
        if (document == null) {
            return;
        }
        if (!(textEditor instanceof AbstractEEditor)) {
            return;
        }
        offset = offset == -1 ? ((AbstractEEditor)textEditor).getCursor() : offset;
        MacroExpansionScanner expansionScanner = MacroExpansionManager.getInstance().getExpansionScanner();
        MacroExpansionScanner.Expansion expansion = expansionScanner.getExpansion(document, offset);
        if (expansion == null || expansion.isIllegal()) {
            MacroActionUtils.showError(this.fShell, "No expansion detected", NO_MACRO_EXPANSION_AT_CURSOR);
            return;
        }
        if (expansion.isBroken()) {
            MacroActionUtils.showError(this.fShell, "Broken expansion", BROKEN_MACRO_EXPANSION);
            return;
        }
        if (expansion.isNested()) {
            MacroActionUtils.showWarning(this.fShell, "Nested expansions detected", NESTED_MACROS_FOUND).thenAccept(proceed -> {
                if (!proceed.booleanValue()) {
                    return;
                }
                this.replaceInDocumentWrapper(document, expansion, textEditor);
            });
            return;
        }
        this.replaceInDocumentWrapper(document, expansion, textEditor);
        ((DVTEditor)textEditor).selectAndReveal(expansion.getStartOffset() + 1, 0);
    }

    private void replaceInDocumentWrapper(IDocument document, MacroExpansionScanner.Expansion expansion, ITextEditor textEditor) {
        try {
            String commentedOriginal = document.get(expansion.getOriginalStartOffset(), expansion.getOriginalEndOffset() - expansion.getOriginalStartOffset());
            String original = MacroCollapseInlineExpansionActionCommon.blockUncomment(commentedOriginal, DVTDocumentCommon.getLineDelimiter((IEditorPart)textEditor));
            this.replaceInDocument(document, expansion, original);
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    protected abstract IDocument getDocument();

    protected abstract void replaceInDocument(IDocument var1, MacroExpansionScanner.Expansion var2, String var3);

    protected abstract void initShell(ITextEditor var1);

    protected abstract boolean checkIfValidShell();

    private static String blockUncomment(String in, String lineDelimiter) {
        in = in.replace("\r\n", "\n").replace("\r", "\n");
        in = DVTStringUtil.replaceAll((Pattern)NEW_LINE_WS, (CharSequence)("\n" + in), (String)"\n").substring(1);
        in = in.replace("\n", lineDelimiter);
        return in;
    }
}

