/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.actions;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ResourceBundle;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.edt.base.model.reflection.AbstractRfManager;
import ro.amiq.edt.base.ui.actions.MacroExpandActionCommon;
import ro.amiq.edt.base.utils.EDTFileUtils;

public class MacroExpandAction
extends MacroExpandActionCommon {
    public MacroExpandAction(ResourceBundle bundle, String prefix, ITextEditor editor, AbstractRfManager rfManager) {
        super(bundle, prefix, editor, rfManager);
    }

    @Override
    protected void openEditor(String text, int line) {
        String file = String.valueOf(ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString()) + '/' + "__expand_macro__.e";
        try {
            File f = new File(file);
            f.createNewFile();
            Throwable throwable = null;
            Object var6_8 = null;
            try (BufferedWriter out = new BufferedWriter(new FileWriter(file));){
                out.write("<'\n\n" + text + "\n\n'>\n");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            EDTFileUtils.getInstance().openEditor(f, line);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    protected ISelection getSelection(ISelectionProvider selectionProvider) {
        return selectionProvider != null ? selectionProvider.getSelection() : null;
    }

    @Override
    protected void initShell(ITextEditor textEditor) {
        this.fShell = textEditor.getSite().getShell();
    }

    @Override
    protected boolean checkIfValidShell() {
        return this.fShell != null;
    }

    @Override
    protected int getCursor() {
        ITextEditor editor = this.getTextEditor();
        if (!(editor instanceof DVTEditor)) {
            return -1;
        }
        return ((DVTEditor)editor).getCursor();
    }

    @Override
    protected IDocument getDocument() {
        ITextEditor textEditor = this.getTextEditor();
        if (textEditor == null) {
            return null;
        }
        return textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
    }

    @Override
    public void replaceInDocument(IDocument document, TextSelection selection, String replacement) {
        try {
            document.replace(selection.getOffset(), selection.getLength(), replacement);
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        ((DVTEditor)this.getTextEditor()).setCursor(selection.getOffset() + 10);
    }
}

