/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.actions;

import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.utils.DVTDocumentCommon;
import ro.amiq.edt.base.model.reflection.AbstractRfManager;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.util.RfUtils;
import ro.amiq.edt.base.model.reflection.util.RfUtilsCommon;
import ro.amiq.edt.base.ui.actions.MacroActionUtils;
import ro.amiq.edt.base.ui.editor.AbstractEEditor;
import ro.amiq.edt.base.ui.macroexpansion.MacroExpander;

public abstract class MacroExpandActionCommon
extends TextEditorAction {
    public static final String NO_MACRO_CALL_FOUND = "No macro call found at the current cursor position!";
    private int fExpandLevel = Integer.MAX_VALUE;
    private boolean fExpandInline;
    protected Shell fShell;
    private AbstractRfManager fRfManager;

    public int getExpandLevel() {
        return this.fExpandLevel;
    }

    public void setExpandLevel(int expandLevel) {
        this.fExpandLevel = expandLevel;
    }

    public boolean isExpandInline() {
        return this.fExpandInline;
    }

    public void setExpandInline(boolean expandInline) {
        this.fExpandInline = expandInline;
    }

    protected MacroExpandActionCommon(ResourceBundle bundle, String prefix, ITextEditor editor, AbstractRfManager rfManager) {
        super(bundle, prefix, editor);
        this.fRfManager = rfManager;
    }

    public void run() {
        block23: {
            try {
                RfProject rfProject;
                String trimSelectedText;
                String selectedText;
                ITextEditor textEditor = this.getTextEditor();
                if (textEditor == null) {
                    return;
                }
                IDocument document = this.getDocument();
                if (document == null) {
                    return;
                }
                this.initShell(textEditor);
                if (!this.checkIfValidShell()) {
                    return;
                }
                ISelectionProvider selectionProvider = textEditor.getSelectionProvider();
                ISelection selection = this.getSelection(selectionProvider);
                String string = selectedText = selection instanceof TextSelection ? ((TextSelection)selection).getText() : null;
                if (!(selection instanceof TextSelection)) break block23;
                RfUtilsCommon.MacroRegion macroRegion = null;
                int initialIndent = 0;
                int offset = this.getCursor();
                if (selectedText != null && (trimSelectedText = selectedText.trim()).length() > 0) {
                    if (trimSelectedText.endsWith(";") && offset == ((TextSelection)selection).getOffset() + selectedText.length()) {
                        offset = ((TextSelection)selection).getOffset() + selectedText.lastIndexOf(59) - 1;
                    } else if (offset == ((TextSelection)selection).getOffset() && Character.isWhitespace(selectedText.charAt(0))) {
                        offset += selectedText.indexOf(trimSelectedText) + 1;
                    }
                }
                if ((rfProject = ((AbstractEEditor)textEditor).getRfProject()) == null) {
                    return;
                }
                macroRegion = RfUtils.getMacro(rfProject, textEditor, document, offset);
                if (macroRegion == null) {
                    MacroActionUtils.showError(this.fShell, "No macro found", NO_MACRO_CALL_FOUND);
                    return;
                }
                IRegion lineRegion = document.getLineInformationOfOffset(offset);
                String lineText = document.get(lineRegion.getOffset(), lineRegion.getLength());
                int i = 0;
                while (i < lineText.length()) {
                    if (!Character.isWhitespace(lineText.charAt(i))) break;
                    ++initialIndent;
                    ++i;
                }
                selection = new TextSelection(document, macroRegion.getRegion().getOffset(), macroRegion.getRegion().getLength());
                selectedText = ((TextSelection)selection).getText();
                String contentType = ((IDocumentExtension3)document).getDocumentPartitioner("__e_partitioning").getContentType(((TextSelection)selection).getOffset());
                String expanded = new MacroExpander().expand(initialIndent, selectedText, rfProject, contentType, this.fExpandLevel, macroRegion.getUserDefineReplace());
                if (expanded == null) {
                    return;
                }
                try {
                    if (this.fExpandInline) {
                        this.replaceSelection(document, (TextSelection)selection, expanded);
                        break block23;
                    }
                    this.openEditor(expanded, 1);
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
            finally {
                ObjectionManager.getInstance().clear(Objection.MACRO_EXPAND);
            }
        }
    }

    private String blockComment(String in, String lineDelimiter) {
        in = in.replace("\r\n", "\n").replace("\r", "\n");
        in = in.replace("\n", "\n// ");
        in = in.replace("\n", lineDelimiter);
        return in;
    }

    protected void replaceSelection(IDocument document, TextSelection selection, String expanded) {
        String oldText = selection.getText();
        String replacement = "";
        String lineDelimiter = DVTDocumentCommon.getLineDelimiter((IEditorPart)this.getTextEditor());
        replacement = String.valueOf(replacement) + this.blockComment(String.valueOf(lineDelimiter) + "@DVT_EXPAND_MACRO_INLINE_START", lineDelimiter);
        replacement = String.valueOf(replacement) + this.blockComment(String.valueOf(lineDelimiter) + oldText, lineDelimiter);
        replacement = String.valueOf(replacement) + this.blockComment(String.valueOf(lineDelimiter) + "@DVT_EXPAND_MACRO_INLINE_ORIGINAL", lineDelimiter);
        replacement = String.valueOf(replacement) + lineDelimiter + expanded;
        replacement = String.valueOf(replacement) + this.blockComment(String.valueOf(lineDelimiter) + "@DVT_EXPAND_MACRO_INLINE_END", lineDelimiter);
        replacement = String.valueOf(replacement) + lineDelimiter;
        this.replaceInDocument(document, selection, replacement);
    }

    protected IProject getProject(ITextEditor textEditor) {
        if (textEditor == null) {
            return null;
        }
        IEditorInput editorInput = textEditor.getEditorInput();
        if (editorInput == null) {
            return null;
        }
        IFile file = (IFile)editorInput.getAdapter(IFile.class);
        if (file == null) {
            return null;
        }
        return file.getProject();
    }

    protected abstract int getCursor();

    protected abstract boolean checkIfValidShell();

    protected abstract void openEditor(String var1, int var2);

    protected abstract ISelection getSelection(ISelectionProvider var1);

    protected abstract void initShell(ITextEditor var1);

    protected abstract IDocument getDocument();

    public abstract void replaceInDocument(IDocument var1, TextSelection var2, String var3);
}

