/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.decorators;

import java.util.List;
import org.eclipse.jface.viewers.IDecoration;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.decorators.DVTAbstractDecorator;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfMethodLayer;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructLayer;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedMethod;
import ro.amiq.edt.base.model.reflection.views.AbstractRfTreeElementWrapper;

public abstract class AbstractOverrideDecorator
extends DVTAbstractDecorator {
    public void decorate(Object element, IDecoration decoration) {
        try {
            if (!(element instanceof AbstractRfTreeElementWrapper) && !(element instanceof TreePath)) {
                return;
            }
            Object rfElement = null;
            if (element instanceof AbstractRfTreeElementWrapper) {
                rfElement = ((AbstractRfTreeElementWrapper)((Object)element)).getRfElement();
            } else if (element instanceof TreePath) {
                rfElement = ((TreePath)element).getElement();
            }
            if (rfElement instanceof RfMethodLayer) {
                this.addOverrideDecorator((RfMethodLayer)rfElement, decoration);
            } else {
                if (!(element instanceof AbstractRfTreeElementWrapper)) {
                    return;
                }
                Object additionalInfo = ((AbstractRfTreeElementWrapper)((Object)element)).getAdditionalInfo(IDVTElementWrapper.Attribute.TYPES_MEMBERS_DEF);
                if (additionalInfo instanceof RfMethodLayer) {
                    this.addOverrideDecorator((RfMethodLayer)additionalInfo, decoration);
                }
            }
        }
        catch (Exception exception) {}
    }

    private void addOverrideDecorator(RfMethodLayer defElement, IDecoration decoration) {
        RfMethod method = defElement.getMethod();
        if (method == null) {
            return;
        }
        RfStructLayer currLayer = defElement.getStructLayer();
        if (currLayer == null) {
            return;
        }
        RfStruct currStruct = currLayer.getStruct();
        if (currStruct == null) {
            return;
        }
        if (method instanceof RfPredefinedMethod) {
            decoration.addOverlay(DVTImages.DESC_OVR_IMPLEMENTS, 2);
        } else {
            List<RfDefElement> layers = method.getLayers();
            RfDefElement lastLayer = null;
            int kind = 0;
            for (RfDefElement layer : layers) {
                if (layer == defElement) break;
                RfStructLayer prevLayer = layer.getStructLayer();
                RfStruct prevStruct = prevLayer.getStruct();
                if (currStruct == prevStruct) {
                    lastLayer = layer;
                    kind = 3;
                    continue;
                }
                if (!currStruct.isLike(prevStruct.getName())) continue;
                lastLayer = layer;
                kind = 0;
            }
            if (lastLayer != null && lastLayer.getDefFile() != null && lastLayer.getDefFile().getParserPath() != null) {
                switch (kind) {
                    case 3: {
                        decoration.addOverlay(DVTImages.DESC_OVR_EXTENDS, 2);
                        break;
                    }
                    case 0: {
                        decoration.addOverlay(DVTImages.DESC_OVR_OVERRIDES, 2);
                        break;
                    }
                }
            }
        }
    }
}

