/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.decorators;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.resources.properties.PropertiesManager;
import ro.amiq.dvt.resources.properties.PropertyTypes;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.views.AbstractRfTreeElementWrapper;

public abstract class AbstractTestFileDecorator
extends LabelProvider
implements ILightweightLabelDecorator {
    public abstract String getNature();

    public void decorate(Object element, IDecoration decoration) {
        try {
            if (element instanceof AbstractRfTreeElementWrapper && ((AbstractRfTreeElementWrapper)((Object)element)).getAccessDecoratorEnable()) {
                return;
            }
            IResource objectResource = this.getResource(element);
            if (objectResource == null) {
                return;
            }
            if (!objectResource.isAccessible()) {
                return;
            }
            IProject project = objectResource.getProject();
            if (project == null) {
                return;
            }
            if (!project.hasNature(this.getNature())) {
                return;
            }
            if (objectResource instanceof IFile) {
                if (PropertiesManager.getSessionProperty((IResource)objectResource, (String)PropertyTypes.QN_IMPORTED_FILE) != null) {
                    return;
                }
                if (PropertiesManager.getSessionProperty((IResource)objectResource, (String)PropertyTypes.QN_TEST_FILE) == null) {
                    return;
                }
                if (PropertiesManager.getSessionProperty((IResource)objectResource, (String)PropertyTypes.QN_ACTIVE_TEST_FILE) != null) {
                    if (BuildConfigManager.isSkip((IResource)objectResource)) {
                        decoration.addOverlay(DVTImages.DESC_OVR_IGNORED_ACTIVE_TEST_FILE, 0);
                    } else {
                        decoration.addOverlay(DVTImages.DESC_OVR_ACTIVE_TEST_FILE, 0);
                    }
                } else if (BuildConfigManager.isSkip((IResource)objectResource)) {
                    decoration.addOverlay(DVTImages.DESC_OVR_IGNORED_TEST_FILE, 0);
                } else {
                    decoration.addOverlay(DVTImages.DESC_OVR_TEST_FILE, 0);
                }
            }
        }
        catch (Exception exception) {}
    }

    private IResource getResource(Object object) {
        if (object instanceof AbstractRfTreeElementWrapper) {
            return this.getResource(((AbstractRfTreeElementWrapper)((Object)object)).getRfElement());
        }
        if (object instanceof RfModule) {
            return (IResource)((RfModule)object).getAdapter(IResource.class);
        }
        if (object instanceof RfNamedElement) {
            return (IResource)((RfNamedElement)object).getInternalAdapter(IResource.class);
        }
        if (object instanceof RfDefElement) {
            return (IResource)((RfDefElement)object).getInternalAdapter(IResource.class);
        }
        if (object instanceof IResource) {
            return (IResource)object;
        }
        if (object instanceof IAdaptable) {
            return (IResource)((IAdaptable)object).getAdapter(IResource.class);
        }
        return null;
    }

    public void refresh(Object[] elements) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this, elements)));
    }
}

