/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.editor;

import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import ro.amiq.dvt.ui.editor.DVTPositionUpdater;
import ro.amiq.dvt.ui.editor.IDVTDocumentSetupParticipant;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.ui.editor.EFastPartitionScanner;
import ro.amiq.edt.base.ui.editor.MacroPositionUpdater;

public abstract class AbstractEDocumentSetupParticipantCommon
implements IDVTDocumentSetupParticipant {
    protected FastPartitioner partitioner;

    public abstract IEPluginConfig getPluginConfig();

    public void setup(IDocument document) {
        if (document == null) {
            return;
        }
        this.addPositionCategories(document);
    }

    public void addPositionCategories(IDocument document) {
        DVTPositionUpdater semanticUpdater = new DVTPositionUpdater("SEMANTIC_HIGHLIGHT");
        DVTPositionUpdater reflectionUpdater = new DVTPositionUpdater("REFLECTION");
        DefaultPositionUpdater foldingUpdater = new DefaultPositionUpdater("__dvt_folding_position");
        MacroPositionUpdater macroUpdater = new MacroPositionUpdater("__dvt_macro_position");
        if (document instanceof IDocumentExtension3) {
            IDocumentExtension3 extension3 = (IDocumentExtension3)document;
            this.partitioner = new FastPartitioner((IPartitionTokenScanner)new EFastPartitionScanner(this.getPluginConfig()), new String[]{"__dftl_partition_content_type", "__e_expansion", "__e_sv_ml_comment", "__e_sl_comment", "__e_ml_comment", "__e_string", "__e_sl_comment_in_expansion", "__e_string_in_code_replacement_in_expansion", "__e_string_in_code_section_in_expansion"});
            extension3.setDocumentPartitioner("__e_partitioning", (IDocumentPartitioner)this.partitioner);
            this.partitioner.connect(document);
        }
        document.addPositionCategory("SEMANTIC_HIGHLIGHT");
        document.addPositionUpdater((IPositionUpdater)semanticUpdater);
        document.addPositionCategory("__dvt_folding_position");
        document.addPositionUpdater((IPositionUpdater)foldingUpdater);
        document.addPositionCategory("REFLECTION");
        document.addPositionUpdater((IPositionUpdater)reflectionUpdater);
        document.addPositionCategory("__dvt_macro_position");
        document.addPositionUpdater((IPositionUpdater)macroUpdater);
    }

    public void disconnect() {
        if (this.partitioner != null) {
            this.partitioner.disconnect();
        }
        this.partitioner = null;
    }
}

