/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.editor;

import java.io.File;
import java.util.ResourceBundle;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.internal.resources.MarkerInfo;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.texteditor.TextEditorAction;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.core.IPluginConfig;
import ro.amiq.dvt.model.problems.EProblemCategories;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.actions.CopyFileInfoAction;
import ro.amiq.dvt.ui.actions.CopyFileInfoKind;
import ro.amiq.dvt.ui.actions.DVTQuickMenuCreator;
import ro.amiq.dvt.ui.editor.DVTContentAssistAction;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTFileDocumentProvider;
import ro.amiq.dvt.ui.editor.DVTSourceViewerConfiguration;
import ro.amiq.dvt.ui.editor.DVTTextOperationAction;
import ro.amiq.dvt.ui.editor.actions.IReferencesAction;
import ro.amiq.dvt.ui.editor.actions.ToggleMarkOccurrencesAction;
import ro.amiq.dvt.ui.editor.contentasisst.IDVTContentAssistConstants;
import ro.amiq.dvt.ui.editor.emulation.EditorEmulationAction;
import ro.amiq.dvt.ui.editor.emulation.EditorEmulationContributionItem;
import ro.amiq.dvt.ui.editor.formatter.detectindentation.DVTAutoIndentDetectionManager;
import ro.amiq.dvt.ui.editor.highlight.DVTHlUtils;
import ro.amiq.dvt.ui.editor.highlight.DVTSemanticHighlighter;
import ro.amiq.dvt.ui.editor.hover.DVTInformationControl;
import ro.amiq.dvt.ui.editor.lazy.outline.DVTLazyOutlinePage;
import ro.amiq.dvt.ui.editor.lazy.outline.QuickLazyOutlineView;
import ro.amiq.dvt.ui.editor.scopebreadcrumb.ScopeBreadcrumbUtils;
import ro.amiq.dvt.ui.editor.scopebreadcrumb.ScopeBreadcrumbViewer;
import ro.amiq.dvt.ui.projectcolors.ProjectColorUtils;
import ro.amiq.dvt.ui.search.ui.IBaseShowConstraintsAction;
import ro.amiq.dvt.ui.search.ui.IBaseShowEmittersAction;
import ro.amiq.dvt.ui.search.ui.IBaseShowInstancesAction;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.util.RfUtils;
import ro.amiq.edt.base.model.reflection.views.EQuickViewersUtil;
import ro.amiq.edt.base.templates.TemplateMessages;
import ro.amiq.edt.base.ui.actions.MacroCollapseInlineExpansionAction;
import ro.amiq.edt.base.ui.actions.MacroExpandAllLevelsAction;
import ro.amiq.edt.base.ui.actions.MacroExpandAllLevelsInlineAction;
import ro.amiq.edt.base.ui.editor.AbstractEDocumentSetupParticipant;
import ro.amiq.edt.base.ui.editor.AbstractEEditorCommon;
import ro.amiq.edt.base.ui.editor.EEditorMessages;
import ro.amiq.edt.base.ui.editor.ESourceViewerConfiguration;
import ro.amiq.edt.base.ui.editor.actions.ERefactorExtractToMethodAction;
import ro.amiq.edt.base.ui.editor.actions.ERefactorExtractToTCMAction;
import ro.amiq.edt.base.ui.editor.actions.ERenameRefactorAction;
import ro.amiq.edt.base.ui.editor.actions.GoToImportAction;
import ro.amiq.edt.base.ui.editor.actions.OpenDeclarationAction;
import ro.amiq.edt.base.ui.editor.actions.OverrideMethodsAction;
import ro.amiq.edt.base.ui.editor.actions.ReferencesInFileAction;
import ro.amiq.edt.base.ui.editor.actions.ReferencesInProjectAction;
import ro.amiq.edt.base.ui.editor.actions.ReferencesInWorkingSetAction;
import ro.amiq.edt.base.ui.editor.actions.ReferencesInWorkspaceAction;
import ro.amiq.edt.base.ui.editor.actions.ShowConstraintsAction;
import ro.amiq.edt.base.ui.editor.actions.ShowDiagramAction;
import ro.amiq.edt.base.ui.editor.actions.ShowEmittersAction;
import ro.amiq.edt.base.ui.editor.actions.ShowInstancesAction;
import ro.amiq.edt.base.ui.editor.actions.ShowReadersUsagesAction;
import ro.amiq.edt.base.ui.editor.actions.ShowWritersUsagesAction;
import ro.amiq.edt.base.ui.editor.actions.ToggleCommentAction;
import ro.amiq.edt.base.ui.editor.highlight.ESemanticHighlighter;
import ro.amiq.edt.base.ui.editor.hover.EHoverSourceInformationPresenter;
import ro.amiq.edt.base.ui.editor.lazy.outline.ELazyOutlinePage;
import ro.amiq.edt.base.ui.editor.lazy.outline.EQuickLazyOutlineView;
import ro.amiq.edt.base.utils.EDTFileUtils;

public abstract class AbstractEEditor
extends AbstractEEditorCommon {
    private ELazyOutlinePage fOutlinePage;
    private boolean fIsConnectedToDocument = false;
    private IInformationPresenter fOutlinePresenter;
    public static final String TOGGLE_MARK_OCCURRENCES = "ro.amiq.edt.base.ui.editor.ToggleMarkOccurrences";
    public static final String DEFINE_FOLDING_REGION = "ro.amiq.edt.base.ui.editor.DefineFoldingRegion";
    public static final String EXPAND_FIRST_LEVEL = "ro.amiq.edt.base.ui.editor.ExpandFirstLevel";
    public static final String EXPAND_ALL_LEVELS = "ro.amiq.edt.base.ui.editor.ExpandAllLevels";
    public static final String COLLAPSE_ALL_LEVELS = "ro.amiq.edt.base.ui.editor.CollapseAllLevels";
    public static final String SHOW_ACTIVE_PREPROCESSING = "ro.amiq.edt.base.ui.editor.ShowActivePreprocessing";
    public static final String FORWARD_END_OF_WORD = "ro.amiq.edt.base.ui.editor.ForwardEndOfWord";
    public static final String BACKWARD_START_OF_WORD = "ro.amiq.edt.base.ui.editor.BackwardStartOfWord";
    public static final String SELECT_ENCLOSING_ELEMENT = "ro.amiq.edt.base.ui.editor.SelectEnclosingElement";
    public static final String RESTORE_LAST_SELECTION = "ro.amiq.edt.base.ui.editor.RestoreLastSelection";
    public static final String GOTO_PAIR_BRACKET = "ro.amiq.edt.base.ui.editor.GoToPairBracket";
    public static final String TOGGLE_COLLAPSE_LINE = "ro.amiq.edt.base.ui.editor.ToggleCollapseLine";
    public static final String TOGGLE_EXPAND_SCOPE = "ro.amiq.edt.base.ui.editor.ToggleExpandScope";
    public static final String TEMPLATE_PROPOSALS = "template_proposals_action";
    public static final String TOGGLE_COMMENT = "ro.amiq.edt.base.ui.editor.ToggleComment";
    public static final String FORMAT_SOURCE = "ro.amiq.edt.base.ui.editor.FormatSource";
    public static final String OPEN_DECLARATION = "ro.amiq.edt.base.ui.editor.OpenDeclaration";
    public static final String IMPORTING_FILE = "ro.amiq.edt.base.ui.editor.ImportingFile";
    public static final String OVERRIDE_METHODS = "ro.amiq.edt.base.ui.editor.OverrideMethods";
    public static final String MACROS_EXPAND_ALL_LEVELS = "ro.amiq.edt.base.ui.editor.MacrosExpandAllLevels";
    public static final String MACROS_EXPAND_ALL_LEVELS_INLINE = "ro.amiq.edt.base.ui.editor.MacrosExpandAllLevelsInline";
    public static final String MACROS_COLLAPSE_INLINE_EXPANSION = "ro.amiq.edt.base.ui.editor.MacrosCollapseInlineExpansion";
    public static final String MACROS_SUBMENU = "ro.amiq.edt.base.ui.editor.MacrosSubMenu";
    public static final String SHOW_DIAGRAM = "ro.amiq.edt.base.ui.editor.ShowDiagram";
    public static final String QUICK_OUTLINE = "ro.amiq.edt.base.ui.editor.QuickOutline";
    public static final String OPEN_HELP_SEARCH = "ro.amiq.edt.base.ui.editor.OpenHelpSearch";
    public static final String QUICK_RFMACROS = "ro.amiq.edt.base.ui.editor.QuickRfMacros";
    public static final String SWITCH_COMMENT_STYLE = "ro.amiq.edt.base.ui.editor.SwitchCommentStyle";
    public static final String SOURCE_SUBMENU = "ro.amiq.edt.base.ui.editor.SourceSubMenu";
    public static final String REFERENCES_IN_WORKSPACE = "ro.amiq.edt.base.ui.editor.actions.ReferencesInWorkspace";
    public static final String REFERENCES_IN_PROJECT = "ro.amiq.edt.base.ui.editor.actions.ReferencesInProject";
    public static final String REFERENCES_IN_FILE = "ro.amiq.edt.base.ui.editor.actions.ReferencesInFile";
    public static final String REFERENCES_IN_WORKING_SET = "ro.amiq.edt.base.ui.editor.actions.ReferencesInWorkingSet";
    public static final String REFERENCES_SUBMENU_COMMAND_ID = "ro.amiq.edt.base.ui.editor.ReferencesSubMenu";
    public static final String REFACTOR_RENAME = "ro.amiq.edt.base.ui.editor.actions.RefactorRename";
    private static final String REFACTOR_EXTRACT_TO_METHOD = "ro.amiq.edt.base.ui.editor.actions.RefactorExtractToMethod";
    private static final String REFACTOR_EXTRACT_TO_TCM = "ro.amiq.edt.base.ui.editor.actions.RefactorExtractToTCM";
    public static final String REFACTOR_SUBMENU = "ro.amiq.edt.base.ui.editor.RefactorSubMenu";
    public static final String COPY_FULL_PATH = "ro.amiq.edt.base.ui.editor.CopyFullPath";
    public static final String COPY_FILE_NAME = "ro.amiq.edt.base.ui.editor.CopyFileName";
    public static final String SHOW_CONSTRAINTS = "ro.amiq.dvt.ui.views.commands.ShowConstraints";
    public static final String SHOW_INSTANCES = "ro.amiq.dvt.ui.views.commands.ShowInstances";
    public static final String SHOW_EMITTERS = "ro.amiq.dvt.ui.views.commands.ShowEmitters";
    private CustomGotoMarker fCustomGotoMarker = new CustomGotoMarker();

    protected AbstractEEditor() {
        this.getPluginConfig().getPlugin().getWorkbench().getDecoratorManager().addListener((ILabelProviderListener)this);
        this.setHelpContextId("ro.amiq.edt.base.help.editor");
    }

    protected AbstractEEditor(IDocument document) {
        super(document);
    }

    @Override
    protected DVTSourceViewerConfiguration createSourceViewerConfiguration() {
        return new ESourceViewerConfiguration(this.getPluginConfig(), this);
    }

    public void dispose() {
        try {
            try {
                ProjectionViewer viewer;
                ESourceViewerConfiguration configuration = (ESourceViewerConfiguration)this.getSourceViewerConfiguration();
                if (configuration != null) {
                    configuration.dispose();
                }
                if ((viewer = (ProjectionViewer)this.getSourceViewer()) != null) {
                    viewer.unconfigure();
                    viewer.setProjectionSummary(null);
                }
                DVTAutoIndentDetectionManager.INSTANCE.removeDetectedIndendationDocument(this.getDocument());
                this.disconnectModuleFromDocument();
                TextEditorAction action = (TextEditorAction)this.getAction("ToggleMarkOccurrences");
                if (action != null) {
                    action.setEditor(null);
                }
                if ((action = (TextEditorAction)this.getAction("ToggleComment")) != null) {
                    action.setEditor(null);
                }
                this.fOutlinePage = null;
                if (this.fOutlinePresenter != null) {
                    this.fOutlinePresenter.uninstall();
                    this.fOutlinePresenter = null;
                }
                RfUtils.clearCaches();
                this.disposeListeners();
                AbstractEDocumentSetupParticipant setupParticipant = (AbstractEDocumentSetupParticipant)((DVTFileDocumentProvider)this.getDocumentProvider()).getDocumentSetupParticipant();
                setupParticipant.disconnect();
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                super.dispose();
            }
        }
        finally {
            super.dispose();
        }
    }

    public void disposeListeners() {
        this.getPluginConfig().getPlugin().getWorkbench().getDecoratorManager().removeListener((ILabelProviderListener)this);
        super.disposeListeners();
    }

    public void configureProjectionSupport(ProjectionSupport projectionSupport) {
        projectionSupport.addSummarizableAnnotationType(EProblemCategories.E_SYNTAX.getMarkerId());
        projectionSupport.addSummarizableAnnotationType(EProblemCategories.E_SEMANTIC.getMarkerId());
        projectionSupport.addSummarizableAnnotationType(EProblemCategories.E_NAME_CHECKING.getMarkerId());
        projectionSupport.addSummarizableAnnotationType(EProblemCategories.SLN_SYNTAX.getMarkerId());
        projectionSupport.addSummarizableAnnotationType(EProblemCategories.SLN_SEMANTIC.getMarkerId());
        projectionSupport.addSummarizableAnnotationType(EProblemCategories.SLN_NAME_CHECKING.getMarkerId());
        projectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.error");
        projectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.warning");
        projectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.bookmark");
        projectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.task");
        projectionSupport.addSummarizableAnnotationType("ro.amiq.dvt.ui.occurrences");
        projectionSupport.setHoverControlCreator(new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell shell) {
                return new DVTInformationControl(shell, (DefaultInformationControl.IInformationPresenter)new EHoverSourceInformationPresenter(AbstractEEditor.this.getPluginConfig()));
            }
        });
    }

    public void configureSourceViewerConfiguration(ProjectionAnnotationModel annotationModel) {
        ESourceViewerConfiguration configuration = (ESourceViewerConfiguration)this.getSourceViewerConfiguration();
        configuration.setProjectionAnnotationModel(annotationModel);
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        support.setMatchingCharacterPainterPreferenceKeys("matchingBracketsEEnable", "matchingBracketsEColor");
        super.configureSourceViewerDecorationSupport(support);
    }

    public Object getAdapter(Class required) {
        if (IGotoMarker.class.equals((Object)required)) {
            return this.fCustomGotoMarker;
        }
        if (IContentOutlinePage.class.equals((Object)required)) {
            if (this.fOutlinePage == null) {
                this.fOutlinePage = new ELazyOutlinePage(this.getPluginConfig(), this);
            }
            if (this.fOutlinePage.getEditor() == null) {
                this.fOutlinePage.setEditor(this);
            }
            return this.fOutlinePage;
        }
        return super.getAdapter(required);
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            super.doSave(monitor);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void doSaveAs() {
        try {
            super.doSaveAs();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void doSetInput(IEditorInput input) throws CoreException {
        try {
            super.doSetInput(input);
            AbstractEDocumentSetupParticipant setupParticipant = (AbstractEDocumentSetupParticipant)((DVTFileDocumentProvider)this.getDocumentProvider()).getDocumentSetupParticipant();
            IDocumentExtension3 extension3 = (IDocumentExtension3)this.getDocument();
            if (extension3.getDocumentPartitioner("__e_partitioning") == null) {
                setupParticipant.setup(this.getDocument());
            }
            this.setPrefStore(this.getPluginConfig().getPlugin().getPreferenceStore());
            this.connectModuleToDocument(false);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public Image getTitleImage() {
        IFile file = (IFile)this.getEditorInput().getAdapter(IFile.class);
        Image image = super.getTitleImage();
        try {
            if (file == null) {
                image = DVTUtilsCommon.INSTANCE.isInSLNMode((IPluginConfig)this.getPluginConfig()) ? DVTImages.imageCache.getImage(DVTImages.DESC_SLN_MODULE_GRAY) : (DVTUtilsCommon.INSTANCE.isInSDLMode((IPluginConfig)this.getPluginConfig()) ? DVTImages.imageCache.getImage(DVTImages.DESC_SDL_MODULE_GRAY) : DVTImages.imageCache.getImage(DVTImages.DESC_E_MODULE_GRAY));
            } else {
                IContainer parent = file.getParent();
                while (parent != null && !(parent instanceof IProject)) {
                    if (parent.isLinked()) {
                        if (DVTUtilsCommon.INSTANCE.isInSLNMode((IPluginConfig)this.getPluginConfig())) {
                            image = DVTImages.imageCache.getImage(DVTImages.DESC_SLN_MODULE_LINKED);
                            break;
                        }
                        if (DVTUtilsCommon.INSTANCE.isInSDLMode((IPluginConfig)this.getPluginConfig())) {
                            image = DVTImages.imageCache.getImage(DVTImages.DESC_SDL_MODULE_LINKED);
                            break;
                        }
                        image = DVTImages.imageCache.getImage(DVTImages.DESC_E_MODULE_LINKED);
                        break;
                    }
                    parent = parent.getParent();
                }
                Image newImage = null;
                newImage = DVTUtilsCommon.INSTANCE.isInSLNMode((IPluginConfig)this.getPluginConfig()) ? ProjectColorUtils.transformImage((ImageDescriptor)DVTImages.DESC_SLN_MODULE_BLACK_TRANSPARENT, (String)file.getProject().getName()) : (DVTUtilsCommon.INSTANCE.isInSDLMode((IPluginConfig)this.getPluginConfig()) ? ProjectColorUtils.transformImage((ImageDescriptor)DVTImages.DESC_SDL_MODULE_BLACK_TRANSPARENT, (String)file.getProject().getName()) : ProjectColorUtils.transformImage((ImageDescriptor)DVTImages.DESC_E_MODULE_BLACK_TRANSPARENT, (String)file.getProject().getName()));
                image = newImage == null ? image : newImage;
            }
            ILabelDecorator decorator = this.getPluginConfig().getPlugin().getWorkbench().getDecoratorManager().getLabelDecorator();
            if (decorator != null) {
                return decorator.decorateImage(image, (Object)this);
            }
        }
        catch (Exception exception) {}
        return image;
    }

    protected void handleCursorPositionChanged() {
        super.handleCursorPositionChanged();
    }

    protected void createActions() {
        super.createActions();
        Object a = new DVTEditor.OpenHelpSearch((DVTEditor)this);
        a.setActionDefinitionId(OPEN_HELP_SEARCH);
        this.setAction("OpenHelpSearch", (IAction)a);
        a = new DVTEditor.CollapseAllLevelsAction((DVTEditor)this, EEditorMessages.getResourceBundle(), "CollapseAllLevels.", (ITextEditor)this);
        a.setActionDefinitionId(COLLAPSE_ALL_LEVELS);
        this.setAction("CollapseAllLevels", (IAction)a);
        a = new DVTEditor.ShowActivePreprocessingAction((DVTEditor)this, EEditorMessages.getResourceBundle(), "ShowActivePreprocessing.", (ITextEditor)this);
        a.setActionDefinitionId(SHOW_ACTIVE_PREPROCESSING);
        this.setAction("ShowActivePreprocessing", (IAction)a);
        a = new DVTEditor.ExpandAllLevelsAction((DVTEditor)this, EEditorMessages.getResourceBundle(), "ExpandAllLevels.", (ITextEditor)this);
        a.setActionDefinitionId(EXPAND_ALL_LEVELS);
        this.setAction("ExpandAllLevels", (IAction)a);
        a = new DVTEditor.ShowFirstLevelAction((DVTEditor)this, EEditorMessages.getResourceBundle(), "ExpandFirstLevel.", (ITextEditor)this);
        a.setActionDefinitionId(EXPAND_FIRST_LEVEL);
        this.setAction("ExpandFirstLevel", (IAction)a);
        a = new DVTEditor.DefineFoldingRegionAction((DVTEditor)this, EEditorMessages.getResourceBundle(), "DefineFoldingRegion.", (ITextEditor)this);
        a.setActionDefinitionId(DEFINE_FOLDING_REGION);
        this.setAction("DefineFoldingRegion", (IAction)a);
        a = new ToggleMarkOccurrencesAction(EEditorMessages.getResourceBundle(), "ToggleMarkOccurrences.", (ITextEditor)this);
        a.setActionDefinitionId(TOGGLE_MARK_OCCURRENCES);
        this.setAction("ToggleMarkOccurrences", (IAction)a);
        this.getEditorSite().getActionBars().setGlobalActionHandler(TOGGLE_MARK_OCCURRENCES, (IAction)a);
        a = new DVTEditor.ForwardEndOfWord((DVTEditor)this, EEditorMessages.getResourceBundle(), "", (ITextEditor)this);
        a.setActionDefinitionId(FORWARD_END_OF_WORD);
        this.setAction("ForwardEndOfWord", (IAction)a);
        a = new DVTEditor.BackwardStartOfWord((DVTEditor)this, EEditorMessages.getResourceBundle(), "", (ITextEditor)this);
        a.setActionDefinitionId(BACKWARD_START_OF_WORD);
        this.setAction("BackwardStartOfWord", (IAction)a);
        a = new DVTEditor.SelectEnclosingElement((DVTEditor)this, EEditorMessages.getResourceBundle(), "", (ITextEditor)this);
        a.setActionDefinitionId(SELECT_ENCLOSING_ELEMENT);
        this.setAction("SelectEnclosingElement", (IAction)a);
        a = new DVTEditor.RestoreLastSelection((DVTEditor)this, EEditorMessages.getResourceBundle(), "", (ITextEditor)this);
        a.setActionDefinitionId(RESTORE_LAST_SELECTION);
        this.setAction("RestoreLastSelection", (IAction)a);
        a = new DVTEditor.GoToPairMatchingBeginEndBlockOrPairBracket((DVTEditor)this, EEditorMessages.getResourceBundle(), "GoToPairBracket.", (ITextEditor)this);
        a.setActionDefinitionId(GOTO_PAIR_BRACKET);
        this.setAction("GoToPairBracket", (IAction)a);
        a = new DVTEditor.ToggleCollapseLineAction((DVTEditor)this, EEditorMessages.getResourceBundle(), "ToggleCollapseLine.", (ITextEditor)this);
        a.setActionDefinitionId(TOGGLE_COLLAPSE_LINE);
        this.setAction("ToggleCollapseLine", (IAction)a);
        a = new DVTEditor.ToggleExpandScopeAction((DVTEditor)this, EEditorMessages.getResourceBundle(), "ToggleExpandScope.", (ITextEditor)this);
        a.setActionDefinitionId(TOGGLE_EXPAND_SCOPE);
        this.setAction("ToggleExpandScope", (IAction)a);
        a = new DVTContentAssistAction(EEditorMessages.getResourceBundle(), "ContentAssistProposal", (ITextEditor)this);
        a.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)a);
        this.markAsStateDependentAction("ContentAssistProposal", true);
        a = new DVTTextOperationAction(TemplateMessages.getResourceBundle(), "Editor.template_proposals_action.", (ITextEditor)this, 13);
        a.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction(TEMPLATE_PROPOSALS, (IAction)a);
        this.markAsStateDependentAction(TEMPLATE_PROPOSALS, true);
        a = new DVTEditor.FormatSourceAction((DVTEditor)this, EEditorMessages.getResourceBundle(), "FormatSource.", (ITextEditor)this);
        a.setActionDefinitionId(FORMAT_SOURCE);
        this.setAction("FormatSource", (IAction)a);
        a = new ToggleCommentAction(EEditorMessages.getResourceBundle(), "ToggleComment.", (ITextEditor)this, this.getPluginConfig());
        a.setActionDefinitionId(TOGGLE_COMMENT);
        this.setAction("ToggleComment", (IAction)a);
        this.markAsStateDependentAction("ToggleComment", true);
        this.configureToggleCommentAction();
        a = new OpenDeclarationAction(EEditorMessages.getResourceBundle(), "OpenDeclaration.", (ITextEditor)this, this.getPluginConfig());
        a.setActionDefinitionId(OPEN_DECLARATION);
        this.setAction("OpenDeclaration", (IAction)a);
        a = new GoToImportAction(EEditorMessages.getResourceBundle(), "ImportingFile.", (ITextEditor)this, this.getPluginConfig());
        a.setActionDefinitionId(IMPORTING_FILE);
        this.setAction("ImportingFile", (IAction)a);
        a = new OverrideMethodsAction(EEditorMessages.getResourceBundle(), "OverrideMethods.", (ITextEditor)this, this.getPluginConfig());
        a.setActionDefinitionId(OVERRIDE_METHODS);
        this.setAction("OverrideMethods", (IAction)a);
        a = new MacroExpandAllLevelsAction(EEditorMessages.getResourceBundle(), "MacrosExpandAllLevels.", (ITextEditor)this, this.getPluginConfig().getRfManager());
        a.setActionDefinitionId(MACROS_EXPAND_ALL_LEVELS);
        this.setAction("MacrosExpandAllLevels", (IAction)a);
        a = new MacroExpandAllLevelsInlineAction(EEditorMessages.getResourceBundle(), "MacrosExpandAllLevelsInline.", (ITextEditor)this, this.getPluginConfig().getRfManager());
        a.setActionDefinitionId(MACROS_EXPAND_ALL_LEVELS_INLINE);
        this.setAction("MacrosExpandAllLevelsInline", (IAction)a);
        a = new MacroCollapseInlineExpansionAction(EEditorMessages.getResourceBundle(), "MacrosCollapseInlineExpansion.", (ITextEditor)this);
        a.setActionDefinitionId(MACROS_COLLAPSE_INLINE_EXPANSION);
        this.setAction("MacrosCollapseInlineExpansion", (IAction)a);
        a = new ShowDiagramAction(EEditorMessages.getResourceBundle(), "ShowDiagram.", (ITextEditor)this, this.getPluginConfig());
        a.setActionDefinitionId(SHOW_DIAGRAM);
        this.setAction("ShowDiagram", (IAction)a);
        a = new SwitchCommentStyle(EEditorMessages.getResourceBundle(), "CommentStyle.", (ITextEditor)this);
        a.setActionDefinitionId(SWITCH_COMMENT_STYLE);
        this.setAction("SwitchCommentStyle", (IAction)a);
        a = new ReferencesInWorkspaceAction(EEditorMessages.getResourceBundle(), "ReferencesInWorkspace.", (ITextEditor)this, this.getPluginConfig());
        a.setActionDefinitionId(REFERENCES_IN_WORKSPACE);
        this.setAction("ReferencesInWorkspace", (IAction)a);
        a = new ShowReadersUsagesAction(EEditorMessages.getResourceBundle(), "ShowReadersUsages.", (ITextEditor)this, this.getPluginConfig());
        a.setActionDefinitionId("ro.amiq.dvt.ui.views.commands.ShowReaders");
        this.setAction("ShowReadersUsages", (IAction)a);
        a = new ShowWritersUsagesAction(EEditorMessages.getResourceBundle(), "ShowWritersUsages.", (ITextEditor)this, this.getPluginConfig());
        a.setActionDefinitionId("ro.amiq.dvt.ui.views.commands.ShowWriters");
        this.setAction("ShowWritersUsages", (IAction)a);
        a = new ReferencesInProjectAction(EEditorMessages.getResourceBundle(), "ReferencesInProject.", (ITextEditor)this, this.getPluginConfig());
        a.setActionDefinitionId(REFERENCES_IN_PROJECT);
        this.setAction("ReferencesInProject", (IAction)a);
        a = new ReferencesInProjectAction(EEditorMessages.getResourceBundle(), "Usages.", (ITextEditor)this, this.getPluginConfig());
        a.setActionDefinitionId(REFERENCES_IN_PROJECT);
        this.setAction("Usages", (IAction)a);
        a = new ReferencesInFileAction(EEditorMessages.getResourceBundle(), "ReferencesInFile.", (ITextEditor)this, this.getPluginConfig());
        a.setActionDefinitionId(REFERENCES_IN_FILE);
        this.setAction("ReferencesInFile", (IAction)a);
        a = new ReferencesInWorkingSetAction(EEditorMessages.getResourceBundle(), "ReferencesInWorkingSet.", (ITextEditor)this, this.getPluginConfig());
        a.setActionDefinitionId(REFERENCES_IN_WORKING_SET);
        this.setAction("ReferencesInWorkingSet", (IAction)a);
        a = new ERenameRefactorAction(EEditorMessages.getResourceBundle(), "RefactorRename.", this, this.getPluginConfig());
        a.setActionDefinitionId(REFACTOR_RENAME);
        this.setAction("RefactorRename", (IAction)a);
        a = new ERefactorExtractToMethodAction(EEditorMessages.getResourceBundle(), "RefactorExtractToMethod.", (ITextEditor)this, this.getPluginConfig());
        a.setActionDefinitionId(REFACTOR_EXTRACT_TO_METHOD);
        this.setAction("RefactorExtractToMethod", (IAction)a);
        a = new ERefactorExtractToTCMAction(EEditorMessages.getResourceBundle(), "RefactorExtractToTCM.", (ITextEditor)this, this.getPluginConfig());
        a.setActionDefinitionId(REFACTOR_EXTRACT_TO_TCM);
        this.setAction("RefactorExtractToTCM", (IAction)a);
        a = new CopyFileInfoAction(EEditorMessages.getResourceBundle(), "CopyFullPath.", (ITextEditor)this, CopyFileInfoKind.COPY_FULL_PATH);
        a.setActionDefinitionId(COPY_FULL_PATH);
        this.setAction("CopyFullPath", (IAction)a);
        a = new CopyFileInfoAction(EEditorMessages.getResourceBundle(), "CopyFileName.", (ITextEditor)this, CopyFileInfoKind.COPY_FILE_NAME);
        a.setActionDefinitionId(COPY_FILE_NAME);
        this.setAction("CopyFileName", (IAction)a);
        a = new ShowInstancesAction(EEditorMessages.getResourceBundle(), "ShowInstances.", (ITextEditor)this, this.getPluginConfig());
        a.setActionDefinitionId(SHOW_INSTANCES);
        this.setAction("ShowInstances", (IAction)a);
        a = new ShowEmittersAction(EEditorMessages.getResourceBundle(), "ShowEmitters.", (ITextEditor)this, this.getPluginConfig());
        a.setActionDefinitionId(SHOW_EMITTERS);
        this.setAction("ShowEmitters", (IAction)a);
        a = new ShowConstraintsAction(EEditorMessages.getResourceBundle(), "ShowConstraints.", (ITextEditor)this, this.getPluginConfig());
        a.setActionDefinitionId(SHOW_CONSTRAINTS);
        this.setAction("ShowConstraints", (IAction)a);
    }

    private String getSourceMenuLabel() {
        String keyBinding = null;
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        if (bindingService != null) {
            keyBinding = bindingService.getBestActiveBindingFormattedFor(SOURCE_SUBMENU);
        }
        if (keyBinding == null) {
            keyBinding = "";
        }
        return NLS.bind((String)EEditorMessages.getString("SourceSubmenu.label"), (Object)keyBinding);
    }

    private String getMacrosMenuLabel() {
        String keyBinding = null;
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        if (bindingService != null) {
            keyBinding = bindingService.getBestActiveBindingFormattedFor(MACROS_SUBMENU);
        }
        if (keyBinding == null) {
            keyBinding = "";
        }
        return NLS.bind((String)EEditorMessages.getString("MacrosSubMenu.label"), (Object)keyBinding);
    }

    private String getReferencesMenuLabel() {
        String keyBinding = null;
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        if (bindingService != null) {
            keyBinding = bindingService.getBestActiveBindingFormattedFor(REFERENCES_SUBMENU_COMMAND_ID);
        }
        if (keyBinding == null) {
            keyBinding = "";
        }
        return NLS.bind((String)EEditorMessages.getString("ReferencesSubmenu.label"), (Object)keyBinding);
    }

    private String getRefactorMenuLabel() {
        String keyBinding = null;
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        if (bindingService != null) {
            keyBinding = bindingService.getBestActiveBindingFormattedFor(REFACTOR_SUBMENU);
        }
        if (keyBinding == null) {
            keyBinding = "";
        }
        return NLS.bind((String)EEditorMessages.getString("RefactorSubMenu.label"), (Object)keyBinding);
    }

    protected void addSourceSubmenuItems(IMenuManager menu) {
        this.addAction(menu, "QuickAssist");
        menu.add((IContributionItem)new Separator());
        this.addAction(menu, "GoToPairBracket");
        menu.add((IContributionItem)new Separator());
        this.addAction(menu, "FormatSource");
        this.addAction(menu, "SwitchCommentStyle");
        this.addAction(menu, "ToggleComment");
        menu.add((IContributionItem)new Separator());
        this.addAction(menu, "OverrideMethods");
    }

    protected void addMacrosSubmenuItems(IMenuManager menu) {
        this.addAction(menu, "MacrosExpandAllLevelsInline");
        this.addAction(menu, "MacrosExpandAllLevels");
        menu.add((IContributionItem)new Separator());
        this.addAction(menu, "MacrosCollapseInlineExpansion");
    }

    protected void addReferencesSubmenuItems(IMenuManager menu) {
        this.addAction(menu, "ReferencesInWorkspace");
        this.addAction(menu, "ReferencesInProject");
        this.addAction(menu, "ReferencesInFile");
        menu.add((IContributionItem)new Separator());
        this.addAction(menu, "ReferencesInWorkingSet");
    }

    protected void addRefactorSubmenuItems(IMenuManager menu) {
        this.addAction(menu, "RefactorRename");
        menu.add((IContributionItem)new Separator());
        this.addAction(menu, "RefactorExtractToMethod");
        this.addAction(menu, "RefactorExtractToTCM");
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        MenuManager submenu = new MenuManager("Edit", null, null);
        menu.add((IContributionItem)submenu);
        this.addAction((IMenuManager)submenu, ITextEditorActionConstants.CUT);
        this.addAction((IMenuManager)submenu, ITextEditorActionConstants.COPY);
        this.addAction((IMenuManager)submenu, ITextEditorActionConstants.PASTE);
        submenu.add((IContributionItem)new Separator());
        this.addAction((IMenuManager)submenu, ITextEditorActionConstants.UNDO);
        this.addAction((IMenuManager)submenu, ITextEditorActionConstants.REDO);
        submenu.add((IContributionItem)new Separator());
        this.addAction((IMenuManager)submenu, "CopyFileName");
        this.addAction((IMenuManager)submenu, "CopyFullPath");
        submenu.add((IContributionItem)new Separator());
        submenu.add((IContributionItem)new EditorEmulationContributionItem(new EditorEmulationAction(false)));
        submenu = new MenuManager("Folding", null, null);
        menu.add((IContributionItem)submenu);
        this.addAction((IMenuManager)submenu, "CollapseAllLevels");
        this.addAction((IMenuManager)submenu, "ShowActivePreprocessing");
        this.addAction((IMenuManager)submenu, "ExpandFirstLevel");
        this.addAction((IMenuManager)submenu, "ExpandAllLevels");
        this.addAction((IMenuManager)submenu, "ToggleExpandScope");
        this.addAction((IMenuManager)submenu, "ToggleCollapseLine");
        this.addAction((IMenuManager)submenu, "DefineFoldingRegion");
        submenu = new MenuManager(this.getMacrosMenuLabel(), null, null);
        menu.add((IContributionItem)submenu);
        this.addMacrosSubmenuItems((IMenuManager)submenu);
        submenu = new MenuManager(this.getSourceMenuLabel(), null, null);
        menu.add((IContributionItem)submenu);
        this.addSourceSubmenuItems((IMenuManager)submenu);
        submenu = new MenuManager("Show", null, "ro.amiq.dvt.ui.editor.menu.show");
        menu.add((IContributionItem)submenu);
        this.addAction((IMenuManager)submenu, "OpenDeclaration");
        submenu.add((IContributionItem)new Separator());
        submenu.add((IContributionItem)new GroupMarker("ro.amiq.dvt.ui.editor.menu.show.group1"));
        this.addAction((IMenuManager)submenu, "ShowDiagram");
        submenu.add((IContributionItem)new GroupMarker("ro.amiq.dvt.ui.editor.menu.show.group2"));
        this.addAction((IMenuManager)submenu, "QuickOutline");
        submenu.add((IContributionItem)new GroupMarker("ro.amiq.dvt.ui.editor.menu.show.group3"));
        submenu.add((IContributionItem)new Separator());
        this.addAction((IMenuManager)submenu, "ShowConstraints");
        this.addAction((IMenuManager)submenu, "ShowInstances");
        this.addAction((IMenuManager)submenu, "ShowEmitters");
        this.addAction((IMenuManager)submenu, "Usages");
        this.addAction((IMenuManager)submenu, "ShowReadersUsages");
        this.addAction((IMenuManager)submenu, "ShowWritersUsages");
        submenu.add((IContributionItem)new Separator());
        this.addAction((IMenuManager)submenu, "ImportingFile");
        menu.add((IContributionItem)new Separator());
        submenu = new MenuManager(this.getReferencesMenuLabel(), null, "ro.amiq.dvt.ui.editor.ReferencesSubMenu");
        menu.add((IContributionItem)submenu);
        this.addReferencesSubmenuItems((IMenuManager)submenu);
        submenu = new MenuManager(this.getRefactorMenuLabel());
        menu.add((IContributionItem)submenu);
        this.addRefactorSubmenuItems((IMenuManager)submenu);
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new Separator("ro.amiq.dvt.ui.editor.menu.debug"));
    }

    protected void initializeKeyBindingScopes() {
        if (this.getPluginConfig().getLanguageKind() == LanguageKind.SLN) {
            this.setKeyBindingScopes(new String[]{"ro.amiq.edt.base.slnEditorScope"});
        } else {
            this.setKeyBindingScopes(new String[]{"ro.amiq.edt.base.eEditorScope"});
        }
    }

    public void setFocus() {
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer == null) {
            return;
        }
        StyledText styledText = sourceViewer.getTextWidget();
        if (styledText == null) {
            return;
        }
        if (styledText.isFocusControl()) {
            return;
        }
        super.setFocus();
        if (this.fPropertyChangedEvent) {
            sourceViewer.invalidateTextPresentation();
            this.fPropertyChangedEvent = false;
        }
        EQuickViewersUtil.getInstance().scheduleReparseIfNonTop(this.getPluginConfig(), (ITextEditor)this, true);
        this.connectModuleToDocument(true);
        this.switchPerspective();
        this.detectIndentation();
    }

    private void switchPerspective() {
        try {
            boolean disableSwitchPerspective = DVTPlugin.getDefault().getPreferenceStore().getBoolean("ro.amiq.dvt.DISABLE_SWITCH_PERSPECTIVE");
            if (disableSwitchPerspective) {
                return;
            }
            IProject project = this.getProject();
            if (project == null) {
                return;
            }
            IWorkbenchPage activePage = DVTPlugin.getActivePage();
            if (activePage == null) {
                return;
            }
            IPerspectiveDescriptor perspective = activePage.getPerspective();
            if (perspective == null) {
                return;
            }
            if (perspective.getId().equals("ro.amiq.edt.base.ui.perspectives.EDTPerspective")) {
                return;
            }
            if (project.hasNature(this.getPluginConfig().getNature()) && (perspective.getId().equals("ro.amiq.vlogdt.ui.perspectives.VlogPerspective") || perspective.getId().equals("ro.amiq.vhdldt.ui.perspectives.VhdlPerspective"))) {
                PlatformUI.getWorkbench().showPerspective("ro.amiq.edt.base.ui.perspectives.EDTPerspective", PlatformUI.getWorkbench().getActiveWorkbenchWindow());
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void connectModuleToDocument(boolean connectPositionsAfterEditorFocus) {
        try {
            IProject project = this.getProject();
            if (project == null) {
                DVTHlUtils.startHighlight(null, (DVTEditor)this, (DVTSemanticHighlighter)new ESemanticHighlighter(this.getDocument()), (AbstractUIPlugin)this.getPluginConfig().getPlugin(), (String)"highlight.semantic");
                ObjectionManager.getInstance().clear(Objection.OVERRIDE_INDICATION);
                return;
            }
            IFile file = (IFile)this.getAdapter(IResource.class);
            if (file == null) {
                ObjectionManager.getInstance().clear(Objection.SEMANTIC_HIGHLIGHT);
                ObjectionManager.getInstance().clear(Objection.OVERRIDE_INDICATION);
                return;
            }
            ParserPath parserPath = DVTFileUtils.getInstance().resource2parser((IResource)file);
            if (parserPath == null) {
                ObjectionManager.getInstance().clear(Objection.SEMANTIC_HIGHLIGHT);
                ObjectionManager.getInstance().clear(Objection.OVERRIDE_INDICATION);
                return;
            }
            RfProject rfProject = this.getPluginConfig().getRfManager().getRfProject(project);
            IDocument document = this.getDocument();
            if (document == null) {
                ObjectionManager.getInstance().clear(Objection.SEMANTIC_HIGHLIGHT);
                ObjectionManager.getInstance().clear(Objection.OVERRIDE_INDICATION);
                return;
            }
            boolean shouldIncrementalBuild = DVTFileUtils.getInstance().shouldIncrementalBuild(this.getDocument(), null, this.getProject());
            if (shouldIncrementalBuild && rfProject != null) {
                rfProject.connectModuleToDocument(this.getEditorID(), parserPath, this, connectPositionsAfterEditorFocus);
            } else {
                ObjectionManager.getInstance().clear(Objection.OVERRIDE_INDICATION);
            }
            DVTHlUtils.startHighlight((IRfFileDef)(rfProject != null ? rfProject.getModule(parserPath) : null), (DVTEditor)this, (DVTSemanticHighlighter)new ESemanticHighlighter(document), (AbstractUIPlugin)this.getPluginConfig().getPlugin(), (String)"highlight.semantic");
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void disconnectModuleFromDocument() {
        try {
            IProject project = this.getProject();
            if (project == null) {
                return;
            }
            IFile file = (IFile)this.getAdapter(IResource.class);
            if (file == null) {
                return;
            }
            ParserPath parserPath = DVTFileUtils.getInstance().resource2parser((IResource)file);
            if (parserPath == null) {
                return;
            }
            RfProject rfProject = this.getPluginConfig().getRfManager().getRfProject(project);
            if (rfProject == null) {
                return;
            }
            rfProject.disconnectModuleFromDocument(parserPath);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void notifyListeners(int eventType, Event event) {
        this.getSourceViewer().getTextWidget().notifyListeners(eventType, event);
    }

    public ISourceViewer testGetSourceViewer() {
        return this.getSourceViewer();
    }

    public DVTSourceViewerConfiguration testGetSourceViewerConfiguration() {
        return (DVTSourceViewerConfiguration)this.getSourceViewerConfiguration();
    }

    public IHyperlinkDetector[] testGetAllHyperlinkDetectors() {
        return this.getSourceViewerConfiguration().getHyperlinkDetectors(this.getSourceViewer());
    }

    public int testGetCurrentLine() {
        ISourceViewer sourceViewer = this.getSourceViewer();
        StyledText styledText = sourceViewer.getTextWidget();
        return styledText.getLineAtOffset(styledText.getCaretOffset());
    }

    public TextEditorAction testGetReferencesInWorkspaceAction() {
        return new ReferencesInWorkspaceAction(EEditorMessages.getResourceBundle(), "ReferencesInWorkspace.", (ITextEditor)this, this.getPluginConfig());
    }

    public IReferencesAction testGetShowReadersUsagesAction() {
        return new ShowReadersUsagesAction(EEditorMessages.getResourceBundle(), "ShowReaders.", (ITextEditor)this, this.getPluginConfig());
    }

    public IReferencesAction testGetShowWritersUsagesAction() {
        return new ShowWritersUsagesAction(EEditorMessages.getResourceBundle(), "ShowWriters.", (ITextEditor)this, this.getPluginConfig());
    }

    public TextEditorAction testGetReferencesInFileAction() {
        return new ReferencesInFileAction(EEditorMessages.getResourceBundle(), "ReferencesInFile.", (ITextEditor)this, this.getPluginConfig());
    }

    public IRfNamedElementAndScope testGetNamedElementAndScopeAtPosition(int line, int column) {
        RfProject rfProject;
        IDocument document;
        IFile file;
        block11: {
            IProject project;
            block10: {
                block9: {
                    block8: {
                        IEditorInput editorInput;
                        block7: {
                            try {
                                editorInput = this.getEditorInput();
                                if (editorInput != null) break block7;
                                return null;
                            }
                            catch (Exception e) {
                                DVTLogger.INSTANCE.logError((Throwable)e);
                                return null;
                            }
                        }
                        file = (IFile)editorInput.getAdapter(IFile.class);
                        if (file != null) break block8;
                        return null;
                    }
                    project = file.getProject();
                    if (project != null) break block9;
                    return null;
                }
                document = this.getDocument();
                if (document != null) break block10;
                return null;
            }
            rfProject = this.getPluginConfig().getRfManager().getRfProject(project);
            if (rfProject != null) break block11;
            return null;
        }
        int offset = document.getLineOffset(line) + column;
        return RfUtils.getRfElement(rfProject, file, document, offset, false);
    }

    public IRfBreadcrumbElement getCursorScopeForBreadcrumb(boolean overrideCache) {
        ScopeBreadcrumbUtils breadcrumbUtils = (ScopeBreadcrumbUtils)this.getBreadcrumbUtils(ScopeBreadcrumbViewer.class);
        if (breadcrumbUtils == null) {
            return null;
        }
        IRfBreadcrumbElement scopeForBreadcrumb = breadcrumbUtils.getScopeForBreadcrumb((ITextEditor)this, this.getCursor(), false);
        if (scopeForBreadcrumb == null) {
            return null;
        }
        return scopeForBreadcrumb;
    }

    @Override
    protected Object getFile() {
        return this.getAdapter(IResource.class);
    }

    public IRfScopeElement getCursorScope() {
        return null;
    }

    protected IPreferenceStore getPluginSpecificPreferenceStore() {
        return this.getPluginConfig().getPlugin().getPreferenceStore();
    }

    public IBaseShowConstraintsAction testGetShowConstraintsAction() {
        return new ShowConstraintsAction(EEditorMessages.getResourceBundle(), "ShowConstraints.", (ITextEditor)this, this.getPluginConfig());
    }

    public IBaseShowEmittersAction testGetShowEmittersAction() {
        return new ShowEmittersAction(EEditorMessages.getResourceBundle(), "ShowEmitters.", (ITextEditor)this, this.getPluginConfig());
    }

    public IBaseShowInstancesAction testGetShowInstancesAction() {
        return new ShowInstancesAction(EEditorMessages.getResourceBundle(), "ShowInstances.", (ITextEditor)this, this.getPluginConfig());
    }

    public void showContentAssistProposalsForCreatedFile() {
        DVTUiUtils.getActiveWorkbenchShell().getDisplay().asyncExec(() -> {
            IContentAssistant contAss = ((ESourceViewerConfiguration)this.getSourceViewerConfiguration()).getContentAssistant(this.getSourceViewer());
            contAss.install((ITextViewer)this.getSourceViewer());
            ((ESourceViewerConfiguration)this.getSourceViewerConfiguration()).getSourceProcessorManager().showContentAssistPage(IDVTContentAssistConstants.ELangContentAssistProposalsPage.TEMPLATES.getCode());
            contAss.showPossibleCompletions();
        });
    }

    public void showAIAssistantProposals() {
        DVTUiUtils.getActiveWorkbenchShell().getDisplay().asyncExec(() -> {
            IContentAssistant contAss = ((ESourceViewerConfiguration)this.getSourceViewerConfiguration()).getContentAssistant(this.getSourceViewer());
            contAss.install((ITextViewer)this.getSourceViewer());
            ((ESourceViewerConfiguration)this.getSourceViewerConfiguration()).getSourceProcessorManager().showContentAssistPage(IDVTContentAssistConstants.ELangContentAssistProposalsPage.AI_ASSISTANT.getCode());
            contAss.showPossibleCompletions();
        });
    }

    public boolean isHoverDisabled() {
        return this.getPluginConfig().getPlugin().getPreferenceStore().getBoolean("editor.disable_tool_tips");
    }

    public void installSubmenuActions() {
        this.fHandlerService = (IHandlerService)this.getEditorSite().getService(IHandlerService.class);
        if (this.fHandlerService != null) {
            IHandler handler = new DVTQuickMenuCreator(){

                protected void fillMenu(IMenuManager menu) {
                    AbstractEEditor.this.addSourceSubmenuItems(menu);
                }
            }.createHandler();
            this.fSubmenuHandlerActivations.put(SOURCE_SUBMENU, this.fHandlerService.activateHandler(SOURCE_SUBMENU, handler));
            handler = new DVTQuickMenuCreator(){

                protected void fillMenu(IMenuManager menu) {
                    AbstractEEditor.this.addMacrosSubmenuItems(menu);
                }
            }.createHandler();
            this.fSubmenuHandlerActivations.put(MACROS_SUBMENU, this.fHandlerService.activateHandler(MACROS_SUBMENU, handler));
            handler = new DVTQuickMenuCreator(){

                protected void fillMenu(IMenuManager menu) {
                    AbstractEEditor.this.addReferencesSubmenuItems(menu);
                }
            }.createHandler();
            this.fSubmenuHandlerActivations.put(REFERENCES_SUBMENU_COMMAND_ID, this.fHandlerService.activateHandler(REFERENCES_SUBMENU_COMMAND_ID, handler));
            handler = new DVTQuickMenuCreator(){

                protected void fillMenu(IMenuManager menu) {
                    AbstractEEditor.this.addRefactorSubmenuItems(menu);
                }
            }.createHandler();
            this.fSubmenuHandlerActivations.put(REFACTOR_SUBMENU, this.fHandlerService.activateHandler(REFACTOR_SUBMENU, handler));
        }
    }

    public void recomputeHighlightPositionsAndInvalidateEditor() {
        try {
            IProject project = this.getProject();
            if (project == null) {
                DVTHlUtils.startHighlight(null, (DVTEditor)this, (DVTSemanticHighlighter)new ESemanticHighlighter(this.getDocument()), (AbstractUIPlugin)this.getPluginConfig().getPlugin(), (String)"highlight.semantic");
                ObjectionManager.getInstance().clear(Objection.OVERRIDE_INDICATION);
                return;
            }
            IFile file = (IFile)this.getAdapter(IResource.class);
            if (file == null) {
                ObjectionManager.getInstance().clear(Objection.SEMANTIC_HIGHLIGHT);
                ObjectionManager.getInstance().clear(Objection.OVERRIDE_INDICATION);
                return;
            }
            ParserPath parserPath = DVTFileUtils.getInstance().resource2parser((IResource)file);
            if (parserPath == null) {
                ObjectionManager.getInstance().clear(Objection.SEMANTIC_HIGHLIGHT);
                ObjectionManager.getInstance().clear(Objection.OVERRIDE_INDICATION);
                return;
            }
            RfProject rfProject = this.getPluginConfig().getRfManager().getRfProject(project);
            if (rfProject == null) {
                ObjectionManager.getInstance().clear(Objection.SEMANTIC_HIGHLIGHT);
                ObjectionManager.getInstance().clear(Objection.OVERRIDE_INDICATION);
                return;
            }
            DVTHlUtils.startHighlight((IRfFileDef)rfProject.getModule(parserPath), (DVTEditor)this, (DVTSemanticHighlighter)new ESemanticHighlighter(this.getDocument()), (AbstractUIPlugin)this.getPluginConfig().getPlugin(), (String)"highlight.semantic");
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public QuickLazyOutlineView createQuickOutlineView() {
        return new EQuickLazyOutlineView(this);
    }

    public DVTLazyOutlinePage getOutlinePage() {
        return this.fOutlinePage;
    }

    private class CustomGotoMarker
    implements IGotoMarker {
        private CustomGotoMarker() {
        }

        public void gotoMarker(IMarker marker) {
            try {
                String fileName;
                MarkerInfo info = ((Workspace)ResourcesPlugin.getWorkspace()).getMarkerManager().findMarkerInfo(marker.getResource(), marker.getId());
                String string = fileName = info == null ? null : (String)marker.getAttribute("ro.amiq.dvt.file_name");
                if (fileName == null) {
                    ((IGotoMarker)AbstractEEditor.super.getAdapter(IGotoMarker.class)).gotoMarker(marker);
                } else {
                    int line = (Integer)marker.getAttribute("ro.amiq.dvt.line_number");
                    IFile file = (IFile)AbstractEEditor.this.getAdapter(IResource.class);
                    if (file != null) {
                        IProject project = file.getProject();
                        if (project == null) {
                            EDTFileUtils.getInstance().openEditor(new File(fileName), line);
                        } else {
                            EDTFileUtils.getInstance().openFile(AbstractEEditor.this.getPluginConfig().getModelManager(), project, fileName, line, null);
                        }
                    } else {
                        EDTFileUtils.getInstance().openEditor(new File(fileName), line);
                    }
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }

    private class SwitchCommentStyle
    extends TextEditorAction {
        public SwitchCommentStyle(ResourceBundle bundle, String prefix, ITextEditor editor) {
            super(bundle, prefix, editor);
            boolean vhdlStyle = AbstractEEditor.this.getPluginConfig().getPlugin().getPreferenceStore().getBoolean("toggleCommnetStyle");
            String text = "Switch to " + (!vhdlStyle ? "VHDL" : "Verilog") + " Comment Style";
            this.setText(text);
            this.setToolTipText(text);
            ESourceViewerConfiguration configuration = (ESourceViewerConfiguration)AbstractEEditor.this.getSourceViewerConfiguration();
            String defaultComment = configuration.getPrefixZero();
            if (vhdlStyle && defaultComment.equals("//")) {
                ESourceViewerConfiguration.switchDefaultPrefixes();
            } else if (!vhdlStyle && defaultComment.equals("--")) {
                ESourceViewerConfiguration.switchDefaultPrefixes();
            }
        }

        public void run() {
            boolean vhdlStyle = AbstractEEditor.this.getPluginConfig().getPlugin().getPreferenceStore().getBoolean("toggleCommnetStyle");
            vhdlStyle = !vhdlStyle;
            String text = "Switch to " + (!vhdlStyle ? "VHDL" : "Verilog") + " Comment Style";
            this.setText(text);
            this.setToolTipText(text);
            AbstractEEditor.this.getPluginConfig().getPlugin().getPreferenceStore().setValue("toggleCommnetStyle", vhdlStyle);
            ESourceViewerConfiguration configuration = (ESourceViewerConfiguration)AbstractEEditor.this.getSourceViewerConfiguration();
            String defaultComment = configuration.getPrefixZero();
            if (vhdlStyle && defaultComment.equals("//")) {
                ESourceViewerConfiguration.switchDefaultPrefixes();
            } else if (!vhdlStyle && defaultComment.equals("--")) {
                ESourceViewerConfiguration.switchDefaultPrefixes();
            }
        }
    }
}

