/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTPairMatcher;
import ro.amiq.dvt.ui.editor.DVTPairMatcherAccessor;
import ro.amiq.dvt.ui.editor.DVTSourceViewerConfiguration;
import ro.amiq.dvt.ui.editor.DVTWordFinder;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.IEModule;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.util.RfUtils;
import ro.amiq.edt.base.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.edt.base.ui.editor.EPairMatcherAccessor;
import ro.amiq.edt.base.ui.editor.ESourceViewerConfiguration;
import ro.amiq.edt.base.ui.editor.EWordFinder;

public abstract class AbstractEEditorCommon
extends DVTEditor {
    protected AbstractEEditorCommon() {
    }

    protected AbstractEEditorCommon(IDocument document) {
        super(document);
    }

    public RfProject getRfProject() {
        IProject project = this.getProject();
        if (project == null) {
            return null;
        }
        return this.getPluginConfig().getRfManager().getRfProject(project);
    }

    public void createEditorConfiguration() {
        DVTSourceViewerConfiguration configuration = this.createSourceViewerConfiguration();
        configuration.setBracketMatcher((ICharacterPairMatcher)DVTPairMatcher.makePairMatcher((LanguageKind)this.getPluginConfig().getLanguageKind(), (char[])BRACKETS, (DVTPairMatcherAccessor)new EPairMatcherAccessor()));
        this.setSourceViewerConfiguration((SourceViewerConfiguration)configuration);
    }

    protected void scheduleReparse(IDocument document, IFile file) {
        IEModule module = this.getPluginConfig().getModelManager().getEModel().getOrCreateEModule(file);
        if (module == null) {
            return;
        }
        boolean shouldIncrementalBuild = DVTFileUtils.getInstance().shouldIncrementalBuild(this.getDocument(), null, this.getProject());
        if (shouldIncrementalBuild) {
            int buildAutoTime = DVTPlugin.getDefault().getPreferenceStore().getInt("ro.amiq.dvt.TRIGGER_AUTOBUILD_VALUE");
            module.scheduleReparse(false, false, (long)buildAutoTime * 1000L, document, false);
        }
    }

    public DVTWordFinder getWordFinder() {
        return EWordFinder.getDefault();
    }

    protected boolean c() {
        return DVTPlugin.getDefault().collect().c(this.getProject(), this.getPluginConfig().feature());
    }

    public IRfNamedElementAndScope getCursorElement() {
        return this.getCursorElementNonUi(this.getCursor());
    }

    public IRfNamedElementAndScope getCursorElementNonUi(int cursor) {
        IProject project = this.getProject();
        if (project == null) {
            return null;
        }
        RfProject rfProject = this.getPluginConfig().getRfManager().getRfProject(project);
        if (rfProject == null) {
            return null;
        }
        Object file = this.getFile();
        if (!(file instanceof IFile)) {
            return null;
        }
        RfWNamedElementAndScope namedElementAndScope = RfUtils.getRfElement(rfProject, (IFile)file, this.getDocument(), cursor, false);
        return namedElementAndScope;
    }

    public DVTSourceViewerConfiguration makeSourceViewerConfiguration() {
        return new ESourceViewerConfiguration(this.getPluginConfig(), null);
    }

    public abstract IEPluginConfig getPluginConfig();

    protected abstract DVTSourceViewerConfiguration createSourceViewerConfiguration();

    protected abstract Object getFile();
}

