/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.editor;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.ui.editor.ESourceViewerConfiguration;

public class EAutoEditStrategyCommon
extends DefaultIndentLineAutoEditStrategy {
    protected static final int TIME_THRESHOLD = 250;
    protected ESourceViewerConfiguration fConfiguration;
    protected ISourceViewer fSourceViewer;
    protected IEPluginConfig fPluginConfig;
    private char fPreviousChar;
    private char fPrePreviousChar;
    private Map<String, List<Long>> fCharTimestampMap = new HashMap<String, List<Long>>();

    protected EAutoEditStrategyCommon(IEPluginConfig pluginConfig, ISourceViewer sourceViewer, ESourceViewerConfiguration configuration) {
        this.fSourceViewer = sourceViewer;
        this.fConfiguration = configuration;
        this.fPluginConfig = pluginConfig;
    }

    public void transformText(IDocument document, DocumentCommand command) {
        if (document == null || command == null) {
            return;
        }
        char ch = '\u0000';
        if (command.text.length() == 1) {
            ch = command.text.charAt(0);
        }
        long currentTimestamp = System.currentTimeMillis();
        boolean useWhitespace = this.fPluginConfig.getPlugin().getPreferenceStore().getBoolean("typing.transform_whitespace");
        if (ch == ';' && this.fPluginConfig.getPlugin().getPreferenceStore().getBoolean("typing.transform_semicolon_to_assign")) {
            if (this.fPreviousChar == ';' && this.fPrePreviousChar == ';' && currentTimestamp - this.fCharTimestampMap.get(String.valueOf(ch)).get(0) + (this.fCharTimestampMap.get(String.valueOf(ch)).get(0) - this.fCharTimestampMap.get(String.valueOf(ch)).get(1)) < 500L) {
                command.offset -= 2;
                command.text = useWhitespace ? " := " : ":=";
                command.length = 2;
                this.fCharTimestampMap.put(";", Arrays.asList(0L, 0L));
            } else if (this.fPreviousChar == ';') {
                Long previousTimestamp = this.fCharTimestampMap.get(String.valueOf(ch)).get(0);
                this.fCharTimestampMap.put(";", Arrays.asList(currentTimestamp, previousTimestamp));
            } else {
                this.fCharTimestampMap.put(";", Arrays.asList(currentTimestamp));
            }
        }
        this.fPrePreviousChar = this.fPreviousChar;
        this.fPreviousChar = ch;
    }
}

