/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.editor;

import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import ro.amiq.dvt.startup.core.DVTLogger;

public class EBasePartitionScanner
extends BufferedRuleBasedScanner {
    public EBasePartitionScanner(int size) {
        super(size);
    }

    public int getOffset() {
        return this.fOffset;
    }

    public int getLineOfOffset(int offset) {
        try {
            return this.fDocument.getLineOfOffset(offset);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return -1;
        }
    }

    public int getNumberOfLines() {
        return this.fDocument.getNumberOfLines();
    }

    public String getLine(int line) {
        try {
            IRegion r = this.fDocument.getLineInformation(line);
            return this.fDocument.get(r.getOffset(), r.getLength());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return "";
        }
    }

    public int getLineOffset(int line) {
        try {
            return this.fDocument.getLineOffset(line);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return 0;
        }
    }

    public String get(int offset, int length) {
        try {
            return this.fDocument.get(offset, length);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return "";
        }
    }

    public boolean isAtColumn(int column) {
        block5: {
            block4: {
                try {
                    if (this.fOffset != 1 || column != 1) break block4;
                    return true;
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return false;
                }
            }
            if (this.fOffset - column - 1 >= 0) break block5;
            return false;
        }
        char ch0 = this.fDocument.getChar(this.fOffset - column - 1);
        char ch1 = this.fDocument.getChar(this.fOffset - column);
        return (ch0 == '\n' || ch0 == '\r') && ch1 != '\r' && ch1 != '\n';
    }

    public int getColumn() {
        try {
            int line = this.fDocument.getLineOfOffset(this.fOffset);
            int start = this.fDocument.getLineOffset(line);
            this.fColumn = this.fOffset - start;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return this.fColumn;
    }
}

