/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.editor;

import java.util.ArrayList;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import ro.amiq.dvt.core.IPluginConfig;
import ro.amiq.dvt.ui.editor.DVTBaseScanner;
import ro.amiq.dvt.ui.editor.highlight.DVTHlUtils;
import ro.amiq.dvt.ui.editor.highlight.IHighlightListener;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.ui.editor.IEStyle;
import ro.amiq.edt.base.ui.editor.rules.ECloseRule;
import ro.amiq.edt.base.ui.editor.rules.ECombinedWordRule;
import ro.amiq.edt.base.ui.editor.rules.EEventDetector;
import ro.amiq.edt.base.ui.editor.rules.EFoldingZoneMarker;
import ro.amiq.edt.base.ui.editor.rules.EGroupRule;
import ro.amiq.edt.base.ui.editor.rules.EHDLPathRule;
import ro.amiq.edt.base.ui.editor.rules.ENumericRule;
import ro.amiq.edt.base.ui.editor.rules.EOpenRule;
import ro.amiq.edt.base.ui.editor.rules.EPreprocessRule;
import ro.amiq.edt.base.ui.editor.rules.EReplaceRule;
import ro.amiq.edt.base.ui.editor.rules.EWhitespaceDetector;
import ro.amiq.edt.base.ui.preferences.PrefConst;

public class ECodeScanner
extends DVTBaseScanner {
    private ECombinedWordRule fECombinedWordRule;

    public ECodeScanner(IEPluginConfig pluginConfig, IEStyle style, int nofLinesFolding) {
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new WhitespaceRule((IWhitespaceDetector)new EWhitespaceDetector()));
        rules.add(new ENumericRule(style.getToken("highlight.number")));
        rules.add(new EReplaceRule(style.getToken("highlight.replace")));
        rules.add(new EGroupRule(style.getToken("highlight.group")));
        rules.add(new WordRule((IWordDetector)new EEventDetector(), style.getToken("highlight.event")));
        rules.add(new EPreprocessRule(PrefConst.getEPreproc(pluginConfig.getPlugin()), style.getToken("highlight.preproc")));
        rules.add(new EHDLPathRule(style.getToken("highlight.hdl_path")));
        this.fECombinedWordRule = new ECombinedWordRule(pluginConfig.getPlugin(), DVTUtilsCommon.INSTANCE.isInSlnLikeMode((IPluginConfig)pluginConfig), style);
        DVTHlUtils.addListener((IHighlightListener)this.fECombinedWordRule);
        rules.add(this.fECombinedWordRule);
        rules.add(new EOpenRule(style.getToken("highlight.openclose")));
        rules.add(new ECloseRule(style.getToken("highlight.openclose")));
        rules.add(new EFoldingZoneMarker(nofLinesFolding));
        IRule[] result = new IRule[rules.size()];
        rules.toArray(result);
        this.setRules(result);
    }

    public void setNofLinesFolding(int nofLines) {
        if (this.fRules != null) {
            IRule[] iRuleArray = this.fRules;
            int n = this.fRules.length;
            int n2 = 0;
            while (n2 < n) {
                IRule rule = iRuleArray[n2];
                if (rule instanceof EFoldingZoneMarker) {
                    ((EFoldingZoneMarker)rule).setNofLinesFolding(nofLines);
                }
                ++n2;
            }
        }
    }

    public void dispose() {
        DVTHlUtils.removeListener((IHighlightListener)this.fECombinedWordRule);
        super.dispose();
    }
}

