/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.editor;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import ro.amiq.dvt.ui.editor.TextUtils;
import ro.amiq.dvt.utils.DVTDocumentCommon;
import ro.amiq.edt.base.ui.editor.EWordFinder;

public class EDoubleClickStrategy
implements ITextDoubleClickStrategy {
    private ICharacterPairMatcher fPairMatcher;

    public EDoubleClickStrategy(ICharacterPairMatcher pairMatcher) {
        this.fPairMatcher = pairMatcher;
    }

    public void doubleClicked(ITextViewer textViewer) {
        int offset = textViewer.getSelectedRange().x;
        if (offset < 0) {
            return;
        }
        if (this.fPairMatcher == null) {
            return;
        }
        IDocument document = textViewer.getDocument();
        IRegion region = this.fPairMatcher.match(document, offset);
        if (region != null && region.getLength() >= 2) {
            textViewer.setSelectedRange(region.getOffset() + 1, region.getLength() - 2);
        } else {
            region = EWordFinder.getDefault().getWordAtOffset(document, offset, true);
            if (region.getLength() != 0) {
                textViewer.setSelectedRange(region.getOffset(), region.getLength());
            } else {
                char c = TextUtils.getChar((IDocument)document, (int)offset);
                if (Character.isWhitespace(c)) {
                    region = DVTDocumentCommon.getWhitespaceBlockAtOffset((IDocument)document, (int)offset);
                    textViewer.setSelectedRange(region.getOffset(), region.getLength());
                }
            }
        }
    }
}

