/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.editor;

import java.util.Arrays;
import java.util.Comparator;
import java.util.regex.Pattern;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.ui.editor.EBasePartitionScanner;

public class EFastPartitionScanner
implements IPartitionTokenScanner {
    private static final Pattern SL_COMMENT = Pattern.compile("(//|--).*$");
    public static final int E_ML_COMMENT = 0;
    public static final int E_SL_COMMENT = 1;
    public static final int E_EXPANSION = 2;
    public static final int E_SECTION = 3;
    public static final int E_STRING = 4;
    public static final int E_CODE_REPLACEMENT_IN_EXPANSION = 5;
    public static final int E_CODE_SECTION_IN_EXPANSION = 6;
    public static final int E_SL_COMMENT_IN_EXPANSION = 7;
    public static final int E_STRING_IN_CODE_REPLACEMENT_IN_EXPANSION = 8;
    public static final int E_STRING_IN_CODE_SECTION_IN_EXPANSION = 9;
    public static final int E_SV_ML_COMMENT = 10;
    public static final int E_NULL = 11;
    private final EBasePartitionScanner fScanner = new EBasePartitionScanner(500);
    private int fTokenOffset;
    private int fTokenLength;
    private int fPrefixLength;
    private int fState = 0;
    private int fDefaultState = 0;
    private boolean fBackslash = false;
    private int fChar = 97;
    private final IToken[] fTokens = new IToken[]{new Token((Object)"__e_ml_comment"), new Token((Object)"__e_sl_comment"), new Token((Object)"__e_expansion"), new Token((Object)"__dftl_partition_content_type"), new Token((Object)"__e_string"), new Token((Object)"__dftl_partition_content_type"), new Token((Object)"__dftl_partition_content_type"), new Token((Object)"__e_sl_comment_in_expansion"), new Token((Object)"__e_string_in_code_replacement_in_expansion"), new Token((Object)"__e_string_in_code_section_in_expansion"), new Token((Object)"__e_sv_ml_comment"), new Token(null)};
    private boolean fAutoDetectSection;
    private IEPluginConfig fPluginConfig;
    private boolean fCodeInExpansionEndSequenceExpected;
    private static final char[] START_EXPANSION = new char[]{'#', ':'};
    private static final char[] END_EXPANSION = new char[]{'e', 'n', 'd', ' ', '#'};
    private static final char[] END_EXPANSION_SHORT = new char[]{'e', 'n', 'd', '#'};
    private static final char[] START_ML_COMMENT = new char[]{'\'', '>'};
    private static final char[] START_SV_ML_COMMENT = new char[]{'/', '*'};
    private static final char[] START_ML_COMMENT_END_ML_COMMENT = new char[]{'\'', '>', '<', '\''};
    private static final char[] END_ML_COMMENT = new char[]{'<', '\''};
    private static final char[] END_SV_ML_COMMENT = new char[]{'*', '/'};
    private static final char[] END_ML_COMMENT_START_ML_COMMENT = new char[]{'>', '\'', '\'', '<'};
    private static final char[] START_SL_VLOG_COMMENT = new char[]{'/', '/'};
    private static final char[] START_SL_VHDL_COMMENT = new char[]{'-', '-'};
    private static final char[] START_E_CODE_REPLACEMENT_IN_EXPANSION = new char[]{'<', '('};
    private static final char[] END_E_CODE_REPLACEMENT_IN_EXPANSION = new char[]{')', '>'};
    private static final char[] START_E_CODE_SECTION_IN_EXPANSION = new char[]{'<', '[', ']', '>'};
    private static final char[] START_E_CODE_SECTION_IN_EXPANSION_2 = new char[]{'<', '['};
    private static final char[] END_E_CODE_SECTION_IN_EXPANSION_2 = new char[]{']', '>'};
    private Comparator fLineDelimiterComparator = new DecreasingCharArrayLengthComparator();
    private char[][] fLineDelimiters;
    private char[][] fSortedLineDelimiters;

    public EFastPartitionScanner(IEPluginConfig pluginConfig, int state) {
        this.fState = state;
        this.fDefaultState = state;
        this.fPluginConfig = pluginConfig;
    }

    public EFastPartitionScanner(IEPluginConfig pluginConfig) {
        this.fState = 0;
        this.fDefaultState = 0;
        this.fPluginConfig = pluginConfig;
    }

    public EFastPartitionScanner(IEPluginConfig pluginConfig, boolean autoDetectSection) {
        this.fState = 0;
        this.fDefaultState = 0;
        this.fAutoDetectSection = autoDetectSection;
        this.fPluginConfig = pluginConfig;
    }

    public IToken nextToken() {
        if (this.fTokenOffset >= 0) {
            this.fTokenOffset += this.fTokenLength;
            this.fTokenLength = this.fPrefixLength;
        } else {
            this.fTokenOffset += this.fTokenLength + this.fPrefixLength;
            this.fTokenLength = 0;
        }
        this.fPrefixLength = 0;
        while ((this.fChar = this.fScanner.read()) != -1) {
            ++this.fTokenLength;
            if (this.fState == 2) {
                if (this.fChar == 101 && this.sequenceDetected(END_EXPANSION)) {
                    i = this.fScanner.getLineOfOffset(this.fScanner.getOffset());
                    line = this.fScanner.getLine(i);
                    if (line.trim().startsWith("end #")) {
                        this.fChar = this.fScanner.read();
                        ++this.fTokenLength;
                        this.fChar = this.fScanner.read();
                        ++this.fTokenLength;
                        this.fChar = this.fScanner.read();
                        ++this.fTokenLength;
                        this.fChar = this.fScanner.read();
                        ++this.fTokenLength;
                        this.fState = 3;
                        return this.createToken(2);
                    }
                } else if (this.fChar == 101 && this.sequenceDetected(END_EXPANSION_SHORT)) {
                    i = this.fScanner.getLineOfOffset(this.fScanner.getOffset());
                    line = this.fScanner.getLine(i);
                    if (line.trim().startsWith("end#")) {
                        this.fChar = this.fScanner.read();
                        ++this.fTokenLength;
                        this.fChar = this.fScanner.read();
                        ++this.fTokenLength;
                        this.fChar = this.fScanner.read();
                        ++this.fTokenLength;
                        this.fState = 3;
                        return this.createToken(2);
                    }
                } else {
                    if (this.fChar == 60 && this.sequenceDetected(START_E_CODE_SECTION_IN_EXPANSION)) {
                        this.fChar = this.fScanner.read();
                        ++this.fTokenLength;
                        this.fChar = this.fScanner.read();
                        ++this.fTokenLength;
                        this.fChar = this.fScanner.read();
                        ++this.fTokenLength;
                        this.fCodeInExpansionEndSequenceExpected = false;
                        this.fState = 6;
                        return this.createToken(2);
                    }
                    if (this.fChar == 60 && this.sequenceDetected(START_E_CODE_SECTION_IN_EXPANSION_2)) {
                        this.fChar = this.fScanner.read();
                        ++this.fTokenLength;
                        this.fCodeInExpansionEndSequenceExpected = true;
                        this.fState = 6;
                        return this.createToken(2);
                    }
                    if (this.fChar == 60 && this.sequenceDetected(START_E_CODE_REPLACEMENT_IN_EXPANSION)) {
                        this.fChar = this.fScanner.read();
                        ++this.fTokenLength;
                        this.fState = 5;
                        return this.createToken(2);
                    }
                }
            } else if (this.fState == 3) {
                if (this.fChar == 35 && this.sequenceDetected(START_EXPANSION)) {
                    i = this.fScanner.getLineOfOffset(this.fScanner.getOffset());
                    line = this.fScanner.getLine(i);
                    if (DVTStringUtil.replaceFirst((Pattern)SL_COMMENT, (CharSequence)line, (String)"").trim().endsWith("#:")) {
                        this.fScanner.unread();
                        --this.fTokenLength;
                        this.fState = 2;
                        return this.createToken(3);
                    }
                } else if (this.fChar == 39 && this.sequenceDetected(START_ML_COMMENT_END_ML_COMMENT) && this.fScanner.isAtColumn(1)) {
                    this.fChar = this.fScanner.read();
                    ++this.fTokenLength;
                    this.fChar = this.fScanner.read();
                    ++this.fTokenLength;
                    this.fChar = this.fScanner.read();
                    ++this.fTokenLength;
                    this.fChar = this.fScanner.read();
                    ++this.fTokenLength;
                } else {
                    if (this.fChar == 39 && this.sequenceDetected(START_ML_COMMENT) && this.fScanner.isAtColumn(1)) {
                        this.fChar = this.fScanner.read();
                        ++this.fTokenLength;
                        this.fState = 0;
                        return this.createToken(3);
                    }
                    if (this.fChar == 47 && this.sequenceDetected(START_SV_ML_COMMENT)) {
                        this.fScanner.unread();
                        --this.fTokenLength;
                        this.fScanner.unread();
                        --this.fTokenLength;
                        this.fChar = this.fScanner.read();
                        ++this.fTokenLength;
                        this.fState = 10;
                        return this.createToken(3);
                    }
                    if (this.fChar == 45 && this.sequenceDetected(START_SL_VHDL_COMMENT)) {
                        this.fScanner.unread();
                        --this.fTokenLength;
                        this.fState = 1;
                        return this.createToken(3);
                    }
                    if (this.fChar == 47 && this.sequenceDetected(START_SL_VLOG_COMMENT)) {
                        this.fScanner.unread();
                        --this.fTokenLength;
                        this.fState = 1;
                        return this.createToken(3);
                    }
                    if (this.fChar == 34 && !this.fBackslash) {
                        this.fScanner.unread();
                        --this.fTokenLength;
                        this.fState = 4;
                        return this.createToken(3);
                    }
                }
            } else if (this.fState == 0) {
                if (this.fChar == 60 && this.sequenceDetected(END_ML_COMMENT_START_ML_COMMENT) && this.fScanner.isAtColumn(1)) {
                    this.fChar = this.fScanner.read();
                    ++this.fTokenLength;
                    this.fChar = this.fScanner.read();
                    ++this.fTokenLength;
                    this.fChar = this.fScanner.read();
                    ++this.fTokenLength;
                    this.fChar = this.fScanner.read();
                    ++this.fTokenLength;
                }
                if (this.fChar == 60 && this.sequenceDetected(END_ML_COMMENT) && this.fScanner.isAtColumn(1)) {
                    this.fScanner.unread();
                    --this.fTokenLength;
                    this.fState = 3;
                    return this.createToken(0);
                }
            } else if (this.fState == 10) {
                if (this.fChar == 42 && this.sequenceDetected(END_SV_ML_COMMENT)) {
                    this.fChar = this.fScanner.read();
                    ++this.fTokenLength;
                    this.fState = 3;
                    return this.createToken(10);
                }
                if (this.fChar == 60 && this.sequenceDetected(END_ML_COMMENT) && this.fScanner.isAtColumn(1)) {
                    this.fScanner.unread();
                    --this.fTokenLength;
                    this.fState = 3;
                    return this.createToken(10);
                }
            } else {
                if (this.fState == 4) {
                    this.endStringDetected((ICharacterScanner)this.fScanner);
                    this.fState = 3;
                    return this.createToken(4);
                }
                if (this.fState == 1) {
                    if (this.fChar == 10 || this.fChar == 13) {
                        if (this.fChar == 13) {
                            if (this.fScanner.read() == 10) {
                                ++this.fTokenLength;
                            } else {
                                this.fScanner.unread();
                            }
                        }
                        this.fState = 3;
                        return this.createToken(1);
                    }
                } else if (this.fState == 5) {
                    if (this.fChar == 41 && this.sequenceDetected(END_E_CODE_REPLACEMENT_IN_EXPANSION)) {
                        this.fScanner.unread();
                        --this.fTokenLength;
                        this.fState = 2;
                        return this.createToken(5);
                    }
                    if (this.fChar == 34 && !this.fBackslash) {
                        this.fScanner.unread();
                        --this.fTokenLength;
                        this.fState = 8;
                        return this.createToken(5);
                    }
                } else {
                    if (this.fState == 8) {
                        this.endStringDetected((ICharacterScanner)this.fScanner);
                        this.fState = 5;
                        return this.createToken(8);
                    }
                    if (this.fState == 6) {
                        if (this.fChar == 10 || this.fChar == 13 || this.fCodeInExpansionEndSequenceExpected && this.sequenceDetected(END_E_CODE_SECTION_IN_EXPANSION_2)) {
                            this.fScanner.unread();
                            --this.fTokenLength;
                            this.fState = 2;
                            return this.createToken(6);
                        }
                        if (this.fChar == 47 && this.sequenceDetected(START_SL_VLOG_COMMENT)) {
                            this.fScanner.unread();
                            --this.fTokenLength;
                            this.fState = 7;
                            return this.createToken(6);
                        }
                        if (this.fChar == 45 && this.sequenceDetected(START_SL_VHDL_COMMENT)) {
                            this.fScanner.unread();
                            --this.fTokenLength;
                            this.fState = 7;
                            return this.createToken(6);
                        }
                        if (this.fChar == 34 && !this.fBackslash) {
                            this.fScanner.unread();
                            --this.fTokenLength;
                            this.fState = 9;
                            return this.createToken(6);
                        }
                    } else {
                        if (this.fState == 9) {
                            this.endStringDetected((ICharacterScanner)this.fScanner);
                            this.fState = 6;
                            return this.createToken(9);
                        }
                        if (this.fState == 7 && (this.fChar == 10 || this.fChar == 13)) {
                            this.fScanner.unread();
                            --this.fTokenLength;
                            this.fState = 2;
                            return this.createToken(7);
                        }
                    }
                }
            }
            boolean bl = this.fBackslash = !this.fBackslash && this.fChar == 92;
        }
        if (this.fTokenLength > 0) {
            return this.createToken(this.fState);
        }
        return Token.EOF;
    }

    private IToken createToken(int state) {
        if (this.fTokenLength > 0) {
            return this.fTokens[state];
        }
        return this.fTokens[11];
    }

    static String getContentType(int state) {
        if (state == 3) {
            return "E_SECTION";
        }
        if (state == 2) {
            return "E_EXPANSION";
        }
        if (state == 0) {
            return "E_ML_COMMENT";
        }
        if (state == 1) {
            return "E_SL_COMMENT";
        }
        if (state == 5) {
            return "E_CODE_REPLACEMENT_IN_EXPANSION";
        }
        if (state == 6) {
            return "E_CODE_SECTION_IN_EXPANSION";
        }
        if (state == 7) {
            return "E_SL_COMMENT_IN_EXPANSION";
        }
        if (state == 8) {
            return "E_STRING_IN_CODE_REPLACEMENT_IN_EXPANSION";
        }
        if (state == 10) {
            return "E_SV_ML_COMMENT";
        }
        if (state == 9) {
            return "E_STRING_IN_CODE_SECTION_IN_EXPANSION";
        }
        return "E_STRING";
    }

    private boolean sequenceDetected(char[] sequence) {
        if (this.fChar == -1) {
            return false;
        }
        int c = this.fChar;
        int i = 0;
        while (i < sequence.length) {
            if (c != sequence[i]) {
                int j = 0;
                while (j < i) {
                    this.fScanner.unread();
                    --this.fTokenOffset;
                    ++j;
                }
                return false;
            }
            c = this.fScanner.read();
            ++this.fTokenOffset;
            ++i;
        }
        int j = 0;
        while (j < sequence.length) {
            this.fScanner.unread();
            --this.fTokenOffset;
            ++j;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private boolean endStringDetected(ICharacterScanner scanner) {
        block11: {
            originalDelimiters = scanner.getLegalLineDelimiters();
            count = originalDelimiters.length;
            if (this.fLineDelimiters != null && originalDelimiters.length == count) ** GOTO lbl7
            this.fSortedLineDelimiters = new char[count][];
            break block11;
lbl-1000:
            // 1 sources

            {
                --count;
lbl7:
                // 2 sources

                ** while (count > 0 && this.fLineDelimiters[count - 1] == originalDelimiters[count - 1])
            }
        }
        if (count != 0) {
            this.fLineDelimiters = originalDelimiters;
            System.arraycopy(this.fLineDelimiters, 0, this.fSortedLineDelimiters, 0, this.fLineDelimiters.length);
            Arrays.sort(this.fSortedLineDelimiters, this.fLineDelimiterComparator);
        }
        while ((c = scanner.read()) != -1) {
            ++this.fTokenLength;
            if (c == 92) {
                c = scanner.read();
                ++this.fTokenLength;
                rewind = this.fTokenLength;
                while (Character.isWhitespace(c) && c != 13 && c != 10) {
                    c = scanner.read();
                    ++this.fTokenLength;
                }
                rewind = this.fTokenLength - rewind;
                i = 0;
                while (i < this.fSortedLineDelimiters.length) {
                    if (c == this.fSortedLineDelimiters[i][0] && this.sequenceDetected(scanner, this.fSortedLineDelimiters[i], true)) {
                        rewind = 0;
                        break;
                    }
                    ++i;
                }
                i = 0;
                while (i < rewind) {
                    scanner.unread();
                    --this.fTokenLength;
                    ++i;
                }
                continue;
            }
            if (c == 34) {
                return true;
            }
            i = 0;
            while (i < this.fSortedLineDelimiters.length) {
                if (c == this.fSortedLineDelimiters[i][0] && this.sequenceDetected(scanner, this.fSortedLineDelimiters[i], true)) {
                    return false;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean sequenceDetected(ICharacterScanner scanner, char[] sequence, boolean eofAllowed) {
        int i = 1;
        while (i < sequence.length) {
            int c = scanner.read();
            ++this.fTokenLength;
            if (c == -1 && eofAllowed) {
                return true;
            }
            if (c != sequence[i]) {
                scanner.unread();
                --this.fTokenLength;
                int j = i - 1;
                while (j > 0) {
                    scanner.unread();
                    --this.fTokenLength;
                    --j;
                }
                return false;
            }
            ++i;
        }
        return true;
    }

    public void setPartialRange(IDocument document, int offset, int length, String contentType, int partitionOffset) {
        try {
            this.fScanner.setRange(document, offset, length);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        this.fTokenOffset = partitionOffset;
        this.fTokenLength = 0;
        this.fCodeInExpansionEndSequenceExpected = false;
        this.fPrefixLength = offset - partitionOffset;
        this.fState = contentType == null ? this.fDefaultState : EFastPartitionScanner.getState(contentType);
    }

    protected static int getState(String contentType) {
        if (contentType == null) {
            return 0;
        }
        if ("__e_sl_comment".equals(contentType)) {
            return 1;
        }
        if ("__e_sv_ml_comment".equals(contentType)) {
            return 10;
        }
        if ("__dftl_partition_content_type".equals(contentType)) {
            return 3;
        }
        if ("__e_expansion".equals(contentType)) {
            return 2;
        }
        if ("__e_string".equals(contentType)) {
            return 4;
        }
        if ("__e_sl_comment_in_expansion".equals(contentType)) {
            return 7;
        }
        if ("__e_string_in_code_replacement_in_expansion".equals(contentType)) {
            return 8;
        }
        if ("__e_string_in_code_section_in_expansion".equals(contentType)) {
            return 9;
        }
        return 0;
    }

    public void setRange(IDocument document, int offset, int length) {
        try {
            this.fState = this.fDefaultState;
            if (this.fAutoDetectSection) {
                String content = document.get();
                this.fState = !content.startsWith("\r\n<'") && !content.startsWith("\n<'") && !content.startsWith("\r<'") ? this.fDefaultState : 3;
            }
            this.fScanner.setRange(document, offset, length);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        this.fTokenOffset = offset;
        this.fPrefixLength = 0;
        this.fTokenLength = 0;
    }

    public int getTokenLength() {
        return this.fTokenLength;
    }

    public int getTokenOffset() {
        return this.fTokenOffset;
    }

    private static class DecreasingCharArrayLengthComparator
    implements Comparator {
        private DecreasingCharArrayLengthComparator() {
        }

        public int compare(Object o1, Object o2) {
            return ((char[])o2).length - ((char[])o1).length;
        }
    }
}

